/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import com.qualcomm.ftccommon.UpdateUI;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.Gamepad;
import com.qualcomm.robotcore.hardware.HardwareDeviceCloseOnTearDown;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.ServoController;
import com.qualcomm.robotcore.hardware.VoltageSensor;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.robocol.TelemetryMessage;
import com.qualcomm.robotcore.robot.RobotState;
import com.qualcomm.robotcore.util.BatteryChecker;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.MovingStatistics;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;

public class FtcEventLoopHandler
implements BatteryChecker.BatteryWatcher {
    public static final String TAG = "FtcEventLoopHandler";
    public static final String NO_VOLTAGE_SENSOR = "$no$voltage$sensor$";
    protected static final boolean DEBUG = false;
    protected final UpdateUI.Callback callback;
    protected final HardwareFactory hardwareFactory;
    protected final Context robotControllerContext;
    protected EventLoopManager eventLoopManager;
    protected BatteryChecker robotControllerBatteryChecker;
    protected double robotControllerBatteryCheckerInterval = 180.0;
    protected ElapsedTime robotBatteryTimer = new ElapsedTime();
    protected double robotBatteryInterval = 3.0;
    protected MovingStatistics robotBatteryStatistics = new MovingStatistics(10);
    protected ElapsedTime robotBatteryLoggingTimer = null;
    protected double robotBatteryLoggingInterval = this.robotControllerBatteryCheckerInterval;
    protected ElapsedTime userTelemetryTimer = new ElapsedTime(0L);
    protected double userTelemetryInterval = 0.25;
    protected final Object refreshUserTelemetryLock = new Object();
    protected ElapsedTime updateUITimer = new ElapsedTime();
    protected double updateUIInterval = 0.25;
    protected ElapsedTime gamepadEffectsTimer = new ElapsedTime();
    protected int gamepadEffectsInterval = 50;
    protected HardwareMap hardwareMap = null;

    public FtcEventLoopHandler(HardwareFactory hardwareFactory, UpdateUI.Callback callback, Context robotControllerContext) {
        this.hardwareFactory = hardwareFactory;
        this.callback = callback;
        this.robotControllerContext = robotControllerContext;
        long milliseconds = (long)(this.robotControllerBatteryCheckerInterval * 1000.0);
        this.robotControllerBatteryChecker = new BatteryChecker((BatteryChecker.BatteryWatcher)this, milliseconds);
    }

    public void init(EventLoopManager eventLoopManager) {
        this.eventLoopManager = eventLoopManager;
        this.robotControllerBatteryChecker.startBatteryMonitoring();
    }

    public void close() {
        FtcEventLoopHandler.closeHardwareMap(this.hardwareMap);
        this.closeBatteryMonitoring();
        this.eventLoopManager = null;
    }

    protected static void closeHardwareMap(HardwareMap hardwareMap) {
        FtcEventLoopHandler.closeMotorControllers(hardwareMap);
        FtcEventLoopHandler.closeServoControllers(hardwareMap);
        FtcEventLoopHandler.closeAutoCloseOnTeardown(hardwareMap);
    }

    public EventLoopManager getEventLoopManager() {
        return this.eventLoopManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareMap getHardwareMap(OpModeManagerNotifier opModeNotifier) throws RobotCoreException, InterruptedException {
        HardwareFactory hardwareFactory = this.hardwareFactory;
        synchronized (hardwareFactory) {
            if (this.hardwareMap == null) {
                this.hardwareMap = this.hardwareFactory.createHardwareMap((SyncdDevice.Manager)this.eventLoopManager, opModeNotifier);
            }
            return this.hardwareMap;
        }
    }

    public void displayGamePadInfo(String activeOpModeName) {
        if (this.updateUITimer.time() > this.updateUIInterval) {
            this.updateUITimer.reset();
            this.callback.updateUi(activeOpModeName, new Gamepad[]{this.getLatestGamepad1Data(), this.getLatestGamepad2Data()});
        }
    }

    public Gamepad[] getOpModeGamepads() {
        return this.eventLoopManager != null ? this.eventLoopManager.getOpModeGamepads() : new Gamepad[2];
    }

    public Gamepad getLatestGamepad1Data() {
        return this.eventLoopManager != null ? this.eventLoopManager.getLatestGamepad1Data() : new Gamepad();
    }

    public Gamepad getLatestGamepad2Data() {
        return this.eventLoopManager != null ? this.eventLoopManager.getLatestGamepad2Data() : new Gamepad();
    }

    public void gamepadEffects() {
        if (this.gamepadEffectsTimer.milliseconds() > (double)this.gamepadEffectsInterval) {
            Gamepad[] gamepads = this.getOpModeGamepads();
            Gamepad.RumbleEffect rumble0 = (Gamepad.RumbleEffect)gamepads[0].rumbleQueue.poll();
            Gamepad.RumbleEffect rumble1 = (Gamepad.RumbleEffect)gamepads[1].rumbleQueue.poll();
            if (rumble0 != null) {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_RUMBLE_EFFECT", rumble0.serialize()));
            }
            if (rumble1 != null) {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_RUMBLE_EFFECT", rumble1.serialize()));
            }
            Gamepad.LedEffect led0 = (Gamepad.LedEffect)gamepads[0].ledQueue.poll();
            Gamepad.LedEffect led1 = (Gamepad.LedEffect)gamepads[1].ledQueue.poll();
            if (led0 != null) {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_GAMEPAD_LED_EFFECT", led0.serialize()));
            }
            if (led1 != null) {
                NetworkConnectionHandler.getInstance().sendCommand(new Command("CMD_GAMEPAD_LED_EFFECT", led1.serialize()));
            }
            this.gamepadEffectsTimer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUserTelemetry(TelemetryMessage telemetry, double requestedInterval) {
        Object object = this.refreshUserTelemetryLock;
        synchronized (object) {
            boolean transmitBecauseOfBattery;
            if (Double.isNaN(requestedInterval)) {
                requestedInterval = this.userTelemetryInterval;
            }
            boolean transmitBecauseOfUser = this.userTelemetryTimer.seconds() >= requestedInterval;
            double msThreshold = 2.0;
            boolean bl = transmitBecauseOfBattery = this.robotBatteryTimer.seconds() >= this.robotBatteryInterval || transmitBecauseOfUser && this.robotBatteryStatistics.getMean() < msThreshold;
            if (transmitBecauseOfUser || transmitBecauseOfBattery) {
                if (transmitBecauseOfUser) {
                    this.userTelemetryTimer.reset();
                }
                if (transmitBecauseOfBattery) {
                    telemetry.addData("$Robot$Battery$Level$", this.buildRobotBatteryMsg());
                    this.robotBatteryTimer.reset();
                }
                if (telemetry.hasData()) {
                    if (this.eventLoopManager != null) {
                        this.eventLoopManager.sendTelemetryData(telemetry);
                    }
                    telemetry.clearData();
                }
            }
        }
    }

    public void sendBatteryInfo() {
        this.robotControllerBatteryChecker.pollBatteryLevel((BatteryChecker.BatteryWatcher)this);
        String batteryMessage = this.buildRobotBatteryMsg();
        if (batteryMessage != null) {
            this.sendTelemetry("$Robot$Battery$Level$", batteryMessage);
        }
    }

    private String buildRobotBatteryMsg() {
        String msg;
        if (this.hardwareMap == null) {
            return null;
        }
        double minBatteryLevel = Double.POSITIVE_INFINITY;
        for (VoltageSensor sensor : this.hardwareMap.voltageSensor) {
            long nanoBefore = System.nanoTime();
            double sensorVoltage = sensor.getVoltage();
            long nanoAfter = System.nanoTime();
            if (!(sensorVoltage >= 1.0)) continue;
            this.robotBatteryStatistics.add((double)(nanoAfter - nanoBefore) / 1000000.0);
            if (!(sensorVoltage < minBatteryLevel)) continue;
            minBatteryLevel = sensorVoltage;
        }
        if (minBatteryLevel == Double.POSITIVE_INFINITY) {
            msg = NO_VOLTAGE_SENSOR;
        } else {
            msg = Integer.toString((int)(minBatteryLevel * 100.0));
            msg = new StringBuilder(msg).insert(msg.length() - 2, ".").toString();
        }
        return msg;
    }

    public void sendTelemetry(String tag, String msg) {
        TelemetryMessage telemetry = new TelemetryMessage();
        telemetry.setTag(tag);
        telemetry.addData(tag, msg);
        if (this.eventLoopManager != null) {
            this.eventLoopManager.sendTelemetryData(telemetry);
        } else {
            RobotLog.vv((String)TAG, (String)"sendTelemetry() with null EventLoopManager; ignored");
        }
        telemetry.clearData();
    }

    protected static void closeMotorControllers(HardwareMap hardwareMap) {
        if (hardwareMap != null) {
            for (DcMotorController controller : hardwareMap.getAll(DcMotorController.class)) {
                controller.close();
            }
        }
    }

    protected static void closeServoControllers(HardwareMap hardwareMap) {
        if (hardwareMap != null) {
            for (ServoController controller : hardwareMap.getAll(ServoController.class)) {
                controller.close();
            }
        }
    }

    protected static void closeAutoCloseOnTeardown(HardwareMap hardwareMap) {
        if (hardwareMap != null) {
            for (HardwareDeviceCloseOnTearDown device : hardwareMap.getAll(HardwareDeviceCloseOnTearDown.class)) {
                device.close();
            }
        }
    }

    protected void closeBatteryMonitoring() {
        this.robotControllerBatteryChecker.close();
    }

    public void restartRobot() {
        RobotLog.dd((String)TAG, (String)"restarting robot...");
        this.closeBatteryMonitoring();
        this.callback.restartRobot();
    }

    public String getOpMode(String extra) {
        if (this.eventLoopManager == null || this.eventLoopManager.state != RobotState.RUNNING) {
            return "$Stop$Robot$";
        }
        return extra;
    }

    public void updateBatteryStatus(BatteryChecker.BatteryStatus status) {
        this.sendTelemetry("$RobotController$Battery$Status$", status.serialize());
    }
}

