/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import com.qualcomm.ftccommon.CommandList;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.LynxModuleMeta;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;

public class FtcLynxModuleAddressUpdateActivity
extends EditActivity {
    public static final String TAG = "FtcLynxModuleAddressUpdateActivity";
    protected final NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected final int msResponseWait = 10000;
    protected List<PortalInfo> portals = new ArrayList<PortalInfo>();
    protected final DisplayedPortalList displayedPortalList = new DisplayedPortalList();
    DialogInterface.OnClickListener doNothingAndCloseListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int button) {
        }
    };

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ftc_lynx_address_update);
        Button applyButton = (Button)this.findViewById(R.id.applyButton);
        applyButton.setVisibility(0);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.loadExpansionHubs();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void loadExpansionHubs() {
        Runnable displayHubsOnUiThread = () -> {
            this.displayedPortalList.initialize(this.portals);
            TextView noDevicesNotice = (TextView)this.findViewById(R.id.noDevicesNotice);
            if (this.portals.isEmpty()) {
                noDevicesNotice.setVisibility(0);
            } else {
                noDevicesNotice.setVisibility(8);
            }
        };
        AppUtil.getInstance().showWaitCursor(this.getString(R.string.dialogMessagePleaseWait), () -> {
            this.portals = this.getPortalsInfo();
        }, displayHubsOnUiThread);
    }

    public void onApplyButtonPressed(View view) {
        RobotLog.vv((String)TAG, (String)"onApplyButtonPressed()");
        Runnable waitForChangeToFinish = () -> {
            final CountDownLatch changesAppliedLatch = new CountDownLatch(1);
            this.networkConnectionHandler.pushReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)new RecvLoopRunnable.DegenerateCallback(){

                public CallbackResult commandEvent(Command command) throws RobotCoreException {
                    if (command.getName().equals("CMD_LYNX_ADDRESS_CHANGE_FINISHED")) {
                        changesAppliedLatch.countDown();
                        return CallbackResult.HANDLED;
                    }
                    return super.commandEvent(command);
                }
            });
            try {
                changesAppliedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        boolean changesBeingApplied = this.beginApplyingChanges();
        if (changesBeingApplied) {
            AppUtil.getInstance().showWaitCursor(this.getString(R.string.dialogMessagePleaseWait), waitForChangeToFinish, this::loadExpansionHubs);
        } else {
            this.loadExpansionHubs();
        }
    }

    public void onDoneButtonPressed(View view) {
        RobotLog.vv((String)TAG, (String)"onDoneButtonPressed()");
        this.beginApplyingChanges();
        this.finishOk();
    }

    public void onCancelButtonPressed(View view) {
        RobotLog.vv((String)TAG, (String)"onCancelButtonPressed()");
        this.doBackOrCancel();
    }

    @Override
    public void onBackPressed() {
        RobotLog.vv((String)TAG, (String)"onBackPressed()");
        this.doBackOrCancel();
    }

    protected boolean beginApplyingChanges() {
        ArrayList<CommandList.LynxAddressChangeRequest.AddressChange> modulesToChange = new ArrayList<CommandList.LynxAddressChangeRequest.AddressChange>();
        for (DisplayedPortal displayedPortal : this.displayedPortalList.displayedPortals) {
            int portalParentAddress = displayedPortal.originalParentAddress;
            for (Map.Entry<Integer, Integer> moduleAddressesEntry : displayedPortal.originalToNewAddressMap.entrySet()) {
                int newAddress;
                int originalAddress = moduleAddressesEntry.getKey();
                if (originalAddress == (newAddress = moduleAddressesEntry.getValue().intValue())) continue;
                Assert.assertTrue((originalAddress != 0 ? 1 : 0) != 0);
                Assert.assertTrue((newAddress != 0 ? 1 : 0) != 0);
                CommandList.LynxAddressChangeRequest.AddressChange addressChange = new CommandList.LynxAddressChangeRequest.AddressChange();
                addressChange.serialNumber = displayedPortal.serialNumber;
                addressChange.parentAddress = portalParentAddress;
                addressChange.oldAddress = originalAddress;
                addressChange.newAddress = newAddress;
                modulesToChange.add(addressChange);
                if (originalAddress != portalParentAddress) continue;
                portalParentAddress = newAddress;
            }
        }
        if (this.displayedPortalList.displayedPortals.size() > 0) {
            if (modulesToChange.size() > 0) {
                CommandList.LynxAddressChangeRequest request = new CommandList.LynxAddressChangeRequest();
                request.modulesToChange = modulesToChange;
                this.sendOrInject(new Command("CMD_LYNX_ADDRESS_CHANGE", request.serialize()));
                return true;
            }
            AppUtil.getInstance().showToast(UILocation.BOTH, this.getString(R.string.toastLynxAddressChangeNothingToDo));
        }
        return false;
    }

    protected void doBackOrCancel() {
        if (this.displayedPortalList.isDirty()) {
            DialogInterface.OnClickListener exitWithoutSavingButtonListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FtcLynxModuleAddressUpdateActivity.this.finishCancel();
                }
            };
            AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.saveChangesTitle), this.getString(R.string.saveChangesMessageScreen));
            builder.setPositiveButton(R.string.buttonExitWithoutSaving, exitWithoutSavingButtonListener);
            builder.setNegativeButton(R.string.buttonNameCancel, this.doNothingAndCloseListener);
            builder.show();
        } else {
            this.finishCancel();
        }
    }

    protected List<PortalInfo> getPortalsInfo() {
        USBScanManager usbScanManager = USBScanManager.getInstance();
        ArrayList<PortalInfo> result = new ArrayList<PortalInfo>();
        try {
            ScannedDevices usbDevices = (ScannedDevices)usbScanManager.startDeviceScanIfNecessary().await(10000L);
            if (usbDevices != null) {
                SerialNumber serialNumber;
                HashMap<SerialNumber, ThreadPool.SingletonResult<LynxModuleMetaList>> discoveryResults = new HashMap<SerialNumber, ThreadPool.SingletonResult<LynxModuleMetaList>>();
                for (Map.Entry entry : usbDevices.entrySet()) {
                    serialNumber = (SerialNumber)entry.getKey();
                    DeviceManager.UsbDeviceType usbDeviceType = (DeviceManager.UsbDeviceType)entry.getValue();
                    if (usbDeviceType != DeviceManager.UsbDeviceType.LYNX_USB_DEVICE) continue;
                    discoveryResults.put(serialNumber, usbScanManager.startLynxModuleEnumerationIfNecessary(serialNumber));
                }
                for (Map.Entry entry : discoveryResults.entrySet()) {
                    serialNumber = (SerialNumber)entry.getKey();
                    LynxModuleMetaList discoveredHubs = (LynxModuleMetaList)((ThreadPool.SingletonResult)entry.getValue()).await(10000L);
                    if (discoveredHubs == null) continue;
                    int parentAddress = 0;
                    ArrayList<Integer> childAddresses = new ArrayList<Integer>();
                    for (LynxModuleMeta moduleMeta : discoveredHubs) {
                        int address = moduleMeta.getModuleAddress();
                        if (moduleMeta.isParent()) {
                            parentAddress = address;
                            continue;
                        }
                        childAddresses.add(address);
                    }
                    if (childAddresses.size() <= 0 && (parentAddress == 0 || serialNumber.isEmbedded())) continue;
                    result.add(new PortalInfo(serialNumber, parentAddress, childAddresses));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        RobotLog.vv((String)TAG, (String)"found %d REV Hub Portals", (Object[])new Object[]{result.size()});
        return result;
    }

    protected class DisplayedPortalList {
        protected ViewGroup portalList;
        protected final List<DisplayedPortal> displayedPortals = new ArrayList<DisplayedPortal>();

        protected DisplayedPortalList() {
        }

        public void initialize(List<PortalInfo> portals) {
            this.portalList = (ViewGroup)FtcLynxModuleAddressUpdateActivity.this.findViewById(R.id.portalList);
            this.portalList.removeAllViews();
            this.displayedPortals.clear();
            for (PortalInfo portal : portals) {
                this.add(portal);
            }
        }

        public boolean isDirty() {
            for (DisplayedPortal displayedPortal : this.displayedPortals) {
                if (!displayedPortal.isDirty()) continue;
                return true;
            }
            return false;
        }

        protected void add(PortalInfo portal) {
            ViewGroup portalView = (ViewGroup)LayoutInflater.from((Context)FtcLynxModuleAddressUpdateActivity.this.context).inflate(R.layout.lynx_portal_configure_addresses, null);
            this.portalList.addView((View)portalView);
            DisplayedPortal displayedPortal = new DisplayedPortal(portalView);
            displayedPortal.initialize(portal);
            this.displayedPortals.add(displayedPortal);
        }
    }

    protected class DisplayedPortal {
        protected final Map<Integer, Integer> originalToNewAddressMap = new HashMap<Integer, Integer>();
        protected final ViewGroup portalView;
        protected static final int lastModuleAddressChoice = 10;
        protected final List<DisplayedModule> displayedModules = new ArrayList<DisplayedModule>();
        protected SerialNumber serialNumber;
        protected int originalParentAddress;

        protected DisplayedPortal(ViewGroup portalView) {
            this.portalView = portalView;
        }

        public void initialize(PortalInfo portalInfo) {
            this.serialNumber = portalInfo.serialNumber;
            this.originalParentAddress = portalInfo.parentAddress;
            TextView portalNameView = (TextView)this.portalView.findViewById(R.id.portalSerialText);
            if (this.serialNumber.isEmbedded()) {
                portalNameView.setText((CharSequence)FtcLynxModuleAddressUpdateActivity.this.getString(R.string.lynx_address_control_hub_portal));
            } else {
                portalNameView.setText((CharSequence)FtcLynxModuleAddressUpdateActivity.this.getString(R.string.lynx_address_format_expansion_hub_portal_serial, new Object[]{this.serialNumber}));
                this.add(this.originalParentAddress);
            }
            for (int childAddress : portalInfo.childAddresses) {
                this.add(childAddress);
            }
            this.updateAvailableAddresses();
        }

        public void changeAddress(int originalAddress, int newAddress) {
            RobotLog.vv((String)FtcLynxModuleAddressUpdateActivity.TAG, (String)"Selected address change on portal %s from %d to %d", (Object[])new Object[]{this.serialNumber, originalAddress, newAddress});
            this.originalToNewAddressMap.put(originalAddress, newAddress);
            this.updateAvailableAddresses();
        }

        public boolean isDirty() {
            for (Map.Entry<Integer, Integer> moduleEntry : this.originalToNewAddressMap.entrySet()) {
                int newAddress;
                int originalAddress = moduleEntry.getKey();
                if (originalAddress == (newAddress = moduleEntry.getValue().intValue())) continue;
                return true;
            }
            return false;
        }

        protected void updateAvailableAddresses() {
            ArrayList<AddressAndDisplayName> availableAddresses = new ArrayList<AddressAndDisplayName>(10);
            for (int potentialAddress = 0; potentialAddress <= 10; ++potentialAddress) {
                if (potentialAddress != 0 && this.originalToNewAddressMap.containsValue(potentialAddress)) continue;
                availableAddresses.add(new AddressAndDisplayName(potentialAddress));
            }
            for (DisplayedModule displayedModule : this.displayedModules) {
                displayedModule.setAvailableAddresses(availableAddresses);
            }
        }

        protected void add(int moduleAddress) {
            this.originalToNewAddressMap.put(moduleAddress, moduleAddress);
            View moduleView = LayoutInflater.from((Context)FtcLynxModuleAddressUpdateActivity.this.context).inflate(R.layout.lynx_module_configure_address, null);
            this.portalView.addView(moduleView);
            DisplayedModule displayedModule = new DisplayedModule(moduleView, this, moduleAddress);
            displayedModule.initialize();
            this.displayedModules.add(displayedModule);
        }
    }

    protected static class PortalInfo {
        public final SerialNumber serialNumber;
        public final int parentAddress;
        public final List<Integer> childAddresses;

        public PortalInfo(SerialNumber serialNumber, int parentAddress, List<Integer> childAddresses) {
            this.serialNumber = serialNumber;
            this.parentAddress = parentAddress;
            this.childAddresses = childAddresses;
        }
    }

    protected class AddressAndDisplayName {
        public final String displayName;
        public final int address;

        public AddressAndDisplayName(int address) {
            this.address = address;
            this.displayName = address == 0 ? FtcLynxModuleAddressUpdateActivity.this.getString(R.string.lynx_address_format_no_change) : FtcLynxModuleAddressUpdateActivity.this.getString(R.string.lynx_address_format_new_module_address, new Object[]{address});
        }

        public String toString() {
            return this.displayName;
        }
    }

    protected class DisplayedModule {
        protected final int originalAddress;
        protected final ArrayAdapter<AddressAndDisplayName> availableAddressesAdapter;
        protected final DisplayedPortal portal;
        protected final View view;
        protected final Spinner spinner;

        public DisplayedModule(View view, DisplayedPortal portal, int originalAddress) {
            Assert.assertTrue((originalAddress != 0 ? 1 : 0) != 0);
            this.originalAddress = originalAddress;
            this.portal = portal;
            this.view = view;
            this.availableAddressesAdapter = new ArrayAdapter((Context)FtcLynxModuleAddressUpdateActivity.this, 17367048);
            this.availableAddressesAdapter.setDropDownViewResource(0x1090009);
            this.spinner = (Spinner)view.findViewById(R.id.spinnerChooseAddress);
            this.spinner.setAdapter(this.availableAddressesAdapter);
        }

        public void initialize() {
            TextView addressView = (TextView)this.view.findViewById(R.id.moduleAddressText);
            addressView.setText((CharSequence)FtcLynxModuleAddressUpdateActivity.this.getString(R.string.lynx_address_format_module_address, new Object[]{this.originalAddress}));
            this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
                    AddressAndDisplayName item = (AddressAndDisplayName)adapterView.getItemAtPosition(position);
                    int newAddress = item.address;
                    if (newAddress == DisplayedModule.this.originalAddress) {
                        DisplayedModule.this.selectNoChange();
                    } else if (newAddress == 0) {
                        newAddress = DisplayedModule.this.originalAddress;
                    }
                    DisplayedModule.this.portal.changeAddress(DisplayedModule.this.originalAddress, newAddress);
                }

                public void onNothingSelected(AdapterView<?> adapterView) {
                }
            });
        }

        public void setAvailableAddresses(List<AddressAndDisplayName> availableAddresses) {
            int selectedAddress = this.portal.originalToNewAddressMap.get(this.originalAddress);
            AddressAndDisplayName currentlySelectedAddressAndName = new AddressAndDisplayName(selectedAddress);
            this.availableAddressesAdapter.clear();
            this.availableAddressesAdapter.addAll(availableAddresses);
            this.availableAddressesAdapter.add((Object)currentlySelectedAddressAndName);
            this.availableAddressesAdapter.sort(Comparator.comparingInt(o -> o.address));
            if (selectedAddress == this.originalAddress) {
                this.spinner.setSelection(0);
            } else {
                this.spinner.setSelection(this.availableAddressesAdapter.getPosition((Object)currentlySelectedAddressAndName));
            }
        }

        protected void selectNoChange() {
            this.spinner.setSelection(0);
        }
    }
}

