/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.AlertDialog;
import android.app.Service;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.view.ContextThemeWrapper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.FtcLynxFirmwareUpdateActivity;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.UpdateUI;
import com.qualcomm.robotcore.eventloop.EventLoop;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.opmode.EventLoopManagerClient;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.factory.RobotFactory;
import com.qualcomm.robotcore.hardware.Blinker;
import com.qualcomm.robotcore.hardware.LightBlinker;
import com.qualcomm.robotcore.hardware.LightMultiplexor;
import com.qualcomm.robotcore.hardware.SwitchableLight;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationTypeManager;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.robot.Robot;
import com.qualcomm.robotcore.robot.RobotState;
import com.qualcomm.robotcore.robot.RobotStatus;
import com.qualcomm.robotcore.util.ClockWarningSource;
import com.qualcomm.robotcore.util.Device;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SoftwareVersionWarningSource;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.WebServer;
import com.qualcomm.robotcore.wifi.NetworkConnection;
import com.qualcomm.robotcore.wifi.NetworkConnectionFactory;
import com.qualcomm.robotcore.wifi.NetworkType;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.hardware.android.DragonboardIndicatorLED;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.PeerStatus;
import org.firstinspires.ftc.robotcore.internal.network.PreferenceRemoterRC;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectAgent;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaHelper;
import org.firstinspires.ftc.robotcore.internal.system.AppAliveNotifier;
import org.firstinspires.ftc.robotcore.internal.system.PreferencesHelper;
import org.firstinspires.ftc.robotserver.internal.webserver.CoreRobotWebServer;

public class FtcRobotControllerService
extends Service
implements NetworkConnection.NetworkConnectionCallback,
WifiDirectAgent.Callback,
EventLoopManagerClient {
    public static final String TAG = "FTCService";
    private static final int USB_WAIT = 5000;
    private static final int NETWORK_WAIT = 1000;
    private final IBinder binder = new FtcRobotControllerBinder();
    private final PreferencesHelper preferencesHelper = new PreferencesHelper("FTCService");
    private volatile boolean robotSetupHasBeenStarted = false;
    private NetworkConnection networkConnection;
    private EventLoopManager eventLoopManager;
    private Robot robot;
    private EventLoop eventLoop;
    private EventLoop idleEventLoop;
    private NetworkConnection.NetworkEvent networkConnectionStatus = NetworkConnection.NetworkEvent.UNKNOWN;
    private RobotStatus robotStatus = RobotStatus.NONE;
    private UpdateUI.Callback callback = null;
    private final EventLoopMonitor eventLoopMonitor = new EventLoopMonitor();
    private SwitchableLight bootIndicator = null;
    private Future bootIndicatorOff = null;
    private LightBlinker livenessIndicatorBlinker = null;
    private Future robotSetupFuture = null;
    private WifiDirectAgent wifiDirectAgent = WifiDirectAgent.getInstance();
    private final Object wifiDirectCallbackLock = new Object();
    private AlertDialog alertDialogWifiDirectNameNonPrintableChars;
    private AlertDialog alertDialogConnectedAsPeer;
    private WebServer webServer;
    private OnBotJavaHelper onBotJavaHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Object object = this.wifiDirectCallbackLock;
        synchronized (object) {
            this.wifiDirectCallbackLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForNextWifiDirectCallback() throws InterruptedException {
        Object object = this.wifiDirectCallbackLock;
        synchronized (object) {
            this.wifiDirectCallbackLock.wait();
        }
    }

    public NetworkConnection getNetworkConnection() {
        return this.networkConnection;
    }

    public NetworkConnection.NetworkEvent getNetworkConnectionStatus() {
        return this.networkConnectionStatus;
    }

    public void setOnBotJavaHelper(OnBotJavaHelper onBotJavaHelper) {
        this.onBotJavaHelper = onBotJavaHelper;
    }

    public RobotStatus getRobotStatus() {
        return this.robotStatus;
    }

    public Robot getRobot() {
        return this.robot;
    }

    @NonNull
    public WebServer getWebServer() {
        return this.webServer;
    }

    public OnBotJavaHelper getOnBotJavaHelper() {
        return this.onBotJavaHelper;
    }

    public void onCreate() {
        super.onCreate();
        RobotLog.vv((String)TAG, (String)"onCreate()");
        this.wifiDirectAgent.registerCallback((WifiDirectAgent.Callback)this);
        this.startLEDS();
        SoftwareVersionWarningSource.getInstance();
        ClockWarningSource.getInstance();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        RobotLog.vv((String)TAG, (String)"onStartCommand()");
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        RobotLog.vv((String)TAG, (String)"onBind()");
        this.preferencesHelper.writeBooleanPrefIfDifferent(this.getString(R.string.pref_wifip2p_remote_channel_change_works), Device.wifiP2pRemoteChannelChangeWorks());
        this.preferencesHelper.writeBooleanPrefIfDifferent(this.getString(R.string.pref_has_independent_phone_battery), !LynxConstants.isRevControlHub());
        boolean hasSpeaker = !LynxConstants.isRevControlHub();
        this.preferencesHelper.writeBooleanPrefIfDifferent(this.getString(R.string.pref_has_speaker), hasSpeaker);
        if (!hasSpeaker) {
            this.preferencesHelper.writeBooleanPrefIfDifferent(this.getString(R.string.pref_sound_on_off), false);
        }
        FtcLynxFirmwareUpdateActivity.initializeDirectories();
        NetworkType networkType = (NetworkType)intent.getSerializableExtra("NETWORK_CONNECTION_TYPE");
        this.webServer = new CoreRobotWebServer(networkType);
        this.networkConnection = NetworkConnectionFactory.getNetworkConnection((NetworkType)networkType, (Context)this.getBaseContext());
        if (this.networkConnection == null) {
            RobotLog.setGlobalErrorMsg((String)"Setup failure: A valid network connection type was not found for \"%s\"", (Object[])new Object[]{networkType});
        } else {
            this.networkConnection.setCallback((NetworkConnection.NetworkConnectionCallback)this);
            this.networkConnection.enable();
            this.networkConnection.createConnection();
        }
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        RobotLog.vv((String)TAG, (String)"onUnbind()");
        this.networkConnection.disable();
        this.shutdownRobot();
        if (this.eventLoopManager != null) {
            this.eventLoopManager.close();
            this.eventLoopManager = null;
        }
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        RobotLog.vv((String)TAG, (String)"onDestroy()");
        this.webServer.stop();
        this.stopLEDS();
        this.wifiDirectAgent.unregisterCallback((WifiDirectAgent.Callback)this);
    }

    protected void startLEDS() {
        if (LynxConstants.useIndicatorLEDS()) {
            for (int i = 1; i <= 4; ++i) {
                DragonboardIndicatorLED.forIndex((int)i).enableLight(false);
            }
            this.bootIndicator = LightMultiplexor.forLight((SwitchableLight)DragonboardIndicatorLED.forIndex((int)4));
            this.bootIndicator.enableLight(true);
            this.bootIndicatorOff = ThreadPool.getDefaultScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    FtcRobotControllerService.this.bootIndicator.enableLight(false);
                }
            }, 10L, TimeUnit.SECONDS);
            this.livenessIndicatorBlinker = new LightBlinker((SwitchableLight)LightMultiplexor.forLight((SwitchableLight)DragonboardIndicatorLED.forIndex((int)1)));
            int msLivenessLong = 5000;
            int msLivenessShort = 500;
            ArrayList<Blinker.Step> steps = new ArrayList<Blinker.Step>();
            steps.add(new Blinker.Step(-16711936, (long)(msLivenessLong - msLivenessShort), TimeUnit.MILLISECONDS));
            steps.add(new Blinker.Step(-16777216, (long)msLivenessShort, TimeUnit.MILLISECONDS));
            this.livenessIndicatorBlinker.setPattern(steps);
        }
    }

    protected void stopLEDS() {
        if (this.bootIndicatorOff != null) {
            this.bootIndicatorOff.cancel(false);
            this.bootIndicatorOff = null;
        }
        if (this.bootIndicator != null) {
            this.bootIndicator.enableLight(false);
            this.bootIndicator = null;
        }
        if (this.livenessIndicatorBlinker != null) {
            this.livenessIndicatorBlinker.stopBlinking();
            this.livenessIndicatorBlinker = null;
        }
    }

    public synchronized void setCallback(UpdateUI.Callback callback) {
        this.callback = callback;
        callback.updatePeerStatus(NetworkConnectionHandler.getInstance().isPeerConnected() ? PeerStatus.CONNECTED : PeerStatus.DISCONNECTED);
    }

    public synchronized void setupRobot(EventLoop eventLoop, EventLoop idleEventLoop, @Nullable Runnable runOnComplete) {
        this.shutdownRobotSetup();
        this.eventLoop = eventLoop;
        this.idleEventLoop = idleEventLoop;
        this.robotSetupFuture = ThreadPool.getDefault().submit(new RobotSetupRunnable(runOnComplete));
    }

    void shutdownRobotSetup() {
        if (this.robotSetupFuture != null) {
            ThreadPool.cancelFutureOrExitApplication((Future)this.robotSetupFuture, (long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"robot setup", (String)"internal error");
            this.robotSetupFuture = null;
        }
    }

    public synchronized void shutdownRobot() {
        this.shutdownRobotSetup();
        if (this.robot != null) {
            this.robot.shutdown();
        }
        this.robot = null;
        this.updateRobotStatus(RobotStatus.NONE);
    }

    public CallbackResult onNetworkConnectionEvent(NetworkConnection.NetworkEvent event) {
        CallbackResult result = CallbackResult.NOT_HANDLED;
        RobotLog.ii((String)TAG, (String)("onNetworkConnectionEvent: " + event.toString()));
        switch (event) {
            case CONNECTED_AS_GROUP_OWNER: {
                RobotLog.ii((String)TAG, (String)"Wi-Fi Direct - connected as group owner");
                if (NetworkConnection.isDeviceNameValid((String)this.networkConnection.getDeviceName())) break;
                RobotLog.ee((String)TAG, (String)"Network Connection device name contains non-printable characters");
                this.showWifiDirectNameUnprintableCharsDialog();
                result = CallbackResult.HANDLED;
                break;
            }
            case CONNECTED_AS_PEER: {
                RobotLog.ee((String)TAG, (String)"Wi-Fi Direct - connected as peer, was expecting Group Owner");
                this.showWifiDirectConnectedAsPeerDialog();
                result = CallbackResult.HANDLED;
                break;
            }
            case CONNECTION_INFO_AVAILABLE: {
                RobotLog.ii((String)TAG, (String)("Network Connection Passphrase: " + this.networkConnection.getPassphrase()));
                this.webServer.start();
                break;
            }
            case ERROR: {
                RobotLog.ee((String)TAG, (String)("Network Connection Error: " + this.networkConnection.getFailureReason()));
                break;
            }
            case AP_CREATED: {
                RobotLog.ii((String)TAG, (String)("Network Connection created: " + this.networkConnection.getConnectionOwnerName()));
            }
        }
        this.updateNetworkConnectionStatus(event);
        return result;
    }

    private void showWifiDirectNameUnprintableCharsDialog() {
        if (this.alertDialogWifiDirectNameNonPrintableChars == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, 16973935));
            builder.setTitle((CharSequence)this.getString(R.string.title_p2p_unprintable_chars));
            builder.setMessage((CharSequence)this.getString(R.string.msg_p2p_unprintable_chars));
            builder.setCancelable(false);
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FtcRobotControllerService.this.alertDialogWifiDirectNameNonPrintableChars = null;
                }
            });
            this.alertDialogWifiDirectNameNonPrintableChars = builder.show();
        }
    }

    private void showWifiDirectConnectedAsPeerDialog() {
        if (this.alertDialogConnectedAsPeer == null) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper((Context)this, 16973935));
            builder.setTitle((CharSequence)this.getString(R.string.title_p2p_misconfigured));
            builder.setMessage((CharSequence)this.getString(R.string.msg_rc_p2p_misconfigured));
            builder.setCancelable(false);
            builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FtcRobotControllerService.this.alertDialogConnectedAsPeer = null;
                }
            });
            this.alertDialogConnectedAsPeer = builder.show();
        }
    }

    private void updateNetworkConnectionStatus(NetworkConnection.NetworkEvent event) {
        this.networkConnectionStatus = event;
        if (this.callback != null) {
            this.callback.networkConnectionUpdate(this.networkConnectionStatus);
        }
    }

    private void updateRobotStatus(@NonNull RobotStatus status) {
        this.robotStatus = status;
        if (this.callback != null) {
            this.callback.updateRobotStatus(status);
        }
    }

    private class EventLoopMonitor
    implements EventLoopManager.EventLoopMonitor {
        private EventLoopMonitor() {
        }

        public void onStateChange(@NonNull RobotState state) {
            if (FtcRobotControllerService.this.callback == null) {
                return;
            }
            FtcRobotControllerService.this.callback.updateRobotState(state);
            if (state == RobotState.RUNNING) {
                FtcRobotControllerService.this.updateRobotStatus(RobotStatus.NONE);
            }
        }

        public void onPeerConnected() {
            this.updatePeerStatus(PeerStatus.CONNECTED);
            RobotLog.dd((String)FtcRobotControllerService.TAG, (String)"Sending user device types and preferences to driver station");
            ConfigurationTypeManager.getInstance().sendUserDeviceTypes();
            PreferenceRemoterRC.getInstance().sendAllPreferences();
        }

        public void onPeerDisconnected() {
            this.updatePeerStatus(PeerStatus.DISCONNECTED);
        }

        private void updatePeerStatus(PeerStatus peerStatus) {
            if (FtcRobotControllerService.this.callback == null) {
                return;
            }
            FtcRobotControllerService.this.callback.updatePeerStatus(peerStatus);
        }

        public void onTelemetryTransmitted() {
            if (FtcRobotControllerService.this.callback == null) {
                return;
            }
            FtcRobotControllerService.this.callback.refreshErrorTextOnUiThread();
        }
    }

    public class FtcRobotControllerBinder
    extends Binder {
        public FtcRobotControllerService getService() {
            return FtcRobotControllerService.this;
        }
    }

    private class RobotSetupRunnable
    implements Runnable {
        @Nullable
        Runnable runOnComplete;

        RobotSetupRunnable(Runnable runOnComplete) {
            this.runOnComplete = runOnComplete;
        }

        void shutdownRobot() {
            if (FtcRobotControllerService.this.robot != null) {
                FtcRobotControllerService.this.robot.shutdown();
                FtcRobotControllerService.this.robot = null;
            }
        }

        void awaitUSB() throws InterruptedException {
            FtcRobotControllerService.this.updateRobotStatus(RobotStatus.SCANNING_USB);
            AppAliveNotifier.getInstance().notifyAppAlive();
            Thread.sleep(5000L);
            AppAliveNotifier.getInstance().notifyAppAlive();
        }

        void initializeEventLoopAndRobot() throws RobotCoreException {
            if (FtcRobotControllerService.this.eventLoopManager == null) {
                FtcRobotControllerService.this.eventLoopManager = new EventLoopManager((Context)FtcRobotControllerService.this, (EventLoopManagerClient)FtcRobotControllerService.this, FtcRobotControllerService.this.idleEventLoop);
            }
            FtcRobotControllerService.this.robot = RobotFactory.createRobot((EventLoopManager)FtcRobotControllerService.this.eventLoopManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForWifi() throws InterruptedException {
            FtcRobotControllerService.this.updateRobotStatus(RobotStatus.WAITING_ON_WIFI);
            boolean waited = false;
            while (true) {
                Object object = FtcRobotControllerService.this.wifiDirectCallbackLock;
                synchronized (object) {
                    if (FtcRobotControllerService.this.wifiDirectAgent.isWifiEnabled()) {
                        return waited;
                    }
                    waited = true;
                    FtcRobotControllerService.this.waitForNextWifiDirectCallback();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForWifiDirect() throws InterruptedException {
            FtcRobotControllerService.this.updateRobotStatus(RobotStatus.WAITING_ON_WIFI_DIRECT);
            boolean waited = false;
            while (true) {
                Object object = FtcRobotControllerService.this.wifiDirectCallbackLock;
                synchronized (object) {
                    if (FtcRobotControllerService.this.wifiDirectAgent.isWifiDirectEnabled()) {
                        return waited;
                    }
                    waited = true;
                    FtcRobotControllerService.this.waitForNextWifiDirectCallback();
                }
            }
        }

        boolean waitForNetworkConnection() throws InterruptedException {
            RobotLog.vv((String)FtcRobotControllerService.TAG, (String)"Waiting for a connection to a Wi-Fi service");
            FtcRobotControllerService.this.updateRobotStatus(RobotStatus.WAITING_ON_NETWORK_CONNECTION);
            boolean waited = false;
            while (!FtcRobotControllerService.this.networkConnection.isConnected()) {
                waited = true;
                FtcRobotControllerService.this.networkConnection.onWaitForConnection();
                Thread.sleep(1000L);
            }
            return waited;
        }

        void waitForNetwork() throws InterruptedException {
            if (FtcRobotControllerService.this.networkConnection.getNetworkType() == NetworkType.WIFIDIRECT) {
                this.waitForWifi();
                this.waitForWifiDirect();
                FtcRobotControllerService.this.networkConnection.createConnection();
            }
            this.waitForNetworkConnection();
            FtcRobotControllerService.this.webServer.start();
        }

        void startRobot() throws RobotCoreException {
            FtcRobotControllerService.this.updateRobotStatus(RobotStatus.STARTING_ROBOT);
            ((FtcRobotControllerService)FtcRobotControllerService.this).robot.eventLoopManager.setMonitor((EventLoopManager.EventLoopMonitor)FtcRobotControllerService.this.eventLoopMonitor);
            FtcRobotControllerService.this.robot.start(FtcRobotControllerService.this.eventLoop);
        }

        @Override
        public void run() {
            final boolean isFirstRun = !FtcRobotControllerService.this.robotSetupHasBeenStarted;
            FtcRobotControllerService.this.robotSetupHasBeenStarted = true;
            ThreadPool.logThreadLifeCycle((String)"RobotSetupRunnable.run()", (Runnable)new Runnable(){

                @Override
                public void run() {
                    RobotLog.vv((String)FtcRobotControllerService.TAG, (String)"Processing robot setup");
                    try {
                        RobotSetupRunnable.this.shutdownRobot();
                        RobotSetupRunnable.this.awaitUSB();
                        RobotSetupRunnable.this.initializeEventLoopAndRobot();
                        RobotSetupRunnable.this.waitForNetwork();
                        RobotSetupRunnable.this.startRobot();
                    }
                    catch (RobotCoreException e) {
                        FtcRobotControllerService.this.updateRobotStatus(RobotStatus.UNABLE_TO_START_ROBOT);
                        RobotLog.setGlobalErrorMsg((RobotCoreException)e, (String)FtcRobotControllerService.this.getString(R.string.globalErrorFailedToCreateRobot));
                    }
                    catch (InterruptedException e) {
                        FtcRobotControllerService.this.updateRobotStatus(RobotStatus.ABORT_DUE_TO_INTERRUPT);
                    }
                    finally {
                        if (RobotSetupRunnable.this.runOnComplete != null) {
                            RobotSetupRunnable.this.runOnComplete.run();
                        }
                    }
                    if (isFirstRun) {
                        RobotLog.dd((String)FtcRobotControllerService.TAG, (String)"Detecting Wi-Fi reset");
                        FtcRobotControllerService.this.networkConnection.detectWifiReset();
                    }
                }
            });
        }
    }
}

