/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.widget.FrameLayout;
import com.qualcomm.ftccommon.LaunchActivityConstantsList;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.ViewLogsActivity;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectDeviceNameManager;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.PreferencesHelper;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;

public class FtcRobotControllerSettingsActivity
extends ThemedActivity {
    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_generic_settings);
        DeviceNameManagerFactory.getInstance().initializeDeviceNameIfNecessary();
        this.getFragmentManager().beginTransaction().replace(R.id.container, (Fragment)new SettingsFragment()).commit();
    }

    public static class SettingsFragment
    extends PreferenceFragment {
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(R.xml.app_settings);
            Preference editDeviceNamePref = this.findPreference(this.getString(R.string.pref_device_name));
            editDeviceNamePref.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

                public boolean onPreferenceChange(Preference preference, Object newValue) {
                    if (newValue instanceof String && WifiDirectDeviceNameManager.validDeviceName((String)((String)newValue))) {
                        return true;
                    }
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                    builder.setTitle((CharSequence)this.getString(R.string.prefedit_device_name_invalid_title));
                    builder.setMessage((CharSequence)this.getString(R.string.prefedit_device_name_invalid_text));
                    builder.setPositiveButton(17039370, null);
                    builder.show();
                    return false;
                }
            });
            Preference prefViewLogs = this.findPreference(this.getString(R.string.pref_launch_viewlogs));
            prefViewLogs.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    Intent viewLogsIntent = new Intent((Context)AppUtil.getDefContext(), ViewLogsActivity.class);
                    viewLogsIntent.putExtra("org.firstinspires.ftc.ftccommon.logFilename", RobotLog.getLogFilename((Context)this.getActivity()));
                    this.startActivity(viewLogsIntent);
                    return true;
                }
            });
            PreferencesHelper preferencesHelper = new PreferencesHelper(this.getTag());
            if (!preferencesHelper.readBoolean(this.getString(R.string.pref_has_speaker), true)) {
                Preference prefSoundOnOff = this.findPreference(this.getString(R.string.pref_sound_on_off));
                prefSoundOnOff.setEnabled(false);
            }
        }

        public void onActivityResult(int request, int result, Intent intent) {
            if ((request == LaunchActivityConstantsList.RequestCode.CONFIGURE_ROBOT_CONTROLLER.ordinal() || request == LaunchActivityConstantsList.RequestCode.SETTINGS_ROBOT_CONTROLLER.ordinal()) && result == -1) {
                this.getActivity().setResult(-1, intent);
            }
        }
    }
}

