/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.AnyRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.Arrays;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectChannelAndDescription;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectChannelChanger;
import org.firstinspires.ftc.robotcore.internal.network.WifiUtil;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.PreferencesHelper;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.inspection.R;

public class FtcWifiDirectChannelSelectorActivity
extends ThemedActivity
implements AdapterView.OnItemClickListener {
    public static final String TAG = "FtcWifiDirectChannelSelectorActivity";
    private boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
    private PreferencesHelper preferencesHelper = new PreferencesHelper("FtcWifiDirectChannelSelectorActivity");
    private WifiDirectChannelChanger configurer = null;
    private final int INDEX_AUTO_AND_2_4_ITEMS = 12;

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ftc_wifi_channel_selector);
        ListView channelPickList = (ListView)this.findViewById(R.id.channelPickList);
        this.loadAdapter(channelPickList);
        channelPickList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        channelPickList.setChoiceMode(1);
        if (!this.remoteConfigure) {
            this.configurer = new WifiDirectChannelChanger();
        }
    }

    protected void onStart() {
        super.onStart();
        int prefChannel = this.preferencesHelper.readInt(this.getString(R.string.pref_wifip2p_channel), -1);
        if (prefChannel == -1) {
            prefChannel = 0;
            RobotLog.vv((String)TAG, (String)"pref_wifip2p_channel: No preferred channel defined. Will use a default value of %d", (Object[])new Object[]{prefChannel});
        } else {
            RobotLog.vv((String)TAG, (String)"pref_wifip2p_channel: Found existing preferred channel (%d).", (Object[])new Object[]{prefChannel});
        }
        ListView channelPickList = (ListView)this.findViewById(R.id.channelPickList);
        ArrayAdapter<WifiDirectChannelAndDescription> adapter = this.getAdapter((AdapterView<?>)channelPickList);
        int index = -1;
        for (int i = 0; i < adapter.getCount(); ++i) {
            WifiDirectChannelAndDescription item = (WifiDirectChannelAndDescription)adapter.getItem(i);
            if (prefChannel != item.getChannel()) continue;
            index = i;
            channelPickList.setItemChecked(index, true);
            RobotLog.vv((String)TAG, (String)"preferred channel matches ListView index %d (%d).", (Object[])new Object[]{index, item.getChannel()});
            i = adapter.getCount();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected ArrayAdapter<WifiDirectChannelAndDescription> getAdapter(AdapterView<?> av) {
        return (ArrayAdapter)av.getAdapter();
    }

    protected void loadAdapter(ListView itemsListView) {
        Object[] items = WifiDirectChannelAndDescription.load().toArray(new WifiDirectChannelAndDescription[0]);
        Arrays.sort(items);
        if (!WifiUtil.is5GHzAvailable()) {
            items = (WifiDirectChannelAndDescription[])Arrays.copyOf(items, 12);
            RobotLog.vv((String)TAG, (String)"5GHz radio not available.");
        } else {
            RobotLog.vv((String)TAG, (String)"5GHz radio is available.");
        }
        WifiChannelItemAdapter adapter = new WifiChannelItemAdapter((Context)this, 0x1090009, (WifiDirectChannelAndDescription[])items);
        itemsListView.setAdapter((ListAdapter)adapter);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.configurer == null || !this.configurer.isBusy()) {
            ArrayAdapter<WifiDirectChannelAndDescription> adapter = this.getAdapter(parent);
            WifiDirectChannelAndDescription item = (WifiDirectChannelAndDescription)adapter.getItem(position);
            CheckedTextView checkedTextView = (CheckedTextView)view;
            checkedTextView.setChecked(true);
            if (this.remoteConfigure) {
                if (this.preferencesHelper.writePrefIfDifferent(this.getString(R.string.pref_wifip2p_channel), (Object)item.getChannel())) {
                    AppUtil.getInstance().showToast(UILocation.ONLY_LOCAL, this.getString(R.string.toastWifiP2pChannelChangeRequestedDS, new Object[]{item.getDescription()}));
                }
            } else {
                this.configurer.changeToChannel(item.getChannel());
            }
        }
    }

    public void onWifiSettingsClicked(View view) {
        RobotLog.vv((String)TAG, (String)"launch Wi-Fi settings");
        this.startActivity(new Intent("android.net.wifi.PICK_WIFI_NETWORK"));
    }

    protected class WifiChannelItemAdapter
    extends ArrayAdapter<WifiDirectChannelAndDescription> {
        @AnyRes
        int checkmark;

        public WifiChannelItemAdapter(@LayoutRes Context context, @NonNull int resource, WifiDirectChannelAndDescription[] objects) {
            super(context, resource, (Object[])objects);
            TypedValue typedValue = new TypedValue();
            FtcWifiDirectChannelSelectorActivity.this.getTheme().resolveAttribute(16843289, typedValue, true);
            this.checkmark = typedValue.resourceId;
        }

        @NonNull
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            CheckedTextView checkedTextView = (CheckedTextView)view;
            checkedTextView.setCheckMarkDrawable(this.checkmark);
            return view;
        }
    }
}

