/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectAgent;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectGroupName;
import org.firstinspires.ftc.robotcore.internal.network.WifiDirectPersistentGroupManager;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.inspection.R;

public class FtcWifiDirectRememberedGroupsActivity
extends ThemedActivity {
    public static final String TAG = "FtcWifiDirectRememberedGroupsActivity";
    private final boolean remoteConfigure = AppUtil.getInstance().isDriverStation();
    private final NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    private final RecvLoopCallback recvLoopCallback = new RecvLoopCallback();
    private final Object requestGroupsFutureLock = new Object();
    private Future requestGroupsFuture = null;
    private WifiDirectPersistentGroupManager persistentGroupManager;

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ftc_wifi_remembered_groups);
        if (!this.remoteConfigure) {
            this.persistentGroupManager = new WifiDirectPersistentGroupManager(WifiDirectAgent.getInstance());
        } else {
            this.networkConnectionHandler.pushReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)this.recvLoopCallback);
        }
    }

    protected void onStart() {
        super.onStart();
        if (!this.remoteConfigure) {
            this.loadLocalGroups();
        } else {
            this.requestRememberedGroups();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.removeReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)this.recvLoopCallback);
        }
    }

    protected void loadLocalGroups() {
        this.loadGroupList(this.getLocalGroupList());
    }

    protected void requestRememberedGroups() {
        RobotLog.vv((String)TAG, (String)"requestRememberedGroups()");
        this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_REMEMBERED_GROUPS"));
    }

    protected CallbackResult handleCommandRequestRememberedGroupsResp(String extra) throws RobotCoreException {
        RobotLog.vv((String)TAG, (String)"handleCommandRequestRememberedGroupsResp()");
        List names = WifiDirectGroupName.deserializeNames((String)extra);
        this.loadGroupList(names);
        return CallbackResult.HANDLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallbackResult handleRememberedGroupsChanged() {
        Object object = this.requestGroupsFutureLock;
        synchronized (object) {
            if (this.requestGroupsFuture != null) {
                this.requestGroupsFuture.cancel(false);
                this.requestGroupsFuture = null;
            }
            this.requestGroupsFuture = ThreadPool.getDefaultScheduler().schedule(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    Object object = FtcWifiDirectRememberedGroupsActivity.this.requestGroupsFutureLock;
                    synchronized (object) {
                        FtcWifiDirectRememberedGroupsActivity.this.requestRememberedGroups();
                        FtcWifiDirectRememberedGroupsActivity.this.requestGroupsFuture = null;
                    }
                    return null;
                }
            }, 250L, TimeUnit.MILLISECONDS);
        }
        return CallbackResult.HANDLED_CONTINUE;
    }

    protected List<WifiDirectGroupName> getLocalGroupList() {
        return WifiDirectGroupName.namesFromGroups((Collection)this.persistentGroupManager.getPersistentGroups());
    }

    protected void loadGroupList(final List<WifiDirectGroupName> names) {
        AppUtil.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ListView groupList = (ListView)FtcWifiDirectRememberedGroupsActivity.this.findViewById(R.id.groupList);
                Collections.sort(names);
                if (names.isEmpty()) {
                    names.add(new WifiDirectGroupName(FtcWifiDirectRememberedGroupsActivity.this.getString(R.string.noRememberedGroupsFound)));
                }
                WifiP2pGroupItemAdapter adapter = new WifiP2pGroupItemAdapter((Context)AppUtil.getInstance().getActivity(), 0x1090009, names);
                groupList.setAdapter((ListAdapter)adapter);
            }
        });
    }

    public void onClearRememberedGroupsClicked(View view) {
        RobotLog.vv((String)TAG, (String)"onClearRememberedGroupsClicked()");
        if (!this.remoteConfigure) {
            this.persistentGroupManager.deleteAllPersistentGroups();
            AppUtil.getInstance().showToast(UILocation.BOTH, this.getString(R.string.toastWifiP2pRememberedGroupsCleared));
            this.loadLocalGroups();
        } else {
            this.networkConnectionHandler.sendCommand(new Command("CMD_CLEAR_REMEMBERED_GROUPS"));
        }
    }

    protected class RecvLoopCallback
    extends RecvLoopRunnable.DegenerateCallback {
        protected RecvLoopCallback() {
        }

        public CallbackResult commandEvent(Command command) {
            CallbackResult result = CallbackResult.NOT_HANDLED;
            try {
                switch (command.getName()) {
                    case "CMD_REQUEST_REMEMBERED_GROUPS_RESP": {
                        result = FtcWifiDirectRememberedGroupsActivity.this.handleCommandRequestRememberedGroupsResp(command.getExtra());
                        break;
                    }
                    case "CMD_NOTIFY_WIFI_DIRECT_REMEMBERED_GROUPS_CHANGED": {
                        FtcWifiDirectRememberedGroupsActivity.this.handleRememberedGroupsChanged();
                    }
                }
            }
            catch (RobotCoreException e) {
                RobotLog.logStacktrace((Throwable)e);
            }
            return result;
        }
    }

    protected class WifiP2pGroupItemAdapter
    extends ArrayAdapter<WifiDirectGroupName> {
        public WifiP2pGroupItemAdapter(@LayoutRes Context context, @NonNull int resource, List<WifiDirectGroupName> objects) {
            super(context, resource, objects);
        }
    }
}

