/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.app.Activity;
import android.content.Context;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.qualcomm.ftccommon.FtcRobotControllerService;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.Restarter;
import com.qualcomm.robotcore.hardware.Gamepad;
import com.qualcomm.robotcore.robot.RobotState;
import com.qualcomm.robotcore.robot.RobotStatus;
import com.qualcomm.robotcore.util.Dimmer;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.wifi.NetworkConnection;
import org.firstinspires.ftc.ftccommon.external.RobotStateMonitor;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameListener;
import org.firstinspires.ftc.robotcore.internal.network.DeviceNameManagerFactory;
import org.firstinspires.ftc.robotcore.internal.network.NetworkStatus;
import org.firstinspires.ftc.robotcore.internal.network.PeerStatus;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeMeta;
import org.firstinspires.ftc.robotcore.internal.opmode.RegisteredOpModes;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class UpdateUI {
    public static final boolean DEBUG = false;
    private static final String TAG = "UpdateUI";
    private static final int NUM_GAMEPADS = 2;
    protected TextView textDeviceName;
    protected TextView textNetworkConnectionStatus;
    protected TextView textRobotStatus;
    protected TextView[] textGamepad = new TextView[2];
    protected TextView textOpMode;
    protected TextView textErrorMessage;
    @ColorInt
    protected int textErrorMessageOriginalColor;
    protected RobotState robotState = RobotState.NOT_STARTED;
    protected RobotStatus robotStatus = RobotStatus.NONE;
    protected NetworkStatus networkStatus = NetworkStatus.UNKNOWN;
    protected String networkStatusExtra = null;
    protected PeerStatus peerStatus = PeerStatus.DISCONNECTED;
    protected String networkStatusMessage = null;
    protected String stateStatusMessage = null;
    Restarter restarter;
    FtcRobotControllerService controllerService;
    Activity activity;
    Dimmer dimmer;

    public UpdateUI(Activity activity, Dimmer dimmer) {
        this.activity = activity;
        this.dimmer = dimmer;
    }

    public void setTextViews(TextView textWifiDirectStatus, TextView textRobotStatus, TextView[] textGamepad, TextView textOpMode, TextView textErrorMessage, TextView textDeviceName) {
        this.textNetworkConnectionStatus = textWifiDirectStatus;
        this.textRobotStatus = textRobotStatus;
        this.textGamepad = textGamepad;
        this.textOpMode = textOpMode;
        this.textErrorMessage = textErrorMessage;
        this.textErrorMessageOriginalColor = textErrorMessage.getCurrentTextColor();
        this.textDeviceName = textDeviceName;
    }

    protected void setText(TextView textView, String message) {
        if (textView != null && message != null) {
            if ((message = message.trim()).length() > 0) {
                textView.setText((CharSequence)message);
                textView.setVisibility(0);
            } else {
                textView.setVisibility(4);
                textView.setText((CharSequence)" ");
            }
        }
    }

    public void setControllerService(FtcRobotControllerService controllerService) {
        this.controllerService = controllerService;
    }

    public void setRestarter(Restarter restarter) {
        this.restarter = restarter;
    }

    private void requestRobotRestart() {
        this.restarter.requestRestart();
    }

    public class Callback {
        RobotStateMonitor stateMonitor = null;
        DeviceNameManagerCallback deviceNameManagerCallback = new DeviceNameManagerCallback();
        String previousOpModeName = null;
        OpModeMeta previousOpModeMeta = null;

        public Callback() {
            DeviceNameManagerFactory.getInstance().registerCallback((DeviceNameListener)this.deviceNameManagerCallback);
        }

        public void close() {
            DeviceNameManagerFactory.getInstance().unregisterCallback((DeviceNameListener)this.deviceNameManagerCallback);
        }

        public RobotStateMonitor getStateMonitor() {
            return this.stateMonitor;
        }

        public void setStateMonitor(RobotStateMonitor stateMonitor) {
            this.stateMonitor = stateMonitor;
        }

        public void restartRobot() {
            ThreadPool.getDefault().submit(new Runnable(){

                @Override
                public void run() {
                    AppUtil.getInstance().runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            UpdateUI.this.requestRobotRestart();
                        }
                    });
                }
            });
        }

        public void updateUi(final String opModeName, final Gamepad[] gamepads) {
            UpdateUI.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OpModeMeta opModeMeta;
                    if (UpdateUI.this.textGamepad != null) {
                        for (int i = 0; i < UpdateUI.this.textGamepad.length && i < gamepads.length; ++i) {
                            if (gamepads[i].getGamepadId() == -1) {
                                UpdateUI.this.setText(UpdateUI.this.textGamepad[i], "");
                                continue;
                            }
                            UpdateUI.this.setText(UpdateUI.this.textGamepad[i], gamepads[i].toString());
                        }
                    }
                    if (opModeName.equals(Callback.this.previousOpModeName)) {
                        opModeMeta = Callback.this.previousOpModeMeta;
                    } else {
                        opModeMeta = RegisteredOpModes.getInstance().getOpModeMetadata(opModeName);
                        Callback.this.previousOpModeName = opModeName;
                        Callback.this.previousOpModeMeta = opModeMeta;
                    }
                    UpdateUI.this.setText(UpdateUI.this.textOpMode, "OpMode: " + opModeMeta.getDisplayName());
                    Callback.this.refreshTextErrorMessage();
                }
            });
        }

        public void networkConnectionUpdate(NetworkConnection.NetworkEvent event) {
            switch (event) {
                case UNKNOWN: {
                    this.updateNetworkConnectionStatus(NetworkStatus.UNKNOWN);
                    break;
                }
                case DISCONNECTED: {
                    this.updateNetworkConnectionStatus(NetworkStatus.INACTIVE);
                    break;
                }
                case CONNECTED_AS_GROUP_OWNER: {
                    this.updateNetworkConnectionStatus(NetworkStatus.ENABLED);
                    break;
                }
                case ERROR: {
                    this.updateNetworkConnectionStatus(NetworkStatus.ERROR);
                    break;
                }
                case CONNECTION_INFO_AVAILABLE: {
                    this.updateNetworkConnectionStatus(NetworkStatus.ACTIVE);
                    break;
                }
                case AP_CREATED: {
                    NetworkConnection networkConnection = UpdateUI.this.controllerService.getNetworkConnection();
                    this.updateNetworkConnectionStatus(NetworkStatus.CREATED_AP_CONNECTION, networkConnection.getConnectionOwnerName());
                    break;
                }
            }
        }

        protected void displayDeviceName(final String name) {
            UpdateUI.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UpdateUI.this.textDeviceName.setText((CharSequence)name);
                }
            });
        }

        public void updateNetworkConnectionStatus(NetworkStatus networkStatus) {
            if (UpdateUI.this.networkStatus != networkStatus) {
                UpdateUI.this.networkStatus = networkStatus;
                UpdateUI.this.networkStatusExtra = null;
                if (this.stateMonitor != null) {
                    this.stateMonitor.updateNetworkStatus(networkStatus, null);
                }
                this.refreshNetworkStatus();
            }
        }

        public void updateNetworkConnectionStatus(NetworkStatus networkStatus, @NonNull String extra) {
            if (UpdateUI.this.networkStatus != networkStatus || !extra.equals(UpdateUI.this.networkStatusExtra)) {
                UpdateUI.this.networkStatus = networkStatus;
                UpdateUI.this.networkStatusExtra = extra;
                if (this.stateMonitor != null) {
                    this.stateMonitor.updateNetworkStatus(networkStatus, extra);
                }
                this.refreshNetworkStatus();
            }
        }

        public void updatePeerStatus(PeerStatus peerStatus) {
            if (UpdateUI.this.peerStatus != peerStatus) {
                UpdateUI.this.peerStatus = peerStatus;
                if (this.stateMonitor != null) {
                    this.stateMonitor.updatePeerStatus(peerStatus);
                }
                this.refreshNetworkStatus();
            }
        }

        void refreshNetworkStatus() {
            String strPeerStatus;
            String strNetworkStatus;
            String format = UpdateUI.this.activity.getString(R.string.networkStatusFormat);
            final String message = String.format(format, strNetworkStatus = UpdateUI.this.networkStatus.toString((Context)UpdateUI.this.activity, new Object[]{UpdateUI.this.networkStatusExtra}), strPeerStatus = UpdateUI.this.peerStatus == PeerStatus.UNKNOWN ? "" : String.format(", %s", UpdateUI.this.peerStatus.toString((Context)UpdateUI.this.activity)));
            if (!message.equals(UpdateUI.this.networkStatusMessage)) {
                RobotLog.vv((String)UpdateUI.TAG, (String)message);
            }
            UpdateUI.this.networkStatusMessage = message;
            UpdateUI.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UpdateUI.this.setText(UpdateUI.this.textNetworkConnectionStatus, message);
                }
            });
        }

        public void updateRobotStatus(@NonNull RobotStatus status) {
            UpdateUI.this.robotStatus = status;
            if (this.stateMonitor != null) {
                this.stateMonitor.updateRobotStatus(UpdateUI.this.robotStatus);
            }
            this.refreshStateStatus();
        }

        public void updateRobotState(@NonNull RobotState state) {
            UpdateUI.this.robotState = state;
            if (this.stateMonitor != null) {
                this.stateMonitor.updateRobotState(UpdateUI.this.robotState);
            }
            this.refreshStateStatus();
        }

        protected void refreshStateStatus() {
            String status;
            String state;
            String format = UpdateUI.this.activity.getString(R.string.robotStatusFormat);
            final String message = String.format(format, state = UpdateUI.this.robotState.toString((Context)UpdateUI.this.activity), status = UpdateUI.this.robotStatus == RobotStatus.NONE ? "" : String.format(", %s", UpdateUI.this.robotStatus.toString((Context)UpdateUI.this.activity)));
            if (!message.equals(UpdateUI.this.stateStatusMessage)) {
                RobotLog.v((String)message);
            }
            UpdateUI.this.stateStatusMessage = message;
            UpdateUI.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    UpdateUI.this.setText(UpdateUI.this.textRobotStatus, message);
                    Callback.this.refreshTextErrorMessage();
                }
            });
        }

        public void refreshErrorTextOnUiThread() {
            UpdateUI.this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Callback.this.refreshTextErrorMessage();
                }
            });
        }

        void refreshTextErrorMessage() {
            String errorMessage = RobotLog.getGlobalErrorMsg();
            RobotLog.GlobalWarningMessage warningMessage = RobotLog.getGlobalWarningMessage();
            if (!errorMessage.isEmpty() || !warningMessage.message.isEmpty()) {
                if (!errorMessage.isEmpty()) {
                    String errorForDisplay = UpdateUI.this.activity.getString(R.string.error_text_error, new Object[]{errorMessage});
                    UpdateUI.this.setText(UpdateUI.this.textErrorMessage, errorForDisplay);
                    TextView textView = UpdateUI.this.textErrorMessage;
                    AppUtil.getInstance();
                    textView.setTextColor(AppUtil.getColor((int)R.color.text_error));
                    if (this.stateMonitor != null) {
                        this.stateMonitor.updateErrorMessage(errorMessage);
                    }
                } else {
                    UpdateUI.this.setText(UpdateUI.this.textErrorMessage, warningMessage.message);
                    TextView textView = UpdateUI.this.textErrorMessage;
                    AppUtil.getInstance();
                    textView.setTextColor(AppUtil.getColor((int)R.color.text_warning));
                    if (this.stateMonitor != null) {
                        this.stateMonitor.updateWarningMessage(warningMessage);
                    }
                }
                UpdateUI.this.dimmer.longBright();
            } else {
                UpdateUI.this.setText(UpdateUI.this.textErrorMessage, "");
                UpdateUI.this.textErrorMessage.setTextColor(UpdateUI.this.textErrorMessageOriginalColor);
                if (this.stateMonitor != null) {
                    this.stateMonitor.updateErrorMessage(null);
                    this.stateMonitor.updateWarningMessage(null);
                }
            }
        }

        protected class DeviceNameManagerCallback
        implements DeviceNameListener {
            protected DeviceNameManagerCallback() {
            }

            public void onDeviceNameChanged(String newDeviceName) {
                Callback.this.displayDeviceName(newDeviceName);
            }
        }
    }
}

