/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.core.content.FileProvider;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.inspection.R;

public class ViewLogsActivity
extends ThemedActivity {
    public static final String TAG = "ViewLogsActivity";
    WebView webViewForLogcat;
    int DEFAULT_NUMBER_OF_LINES = 500;
    public static final String FILENAME = "org.firstinspires.ftc.ftccommon.logFilename";
    private File logFile;
    int errorColor;
    String filepath = " ";

    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_view_logs);
        this.errorColor = this.getResources().getColor(R.color.text_warning);
        this.webViewForLogcat = (WebView)this.findViewById(R.id.webView);
        this.webViewForLogcat.getSettings().setBuiltInZoomControls(true);
        this.webViewForLogcat.getSettings().setDisplayZoomControls(false);
        this.webViewForLogcat.setBackgroundColor(this.getResources().getColor(R.color.logviewer_bgcolor));
    }

    protected void onStart() {
        super.onStart();
        Intent intent = this.getIntent();
        Serializable extra = intent.getSerializableExtra(FILENAME);
        if (extra != null) {
            this.filepath = (String)((Object)extra);
        }
        this.logFile = new File(this.filepath);
        try {
            String output = this.readNLines(this.DEFAULT_NUMBER_OF_LINES);
            Spannable colorized = this.colorize(output);
            String html = String.format("<span style='white-space: nowrap;'><font face='monospace' color='white'>%s</font></span>", Html.toHtml((Spanned)colorized));
            this.webViewForLogcat.setWebViewClient(new WebViewClient(){

                public void onPageFinished(WebView webView, String url) {
                    ViewLogsActivity.this.webViewForLogcat.scrollTo(0, 900000000);
                }
            });
            this.webViewForLogcat.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    Intent sendIntent = new Intent("android.intent.action.SEND");
                    sendIntent.putExtra("android.intent.extra.SUBJECT", "FTC Robot Log - " + DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()));
                    sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)FileProvider.getUriForFile((Context)ViewLogsActivity.this, (String)(ViewLogsActivity.this.getPackageName() + ".provider"), (File)ViewLogsActivity.this.logFile));
                    sendIntent.setType("text/plain");
                    ViewLogsActivity.this.startActivity(sendIntent);
                    return false;
                }
            });
            this.webViewForLogcat.loadData(html, "text/html", "UTF-8");
        }
        catch (IOException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Exception loading logcat data");
            this.webViewForLogcat.loadData("<font color='white'>Error loading logcat data</font>", "text/html", "UTF-8");
        }
    }

    public String readNLines(int n) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));
        String[] ringBuffer = new String[n];
        int totalLines = 0;
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            ringBuffer[totalLines % ringBuffer.length] = line;
            ++totalLines;
        }
        int start = totalLines - n;
        if (start < 0) {
            start = 0;
        }
        String output = "";
        for (int i = start; i < totalLines; ++i) {
            int index = i % ringBuffer.length;
            String currentLine = ringBuffer[index];
            output = output + currentLine + "\n";
        }
        int mostRecentIndex = output.lastIndexOf("--------- beginning");
        if (mostRecentIndex < 0) {
            return output;
        }
        return output.substring(mostRecentIndex);
    }

    private Spannable colorize(String output) {
        SpannableString span = new SpannableString((CharSequence)output);
        String[] lines = output.split("\\n");
        int currentStringIndex = 0;
        for (String line : lines) {
            if (line.contains(" E ")) {
                span.setSpan((Object)new ForegroundColorSpan(this.errorColor), currentStringIndex, currentStringIndex + line.length(), 33);
            }
            currentStringIndex += line.length();
            ++currentStringIndex;
        }
        return span;
    }
}

