/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon;

import com.qualcomm.ftccommon.CommandList;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.PeerStatusCallback;

public class VisualIdentificationManager {
    private static final VisualIdentificationManager instance = new VisualIdentificationManager();
    private static final String TAG = "VisualIDManager";
    private final Map<SerialNumber, LynxUsbDevice.SystemOperationHandle> identificationsInProgressMap = new HashMap<SerialNumber, LynxUsbDevice.SystemOperationHandle>();

    public static VisualIdentificationManager getInstance() {
        return instance;
    }

    private VisualIdentificationManager() {
        NetworkConnectionHandler.getInstance().registerPeerStatusCallback(new PeerStatusCallback(){

            public void onPeerConnected() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPeerDisconnected() {
                VisualIdentificationManager visualIdentificationManager = VisualIdentificationManager.this;
                synchronized (visualIdentificationManager) {
                    RobotLog.vv((String)VisualIdentificationManager.TAG, (String)"Driver Station disconnected. Stopping all visual identifications.");
                    for (LynxUsbDevice.SystemOperationHandle handle : VisualIdentificationManager.this.identificationsInProgressMap.values()) {
                        try {
                            handle.performSystemOperation(module -> module.visuallyIdentify(false), 200, TimeUnit.MILLISECONDS);
                        }
                        catch (RobotCoreException | TimeoutException e) {
                            RobotLog.ee((String)VisualIdentificationManager.TAG, (Throwable)e, (String)"Failed to stop visual identification when DS disconnected");
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        handle.close();
                    }
                    VisualIdentificationManager.this.identificationsInProgressMap.clear();
                }
            }
        });
    }

    public synchronized void handleCommandVisuallyIdentify(CommandList.CmdVisuallyIdentify command) {
        SerialNumber serial = command.usbSerialNumber;
        int parentAddress = command.parentModuleAddress;
        int address = command.moduleAddress;
        boolean shouldIdentify = command.shouldIdentify;
        RobotLog.vv((String)TAG, (String)"Setting visual identification status for (serial=%s parentAddress=%d address=%d) to %b", (Object[])new Object[]{serial, parentAddress, address, shouldIdentify});
        LynxUsbDevice.SystemOperationHandle sysopHandle = this.identificationsInProgressMap.get(serial);
        try {
            if (sysopHandle == null) {
                LynxUsbDevice lynxUsb = (LynxUsbDevice)USBScanManager.getInstance().getDeviceManager().createLynxUsbDevice(serial.getScannableDeviceSerialNumber(), null);
                sysopHandle = lynxUsb.keepConnectedModuleAliveForSystemOperations(command.moduleAddress, command.parentModuleAddress);
            }
            sysopHandle.performSystemOperation(module -> module.visuallyIdentify(shouldIdentify), 200, TimeUnit.MILLISECONDS);
        }
        catch (RobotCoreException | InterruptedException | TimeoutException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to visually identify REV Hub");
        }
        if (shouldIdentify) {
            if (sysopHandle != null) {
                this.identificationsInProgressMap.put(serial, sysopHandle);
            }
        } else {
            this.identificationsInProgressMap.remove(serial);
            if (sysopHandle != null) {
                sysopHandle.close();
            }
        }
    }
}

