/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.FtcConfigurationActivity;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.inspection.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConfigureFromTemplateActivity
extends EditActivity {
    public static final RequestCode requestCode = RequestCode.CONFIG_FROM_TEMPLATE;
    public static final String TAG = "ConfigFromTemplate";
    protected NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected List<RobotConfigFile> configurationList = new CopyOnWriteArrayList<RobotConfigFile>();
    protected List<RobotConfigFile> templateList = new CopyOnWriteArrayList<RobotConfigFile>();
    protected final USBScanManager usbScanManager = USBScanManager.getInstance();
    protected ViewGroup feedbackAnchor;
    protected Map<String, String> remoteTemplates = new ConcurrentHashMap<String, String>();
    protected final Deque<StringProcessor> receivedConfigProcessors = new LinkedList<StringProcessor>();
    protected final RecvLoopRunnable.RecvLoopCallback commandCallback = new CommandCallback();

    @Override
    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_configure_from_template);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        if (this.remoteConfigure) {
            this.networkConnectionHandler.pushReceiveLoopCallback(this.commandCallback);
        }
        this.usbScanManager.startDeviceScanIfNecessary();
        this.feedbackAnchor = (ViewGroup)this.findViewById(R.id.feedbackAnchor);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.robotConfigFileManager.updateActiveConfigHeader(this.currentCfgFile);
        if (!this.remoteConfigure) {
            this.configurationList = this.robotConfigFileManager.getXMLFiles();
            this.templateList = this.robotConfigFileManager.getXMLTemplates();
            this.warnIfNoTemplates();
        } else {
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATIONS"));
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATION_TEMPLATES"));
        }
        this.populate();
    }

    protected CallbackResult handleCommandRequestConfigurationsResp(String extra) throws RobotCoreException {
        this.configurationList = RobotConfigFileManager.deserializeXMLConfigList(extra);
        return CallbackResult.HANDLED;
    }

    protected CallbackResult handleCommandRequestTemplatesResp(String extra) throws RobotCoreException {
        this.templateList = RobotConfigFileManager.deserializeXMLConfigList(extra);
        this.warnIfNoTemplates();
        this.populate();
        return CallbackResult.HANDLED;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.removeReceiveLoopCallback(this.commandCallback);
        }
    }

    protected void warnIfNoTemplates() {
        if (this.templateList.size() == 0) {
            this.feedbackAnchor.setVisibility(4);
            final String msg0 = this.getString(R.string.noTemplatesFoundTitle);
            final String msg1 = this.getString(R.string.noTemplatesFoundMessage);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ConfigureFromTemplateActivity.this.utility.setFeedbackText((CharSequence)msg0, (CharSequence)msg1, R.id.feedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
                }
            });
        } else {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ConfigureFromTemplateActivity.this.feedbackAnchor.removeAllViews();
                    ConfigureFromTemplateActivity.this.feedbackAnchor.setVisibility(8);
                }
            });
        }
    }

    protected void populate() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ViewGroup parent = (ViewGroup)ConfigureFromTemplateActivity.this.findViewById(R.id.templateList);
                parent.removeAllViews();
                final Collator coll = Collator.getInstance();
                coll.setStrength(0);
                Collections.sort(ConfigureFromTemplateActivity.this.templateList, new Comparator<RobotConfigFile>(){

                    @Override
                    public int compare(RobotConfigFile lhs, RobotConfigFile rhs) {
                        return coll.compare(lhs.getName(), rhs.getName());
                    }
                });
                for (RobotConfigFile template : ConfigureFromTemplateActivity.this.templateList) {
                    View child = LayoutInflater.from((Context)ConfigureFromTemplateActivity.this.context).inflate(R.layout.template_info, null);
                    parent.addView(child);
                    TextView name = (TextView)child.findViewById(R.id.templateNameText);
                    name.setText((CharSequence)template.getName());
                    name.setTag((Object)template);
                }
            }
        });
    }

    public void onConfigureButtonPressed(View v) {
        RobotConfigFile templateMeta = this.getTemplateMeta(v);
        this.getTemplateAndThen(templateMeta, new TemplateProcessor(){

            @Override
            public void processTemplate(RobotConfigFile templateMeta, XmlPullParser xmlPullParser) {
                ConfigureFromTemplateActivity.this.configureFromTemplate(templateMeta, xmlPullParser);
            }
        });
    }

    void configureFromTemplate(RobotConfigFile templateMeta, XmlPullParser xmlPullParser) {
        try {
            RobotConfigMap robotConfigMap = this.instantiateTemplate(templateMeta, xmlPullParser);
            this.awaitScannedDevices();
            Class<FtcConfigurationActivity> clazz = FtcConfigurationActivity.class;
            EditParameters parameters = new EditParameters(this);
            parameters.setRobotConfigMap(robotConfigMap);
            parameters.setExtantRobotConfigurations(this.configurationList);
            parameters.setScannedDevices(this.scannedDevices);
            Intent intent = new Intent(this.context, clazz);
            parameters.putIntent(intent);
            this.robotConfigFileManager.setActiveConfig(RobotConfigFile.noConfig(this.robotConfigFileManager));
            this.startActivityForResult(intent, FtcConfigurationActivity.requestCode.value);
        }
        catch (RobotCoreException robotCoreException) {
            // empty catch block
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == FtcConfigurationActivity.requestCode.value) {
            this.currentCfgFile = this.robotConfigFileManager.getActiveConfigAndUpdateUI();
        }
    }

    public void onInfoButtonPressed(View v) {
        RobotConfigFile templateMeta = this.getTemplateMeta(v);
        this.getTemplateAndThen(templateMeta, new TemplateProcessor(){

            @Override
            public void processTemplate(RobotConfigFile templateMeta, XmlPullParser xmlPullParser) {
                ConfigureFromTemplateActivity.this.showInfo(templateMeta, xmlPullParser);
            }
        });
    }

    protected void showInfo(RobotConfigFile template, XmlPullParser xmlPullParser) {
        String description = this.indent(3, this.robotConfigFileManager.getRobotConfigDescription(xmlPullParser));
        final String title = this.getString(R.string.templateConfigureConfigurationInstructionsTitle);
        final String message = String.format(this.getString(R.string.templateConfigurationInstructions), template.getName(), description);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ConfigureFromTemplateActivity.this.utility.setFeedbackText((CharSequence)title, (CharSequence)message.trim(), R.id.feedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1, R.id.feedbackOKButton);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getTemplateAndThen(final RobotConfigFile templateMeta, final TemplateProcessor processor) {
        if (this.remoteConfigure) {
            String template = this.remoteTemplates.get(templateMeta.getName());
            if (template != null) {
                XmlPullParser xmlPullParser = this.xmlPullParserFromString(template);
                processor.processTemplate(templateMeta, xmlPullParser);
            } else {
                Deque<StringProcessor> deque = this.receivedConfigProcessors;
                synchronized (deque) {
                    this.receivedConfigProcessors.addLast(new StringProcessor(){

                        @Override
                        public void processString(String template) {
                            ConfigureFromTemplateActivity.this.remoteTemplates.put(templateMeta.getName(), template);
                            XmlPullParser xmlPullParser = ConfigureFromTemplateActivity.this.xmlPullParserFromString(template);
                            processor.processTemplate(templateMeta, xmlPullParser);
                        }
                    });
                    this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_PARTICULAR_CONFIGURATION", templateMeta.toString()));
                }
            }
        } else {
            try {
                processor.processTemplate(templateMeta, templateMeta.getXml());
            }
            catch (FileNotFoundException | XmlPullParserException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to get template XML parser");
            }
        }
    }

    protected XmlPullParser xmlPullParserFromString(String string2) {
        return ReadXMLFileHandler.xmlPullParserFromReader((Reader)new StringReader(string2));
    }

    protected RobotConfigFile getTemplateMeta(View v) {
        ViewGroup viewGroup = (ViewGroup)v.getParent();
        TextView name = (TextView)viewGroup.findViewById(R.id.templateNameText);
        return (RobotConfigFile)name.getTag();
    }

    protected ScannedDevices awaitScannedDevices() {
        try {
            this.scannedDevices = this.usbScanManager.awaitScannedDevices();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.scannedDevices;
    }

    RobotConfigMap instantiateTemplate(RobotConfigFile templateMeta, XmlPullParser xmlPullParser) throws RobotCoreException {
        this.awaitScannedDevices();
        ReadXMLFileHandler readXMLFileHandler = new ReadXMLFileHandler();
        List controllerList = readXMLFileHandler.parse(xmlPullParser);
        RobotConfigMap robotConfigMap = new RobotConfigMap(controllerList);
        robotConfigMap.bindUnboundControllers(this.scannedDevices);
        return robotConfigMap;
    }

    private String indent(int count, String target) {
        String indent = "";
        for (int i = 0; i < count; ++i) {
            indent = indent + " ";
        }
        return indent + target.replace("\n", "\n" + indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackResult handleCommandRequestParticularConfigurationResp(String config) throws RobotCoreException {
        StringProcessor processor = null;
        Deque<StringProcessor> deque = this.receivedConfigProcessors;
        synchronized (deque) {
            processor = this.receivedConfigProcessors.pollFirst();
        }
        if (processor != null) {
            processor.processString(config);
        }
        return CallbackResult.HANDLED;
    }

    private class CommandCallback
    extends RecvLoopRunnable.DegenerateCallback {
        private CommandCallback() {
        }

        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            CallbackResult result = CallbackResult.NOT_HANDLED;
            try {
                String name = command.getName();
                String extra = command.getExtra();
                if (name.equals("CMD_REQUEST_CONFIGURATIONS_RESP")) {
                    result = ConfigureFromTemplateActivity.this.handleCommandRequestConfigurationsResp(extra);
                } else if (name.equals("CMD_REQUEST_CONFIGURATION_TEMPLATES_RESP")) {
                    result = ConfigureFromTemplateActivity.this.handleCommandRequestTemplatesResp(extra);
                } else if (name.equals("CMD_REQUEST_PARTICULAR_CONFIGURATION_RESP")) {
                    result = ConfigureFromTemplateActivity.this.handleCommandRequestParticularConfigurationResp(extra);
                } else if (name.equals("CMD_NOTIFY_ACTIVE_CONFIGURATION")) {
                    result = ConfigureFromTemplateActivity.this.handleCommandNotifyActiveConfig(extra);
                }
            }
            catch (RobotCoreException e) {
                RobotLog.logStackTrace((Throwable)e);
            }
            return result;
        }
    }

    protected static interface TemplateProcessor {
        public void processTemplate(RobotConfigFile var1, XmlPullParser var2);
    }

    protected static interface StringProcessor {
        public void processString(String var1);
    }
}

