/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditSwapUsbDevices;
import com.qualcomm.ftccommon.configuration.IpAddressInputFilter;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.EthernetOverUsbConfiguration;
import com.qualcomm.robotcore.util.RobotLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class EditEthernetOverUsbActivity
extends EditActivity {
    EditText textDeviceName;
    EditText ipAddressInput;
    public static final RequestCode requestCode = RequestCode.EDIT_ETHERNET_OVER_USB;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ethernet_device);
        this.textDeviceName = (EditText)this.findViewById(R.id.ethernetDeviceName);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.textDeviceName.addTextChangedListener((TextWatcher)new EditActivity.SetNameTextWatcher((DeviceConfiguration)this.controllerConfiguration));
        this.textDeviceName.setText((CharSequence)this.controllerConfiguration.getName());
        this.ipAddressInput = (EditText)this.findViewById(R.id.ethernetDeviceIpAddress);
        this.ipAddressInput.setText((CharSequence)((EthernetOverUsbConfiguration)this.controllerConfiguration).getIpAddress().getHostAddress());
        this.ipAddressInput.setFilters(new InputFilter[]{new IpAddressInputFilter()});
        this.ipAddressInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (!this.isValidIPAddress(s.toString())) {
                    // empty if block
                }
            }

            private boolean isValidIPAddress(String ipAddress) {
                String regex = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(?:\\.|$)){4}$";
                Pattern pattern = Pattern.compile(regex);
                return pattern.matcher(ipAddress).matches();
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        this.logActivityResult(requestCodeValue, resultCode, data);
        if (resultCode == -1) {
            EthernetOverUsbConfiguration newModule;
            EditParameters parameters = EditParameters.fromIntent(this, data);
            RequestCode requestCode = RequestCode.fromValue(requestCodeValue);
            if (requestCode == EditSwapUsbDevices.requestCode || requestCode != EditEthernetOverUsbActivity.requestCode || (newModule = (EthernetOverUsbConfiguration)parameters.getConfiguration()) != null) {
                // empty if block
            }
            this.currentCfgFile.markDirty();
            this.robotConfigFileManager.setActiveConfig(this.currentCfgFile);
        }
    }

    public void onDoneButtonPressed(View v) {
        this.finishOk();
    }

    @Override
    protected void finishOk() {
        String ipAddress = this.ipAddressInput.getText().toString();
        this.controllerConfiguration.setName(this.textDeviceName.getText().toString());
        try {
            ((EthernetOverUsbConfiguration)this.controllerConfiguration).setIpAddress(InetAddress.getByName(ipAddress));
        }
        catch (UnknownHostException e) {
            RobotLog.ee((String)"EditActivity", (String)"Ignoring ip address change, invalid ip address: %s", (Object[])new Object[]{ipAddress});
        }
        this.finishOk(new EditParameters((EditActivity)this, (DeviceConfiguration)this.controllerConfiguration, this.getRobotConfigMap()));
    }

    public void onCancelButtonPressed(View v) {
        this.finishCancel();
    }
}

