/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.qualcomm.ftccommon.CommandList;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditAnalogInputDevicesActivity;
import com.qualcomm.ftccommon.configuration.EditDigitalDevicesActivityLynx;
import com.qualcomm.ftccommon.configuration.EditI2cDevicesActivityLynx;
import com.qualcomm.ftccommon.configuration.EditMotorListActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditServoListActivity;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.ControlSystem;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxI2cDeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.RhspModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ServoHubConfiguration;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.List;
import org.firstinspires.ftc.robotcore.internal.system.Assert;

public class EditLynxModuleActivity
extends EditActivity {
    public static final RequestCode requestCode = RequestCode.EDIT_LYNX_MODULE;
    private RhspModuleConfiguration lynxModuleConfiguration;
    private EditText lynx_module_name;
    private EditActivity.DisplayNameAndRequestCode[] listKeys;
    private AdapterView.OnItemClickListener editLaunchListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            EditActivity.DisplayNameAndRequestCode key = EditLynxModuleActivity.this.listKeys[position];
            switch (key.requestCode) {
                case EDIT_MOTOR_LIST: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editMotors(key);
                    break;
                }
                case EDIT_SERVO_LIST: {
                    List servos;
                    if (EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                        servos = ((LynxModuleConfiguration)EditLynxModuleActivity.this.lynxModuleConfiguration).getServos();
                    } else {
                        if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof ServoHubConfiguration)) break;
                        servos = ((ServoHubConfiguration)EditLynxModuleActivity.this.lynxModuleConfiguration).getServos();
                    }
                    EditLynxModuleActivity.this.editServos(key, 0, EditServoListActivity.class, servos);
                    break;
                }
                case EDIT_I2C_BUS0: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editI2cBus(key, 0);
                    break;
                }
                case EDIT_I2C_BUS1: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editI2cBus(key, 1);
                    break;
                }
                case EDIT_I2C_BUS2: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editI2cBus(key, 2);
                    break;
                }
                case EDIT_I2C_BUS3: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editI2cBus(key, 3);
                    break;
                }
                case EDIT_DIGITAL: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editSimple(key, 0, EditDigitalDevicesActivityLynx.class, ((LynxModuleConfiguration)EditLynxModuleActivity.this.lynxModuleConfiguration).getDigitalDevices());
                    break;
                }
                case EDIT_ANALOG_INPUT: {
                    if (!(EditLynxModuleActivity.this.lynxModuleConfiguration instanceof LynxModuleConfiguration)) break;
                    EditLynxModuleActivity.this.editSimple(key, 0, EditAnalogInputDevicesActivity.class, ((LynxModuleConfiguration)EditLynxModuleActivity.this.lynxModuleConfiguration).getAnalogInputs());
                }
            }
        }
    };

    @Override
    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.lynx_module);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.lynxModuleConfiguration = (RhspModuleConfiguration)this.controllerConfiguration;
        String[] strings = null;
        if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
            strings = this.getResources().getStringArray(R.array.lynx_module_options_array);
        }
        if (this.lynxModuleConfiguration instanceof ServoHubConfiguration) {
            strings = this.getResources().getStringArray(R.array.servo_hub_options_array);
        }
        this.listKeys = EditActivity.DisplayNameAndRequestCode.fromArray(strings);
        ListView listView = (ListView)this.findViewById(R.id.lynx_module_devices);
        listView.setAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, (Object[])this.listKeys));
        listView.setOnItemClickListener(this.editLaunchListener);
        this.lynx_module_name = (EditText)this.findViewById(R.id.lynx_module_name);
        this.lynx_module_name.addTextChangedListener((TextWatcher)new EditActivity.SetNameTextWatcher((DeviceConfiguration)this.lynxModuleConfiguration));
        this.lynx_module_name.setText((CharSequence)this.lynxModuleConfiguration.getName());
        RobotLog.vv((String)"EditActivity", (String)"lynxModuleConfiguration.getSerialNumber()=%s", (Object[])new Object[]{this.lynxModuleConfiguration.getSerialNumber()});
        this.visuallyIdentify();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.visuallyUnidentify();
    }

    protected void visuallyIdentify() {
        this.sendIdentify(true);
    }

    protected void visuallyUnidentify() {
        this.sendIdentify(false);
    }

    protected void sendIdentify(boolean shouldIdentify) {
        CommandList.CmdVisuallyIdentify cmdVisuallyIdentify = new CommandList.CmdVisuallyIdentify(this.lynxModuleConfiguration.getUsbDeviceSerialNumber(), this.lynxModuleConfiguration.getModuleAddress(), this.lynxModuleConfiguration.getParentModuleAddress(), shouldIdentify);
        this.sendOrInject(new Command("CMD_VISUALLY_IDENTIFY", cmdVisuallyIdentify.serialize()));
    }

    <ITEM_T extends DeviceConfiguration> EditParameters initParameters(int initialPortNumber, Class<ITEM_T> clazz, List<ITEM_T> currentItems) {
        EditParameters<ITEM_T> result = new EditParameters<ITEM_T>((EditActivity)this, clazz, currentItems);
        result.setInitialPortNumber(initialPortNumber);
        result.setControlSystem(ControlSystem.REV_HUB);
        result.setConfiguringControlHubParent(this.lynxModuleConfiguration.getUsbDeviceSerialNumber().isEmbedded() && (this.lynxModuleConfiguration.isParent() || this.lynxModuleConfiguration.getModuleAddress() == 173));
        return result;
    }

    private void editSimple(EditActivity.DisplayNameAndRequestCode key, int initialPort, Class launchClass, List<DeviceConfiguration> devices) {
        EditParameters parameters = this.initParameters(initialPort, DeviceConfiguration.class, devices);
        this.handleLaunchEdit(key.requestCode, launchClass, parameters);
    }

    private void editServos(EditActivity.DisplayNameAndRequestCode key, int initialPort, Class launchClass, List<DeviceConfiguration> devices) {
        EditParameters parameters = this.initParameters(initialPort, DeviceConfiguration.class, devices);
        this.handleLaunchEdit(key.requestCode, launchClass, parameters);
    }

    private void editMotors(EditActivity.DisplayNameAndRequestCode key) {
        Assert.assertTrue((((LynxModuleConfiguration)this.lynxModuleConfiguration).getMotors().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((((DeviceConfiguration)((LynxModuleConfiguration)this.lynxModuleConfiguration).getMotors().get(0)).getPort() == 0 ? 1 : 0) != 0);
        EditParameters parameters = this.initParameters(0, DeviceConfiguration.class, ((LynxModuleConfiguration)this.lynxModuleConfiguration).getMotors());
        this.handleLaunchEdit(key.requestCode, EditMotorListActivity.class, parameters);
    }

    private void editI2cBus(EditActivity.DisplayNameAndRequestCode key, int busZ) {
        EditParameters parameters = this.initParameters(0, LynxI2cDeviceConfiguration.class, ((LynxModuleConfiguration)this.lynxModuleConfiguration).getI2cDevices(busZ));
        parameters.setI2cBus(busZ);
        parameters.setGrowable(true);
        this.handleLaunchEdit(key.requestCode, EditI2cDevicesActivityLynx.class, parameters);
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        this.logActivityResult(requestCodeValue, resultCode, data);
        RequestCode requestCode = RequestCode.fromValue(requestCodeValue);
        if (resultCode == -1) {
            if (requestCode == RequestCode.EDIT_MOTOR_LIST) {
                if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                    EditParameters parameters = EditParameters.fromIntent(this, data);
                    ((LynxModuleConfiguration)this.lynxModuleConfiguration).setMotors(parameters.getCurrentItems());
                    Assert.assertTrue((((LynxModuleConfiguration)this.lynxModuleConfiguration).getMotors().size() == 4 ? 1 : 0) != 0);
                    Assert.assertTrue((((DeviceConfiguration)((LynxModuleConfiguration)this.lynxModuleConfiguration).getMotors().get(0)).getPort() == 0 ? 1 : 0) != 0);
                }
            } else if (requestCode == RequestCode.EDIT_SERVO_LIST) {
                EditParameters parameters = EditParameters.fromIntent(this, data);
                if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                    ((LynxModuleConfiguration)this.lynxModuleConfiguration).setServos(parameters.getCurrentItems());
                } else if (this.lynxModuleConfiguration instanceof ServoHubConfiguration) {
                    ((ServoHubConfiguration)this.lynxModuleConfiguration).setServos(parameters.getCurrentItems());
                }
            } else if (requestCode == RequestCode.EDIT_ANALOG_INPUT) {
                if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                    EditParameters parameters = EditParameters.fromIntent(this, data);
                    ((LynxModuleConfiguration)this.lynxModuleConfiguration).setAnalogInputs(parameters.getCurrentItems());
                }
            } else if (requestCode == RequestCode.EDIT_DIGITAL) {
                if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                    EditParameters parameters = EditParameters.fromIntent(this, data);
                    ((LynxModuleConfiguration)this.lynxModuleConfiguration).setDigitalDevices(parameters.getCurrentItems());
                }
            } else {
                EditParameters i2cParams = EditParameters.fromIntent(this, data);
                if (requestCode == RequestCode.EDIT_I2C_BUS0) {
                    if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                        ((LynxModuleConfiguration)this.lynxModuleConfiguration).setI2cDevices(0, i2cParams.getCurrentItems());
                    }
                } else if (requestCode == RequestCode.EDIT_I2C_BUS1) {
                    if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                        ((LynxModuleConfiguration)this.lynxModuleConfiguration).setI2cDevices(1, i2cParams.getCurrentItems());
                    }
                } else if (requestCode == RequestCode.EDIT_I2C_BUS2) {
                    if (this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                        ((LynxModuleConfiguration)this.lynxModuleConfiguration).setI2cDevices(2, i2cParams.getCurrentItems());
                    }
                } else if (requestCode == RequestCode.EDIT_I2C_BUS3 && this.lynxModuleConfiguration instanceof LynxModuleConfiguration) {
                    ((LynxModuleConfiguration)this.lynxModuleConfiguration).setI2cDevices(3, i2cParams.getCurrentItems());
                }
            }
            this.currentCfgFile.markDirty();
            this.robotConfigFileManager.setActiveConfig(this.currentCfgFile);
        }
    }

    public void onDoneButtonPressed(View v) {
        this.finishOk();
    }

    @Override
    protected void finishOk() {
        this.controllerConfiguration.setName(this.lynx_module_name.getText().toString());
        this.finishOk(new EditParameters(this, (DeviceConfiguration)this.controllerConfiguration));
    }

    public void onCancelButtonPressed(View v) {
        this.finishCancel();
    }
}

