/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditLynxModuleActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditSwapUsbDevices;
import com.qualcomm.ftccommon.configuration.EditUSBDeviceActivity;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxUsbDeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.RhspModuleConfiguration;
import java.util.List;

public class EditLynxUsbDeviceActivity
extends EditUSBDeviceActivity {
    public static final RequestCode requestCode = RequestCode.EDIT_LYNX_USB_DEVICE;
    private LynxUsbDeviceConfiguration lynxUsbDeviceConfiguration;
    private EditText textLynxUsbDeviceName;
    private EditActivity.DisplayNameAndInteger[] listKeys;
    private AdapterView.OnItemClickListener editLaunchListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            EditActivity.DisplayNameAndInteger key = EditLynxUsbDeviceActivity.this.listKeys[position];
            EditLynxUsbDeviceActivity.this.handleLaunchEdit(EditLynxModuleActivity.requestCode, EditLynxModuleActivity.class, (DeviceConfiguration)EditLynxUsbDeviceActivity.this.lynxUsbDeviceConfiguration.getModules().get(key.value));
        }
    };

    @Override
    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.lynx_usb_device);
        ListView listView = (ListView)this.findViewById(R.id.lynxUsbDeviceModules);
        listView.setOnItemClickListener(this.editLaunchListener);
        this.textLynxUsbDeviceName = (EditText)this.findViewById(R.id.lynxUsbDeviceName);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.lynxUsbDeviceConfiguration = (LynxUsbDeviceConfiguration)this.controllerConfiguration;
        this.textLynxUsbDeviceName.addTextChangedListener((TextWatcher)new EditActivity.SetNameTextWatcher((DeviceConfiguration)this.controllerConfiguration));
        this.textLynxUsbDeviceName.setText((CharSequence)this.controllerConfiguration.getName());
        this.populateModules();
        this.showFixSwapButtons();
    }

    @Override
    protected void refreshSerialNumber() {
        TextView serialNumberView = (TextView)this.findViewById(R.id.serialNumber);
        serialNumberView.setText((CharSequence)EditLynxUsbDeviceActivity.formatSerialNumber((Context)this, this.controllerConfiguration));
    }

    protected void populateModules() {
        ListView listView = (ListView)this.findViewById(R.id.lynxUsbDeviceModules);
        List modules = this.lynxUsbDeviceConfiguration.getModules();
        this.listKeys = new EditActivity.DisplayNameAndInteger[modules.size()];
        for (int i = 0; i < this.listKeys.length; ++i) {
            this.listKeys[i] = new EditActivity.DisplayNameAndInteger(((RhspModuleConfiguration)modules.get(i)).getName(), i);
        }
        listView.setAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, (Object[])this.listKeys));
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        this.logActivityResult(requestCodeValue, resultCode, data);
        if (resultCode == -1) {
            RhspModuleConfiguration newModule;
            EditParameters parameters = EditParameters.fromIntent(this, data);
            RequestCode requestCode = RequestCode.fromValue(requestCodeValue);
            if (requestCode == EditSwapUsbDevices.requestCode) {
                this.completeSwapConfiguration(requestCodeValue, resultCode, data);
            } else if (requestCode == EditLynxModuleActivity.requestCode && (newModule = (RhspModuleConfiguration)parameters.getConfiguration()) != null) {
                for (int i = 0; i < this.lynxUsbDeviceConfiguration.getModules().size(); ++i) {
                    RhspModuleConfiguration existingModule = (RhspModuleConfiguration)this.lynxUsbDeviceConfiguration.getModules().get(i);
                    if (existingModule.getModuleAddress() != newModule.getModuleAddress()) continue;
                    this.lynxUsbDeviceConfiguration.getModules().set(i, newModule);
                    break;
                }
                this.populateModules();
            }
            this.currentCfgFile.markDirty();
            this.robotConfigFileManager.setActiveConfig(this.currentCfgFile);
        }
    }

    public void onDoneButtonPressed(View v) {
        this.finishOk();
    }

    @Override
    protected void finishOk() {
        this.controllerConfiguration.setName(this.textLynxUsbDeviceName.getText().toString());
        this.finishOk(new EditParameters((EditActivity)this, (DeviceConfiguration)this.controllerConfiguration, this.getRobotConfigMap()));
    }

    public void onCancelButtonPressed(View v) {
        this.finishCancel();
    }

    public void onFixButtonPressed(View v) {
        this.fixConfiguration();
    }

    public void onSwapButtonPressed(View view) {
        this.swapConfiguration();
    }
}

