/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.robotcore.hardware.ControlSystem;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.firstinspires.ftc.robotcore.internal.system.Assert;

public class EditParameters<ITEM_T extends DeviceConfiguration>
implements Serializable {
    private boolean isConfigDirty = false;
    private DeviceConfiguration configuration = null;
    private List<ITEM_T> currentItems = null;
    private Class<ITEM_T> itemClass = null;
    private int initialPortNumber = 0;
    private int maxItemCount = 0;
    private int i2cBus = 0;
    private boolean growable = false;
    @NonNull
    private ScannedDevices scannedDevices = new ScannedDevices();
    private RobotConfigMap robotConfigMap = new RobotConfigMap();
    private boolean haveRobotConfigMapParameter = false;
    private List<RobotConfigFile> extantRobotConfigurations = new ArrayList<RobotConfigFile>();
    private ControlSystem controlSystem = null;
    private boolean configuringControlHubParent = false;
    private RobotConfigFile currentCfgFile = null;

    public EditParameters(EditActivity editActivity, DeviceConfiguration configuration) {
        this(editActivity);
        this.configuration = configuration;
    }

    public EditParameters(EditActivity editActivity, DeviceConfiguration configuration, RobotConfigMap robotConfigMap) {
        this(editActivity);
        this.configuration = configuration;
        this.robotConfigMap = robotConfigMap;
        this.haveRobotConfigMapParameter = true;
    }

    public EditParameters(EditActivity editActivity, Class<ITEM_T> itemClass, List<ITEM_T> list) {
        this(editActivity);
        super.setItems(itemClass, list);
    }

    public EditParameters(EditActivity editActivity, DeviceConfiguration configuration, Class<ITEM_T> itemClass, List<ITEM_T> list) {
        this(editActivity);
        this.configuration = configuration;
        super.setItems(itemClass, list);
    }

    public EditParameters(EditActivity editActivity, Class<ITEM_T> itemClass, List<ITEM_T> list, int maxItemCount) {
        this(editActivity);
        super.setItems(itemClass, list);
        this.maxItemCount = maxItemCount;
    }

    private void setItems(Class<ITEM_T> itemClass, List<ITEM_T> list) {
        this.itemClass = itemClass;
        this.currentItems = list;
        for (DeviceConfiguration item : list) {
            Assert.assertTrue((boolean)itemClass.isInstance(item));
        }
    }

    public EditParameters(EditActivity editActivity) {
        this.isConfigDirty = editActivity.currentCfgFile.isDirty();
    }

    public EditParameters() {
    }

    public DeviceConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<ITEM_T> getCurrentItems() {
        return this.currentItems == null ? new LinkedList() : this.currentItems;
    }

    public Class<ITEM_T> getItemClass() {
        Assert.assertNotNull(this.itemClass);
        return this.itemClass;
    }

    public int getMaxItemCount() {
        if (this.currentItems == null) {
            return this.maxItemCount;
        }
        return Math.max(this.maxItemCount, this.currentItems.size());
    }

    public boolean isGrowable() {
        return this.growable;
    }

    public void setGrowable(boolean growable) {
        this.growable = growable;
    }

    @NonNull
    public ScannedDevices getScannedDevices() {
        return this.scannedDevices;
    }

    public void setScannedDevices(@NonNull ScannedDevices devices) {
        this.scannedDevices = devices;
    }

    public void setInitialPortNumber(int initialPortNumber) {
        this.initialPortNumber = initialPortNumber;
    }

    public int getInitialPortNumber() {
        return this.initialPortNumber;
    }

    public int getI2cBus() {
        return this.i2cBus;
    }

    public void setI2cBus(int i2cBus) {
        this.i2cBus = i2cBus;
    }

    public RobotConfigMap getRobotConfigMap() {
        return this.robotConfigMap;
    }

    public void setRobotConfigMap(RobotConfigMap robotConfigMap) {
        this.robotConfigMap = robotConfigMap;
        this.haveRobotConfigMapParameter = true;
    }

    public boolean haveRobotConfigMapParameter() {
        return this.haveRobotConfigMapParameter;
    }

    @NonNull
    public List<RobotConfigFile> getExtantRobotConfigurations() {
        return this.extantRobotConfigurations;
    }

    public void setExtantRobotConfigurations(List<RobotConfigFile> configurations) {
        this.extantRobotConfigurations = configurations;
    }

    public ControlSystem getControlSystem() {
        return this.controlSystem;
    }

    public void setControlSystem(ControlSystem controlSystem) {
        this.controlSystem = controlSystem;
    }

    public boolean configuringControlHubParent() {
        return this.configuringControlHubParent;
    }

    public void setConfiguringControlHubParent(boolean configuringControlHubParent) {
        this.configuringControlHubParent = configuringControlHubParent;
    }

    public RobotConfigFile getCurrentCfgFile() {
        return this.currentCfgFile;
    }

    public void setCurrentCfgFile(RobotConfigFile currentCfgFile) {
        this.currentCfgFile = currentCfgFile;
    }

    public void putIntent(Intent intent) {
        intent.putExtras(this.toBundle());
    }

    public Bundle toBundle() {
        Bundle result = new Bundle();
        if (this.configuration != null) {
            result.putSerializable("configuration", (Serializable)this.configuration);
        }
        if (this.scannedDevices != null && this.scannedDevices.size() > 0) {
            result.putString("scannedDevices", this.scannedDevices.toSerializationString());
        }
        if (this.robotConfigMap != null && this.robotConfigMap.size() > 0) {
            result.putSerializable("robotConfigMap", (Serializable)this.robotConfigMap);
        }
        if (this.extantRobotConfigurations != null && this.extantRobotConfigurations.size() > 0) {
            result.putString("extantRobotConfigurations", RobotConfigFileManager.serializeXMLConfigList(this.extantRobotConfigurations));
        }
        if (this.controlSystem != null) {
            result.putSerializable("controlSystem", (Serializable)this.controlSystem);
        }
        result.putBoolean("configuringControlHubParent", this.configuringControlHubParent);
        if (this.currentCfgFile != null) {
            result.putString("currentCfgFile", RobotConfigFileManager.serializeConfig(this.currentCfgFile));
        }
        result.putBoolean("haveRobotConfigMap", this.haveRobotConfigMapParameter);
        result.putInt("initialPortNumber", this.initialPortNumber);
        result.putInt("maxItemCount", this.maxItemCount);
        result.putInt("i2cBus", this.i2cBus);
        result.putBoolean("growable", this.growable);
        result.putBoolean("isConfigDirty", this.isConfigDirty);
        if (this.itemClass != null) {
            result.putString("itemClass", this.itemClass.getCanonicalName());
        }
        if (this.currentItems != null) {
            for (int i = 0; i < this.currentItems.size(); ++i) {
                result.putSerializable(String.valueOf(i), (Serializable)this.currentItems.get(i));
            }
        }
        return result;
    }

    @NonNull
    public static <RESULT_ITEM extends DeviceConfiguration> EditParameters<RESULT_ITEM> fromIntent(EditActivity editActivity, Intent intent) {
        return EditParameters.fromBundle(editActivity, intent.getExtras());
    }

    @NonNull
    public static <RESULT_ITEM extends DeviceConfiguration> EditParameters<RESULT_ITEM> fromBundle(EditActivity editActivity, Bundle bundle) {
        EditParameters result = new EditParameters();
        if (bundle == null) {
            return result;
        }
        for (String key : bundle.keySet()) {
            if (key.equals("configuration")) {
                result.configuration = (DeviceConfiguration)bundle.getSerializable(key);
                continue;
            }
            if (key.equals("scannedDevices")) {
                result.scannedDevices = ScannedDevices.fromSerializationString((String)bundle.getString(key));
                continue;
            }
            if (key.equals("robotConfigMap")) {
                result.robotConfigMap = (RobotConfigMap)bundle.getSerializable(key);
                continue;
            }
            if (key.equals("haveRobotConfigMap")) {
                result.haveRobotConfigMapParameter = bundle.getBoolean(key);
                continue;
            }
            if (key.equals("extantRobotConfigurations")) {
                result.extantRobotConfigurations = RobotConfigFileManager.deserializeXMLConfigList(bundle.getString(key));
                continue;
            }
            if (key.equals("controlSystem")) {
                result.controlSystem = (ControlSystem)bundle.getSerializable(key);
                continue;
            }
            if (key.equals("configuringControlHubParent")) {
                result.configuringControlHubParent = bundle.getBoolean(key);
                continue;
            }
            if (key.equals("currentCfgFile")) {
                result.currentCfgFile = RobotConfigFileManager.deserializeConfig(bundle.getString(key));
                continue;
            }
            if (key.equals("initialPortNumber")) {
                result.initialPortNumber = bundle.getInt(key);
                continue;
            }
            if (key.equals("i2cBus")) {
                result.i2cBus = bundle.getInt(key);
                continue;
            }
            if (key.equals("maxItemCount")) {
                result.maxItemCount = bundle.getInt(key);
                continue;
            }
            if (key.equals("growable")) {
                result.growable = bundle.getBoolean(key);
                continue;
            }
            if (key.equals("isConfigDirty")) {
                result.isConfigDirty = bundle.getBoolean(key);
                continue;
            }
            if (key.equals("itemClass")) {
                try {
                    result.itemClass = Class.forName(bundle.getString(key));
                }
                catch (ClassNotFoundException e) {
                    result.itemClass = null;
                }
                continue;
            }
            try {
                int i = Integer.parseInt(key);
                DeviceConfiguration dev = (DeviceConfiguration)bundle.getSerializable(key);
                if (result.currentItems == null) {
                    result.currentItems = new ArrayList();
                }
                result.currentItems.add(i, dev);
            }
            catch (NumberFormatException e) {}
        }
        if (result.isConfigDirty) {
            editActivity.currentCfgFile.markDirty();
        }
        return result;
    }
}

