/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.DeviceInfoAdapter;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.util.RobotLog;

public class EditSwapUsbDevices
extends EditActivity {
    public static final String TAG = "EditSwapUsbDevices";
    public static final RequestCode requestCode = RequestCode.EDIT_SWAP_USB_DEVICES;
    protected ControllerConfiguration targetConfiguration;

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RobotLog.vv((String)TAG, (String)"onCreate()");
        this.setContentView(R.layout.activity_swap_usb_devices);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.targetConfiguration = (ControllerConfiguration)parameters.getConfiguration();
        String message = String.format(this.getString(R.string.swapPrompt), this.targetConfiguration.getName());
        TextView caption = (TextView)this.findViewById(R.id.swapCaption);
        caption.setText((CharSequence)message);
        Button doneButton = (Button)this.findViewById(R.id.doneButton);
        doneButton.setVisibility(8);
        this.populateList();
    }

    protected void populateList() {
        ListView controllerListView = (ListView)this.findViewById(R.id.controllersList);
        DeviceInfoAdapter adapter = new DeviceInfoAdapter(this, 17367044, this.getRobotConfigMap().getEligibleSwapTargets(this.targetConfiguration, this.scannedDevices, (Context)this));
        controllerListView.setAdapter((ListAdapter)adapter);
        controllerListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View v, int pos, long arg3) {
                ControllerConfiguration controllerConfiguration = (ControllerConfiguration)adapterView.getItemAtPosition(pos);
                EditSwapUsbDevices.this.finishOk(new EditParameters(EditSwapUsbDevices.this, (DeviceConfiguration)controllerConfiguration));
            }
        });
    }

    @Override
    public void onBackPressed() {
        RobotLog.vv((String)TAG, (String)"onBackPressed()");
        this.doBackOrCancel();
    }

    public void onCancelButtonPressed(View view) {
        RobotLog.vv((String)TAG, (String)"onCancelButtonPressed()");
        this.doBackOrCancel();
    }

    protected void doBackOrCancel() {
        this.finishCancel();
    }
}

