/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditSwapUsbDevices;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;

public class EditUSBDeviceActivity
extends EditActivity {
    protected ScannedDevices extraUSBDevices = new ScannedDevices();

    @Override
    public String getTag() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected void deserialize(EditParameters parameters) {
        super.deserialize(parameters);
        this.determineExtraUSBDevices();
    }

    protected void swapConfiguration() {
        if (this.getRobotConfigMap().isSwappable(this.controllerConfiguration, this.scannedDevices, (Context)this)) {
            EditParameters parameters = new EditParameters(this, (DeviceConfiguration)this.controllerConfiguration);
            parameters.setRobotConfigMap(this.getRobotConfigMap());
            parameters.setScannedDevices(this.scannedDevices);
            this.handleLaunchEdit(EditSwapUsbDevices.requestCode, EditSwapUsbDevices.class, parameters);
        }
    }

    protected boolean completeSwapConfiguration(int requestCodeValue, int resultCode, Intent data) {
        RequestCode requestCode;
        if (resultCode == -1 && (requestCode = RequestCode.fromValue(requestCodeValue)) == EditSwapUsbDevices.requestCode) {
            EditParameters returnedParameters = EditParameters.fromIntent(this, data);
            SerialNumber swappeeSerialNumber = ((ControllerConfiguration)returnedParameters.getConfiguration()).getSerialNumber();
            ControllerConfiguration swappee = this.getRobotConfigMap().get(swappeeSerialNumber);
            if (swappee != null) {
                this.robotConfigMap.swapSerialNumbers(this.controllerConfiguration, swappee);
            } else {
                this.robotConfigMap.setSerialNumber(this.controllerConfiguration, swappeeSerialNumber);
                this.controllerConfiguration.setKnownToBeAttached(true);
            }
            this.determineExtraUSBDevices();
            this.refreshAfterSwap();
            return true;
        }
        return false;
    }

    protected void fixConfiguration() {
        boolean isFixable;
        SerialNumber candidate = this.getFixableCandidate();
        boolean bl = isFixable = candidate != null;
        if (isFixable) {
            this.robotConfigMap.setSerialNumber(this.controllerConfiguration, candidate);
            this.controllerConfiguration.setKnownToBeAttached(true);
            this.determineExtraUSBDevices();
        } else {
            String format = this.getString(R.string.fixFailNoneAvailable);
            String name = this.controllerConfiguration.getName();
            String type = this.controllerConfiguration.getConfigurationType().getName();
            this.appUtil.showToast(UILocation.ONLY_LOCAL, String.format(format, name, type));
        }
        this.refreshAfterFix();
    }

    @Nullable
    protected SerialNumber getFixableCandidate() {
        SerialNumber candidate = null;
        if (this.controllerConfiguration.isKnownToBeAttached()) {
            return null;
        }
        boolean isFixable = false;
        DeviceManager.UsbDeviceType deviceType = this.controllerConfiguration.toUSBDeviceType();
        for (Map.Entry pair : this.extraUSBDevices.entrySet()) {
            if (pair.getValue() != deviceType) continue;
            if (candidate != null) {
                isFixable = false;
                break;
            }
            candidate = (SerialNumber)pair.getKey();
            isFixable = true;
        }
        return isFixable ? candidate : null;
    }

    protected boolean isFixable() {
        return this.getFixableCandidate() != null;
    }

    protected boolean isSwappable() {
        List<ControllerConfiguration> swapCandidates = this.getRobotConfigMap().getEligibleSwapTargets(this.controllerConfiguration, this.scannedDevices, (Context)this);
        SerialNumber fixCandidate = this.getFixableCandidate();
        return !swapCandidates.isEmpty() && (fixCandidate == null || swapCandidates.size() != 1 || !swapCandidates.get(0).getSerialNumber().equals((Object)fixCandidate));
    }

    protected void refreshSerialNumber() {
    }

    protected void refreshAfterFix() {
        this.showFixSwapButtons();
        this.currentCfgFile.markDirty();
        this.robotConfigFileManager.updateActiveConfigHeader(this.currentCfgFile);
    }

    protected void refreshAfterSwap() {
        this.showFixSwapButtons();
        this.currentCfgFile.markDirty();
        this.robotConfigFileManager.updateActiveConfigHeader(this.currentCfgFile);
    }

    protected void showFixSwapButtons() {
        this.showFixButton(this.isFixable());
        this.showSwapButton(this.isSwappable());
        this.refreshSerialNumber();
    }

    protected void showFixButton(boolean show) {
        this.showButton(this.idFixButton, show);
    }

    protected void showSwapButton(boolean show) {
        this.showButton(this.idSwapButton, show);
    }

    protected void showButton(@IdRes int id2, boolean show) {
        View button = this.findViewById(id2);
        if (button != null) {
            button.setVisibility(show ? 0 : 8);
        }
    }

    protected void determineExtraUSBDevices() {
        this.extraUSBDevices = new ScannedDevices(this.scannedDevices);
        for (SerialNumber serialNumber : this.getRobotConfigMap().serialNumbers()) {
            this.extraUSBDevices.remove(serialNumber);
        }
        for (ControllerConfiguration controllerConfiguration : this.getRobotConfigMap().controllerConfigurations()) {
            controllerConfiguration.setKnownToBeAttached(this.scannedDevices.containsKey(controllerConfiguration.getSerialNumber()));
        }
    }
}

