/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.DeviceInfoAdapter;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditEthernetOverUsbActivity;
import com.qualcomm.ftccommon.configuration.EditLynxUsbDeviceActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.EditWebcamActivity;
import com.qualcomm.ftccommon.configuration.RequestCode;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.ftccommon.configuration.USBScanManager;
import com.qualcomm.robotcore.exception.DuplicateNameException;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.configuration.BuiltInConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxUsbDeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.RhspModuleConfiguration;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.system.Misc;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.xmlpull.v1.XmlPullParser;

public class FtcConfigurationActivity
extends EditActivity {
    protected static final boolean DEBUG = false;
    public static final String TAG = "FtcConfigTag";
    public static final RequestCode requestCode = RequestCode.EDIT_FILE;
    protected final USBScanManager usbScanManager = USBScanManager.getInstance();
    protected ThreadPool.Singleton scanButtonSingleton = new ThreadPool.Singleton();
    protected final Object robotConfigMapLock = new Object();
    protected int idFeedbackAnchor = R.id.feedbackAnchor;
    protected Semaphore feedbackPosted = new Semaphore(0);
    protected long msSaveSplashDelay = 1000L;
    protected NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected final RecvLoopRunnable.RecvLoopCallback commandCallback = new CommandCallback();
    DialogInterface.OnClickListener doNothingAndCloseListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int button) {
        }
    };

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RobotLog.vv((String)TAG, (String)"onCreate()");
        this.setContentView(R.layout.activity_ftc_configuration);
        try {
            EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
            this.deserialize(parameters);
            Button scanButton = (Button)this.findViewById(R.id.scanButton);
            scanButton.setVisibility(0);
            Button doneButton = (Button)this.findViewById(R.id.doneButton);
            doneButton.setText(R.string.buttonNameSave);
            this.startExecutorService();
        }
        catch (RobotCoreException e) {
            RobotLog.ee((String)TAG, (String)"exception thrown during FtcConfigurationActivity.onCreate()");
            this.finishCancel();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.pushReceiveLoopCallback(this.commandCallback);
        }
        if (!this.remoteConfigure) {
            this.robotConfigFileManager.createConfigFolder();
        }
        if (!this.currentCfgFile.isDirty()) {
            this.ensureConfigFileIsFresh();
        }
    }

    protected void ensureConfigFileIsFresh() {
        if (this.haveRobotConfigMapParameter) {
            this.populateListAndWarnDevices();
        } else if (this.remoteConfigure) {
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_PARTICULAR_CONFIGURATION", this.currentCfgFile.toString()));
        } else {
            this.readFile();
        }
    }

    protected void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    protected void onStop() {
        super.onStop();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.removeReceiveLoopCallback(this.commandCallback);
        }
    }

    protected void onDestroy() {
        RobotLog.vv((String)TAG, (String)"FtcConfigurationActivity.onDestroy()");
        super.onDestroy();
    }

    public void onDevicesInfoButtonPressed(View v) {
        RobotLog.vv((String)TAG, (String)"onDevicesInfoButtonPressed()");
        AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.titleDevices), this.getString(R.string.msgInfoHowToUse));
        builder.setPositiveButton((CharSequence)this.getString(R.string.buttonNameOK), this.doNothingAndCloseListener);
        AlertDialog alert = builder.create();
        alert.show();
        TextView textView = (TextView)alert.findViewById(16908299);
        textView.setTextSize(14.0f);
    }

    public void onDoneInfoButtonPressed(View v) {
        RobotLog.vv((String)TAG, (String)"onDoneInfoButtonPressed()");
        AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.titleSaveConfiguration), this.getString(R.string.msgInfoSave));
        builder.setPositiveButton((CharSequence)this.getString(R.string.buttonNameOK), this.doNothingAndCloseListener);
        AlertDialog alert = builder.create();
        alert.show();
        TextView textView = (TextView)alert.findViewById(16908299);
        textView.setTextSize(14.0f);
    }

    public void onScanButtonPressed(View v) {
        this.dirtyCheckThenSingletonUSBScanAndUpdateUI(true);
    }

    void dirtyCheckThenSingletonUSBScanAndUpdateUI(final boolean showFeedback) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ThreadPool.logThreadLifeCycle((String)"USB bus scan handler", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (showFeedback) {
                            FtcConfigurationActivity.this.synchronouslySetFeedbackWhile(FtcConfigurationActivity.this.getString(R.string.ftcConfigScanning), "", new Runnable(){

                                @Override
                                public void run() {
                                    FtcConfigurationActivity.this.doUSBScanAndUpdateUI();
                                }
                            });
                        } else {
                            FtcConfigurationActivity.this.doUSBScanAndUpdateUI();
                        }
                    }
                });
            }
        };
        if (this.currentCfgFile.isDirty()) {
            AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.titleUnsavedChanges), this.getString(R.string.msgAlertBeforeScan));
            DialogInterface.OnClickListener okListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int button) {
                    FtcConfigurationActivity.this.scanButtonSingleton.submit(ThreadPool.Singleton.INFINITE_TIMEOUT, runnable);
                }
            };
            builder.setPositiveButton(R.string.buttonNameOK, okListener);
            builder.setNegativeButton(R.string.buttonNameCancel, this.doNothingAndCloseListener);
            builder.show();
        } else {
            this.scanButtonSingleton.submit(ThreadPool.Singleton.INFINITE_TIMEOUT, runnable);
        }
    }

    protected void doUSBScanAndUpdateUI() {
        RobotLog.vv((String)TAG, (String)"doUSBScanAndUpdateUI()...");
        try {
            ThreadPool.SingletonResult<ScannedDevices> future = this.usbScanManager.startDeviceScanIfNecessary();
            ScannedDevices devices = (ScannedDevices)future.await();
            if (devices != null) {
                RobotLog.dd((String)TAG, (String)"scan for devices on USB bus found %d devices", (Object[])new Object[]{devices.size()});
                this.buildRobotConfigMapFromScanned(devices);
                this.appUtil.synchronousRunOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FtcConfigurationActivity.this.clearDuplicateWarning();
                        FtcConfigurationActivity.this.currentCfgFile.markDirty();
                        FtcConfigurationActivity.this.robotConfigFileManager.updateActiveConfigHeader(FtcConfigurationActivity.this.currentCfgFile);
                        FtcConfigurationActivity.this.populateListAndWarnDevices();
                    }
                });
            } else {
                RobotLog.ee((String)TAG, (String)"scan for devices on USB bus failed");
                this.appUtil.showToast(UILocation.ONLY_LOCAL, this.getString(R.string.ftcConfigScanningFailed));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            RobotLog.vv((String)TAG, (String)"...doUSBScanAndUpdateUI()");
        }
    }

    private void startExecutorService() throws RobotCoreException {
        this.scanButtonSingleton.reset();
        this.scanButtonSingleton.setService(this.usbScanManager.getExecutorService());
        this.usbScanManager.startDeviceScanIfNecessary();
        this.usbScanManager.getExecutorService().submit(() -> {
            try {
                this.usbScanManager.awaitScannedDevices();
                this.populateListAndWarnDevices();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private boolean carryOver(SerialNumber serialNumber, RobotConfigMap existingControllers) {
        if (existingControllers == null) {
            return false;
        }
        if (!existingControllers.contains(serialNumber)) {
            return false;
        }
        if (existingControllers.get(serialNumber).isSystemSynthetic()) {
            RobotLog.vv((String)TAG, (String)"not carrying over synthetic controller: serial=%s", (Object[])new Object[]{serialNumber});
            return false;
        }
        return true;
    }

    private RobotConfigMap buildRobotConfigMapFromScanned(RobotConfigMap existingControllers, ScannedDevices scannedDevices) {
        ControllerConfiguration controllerConfiguration;
        DeviceManager.UsbDeviceType deviceType;
        SerialNumber serialNumber;
        RobotConfigMap newRobotConfigMap = new RobotConfigMap();
        this.configurationUtility.resetNameUniquifiers();
        HashSet<Map.Entry> devicesToCarryOver = new HashSet<Map.Entry>();
        HashSet<Map.Entry> devicesToCreate = new HashSet<Map.Entry>();
        for (Map.Entry entry : scannedDevices.entrySet()) {
            if (this.carryOver((SerialNumber)entry.getKey(), existingControllers)) {
                devicesToCarryOver.add(entry);
                continue;
            }
            devicesToCreate.add(entry);
        }
        for (Map.Entry entry : devicesToCarryOver) {
            serialNumber = (SerialNumber)entry.getKey();
            deviceType = (DeviceManager.UsbDeviceType)entry.getValue();
            if (deviceType == DeviceManager.UsbDeviceType.LYNX_USB_DEVICE) {
                RobotLog.vv((String)TAG, (String)"Performing Lynx discovery");
                controllerConfiguration = this.configurationUtility.buildNewControllerConfiguration(serialNumber, deviceType, this.usbScanManager.getLynxModuleMetaListSupplier(serialNumber));
                LynxUsbDeviceConfiguration lynxUsbConfiguration = (LynxUsbDeviceConfiguration)controllerConfiguration;
                ArrayList discoveredModules = new ArrayList(lynxUsbConfiguration.getModules());
                for (RhspModuleConfiguration discoveredModule : discoveredModules) {
                    for (RhspModuleConfiguration existingModule : ((LynxUsbDeviceConfiguration)existingControllers.get(serialNumber)).getModules()) {
                        if (discoveredModule.getModuleAddress() != existingModule.getModuleAddress()) continue;
                        RobotLog.vv((String)TAG, (String)"carrying over %s", (Object[])new Object[]{existingModule.getModuleSerialNumber()});
                        existingModule.setParentModuleAddress(discoveredModule.getParentModuleAddress());
                        lynxUsbConfiguration.getModules().remove(discoveredModule);
                        lynxUsbConfiguration.getModules().add(existingModule);
                        this.configurationUtility.noteExistingName(existingModule.getConfigurationType(), existingModule.getName());
                    }
                }
            } else {
                RobotLog.vv((String)TAG, (String)"carrying over %s", (Object[])new Object[]{serialNumber});
                controllerConfiguration = existingControllers.get(serialNumber);
                this.configurationUtility.noteExistingName(controllerConfiguration.getConfigurationType(), controllerConfiguration.getName());
            }
            controllerConfiguration.setKnownToBeAttached(true);
            newRobotConfigMap.put(serialNumber, controllerConfiguration);
        }
        for (Map.Entry entry : devicesToCreate) {
            serialNumber = (SerialNumber)entry.getKey();
            deviceType = (DeviceManager.UsbDeviceType)entry.getValue();
            controllerConfiguration = deviceType == DeviceManager.UsbDeviceType.ETHERNET_DEVICE ? this.configurationUtility.buildNewEthernetOverUsbControllerConfiguration(serialNumber) : this.configurationUtility.buildNewControllerConfiguration(serialNumber, (DeviceManager.UsbDeviceType)entry.getValue(), this.usbScanManager.getLynxModuleMetaListSupplier(serialNumber));
            controllerConfiguration.setKnownToBeAttached(true);
            newRobotConfigMap.put(serialNumber, controllerConfiguration);
        }
        return newRobotConfigMap;
    }

    private void readFile() {
        try {
            XmlPullParser xmlPullParser = this.currentCfgFile.getXml();
            if (xmlPullParser == null) {
                throw new RobotCoreException("can't access configuration");
            }
            ReadXMLFileHandler parser = new ReadXMLFileHandler();
            List controllerList = parser.parse(xmlPullParser);
            this.buildControllersFromXMLResults(controllerList);
            this.populateListAndWarnDevices();
        }
        catch (Exception e) {
            String message = String.format(this.getString(R.string.errorParsingConfiguration), this.currentCfgFile.getName());
            RobotLog.ee((String)TAG, (Throwable)e, (String)message);
            this.appUtil.showToast(UILocation.ONLY_LOCAL, message);
        }
    }

    private void populateListAndWarnDevices() {
        this.appUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FtcConfigurationActivity.this.populateList();
                FtcConfigurationActivity.this.warnIncompleteDevices();
            }
        });
    }

    private void warnIncompleteDevices() {
        String title = null;
        String message = null;
        if (this.scannedDevices.getErrorMessage() != null) {
            title = this.getString(R.string.errorScanningDevicesTitle);
            message = this.scannedDevices.getErrorMessage();
        } else if (!this.getRobotConfigMap().allControllersAreBound()) {
            title = this.getString(R.string.notAllDevicesFoundTitle);
            message = Misc.formatForUser((int)R.string.notAllDevicesFoundMessage, (Object[])new Object[]{this.getString(R.string.noSerialNumber)});
        } else if (this.getRobotConfigMap().size() == 0) {
            title = this.getString(R.string.noDevicesFoundTitle);
            message = this.getString(R.string.noDevicesFoundMessage);
            this.clearDuplicateWarning();
        }
        if (title != null || message != null) {
            if (title == null) {
                title = "";
            }
            if (message == null) {
                message = "";
            }
            this.utility.setFeedbackText((CharSequence)title, (CharSequence)message, this.idFeedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1, R.id.feedbackOKButton);
        } else {
            this.utility.hideFeedbackText(this.idFeedbackAnchor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronouslySetFeedbackWhile(final String title, final String message, Runnable runnable) {
        CharSequence[] prev = this.utility.getFeedbackText(this.idFeedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
        try {
            this.appUtil.synchronousRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FtcConfigurationActivity.this.utility.setFeedbackText((CharSequence)title, (CharSequence)message, FtcConfigurationActivity.this.idFeedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
                    FtcConfigurationActivity.this.feedbackPosted.release();
                }
            });
            try {
                this.feedbackPosted.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            this.appUtil.runOnUiThread(new Runnable(){
                final /* synthetic */ CharSequence[] val$prev;
                {
                    this.val$prev = charSequenceArray;
                }

                @Override
                public void run() {
                    if (this.val$prev != null) {
                        FtcConfigurationActivity.this.utility.setFeedbackText(this.val$prev, FtcConfigurationActivity.this.idFeedbackAnchor, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
                    } else {
                        FtcConfigurationActivity.this.utility.hideFeedbackText(FtcConfigurationActivity.this.idFeedbackAnchor);
                    }
                }
            });
            throw throwable;
        }
        this.appUtil.runOnUiThread(new /* invalid duplicate definition of identical inner class */);
    }

    private void warnDuplicateNames(String dupeMsg) {
        String msg0 = "Found " + dupeMsg;
        String msg1 = "Please fix and re-save.";
        this.utility.setFeedbackText((CharSequence)msg0, (CharSequence)msg1, R.id.feedbackAnchorDuplicateNames, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
    }

    private void clearDuplicateWarning() {
        LinearLayout warning_layout = (LinearLayout)this.findViewById(R.id.feedbackAnchorDuplicateNames);
        warning_layout.removeAllViews();
        warning_layout.setVisibility(8);
    }

    private void populateList() {
        ListView controllerListView = (ListView)this.findViewById(R.id.controllersList);
        try {
            this.scannedDevices = this.usbScanManager.awaitScannedDevices();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.tellControllersAboutAttachment();
        DeviceInfoAdapter adapter = new DeviceInfoAdapter(this, 17367044, new LinkedList<ControllerConfiguration>(this.getRobotConfigMap().controllerConfigurations()));
        controllerListView.setAdapter((ListAdapter)adapter);
        controllerListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View v, int pos, long arg3) {
                ControllerConfiguration controllerConfiguration = (ControllerConfiguration)adapterView.getItemAtPosition(pos);
                ConfigurationType itemType = controllerConfiguration.getConfigurationType();
                if (itemType == BuiltInConfigurationType.LYNX_USB_DEVICE) {
                    EditParameters parameters = FtcConfigurationActivity.this.initParameters(0, RhspModuleConfiguration.class, controllerConfiguration, ((LynxUsbDeviceConfiguration)controllerConfiguration).getDevices());
                    FtcConfigurationActivity.this.handleLaunchEdit(EditLynxUsbDeviceActivity.requestCode, EditLynxUsbDeviceActivity.class, parameters);
                } else if (itemType == BuiltInConfigurationType.WEBCAM) {
                    EditParameters parameters = FtcConfigurationActivity.this.initParameters(controllerConfiguration);
                    FtcConfigurationActivity.this.handleLaunchEdit(EditWebcamActivity.requestCode, EditWebcamActivity.class, parameters);
                } else if (itemType == BuiltInConfigurationType.ETHERNET_OVER_USB_DEVICE) {
                    EditParameters parameters = FtcConfigurationActivity.this.initParameters(controllerConfiguration);
                    FtcConfigurationActivity.this.handleLaunchEdit(EditEthernetOverUsbActivity.requestCode, EditEthernetOverUsbActivity.class, parameters);
                }
            }
        });
    }

    <ITEM_T extends DeviceConfiguration> EditParameters initParameters(int initialPortNumber, Class<ITEM_T> itemClass, ControllerConfiguration controllerConfiguration, List<ITEM_T> currentItems) {
        EditParameters<ITEM_T> parameters = new EditParameters<ITEM_T>((EditActivity)this, (DeviceConfiguration)controllerConfiguration, itemClass, currentItems);
        parameters.setInitialPortNumber(initialPortNumber);
        parameters.setScannedDevices(this.scannedDevices);
        parameters.setRobotConfigMap(this.getRobotConfigMap());
        return parameters;
    }

    <ITEM_T extends DeviceConfiguration> EditParameters initParameters(ControllerConfiguration controllerConfiguration) {
        return this.initParameters(0, DeviceConfiguration.class, controllerConfiguration, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        try {
            this.logActivityResult(requestCodeValue, resultCode, data);
            if (resultCode == 0) {
                return;
            }
            RequestCode requestCode = RequestCode.fromValue(requestCodeValue);
            EditParameters parameters = EditParameters.fromIntent(this, data);
            RobotLog.vv((String)TAG, (String)"onActivityResult(%s)", (Object[])new Object[]{requestCode.toString()});
            Object object = this.robotConfigMapLock;
            synchronized (object) {
                this.deserializeConfigMap(parameters);
            }
            this.scannedDevices = this.usbScanManager.awaitScannedDevices();
            this.appUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FtcConfigurationActivity.this.currentCfgFile.markDirty();
                    FtcConfigurationActivity.this.robotConfigFileManager.updateActiveConfigHeader(FtcConfigurationActivity.this.currentCfgFile);
                    FtcConfigurationActivity.this.populateList();
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onBackPressed() {
        RobotLog.vv((String)TAG, (String)"onBackPressed()");
        this.doBackOrCancel();
    }

    public void onCancelButtonPressed(View view) {
        RobotLog.vv((String)TAG, (String)"onCancelButtonPressed()");
        this.doBackOrCancel();
    }

    private void doBackOrCancel() {
        if (this.currentCfgFile.isDirty()) {
            DialogInterface.OnClickListener exitWithoutSavingButtonListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    FtcConfigurationActivity.this.currentCfgFile.markClean();
                    FtcConfigurationActivity.this.robotConfigFileManager.setActiveConfig(FtcConfigurationActivity.this.remoteConfigure, FtcConfigurationActivity.this.currentCfgFile);
                    FtcConfigurationActivity.this.finishCancel();
                }
            };
            AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.saveChangesTitle), this.getString(R.string.saveChangesMessage));
            builder.setPositiveButton(R.string.buttonExitWithoutSaving, exitWithoutSavingButtonListener);
            builder.setNegativeButton(R.string.buttonNameCancel, this.doNothingAndCloseListener);
            builder.show();
        } else {
            this.finishCancel();
        }
    }

    public void onDoneButtonPressed(View v) {
        String data;
        RobotLog.vv((String)TAG, (String)"onDoneButtonPressed()");
        try {
            data = this.robotConfigFileManager.toXml(this.getRobotConfigMap());
            this.clearDuplicateWarning();
        }
        catch (DuplicateNameException e) {
            this.warnDuplicateNames(e.getMessage());
            RobotLog.ee((String)TAG, (String)e.getMessage());
            return;
        }
        if (data == null) {
            return;
        }
        String message = this.getString(R.string.configNamePromptBanter);
        final EditText input = new EditText((Context)this);
        input.setText((CharSequence)(this.currentCfgFile.isNoConfig() ? "" : this.currentCfgFile.getName()));
        AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.configNamePromptTitle), message);
        builder.setView((View)input);
        DialogInterface.OnClickListener okListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int button) {
                String newConfigurationName = input.getText().toString();
                RobotConfigFileManager.ConfigNameCheckResult checkResult = FtcConfigurationActivity.this.robotConfigFileManager.isPlausibleConfigName(FtcConfigurationActivity.this.currentCfgFile, newConfigurationName, FtcConfigurationActivity.this.extantRobotConfigurations);
                if (!checkResult.success) {
                    String message = String.format(checkResult.errorFormat, newConfigurationName);
                    FtcConfigurationActivity.this.appUtil.showToast(UILocation.ONLY_LOCAL, String.format("%s %s", message, FtcConfigurationActivity.this.getString(R.string.configurationNotSaved)));
                    return;
                }
                try {
                    if (!FtcConfigurationActivity.this.currentCfgFile.getName().equals(newConfigurationName)) {
                        FtcConfigurationActivity.this.currentCfgFile = new RobotConfigFile(FtcConfigurationActivity.this.robotConfigFileManager, newConfigurationName);
                    }
                    FtcConfigurationActivity.this.robotConfigFileManager.writeToFile(FtcConfigurationActivity.this.currentCfgFile, FtcConfigurationActivity.this.remoteConfigure, data);
                    FtcConfigurationActivity.this.robotConfigFileManager.setActiveConfigAndUpdateUI(FtcConfigurationActivity.this.remoteConfigure, FtcConfigurationActivity.this.currentCfgFile);
                }
                catch (RobotCoreException | IOException | RuntimeException e) {
                    FtcConfigurationActivity.this.appUtil.showToast(UILocation.ONLY_LOCAL, e.getMessage());
                    RobotLog.ee((String)FtcConfigurationActivity.TAG, (String)e.getMessage());
                    return;
                }
                FtcConfigurationActivity.this.confirmSave();
                FtcConfigurationActivity.this.pauseAfterSave();
                FtcConfigurationActivity.this.finishOk();
            }
        };
        builder.setPositiveButton((CharSequence)this.getString(R.string.buttonNameOK), okListener);
        builder.setNegativeButton((CharSequence)this.getString(R.string.buttonNameCancel), this.doNothingAndCloseListener);
        builder.show();
    }

    private void confirmSave() {
        Toast confirmation = Toast.makeText((Context)this, (int)R.string.toastSaved, (int)0);
        confirmation.setGravity(80, 0, 50);
        confirmation.show();
    }

    private void pauseAfterSave() {
        try {
            Thread.sleep(this.msSaveSplashDelay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildControllersFromXMLResults(List<ControllerConfiguration> deviceList) {
        Object object = this.robotConfigMapLock;
        synchronized (object) {
            this.robotConfigMap = new RobotConfigMap(deviceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRobotConfigMapFromScanned(ScannedDevices scannedDevices) {
        Object object = this.robotConfigMapLock;
        synchronized (object) {
            this.robotConfigMap = this.buildRobotConfigMapFromScanned(this.getRobotConfigMap(), scannedDevices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RobotConfigMap getRobotConfigMap() {
        Object object = this.robotConfigMapLock;
        synchronized (object) {
            return super.getRobotConfigMap();
        }
    }

    protected void tellControllersAboutAttachment() {
        for (ControllerConfiguration controllerConfiguration : this.getRobotConfigMap().controllerConfigurations()) {
            controllerConfiguration.setKnownToBeAttached(this.scannedDevices.containsKey(controllerConfiguration.getSerialNumber()));
        }
    }

    protected CallbackResult handleCommandRequestParticularConfigurationResp(String extra) throws RobotCoreException {
        ReadXMLFileHandler readXMLFileHandler = new ReadXMLFileHandler();
        List controllerList = readXMLFileHandler.parse((Reader)new StringReader(extra));
        this.buildControllersFromXMLResults(controllerList);
        this.populateListAndWarnDevices();
        return CallbackResult.HANDLED;
    }

    private class CommandCallback
    extends RecvLoopRunnable.DegenerateCallback {
        private CommandCallback() {
        }

        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            CallbackResult result = CallbackResult.NOT_HANDLED;
            try {
                String name = command.getName();
                String extra = command.getExtra();
                if (name.equals("CMD_REQUEST_PARTICULAR_CONFIGURATION_RESP")) {
                    result = FtcConfigurationActivity.this.handleCommandRequestParticularConfigurationResp(extra);
                }
            }
            catch (RobotCoreException e) {
                RobotLog.logStacktrace((Throwable)e);
            }
            return result;
        }
    }
}

