/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.ConfigureFromTemplateActivity;
import com.qualcomm.ftccommon.configuration.EditActivity;
import com.qualcomm.ftccommon.configuration.EditParameters;
import com.qualcomm.ftccommon.configuration.FtcConfigurationActivity;
import com.qualcomm.ftccommon.configuration.FtcNewFileActivity;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigFileManager;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.File;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;

public class FtcLoadFileActivity
extends EditActivity {
    public static final String TAG = "FtcConfigTag";
    private List<RobotConfigFile> fileList = new CopyOnWriteArrayList<RobotConfigFile>();
    private final NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected final RecvLoopRunnable.RecvLoopCallback commandCallback = new CommandCallback();
    DialogInterface.OnClickListener doNothingAndCloseListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int button) {
        }
    };

    @Override
    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RobotLog.vv((String)TAG, (String)"FtcLoadFileActivity started");
        this.setContentView(R.layout.activity_load);
        EditParameters parameters = EditParameters.fromIntent(this, this.getIntent());
        this.deserialize(parameters);
        this.buildInfoButtons();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.pushReceiveLoopCallback(this.commandCallback);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.remoteConfigure) {
            this.robotConfigFileManager.createConfigFolder();
        }
        if (!this.remoteConfigure) {
            this.fileList = this.robotConfigFileManager.getXMLFiles();
            this.warnIfNoFiles();
        } else {
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATIONS"));
        }
        this.populate();
    }

    protected CallbackResult handleCommandRequestConfigFilesResp(String extra) throws RobotCoreException {
        this.fileList = RobotConfigFileManager.deserializeXMLConfigList(extra);
        this.warnIfNoFiles();
        this.populate();
        return CallbackResult.HANDLED;
    }

    public void onResume() {
        super.onResume();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.remoteConfigure) {
            this.networkConnectionHandler.removeReceiveLoopCallback(this.commandCallback);
        }
    }

    private void buildInfoButtons() {
        Button saveConfigButton = (Button)this.findViewById(R.id.files_holder).findViewById(R.id.info_btn);
        saveConfigButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlertDialog.Builder builder = FtcLoadFileActivity.this.utility.buildBuilder(FtcLoadFileActivity.this.getString(R.string.availableConfigListCaption), FtcLoadFileActivity.this.getString(R.string.availableConfigsInfoMessage));
                builder.setPositiveButton((CharSequence)FtcLoadFileActivity.this.getString(R.string.buttonNameOK), FtcLoadFileActivity.this.doNothingAndCloseListener);
                AlertDialog alert = builder.create();
                alert.show();
                TextView textView = (TextView)alert.findViewById(16908299);
                textView.setTextSize(14.0f);
            }
        });
        Button configFromTemplateButton = (Button)this.findViewById(R.id.configureFromTemplateArea).findViewById(R.id.info_btn);
        configFromTemplateButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlertDialog.Builder builder = FtcLoadFileActivity.this.utility.buildBuilder(FtcLoadFileActivity.this.getString(R.string.configFromTemplateInfoTitle), FtcLoadFileActivity.this.getString(R.string.configFromTemplateInfoMessage));
                builder.setPositiveButton((CharSequence)FtcLoadFileActivity.this.getString(R.string.buttonNameOK), FtcLoadFileActivity.this.doNothingAndCloseListener);
                AlertDialog alert = builder.create();
                alert.show();
                TextView textView = (TextView)alert.findViewById(16908299);
                textView.setTextSize(14.0f);
            }
        });
    }

    private void warnIfNoFiles() {
        if (this.fileList.size() == 0) {
            final String msg0 = this.getString(R.string.noFilesFoundTitle);
            final String msg1 = this.getString(R.string.noFilesFoundMessage);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    FtcLoadFileActivity.this.utility.setFeedbackText((CharSequence)msg0, (CharSequence)msg1, R.id.empty_filelist, R.layout.feedback, R.id.feedbackText0, R.id.feedbackText1);
                }
            });
        } else {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ViewGroup empty_filelist = (ViewGroup)FtcLoadFileActivity.this.findViewById(R.id.empty_filelist);
                    empty_filelist.removeAllViews();
                    empty_filelist.setVisibility(8);
                }
            });
        }
    }

    private void populate() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                View readOnlyExplanation = FtcLoadFileActivity.this.findViewById(R.id.readOnlyExplanation);
                readOnlyExplanation.setVisibility(8);
                ViewGroup inclusionViewGroup = (ViewGroup)FtcLoadFileActivity.this.findViewById(R.id.inclusionlayout);
                inclusionViewGroup.removeAllViews();
                final Collator coll = Collator.getInstance();
                coll.setStrength(0);
                Collections.sort(FtcLoadFileActivity.this.fileList, new Comparator<RobotConfigFile>(){

                    @Override
                    public int compare(RobotConfigFile lhs, RobotConfigFile rhs) {
                        return coll.compare(lhs.getName(), rhs.getName());
                    }
                });
                for (RobotConfigFile file : FtcLoadFileActivity.this.fileList) {
                    View child = LayoutInflater.from((Context)FtcLoadFileActivity.this.context).inflate(R.layout.file_info, null);
                    inclusionViewGroup.addView(child);
                    if (file.isReadOnly()) {
                        Button deleteButton = (Button)child.findViewById(R.id.file_delete_button);
                        deleteButton.setEnabled(false);
                        deleteButton.setClickable(false);
                        readOnlyExplanation.setVisibility(0);
                    }
                    TextView name = (TextView)child.findViewById(R.id.filename_editText);
                    name.setText((CharSequence)file.getName());
                    name.setTag((Object)file);
                    child.findViewById(R.id.configIsReadOnlyFeedback).setVisibility(file.isReadOnly() ? 0 : 8);
                }
            }
        });
    }

    protected void onActivityResult(int requestCodeValue, int resultCode, Intent data) {
        this.logActivityResult(requestCodeValue, resultCode, data);
        this.currentCfgFile = this.robotConfigFileManager.getActiveConfigAndUpdateUI();
    }

    public void onNewButtonPressed(View v) {
        RobotConfigFile file = RobotConfigFile.noConfig(this.robotConfigFileManager);
        this.robotConfigFileManager.setActiveConfigAndUpdateUI(this.remoteConfigure, file);
        Intent intent = this.makeEditConfigIntent(FtcNewFileActivity.class, null);
        this.startActivityForResult(intent, FtcNewFileActivity.requestCode.value);
    }

    public void onFileEditButtonPressed(View v) {
        RobotConfigFile file = this.getFile(v);
        this.robotConfigFileManager.setActiveConfig(this.remoteConfigure, file);
        Intent intent = this.makeEditConfigIntent(FtcConfigurationActivity.class, file);
        this.startActivityForResult(intent, FtcConfigurationActivity.requestCode.value);
    }

    public void onConfigureFromTemplatePressed(View v) {
        Intent intent = this.makeEditConfigIntent(ConfigureFromTemplateActivity.class, null);
        this.startActivityForResult(intent, ConfigureFromTemplateActivity.requestCode.value);
    }

    Intent makeEditConfigIntent(Class clazz, @Nullable RobotConfigFile configFile) {
        EditParameters parameters = new EditParameters(this);
        parameters.setExtantRobotConfigurations(this.fileList);
        if (configFile != null) {
            parameters.setCurrentCfgFile(configFile);
        }
        Intent intent = new Intent(this.context, clazz);
        parameters.putIntent(intent);
        return intent;
    }

    public void onFileActivateButtonPressed(View v) {
        RobotConfigFile file = this.getFile(v);
        this.robotConfigFileManager.setActiveConfigAndUpdateUI(this.remoteConfigure, file);
        if (this.remoteConfigure) {
            this.networkConnectionHandler.sendCommand(new Command("CMD_ACTIVATE_CONFIGURATION", file.toString()));
        }
    }

    public void onFileDeleteButtonPressed(View v) {
        final RobotConfigFile robotConfigFile = this.getFile(v);
        if (robotConfigFile.getLocation() == RobotConfigFile.FileLocation.LOCAL_STORAGE) {
            AlertDialog.Builder builder = this.utility.buildBuilder(this.getString(R.string.confirmConfigDeleteTitle), this.getString(R.string.confirmConfigDeleteMessage));
            DialogInterface.OnClickListener okListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int button) {
                    FtcLoadFileActivity.this.doDeleteConfiguration(robotConfigFile);
                }
            };
            builder.setPositiveButton(R.string.buttonNameOK, okListener);
            builder.setNegativeButton(R.string.buttonNameCancel, this.doNothingAndCloseListener);
            builder.show();
        }
    }

    void doDeleteConfiguration(RobotConfigFile robotConfigFile) {
        if (this.remoteConfigure) {
            if (robotConfigFile.getLocation() == RobotConfigFile.FileLocation.LOCAL_STORAGE) {
                this.networkConnectionHandler.sendCommand(new Command("CMD_DELETE_CONFIGURATION", robotConfigFile.toString()));
                this.fileList.remove(robotConfigFile);
                this.populate();
            }
            this.networkConnectionHandler.sendCommand(new Command("CMD_REQUEST_CONFIGURATIONS"));
        } else {
            File file;
            if (robotConfigFile.getLocation() == RobotConfigFile.FileLocation.LOCAL_STORAGE && !(file = robotConfigFile.getFullPath()).delete()) {
                String filenameWExt = file.getName();
                this.appUtil.showToast(UILocation.ONLY_LOCAL, String.format(this.getString(R.string.configToDeleteDoesNotExist), filenameWExt));
                RobotLog.ee((String)TAG, (String)("Tried to delete a file that does not exist: " + filenameWExt));
            }
            this.fileList = this.robotConfigFileManager.getXMLFiles();
            this.populate();
        }
        RobotConfigFile cfgFile = RobotConfigFile.noConfig(this.robotConfigFileManager);
        this.robotConfigFileManager.setActiveConfigAndUpdateUI(this.remoteConfigure, cfgFile);
    }

    private RobotConfigFile getFile(View v) {
        LinearLayout horizontalButtons = (LinearLayout)v.getParent();
        LinearLayout linearLayout = (LinearLayout)horizontalButtons.getParent();
        TextView name = (TextView)linearLayout.findViewById(R.id.filename_editText);
        return (RobotConfigFile)name.getTag();
    }

    @Override
    public void onBackPressed() {
        this.logBackPressed();
        this.finishOk();
    }

    private class CommandCallback
    extends RecvLoopRunnable.DegenerateCallback {
        private CommandCallback() {
        }

        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            CallbackResult result = CallbackResult.NOT_HANDLED;
            try {
                String name = command.getName();
                String extra = command.getExtra();
                if (name.equals("CMD_REQUEST_CONFIGURATIONS_RESP")) {
                    result = FtcLoadFileActivity.this.handleCommandRequestConfigFilesResp(extra);
                } else if (name.equals("CMD_NOTIFY_ACTIVE_CONFIGURATION")) {
                    result = FtcLoadFileActivity.this.handleCommandNotifyActiveConfig(extra);
                }
            }
            catch (RobotCoreException e) {
                RobotLog.logStacktrace((Throwable)e);
            }
            return result;
        }
    }
}

