/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;

@SuppressLint(value={"AppCompatCustomView"})
public class IpAddressEditText
extends EditText {
    private static final String DOT = ".";
    private int currentNumberIndex = 0;

    public IpAddressEditText(Context context) {
        super(context);
        this.init();
    }

    public IpAddressEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IpAddressEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                String text = s.toString();
                if (!text.isEmpty() && text.length() % 3 == 0 && !text.endsWith(IpAddressEditText.DOT)) {
                    s.insert(text.length(), (CharSequence)IpAddressEditText.DOT);
                    IpAddressEditText.this.currentNumberIndex++;
                }
            }
        });
    }

    private void moveCursorToNextNumber() {
        int selectionStart = this.getSelectionStart();
        if (selectionStart == this.getText().length()) {
            return;
        }
        if (this.currentNumberIndex < 4 && selectionStart % 3 == 2) {
            this.setSelection(selectionStart + 1);
            ++this.currentNumberIndex;
        }
    }

    public String getIpAddress() {
        String text = this.getText().toString();
        if (text.endsWith(DOT)) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

