/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.preference.PreferenceManager;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import com.google.gson.reflect.TypeToken;
import com.qualcomm.ftccommon.R;
import com.qualcomm.ftccommon.configuration.RobotConfigFile;
import com.qualcomm.ftccommon.configuration.RobotConfigMap;
import com.qualcomm.ftccommon.configuration.RobotConfigResFilter;
import com.qualcomm.robotcore.exception.DuplicateNameException;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.WriteXMLFileHandler;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.firstinspires.ftc.robotcore.external.Supplier;
import org.firstinspires.ftc.robotcore.internal.collections.SimpleGson;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Dom2XmlPullBuilder;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.ftc.robotcore.internal.webserver.RobotControllerWebInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RobotConfigFileManager {
    public static final String TAG = "RobotConfigFileManager";
    public static final boolean DEBUG = false;
    public static final String ROBOT_CONFIG_DESCRIPTION_GENERATE_XSLT = "RobotConfigDescriptionGenerate.xslt";
    public static final String ROBOT_CONFIG_TAXONOMY_XML = "RobotConfigTaxonomy.xml";
    public static final String FILE_LIST_COMMAND_DELIMITER = ";";
    public static final String FILE_EXT = ".xml";
    public final String noConfig;
    private Context context;
    private Activity activity;
    private Resources resources;
    private WriteXMLFileHandler writer;
    private SharedPreferences preferences;
    @IdRes
    private final int idActiveConfigName = R.id.idActiveConfigName;
    @IdRes
    private final int idActiveConfigHeader = R.id.idActiveConfigHeader;
    private NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    private AppUtil appUtil = AppUtil.getInstance();
    private static Supplier<Collection<Integer>> xmlResourceIdSupplier = null;
    private static Supplier<Collection<Integer>> xmlResourceTemplateIdsSupplier = null;

    public RobotConfigFileManager(Activity activity) {
        this.activity = activity;
        this.context = this.appUtil.getApplication();
        this.resources = this.context.getResources();
        this.writer = new WriteXMLFileHandler();
        this.preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        this.noConfig = this.context.getString(R.string.noCurrentConfigFile);
    }

    public RobotConfigFileManager() {
        this(null);
    }

    public void createConfigFolder() {
        File robotDir = AppUtil.CONFIG_FILES_DIR;
        boolean createdDir = true;
        if (!robotDir.exists()) {
            createdDir = robotDir.mkdir();
        }
        if (!createdDir) {
            RobotLog.ee((String)TAG, (String)"Can't create the Robot Config Files directory!");
            this.appUtil.showToast(UILocation.BOTH, this.context.getString(R.string.toastCantCreateRobotConfigFilesDir));
        }
    }

    public static String getRobotConfigTypeAttribute() {
        return "FirstInspires-FTC";
    }

    public static String getRobotConfigTemplateAttribute() {
        return "FirstInspires-FTC-template";
    }

    public static void setXmlResourceIdSupplier(Supplier<Collection<Integer>> supplier) {
        xmlResourceIdSupplier = supplier;
    }

    public static void setXmlResourceTemplateIdSupplier(Supplier<Collection<Integer>> supplier) {
        xmlResourceTemplateIdsSupplier = supplier;
    }

    private Collection<Integer> getXmlResourceIds() {
        return xmlResourceIdSupplier != null ? (Collection)xmlResourceIdSupplier.get() : new ArrayList();
    }

    private Collection<Integer> getXmlResourceTemplateIds() {
        return xmlResourceTemplateIdsSupplier != null ? (Collection)xmlResourceTemplateIdsSupplier.get() : new ArrayList();
    }

    @NonNull
    public RobotConfigFile getConfigFromString(String objSerialized) {
        return RobotConfigFile.fromString(this, objSerialized);
    }

    @NonNull
    public RobotConfigFile getActiveConfigAndUpdateUI() {
        RobotConfigFile file = this.getActiveConfig();
        this.updateActiveConfigHeader(file);
        return file;
    }

    @NonNull
    public RobotConfigFile getActiveConfig() {
        String key = this.context.getString(R.string.pref_hardware_config_filename);
        String objSerialized = this.preferences.getString(key, null);
        RobotConfigFile file = objSerialized == null ? RobotConfigFile.noConfig(this) : this.getConfigFromString(objSerialized);
        RobotControllerWebInfo.setActiveConfigName((String)file.getName());
        return file;
    }

    public void sendActiveConfigToDriverStation() {
        RobotConfigFile configFile = this.getActiveConfig();
        String serialized = configFile.toString();
        this.networkConnectionHandler.sendCommand(new Command("CMD_NOTIFY_ACTIVE_CONFIGURATION", serialized));
    }

    public void setActiveConfigAndUpdateUI(boolean runningOnDriverStation, @NonNull RobotConfigFile configFile) {
        this.setActiveConfig(runningOnDriverStation, configFile);
        this.updateActiveConfigHeader(configFile);
    }

    public void setActiveConfigAndUpdateUI(@NonNull RobotConfigFile config) {
        this.setActiveConfig(config);
        this.updateActiveConfigHeader(config);
    }

    public void setActiveConfig(boolean runningOnDriverStation, @NonNull RobotConfigFile config) {
        if (runningOnDriverStation) {
            this.sendRobotControllerActiveConfigAndUpdateUI(config);
        } else {
            this.setActiveConfig(config);
            this.sendActiveConfigToDriverStation();
        }
    }

    public void setActiveConfig(@NonNull RobotConfigFile cfgFile) {
        String objSerialized = SimpleGson.getInstance().toJson((Object)cfgFile);
        SharedPreferences.Editor edit = this.preferences.edit();
        String key = this.context.getString(R.string.pref_hardware_config_filename);
        edit.putString(key, objSerialized);
        edit.apply();
    }

    public void sendRobotControllerActiveConfigAndUpdateUI(@NonNull RobotConfigFile config) {
        this.networkConnectionHandler.sendCommand(new Command("CMD_ACTIVATE_CONFIGURATION", config.toString()));
    }

    public void updateActiveConfigHeader(RobotConfigFile robotConfigFile) {
        this.updateActiveConfigHeader(robotConfigFile.getName(), robotConfigFile.isDirty());
    }

    public void updateActiveConfigHeader(final String fileNameIn, final boolean dirty) {
        if (this.activity != null) {
            this.appUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TextView activeFile;
                    String fileName = RobotConfigFileManager.stripFileNameExtension(fileNameIn).trim();
                    if (fileName.isEmpty()) {
                        fileName = RobotConfigFileManager.this.noConfig;
                    }
                    if (dirty) {
                        fileName = String.format(RobotConfigFileManager.this.context.getString(R.string.configDirtyLabel), fileName);
                    }
                    if ((activeFile = (TextView)RobotConfigFileManager.this.activity.findViewById(RobotConfigFileManager.this.idActiveConfigName)) != null) {
                        activeFile.setText((CharSequence)fileName);
                    } else {
                        RobotLog.ee((String)RobotConfigFileManager.TAG, (String)"unable to find header text 0x%08x", (Object[])new Object[]{RobotConfigFileManager.this.idActiveConfigName});
                    }
                    if (!dirty && fileName.equalsIgnoreCase(RobotConfigFileManager.this.noConfig)) {
                        RobotConfigFileManager.this.changeHeaderBackground(R.id.backgroundLightHolder);
                    } else if (dirty) {
                        RobotConfigFileManager.this.changeHeaderBackground(R.id.backgroundDarkGrayHolder);
                    } else {
                        RobotConfigFileManager.this.changeHeaderBackground(R.id.backgroundMediumHolder);
                    }
                }
            });
        } else {
            RobotLog.ee((String)TAG, (String)"updateActiveConfigHeader called with null activity");
        }
    }

    public void changeHeaderBackground(@IdRes int idColorHolder) {
        if (this.activity != null) {
            View colorHolder = this.activity.findViewById(idColorHolder);
            View view = this.activity.findViewById(R.id.idActiveConfigHeader);
            if (colorHolder != null && view != null) {
                view.setBackground(colorHolder.getBackground());
            }
        } else {
            RobotLog.ee((String)TAG, (String)"changeHeaderBackground called with null activity");
        }
    }

    public ConfigNameCheckResult isPlausibleConfigName(RobotConfigFile existingConfig, String candidate, List<RobotConfigFile> extantConfigurations) {
        if (!candidate.equals(candidate.trim())) {
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameWhitespace));
        }
        if (candidate.length() == 0) {
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameEmpty));
        }
        File file = new File(candidate);
        if (!file.getName().equals(candidate)) {
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameIllegalCharacters));
        }
        String reservedChars = "?:\"*|/\\<>";
        for (char candidateChar : candidate.toCharArray()) {
            if (reservedChars.indexOf(candidateChar) == -1) continue;
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameIllegalCharacters));
        }
        if (candidate.equalsIgnoreCase(this.noConfig)) {
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameReserved));
        }
        if (candidate.equalsIgnoreCase(existingConfig.getName())) {
            return existingConfig.isReadOnly() ? new ConfigNameCheckResult(this.context.getString(R.string.configNameReadOnly)) : new ConfigNameCheckResult(true);
        }
        Object object = extantConfigurations.iterator();
        while (object.hasNext()) {
            RobotConfigFile configFile = (RobotConfigFile)object.next();
            if (!candidate.equalsIgnoreCase(configFile.getName())) continue;
            return new ConfigNameCheckResult(this.context.getString(R.string.configNameExists));
        }
        return new ConfigNameCheckResult(true);
    }

    public static String stripFileNameExtension(String fileName) {
        fileName = fileName.replaceFirst("[.][^.]+$", "");
        return fileName;
    }

    public static File stripFileNameExtension(File path) {
        File folder = path.getParentFile();
        String file = path.getName();
        file = RobotConfigFileManager.stripFileNameExtension(file);
        return new File(folder, file);
    }

    public static String withExtension(String fileName) {
        return RobotConfigFileManager.stripFileNameExtension(fileName) + FILE_EXT;
    }

    public static File getFullPath(String fileNameWithoutExtension) {
        fileNameWithoutExtension = RobotConfigFileManager.withExtension(fileNameWithoutExtension);
        return new File(AppUtil.CONFIG_FILES_DIR, fileNameWithoutExtension);
    }

    public ArrayList<RobotConfigFile> getXMLFiles() {
        File robotDir = AppUtil.CONFIG_FILES_DIR;
        File[] configFiles = robotDir.listFiles();
        ArrayList<RobotConfigFile> fileList = new ArrayList<RobotConfigFile>();
        for (File f : configFiles) {
            if (!f.isFile()) continue;
            String name = f.getName();
            Pattern pattern = Pattern.compile("(?i).xml");
            if (!pattern.matcher(name).find()) continue;
            String nameNoExt = RobotConfigFileManager.stripFileNameExtension(name);
            fileList.add(new RobotConfigFile(this, nameNoExt));
        }
        Iterator<Integer> iterator = this.getXmlResourceIds().iterator();
        while (iterator.hasNext()) {
            int id2 = (Integer)iterator.next();
            XmlResourceParser xpp = this.resources.getXml(id2);
            String name = RobotConfigResFilter.getRootAttribute(xpp, "Robot", "name", this.resources.getResourceEntryName(id2));
            RobotConfigFile configFile = new RobotConfigFile(name, id2);
            if (configFile.containedIn(fileList)) continue;
            fileList.add(configFile);
        }
        return fileList;
    }

    public ArrayList<RobotConfigFile> getXMLTemplates() {
        ArrayList<RobotConfigFile> templateList = new ArrayList<RobotConfigFile>();
        for (int id2 : this.getXmlResourceTemplateIds()) {
            XmlResourceParser xpp = this.resources.getXml(id2);
            String name = RobotConfigResFilter.getRootAttribute(xpp, "Robot", "name", this.resources.getResourceEntryName(id2));
            RobotConfigFile configFile = new RobotConfigFile(name, id2);
            if (configFile.containedIn(templateList)) continue;
            templateList.add(configFile);
        }
        return templateList;
    }

    @NonNull
    public String getRobotConfigDescription(@NonNull XmlPullParser xpp) {
        try {
            Source xmlTemplate = this.getSourceFromPullParser(xpp);
            Source xslt = this.getRobotConfigDescriptionTransform();
            StringWriter output = new StringWriter();
            StreamResult result = new StreamResult(output);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslt);
            transformer.transform(xmlTemplate, result);
            return output.toString().trim();
        }
        catch (IOException | TransformerException | XmlPullParserException e) {
            RobotLog.logStackTrace((Throwable)e);
            return this.context.getString(R.string.templateConfigureNoDescriptionAvailable);
        }
    }

    @NonNull
    protected Source getRobotConfigDescriptionTransform() throws XmlPullParserException, IOException, TransformerConfigurationException, TransformerException {
        InputStreamReader xmlConfigTaxonomyReader = new InputStreamReader(this.context.getAssets().open(ROBOT_CONFIG_TAXONOMY_XML));
        XmlPullParser xmlConfigTaxonomyParser = ReadXMLFileHandler.xmlPullParserFromReader((Reader)xmlConfigTaxonomyReader);
        Dom2XmlPullBuilder builder = new Dom2XmlPullBuilder();
        Element rootElement = builder.parseSubTree(xmlConfigTaxonomyParser);
        Document document = rootElement.getOwnerDocument();
        DOMSource sourceConfigTaxonomy = new DOMSource(rootElement);
        StreamSource xsltGenerate = new StreamSource(this.context.getAssets().open(ROBOT_CONFIG_DESCRIPTION_GENERATE_XSLT));
        StringWriter xsltDescriptionWriter = new StringWriter();
        StreamResult transformerResult = new StreamResult(xsltDescriptionWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xsltGenerate);
        transformer.transform(sourceConfigTaxonomy, transformerResult);
        String xsltDescriptionTransform = xsltDescriptionWriter.toString().trim();
        StringReader xsltDescriptionTransformReader = new StringReader(xsltDescriptionTransform);
        StreamSource result = new StreamSource(xsltDescriptionTransformReader);
        return result;
    }

    protected void addChild(Document document, Element parent, String tag, String contents) {
        Element child = document.createElement(tag);
        child.setTextContent(contents);
        parent.appendChild(child);
    }

    protected Source getSourceFromPullParser(@NonNull XmlPullParser xpp) throws XmlPullParserException, IOException {
        Dom2XmlPullBuilder builder = new Dom2XmlPullBuilder();
        Element rootElement = builder.parseSubTree(xpp);
        return new DOMSource(rootElement);
    }

    public static String serializeXMLConfigList(List<RobotConfigFile> configList) {
        String objsSerialized = SimpleGson.getInstance().toJson(configList);
        return objsSerialized;
    }

    public static String serializeConfig(RobotConfigFile configFile) {
        String serialized = SimpleGson.getInstance().toJson((Object)configFile);
        return serialized;
    }

    public static List<RobotConfigFile> deserializeXMLConfigList(String objsSerialized) {
        Type collectionType = new TypeToken<Collection<RobotConfigFile>>(){}.getType();
        List configList = (List)SimpleGson.getInstance().fromJson(objsSerialized, collectionType);
        return configList;
    }

    public static RobotConfigFile deserializeConfig(String serialized) {
        Class<RobotConfigFile> type = RobotConfigFile.class;
        RobotConfigFile config = (RobotConfigFile)SimpleGson.getInstance().fromJson(serialized, type);
        return config;
    }

    public String toXml(Map<SerialNumber, ControllerConfiguration> deviceControllers) {
        ArrayList<ControllerConfiguration> deviceList = new ArrayList<ControllerConfiguration>();
        deviceList.addAll(deviceControllers.values());
        String output = null;
        try {
            output = this.writer.toXml(deviceList, "type", RobotConfigFileManager.getRobotConfigTypeAttribute(), false);
        }
        catch (DuplicateNameException e) {
            throw e;
        }
        catch (RuntimeException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"exception while serializing to XML");
        }
        return output;
    }

    public String toXml(RobotConfigMap robotConfigMap) {
        return this.toXml(robotConfigMap.map);
    }

    void writeXMLToFile(String filenameWithExt, String data) throws RobotCoreException, IOException {
        this.writer.writeToFile(data, AppUtil.CONFIG_FILES_DIR, filenameWithExt);
    }

    void writeToRobotController(RobotConfigFile cfgFile, String data) {
        this.networkConnectionHandler.sendCommand(new Command("CMD_SAVE_CONFIGURATION", cfgFile.toString() + FILE_LIST_COMMAND_DELIMITER + data));
    }

    public void writeToFile(RobotConfigFile cfgFile, boolean runningOnDriverStation, @NonNull String data) throws RobotCoreException, IOException {
        boolean wasDirty = cfgFile.isDirty();
        cfgFile.markClean();
        try {
            if (runningOnDriverStation) {
                this.writeToRobotController(cfgFile, data);
            } else {
                this.writeXMLToFile(RobotConfigFileManager.withExtension(cfgFile.getName()), data);
            }
        }
        catch (RobotCoreException | IOException | RuntimeException e) {
            if (wasDirty) {
                cfgFile.markDirty();
            }
            throw e;
        }
    }

    public static class ConfigNameCheckResult {
        public boolean success = true;
        public String errorFormat = null;

        public ConfigNameCheckResult(boolean success) {
            this.success = success;
        }

        public ConfigNameCheckResult(@NonNull String errorFormat) {
            this.success = false;
            this.errorFormat = errorFormat;
        }
    }
}

