/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.firstinspires.ftc.robotcore.internal.opmode.ClassFilter;
import org.firstinspires.ftc.robotcore.internal.opmode.OnBotJavaDeterminer;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.xmlpull.v1.XmlPullParserException;

public class RobotConfigResFilter
implements ClassFilter {
    public static final String robotConfigRootTag = "Robot";
    public static final String robotConfigRootTypeAttribute = "type";
    protected Resources resources;
    protected String typeAttributeValue;
    protected ArrayList<Integer> xmlIdCollection;

    public RobotConfigResFilter(String typeAttributeValue) {
        this((Context)AppUtil.getInstance().getApplication(), typeAttributeValue);
    }

    public RobotConfigResFilter(Context context, String typeAttributeValue) {
        this.typeAttributeValue = typeAttributeValue;
        this.resources = context.getResources();
        this.xmlIdCollection = new ArrayList();
        this.clear();
    }

    protected void clear() {
        this.xmlIdCollection.clear();
    }

    public List<Integer> getXmlIds() {
        return this.xmlIdCollection;
    }

    private boolean isRobotConfiguration(XmlResourceParser xpp) {
        return this.typeAttributeValue.equals(RobotConfigResFilter.getRootAttribute(xpp, robotConfigRootTag, robotConfigRootTypeAttribute, null));
    }

    public static String getRootAttribute(XmlResourceParser xpp, String rootElement, String attributeName, String defaultValue) {
        try {
            while (xpp.getEventType() != 1) {
                if (xpp.getEventType() == 2) {
                    if (!xpp.getName().equals(rootElement)) {
                        return null;
                    }
                    String result = xpp.getAttributeValue(null, attributeName);
                    return result != null ? result : defaultValue;
                }
                xpp.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void filterAllClassesStart() {
        this.clear();
    }

    public void filterOnBotJavaClassesStart() {
    }

    public void filterExternalLibrariesClassesStart() {
    }

    public void filterClass(Class clazz) {
        if (OnBotJavaDeterminer.isExternalLibraries((Class)clazz)) {
            return;
        }
        if (clazz.getName().endsWith("R$xml")) {
            Field[] fields;
            for (Field f : fields = clazz.getFields()) {
                try {
                    int id2;
                    Class<?> c = f.getType();
                    if (!c.equals(Integer.TYPE) || !this.isRobotConfiguration(this.resources.getXml(id2 = f.getInt(clazz)))) continue;
                    this.xmlIdCollection.add(id2);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void filterOnBotJavaClass(Class clazz) {
        this.filterClass(clazz);
    }

    public void filterExternalLibrariesClass(Class clazz) {
    }

    public void filterAllClassesComplete() {
    }

    public void filterOnBotJavaClassesComplete() {
        this.filterAllClassesComplete();
    }

    public void filterExternalLibrariesClassesComplete() {
    }
}

