/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.ftccommon.configuration;

import android.content.Context;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.HardwareDeviceManager;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.RobotCoreLynxUsbDevice;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.robocol.Command;
import com.qualcomm.robotcore.util.NextLock;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.firstinspires.ftc.robotcore.external.function.Supplier;
import org.firstinspires.ftc.robotcore.internal.network.CallbackResult;
import org.firstinspires.ftc.robotcore.internal.network.NetworkConnectionHandler;
import org.firstinspires.ftc.robotcore.internal.network.RecvLoopRunnable;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class USBScanManager {
    private static final USBScanManager instance = new USBScanManager();
    public static final String TAG = "FtcConfigTag";
    public static final int msWaitDefault = 4000;
    protected final boolean isRemoteConfig;
    protected final ExecutorService executorService = ThreadPool.getDefault();
    protected final ThreadPool.Singleton<ScannedDevices> scanningSingleton = new ThreadPool.Singleton();
    protected DeviceManager deviceManager;
    protected final NextLock scanResultsSequence = new NextLock();
    protected final Object remoteScannedDevicesLock = new Object();
    protected ScannedDevices remoteScannedDevices;
    protected final NetworkConnectionHandler networkConnectionHandler = NetworkConnectionHandler.getInstance();
    protected final Map<String, LynxModuleDiscoveryState> lynxModuleDiscoveryStateMap = new ConcurrentHashMap<String, LynxModuleDiscoveryState>();

    public static USBScanManager getInstance() {
        return instance;
    }

    private USBScanManager() {
        this.isRemoteConfig = AppUtil.getInstance().isDriverStation();
        if (this.isRemoteConfig) {
            this.networkConnectionHandler.pushReceiveLoopCallback((RecvLoopRunnable.RecvLoopCallback)new ResultsReceiver());
        } else {
            this.deviceManager = new HardwareDeviceManager((Context)AppUtil.getDefContext(), null);
        }
        this.scanningSingleton.setService(this.executorService);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public DeviceManager getDeviceManager() {
        return this.deviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LynxModuleDiscoveryState getDiscoveryState(SerialNumber serialNumber) {
        Map<String, LynxModuleDiscoveryState> map = this.lynxModuleDiscoveryStateMap;
        synchronized (map) {
            LynxModuleDiscoveryState result = this.lynxModuleDiscoveryStateMap.get(serialNumber.getString());
            if (result == null) {
                result = new LynxModuleDiscoveryState(serialNumber);
                this.lynxModuleDiscoveryStateMap.put(serialNumber.getString(), result);
            }
            return result;
        }
    }

    public Supplier<LynxModuleMetaList> getLynxModuleMetaListSupplier(final SerialNumber serialNumber) {
        return new Supplier<LynxModuleMetaList>(){

            public LynxModuleMetaList get() {
                LynxModuleMetaList result = null;
                try {
                    result = (LynxModuleMetaList)USBScanManager.this.startLynxModuleEnumerationIfNecessary(serialNumber).await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return result;
            }
        };
    }

    public ThreadPool.SingletonResult<LynxModuleMetaList> startLynxModuleEnumerationIfNecessary(final SerialNumber serialNumber) {
        final LynxModuleDiscoveryState discoveryState = this.getDiscoveryState(serialNumber);
        return discoveryState.lynxDiscoverySingleton.submit(4000, (Callable)new Callable<LynxModuleMetaList>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LynxModuleMetaList call() throws InterruptedException {
                if (USBScanManager.this.isRemoteConfig) {
                    NextLock.Waiter waiter = discoveryState.lynxDiscoverySequence.getNextWaiter();
                    RobotLog.vv((String)USBScanManager.TAG, (String)"sending remote lynx module discovery request...");
                    USBScanManager.this.networkConnectionHandler.sendCommand(new Command("CMD_DISCOVER_LYNX_MODULES", serialNumber.getString()));
                    waiter.awaitNext();
                    RobotLog.vv((String)USBScanManager.TAG, (String)"...remote scan lynx module discovery completed.");
                    Object object = discoveryState.remoteLynxDiscoveryLock;
                    synchronized (object) {
                        return discoveryState.remoteLynxModules;
                    }
                }
                RobotLog.vv((String)USBScanManager.TAG, (String)"discovering lynx modules on lynx device=%s...", (Object[])new Object[]{serialNumber});
                LynxModuleMetaList localResult = null;
                try (RobotCoreLynxUsbDevice lynxUsbDevice = null;){
                    lynxUsbDevice = USBScanManager.this.deviceManager.createLynxUsbDevice(serialNumber, null);
                    localResult = lynxUsbDevice.discoverModules(true);
                }
                catch (RobotCoreException e) {
                    try {
                        RobotLog.ee((String)USBScanManager.TAG, (String)("discovering lynx modules threw exception: " + e.toString()));
                        localResult = null;
                    }
                    catch (Throwable throwable) {
                        RobotLog.vv((String)USBScanManager.TAG, (String)"...discovering lynx modules complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.toString()});
                        throw throwable;
                    }
                    RobotLog.vv((String)USBScanManager.TAG, (String)"...discovering lynx modules complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.toString()});
                }
                RobotLog.vv((String)USBScanManager.TAG, (String)"...discovering lynx modules complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.toString()});
                return localResult;
            }
        });
    }

    public ThreadPool.SingletonResult<ScannedDevices> startDeviceScanIfNecessary() {
        return this.scanningSingleton.submit(4000, (Callable)new Callable<ScannedDevices>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ScannedDevices call() throws InterruptedException {
                if (USBScanManager.this.isRemoteConfig) {
                    NextLock.Waiter waiter = USBScanManager.this.scanResultsSequence.getNextWaiter();
                    RobotLog.vv((String)USBScanManager.TAG, (String)"sending remote scan request...");
                    USBScanManager.this.networkConnectionHandler.sendCommand(new Command("CMD_SCAN"));
                    waiter.awaitNext();
                    RobotLog.vv((String)USBScanManager.TAG, (String)"...remote scan request completed.");
                    Object object = USBScanManager.this.remoteScannedDevicesLock;
                    synchronized (object) {
                        return USBScanManager.this.remoteScannedDevices;
                    }
                }
                RobotLog.vv((String)USBScanManager.TAG, (String)"scanning USB bus...");
                ScannedDevices localResult = null;
                try {
                    localResult = USBScanManager.this.deviceManager.scanForUsbDevices();
                }
                catch (RobotCoreException e) {
                    try {
                        RobotLog.ee((String)USBScanManager.TAG, (Throwable)e, (String)"USB bus scan threw exception");
                        localResult = null;
                    }
                    catch (Throwable throwable) {
                        RobotLog.vv((String)USBScanManager.TAG, (String)".. scanning complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.keySet().toString()});
                        throw throwable;
                    }
                    RobotLog.vv((String)USBScanManager.TAG, (String)".. scanning complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.keySet().toString()});
                }
                RobotLog.vv((String)USBScanManager.TAG, (String)".. scanning complete: %s", (Object[])new Object[]{localResult == null ? "null" : localResult.keySet().toString()});
                return localResult;
            }
        });
    }

    @NonNull
    public ScannedDevices awaitScannedDevices() throws InterruptedException {
        ScannedDevices result = (ScannedDevices)this.scanningSingleton.await();
        if (result == null) {
            RobotLog.vv((String)TAG, (String)"USBScanManager.await() returning made-up scan result");
            result = new ScannedDevices();
        }
        return result;
    }

    @NonNull
    public LynxModuleMetaList awaitLynxModules(SerialNumber serialNumber) throws InterruptedException {
        LynxModuleDiscoveryState discoveryState = this.getDiscoveryState(serialNumber);
        LynxModuleMetaList result = (LynxModuleMetaList)discoveryState.lynxDiscoverySingleton.await();
        if (result == null) {
            RobotLog.vv((String)TAG, (String)"USBScanManager.awaitLynxModules() returning made-up result");
            result = new LynxModuleMetaList(serialNumber);
        }
        return result;
    }

    public String packageCommandResponse(ScannedDevices scannedDevices) {
        return scannedDevices.toSerializationString();
    }

    public String packageCommandResponse(LynxModuleMetaList lynxModules) {
        return lynxModules.toSerializationString();
    }

    private class ResultsReceiver
    extends RecvLoopRunnable.DegenerateCallback {
        private ResultsReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CallbackResult commandEvent(Command command) throws RobotCoreException {
            switch (command.getName()) {
                case "CMD_SCAN_RESP": {
                    RobotLog.vv((String)USBScanManager.TAG, (String)"Received USB scan response");
                    ScannedDevices scannedDevices = ScannedDevices.fromSerializationString((String)command.getExtra());
                    Object object = USBScanManager.this.remoteScannedDevicesLock;
                    synchronized (object) {
                        USBScanManager.this.remoteScannedDevices = scannedDevices;
                        USBScanManager.this.scanResultsSequence.advanceNext();
                    }
                    return CallbackResult.HANDLED_CONTINUE;
                }
                case "CMD_DISCOVER_LYNX_MODULES_RESP": {
                    RobotLog.vv((String)USBScanManager.TAG, (String)"Received lynx module discovery response");
                    LynxModuleMetaList lynxModules = LynxModuleMetaList.fromSerializationString((String)command.getExtra());
                    LynxModuleDiscoveryState discoveryState = USBScanManager.this.getDiscoveryState(lynxModules.serialNumber);
                    Object object = discoveryState.remoteLynxDiscoveryLock;
                    synchronized (object) {
                        discoveryState.remoteLynxModules = lynxModules;
                        discoveryState.lynxDiscoverySequence.advanceNext();
                    }
                    return CallbackResult.HANDLED_CONTINUE;
                }
            }
            return CallbackResult.NOT_HANDLED;
        }
    }

    protected class LynxModuleDiscoveryState {
        protected SerialNumber serialNumber;
        protected LynxModuleMetaList remoteLynxModules;
        protected NextLock lynxDiscoverySequence = new NextLock();
        protected final Object remoteLynxDiscoveryLock = new Object();
        protected ThreadPool.Singleton<LynxModuleMetaList> lynxDiscoverySingleton = new ThreadPool.Singleton();

        protected LynxModuleDiscoveryState(SerialNumber serialNumber) {
            this.serialNumber = serialNumber;
            this.remoteLynxModules = new LynxModuleMetaList(serialNumber);
            this.lynxDiscoverySingleton.setService(USBScanManager.this.executorService);
        }
    }
}

