/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class FtcRobotControllerWatchdogService
extends Service {
    public static final String TAG = "FtcRobotControllerWatchdogService";

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public static boolean isFtcRobotControllerActivity(Activity activity) {
        try {
            return Class.forName("org.firstinspires.ftc.robotcontroller.internal.FtcRobotControllerActivity") == activity.getClass();
        }
        catch (ClassNotFoundException | RuntimeException e) {
            return false;
        }
    }

    public static boolean isLaunchActivity(Activity activity) {
        return activity != null && FtcRobotControllerWatchdogService.isLaunchActivity(activity.getClass());
    }

    public static boolean isLaunchActivity(Class clazz) {
        return clazz == ActivityFinder.launchActivityClass;
    }

    public static Class launchActivity() {
        return ActivityFinder.launchActivityClass;
    }

    public void onCreate() {
        super.onCreate();
        RobotLog.vv((String)TAG, (String)"onCreate()");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        RobotLog.vv((String)TAG, (String)"onStartCommand() intent=%s flags=0x%x startId=%d", (Object[])new Object[]{intent, flags, startId});
        if (AppUtil.getInstance().isRobotController()) {
            boolean autoStart = FtcRobotControllerWatchdogService.shouldAutoLaunchRobotController();
            if (null == intent && autoStart) {
                FtcRobotControllerWatchdogService.launchRobotController((Context)this);
            }
            return autoStart ? 1 : 2;
        }
        RobotLog.dd((String)TAG, (String)"onStartCommand(): running on DS: shutting down");
        this.stopSelf();
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        RobotLog.vv((String)TAG, (String)"onDestroy()");
    }

    public static boolean shouldAutoLaunchRobotController() {
        boolean result = false;
        if (AppUtil.getInstance().isRobotController() && LynxConstants.isRevControlHub() && LynxConstants.autorunRobotController()) {
            result = true;
        }
        RobotLog.vv((String)TAG, (String)"shouldAutoLauchRobotController() result=%s", (Object[])new Object[]{result});
        return result;
    }

    public static void launchRobotController(Context context) {
        RobotLog.vv((String)TAG, (String)"launchRobotController()");
        Intent openApp = new Intent(context, ActivityFinder.launchActivityClass);
        openApp.addFlags(0x10000000);
        context.startActivity(openApp);
    }

    protected static class ActivityFinder {
        protected static final Class launchActivityClass = ActivityFinder.findLaunchActivityClass();

        protected ActivityFinder() {
        }

        protected static Class findLaunchActivityClass() {
            Class<?> result = null;
            try {
                Application context = AppUtil.getDefContext();
                result = Class.forName(context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent().getClassName());
            }
            catch (ClassNotFoundException | RuntimeException e) {
                result = null;
            }
            if (result == null) {
                try {
                    result = Class.forName("org.firstinspires.ftc.robotcontroller.internal.FtcRobotControllerActivity");
                }
                catch (ClassNotFoundException | RuntimeException exception) {
                    // empty catch block
                }
            }
            if (result == null) {
                throw AppUtil.getInstance().unreachable(FtcRobotControllerWatchdogService.TAG);
            }
            return result;
        }
    }
}

