/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Bundle;
import android.os.Environment;
import android.view.KeyEvent;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.R;
import com.qualcomm.robotcore.util.RobotLog;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.ui.LocalByRefRequestCodeHolder;
import org.firstinspires.ftc.robotcore.internal.ui.ThemedActivity;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;
import org.firstinspires.ftc.robotcore.internal.webserver.FtcUserAgentCategory;
import org.firstinspires.ftc.robotcore.internal.webserver.RobotControllerWebInfo;
import org.firstinspires.ftc.robotserver.internal.webserver.AppThemeColors;
import org.firstinspires.ftc.robotserver.internal.webserver.MimeTypesUtil;
import org.firstinspires.inspection.R;

public class ProgramAndManageActivity
extends ThemedActivity {
    public static final String TAG = "Console";
    protected RobotControllerWebInfo webInfo;
    protected WebView webView;
    final ProgramAndManageWebChromeClient webChromeClient = new ProgramAndManageWebChromeClient();
    final ProgramAndManageWebViewClient webViewClient = new ProgramAndManageWebViewClient();
    final ProgramAndManageDownloadListener downloadListener = new ProgramAndManageDownloadListener();

    public String getTag() {
        return TAG;
    }

    protected FrameLayout getBackBar() {
        return (FrameLayout)this.findViewById(R.id.backbar);
    }

    protected String getUrlParam(String urlString, String paramName) {
        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer();
        sanitizer.setAllowUnregisteredParamaters(true);
        sanitizer.registerParameter(paramName, UrlQuerySanitizer.getAllButNulLegal());
        sanitizer.parseUrl(urlString);
        return sanitizer.getValue(paramName);
    }

    protected void onActivityResult(int actualRequestCode, int resultCode, Intent data) {
        RobotLog.vv((String)TAG, (String)"onActivityResult() requestCode=%d resultCode=%d data=%s", (Object[])new Object[]{actualRequestCode, resultCode, data});
        LocalByRefRequestCodeHolder holder = LocalByRefRequestCodeHolder.from((int)actualRequestCode);
        if (holder != null) {
            int requestCode = holder.getUserRequestCode();
            if (requestCode == RequestCode.CHOOSE_FILE.ordinal()) {
                Uri[] uriArray;
                if (data == null || resultCode != -1) {
                    uriArray = null;
                } else {
                    Uri[] uriArray2 = new Uri[1];
                    uriArray = uriArray2;
                    uriArray2[0] = data.getData();
                }
                Uri[] result = uriArray;
                RobotLog.vv((String)TAG, (String)"CHOOSE_FILE result=%s", (Object[])new Object[]{result == null ? null : result[0]});
                ValueCallback filePathCallback = (ValueCallback)holder.getTargetAndForget();
                filePathCallback.onReceiveValue((Object)result);
            } else {
                RobotLog.ee((String)TAG, (String)"onActivityResult() user requestCode=%d: unexpected", (Object[])new Object[]{requestCode});
            }
        } else {
            RobotLog.ee((String)TAG, (String)"onActivityResult() actual requestCode=%d: unexpected", (Object[])new Object[]{actualRequestCode});
        }
    }

    protected AppUtil.DialogContext showAlert(String message, @Nullable Consumer<AppUtil.DialogContext> runOnDismiss) {
        AppUtil.DialogParams params = new AppUtil.DialogParams(UILocation.ONLY_LOCAL, this.getString(R.string.alertTitleRobotControllerConsole), message);
        params.activity = this;
        params.flavor = AppUtil.DialogFlavor.ALERT;
        return AppUtil.getInstance().showDialog(params, runOnDismiss);
    }

    protected AppUtil.DialogContext showConfirm(String message, @Nullable Consumer<AppUtil.DialogContext> runOnDismiss) {
        AppUtil.DialogParams params = new AppUtil.DialogParams(UILocation.ONLY_LOCAL, this.getString(R.string.alertTitleRobotControllerConsole), message);
        params.activity = this;
        params.flavor = AppUtil.DialogFlavor.CONFIRM;
        return AppUtil.getInstance().showDialog(params, runOnDismiss);
    }

    protected AppUtil.DialogContext showPrompt(String message, @Nullable String defaultValue, @Nullable Consumer<AppUtil.DialogContext> runOnDismiss) {
        AppUtil.DialogParams params = new AppUtil.DialogParams(UILocation.ONLY_LOCAL, this.getString(R.string.alertTitleRobotControllerConsole), message);
        params.activity = this;
        params.flavor = AppUtil.DialogFlavor.PROMPT;
        params.defaultValue = defaultValue;
        return AppUtil.getInstance().showDialog(params, runOnDismiss);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onCreate(@Nullable Bundle savedInstanceState) {
        RobotLog.vv((String)TAG, (String)"onCreate()");
        super.onCreate(savedInstanceState);
        this.downloadListener.register();
        this.setContentView(R.layout.activity_program_and_manage);
        this.webInfo = RobotControllerWebInfo.fromJson((String)this.getIntent().getStringExtra("RC_WEB_INFO"));
        this.webView = (WebView)this.findViewById(R.id.webView);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setUserAgentString(FtcUserAgentCategory.addToUserAgent((String)WebSettings.getDefaultUserAgent((Context)this)));
        this.webView.setWebChromeClient((WebChromeClient)this.webChromeClient);
        this.webView.setWebViewClient((WebViewClient)this.webViewClient);
        this.webView.setDownloadListener((DownloadListener)this.downloadListener);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Ftc-RCConsole-Theme", AppThemeColors.toHeader((String)AppThemeColors.fromTheme().toLess()));
        this.webView.loadUrl(this.webInfo.getServerUrl(), headers);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            switch (keyCode) {
                case 4: {
                    if (!this.webView.canGoBack()) break;
                    this.webView.goBack();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onResume() {
        RobotLog.vv((String)TAG, (String)"onResume()");
        super.onResume();
    }

    protected void onPause() {
        RobotLog.vv((String)TAG, (String)"onPause()");
        super.onPause();
    }

    protected void onDestroy() {
        RobotLog.vv((String)TAG, (String)"onDestroy()");
        super.onDestroy();
        this.downloadListener.unregister();
    }

    protected class ProgramAndManageWebChromeClient
    extends WebChromeClient {
        protected ProgramAndManageWebChromeClient() {
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"onJsAlert() message=%s", (Object[])new Object[]{message});
            return this.showJsAlert(view, url, message, result);
        }

        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"onJsBeforeUnload() url=%s message=%s", (Object[])new Object[]{url, message});
            return this.showJsAlert(view, url, message, result);
        }

        protected boolean showJsAlert(WebView view, String url, String message, final JsResult result) {
            ProgramAndManageActivity.this.showAlert(message, new Consumer<AppUtil.DialogContext>(){

                public void accept(AppUtil.DialogContext context) {
                    result.confirm();
                }
            });
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"onJsConfirm() url=%s message=%s", (Object[])new Object[]{url, message});
            ProgramAndManageActivity.this.showConfirm(message, new Consumer<AppUtil.DialogContext>(){

                public void accept(AppUtil.DialogContext dialogContext) {
                    Assert.assertFalse((dialogContext.getOutcome() == AppUtil.DialogContext.Outcome.UNKNOWN ? 1 : 0) != 0);
                    if (dialogContext.getOutcome() == AppUtil.DialogContext.Outcome.CONFIRMED) {
                        result.confirm();
                    } else {
                        result.cancel();
                    }
                }
            });
            return true;
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, final JsPromptResult result) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"onJsPrompt() url=%s message=%s default=%s", (Object[])new Object[]{url, message, defaultValue});
            ProgramAndManageActivity.this.showPrompt(message, defaultValue, new Consumer<AppUtil.DialogContext>(){

                public void accept(AppUtil.DialogContext dialogContext) {
                    Assert.assertFalse((dialogContext.getOutcome() == AppUtil.DialogContext.Outcome.UNKNOWN ? 1 : 0) != 0);
                    if (dialogContext.getOutcome() == AppUtil.DialogContext.Outcome.CONFIRMED) {
                        result.confirm(dialogContext.getText().toString());
                    } else {
                        result.cancel();
                    }
                }
            });
            return true;
        }

        public void openFileChooser(final ValueCallback<Uri> uploadFile, String acceptType, String capture) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"openFileChooser(): acceptType=%s capture=%s", (Object[])new Object[]{acceptType, capture});
            Assert.assertNotNull(uploadFile);
            this.showFileChooser(new ValueCallback<Uri[]>(){

                public void onReceiveValue(Uri[] value) {
                    uploadFile.onReceiveValue(value != null && value.length > 0 ? value[0] : null);
                }
            }, acceptType);
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            String[] types = fileChooserParams.getAcceptTypes();
            String type = types.length > 0 ? types[0] : null;
            this.showFileChooser(filePathCallback, type);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showFileChooser(ValueCallback<Uri[]> filePathCallback, @Nullable String type) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"showFileChooser(): type=%s", (Object[])new Object[]{type});
            boolean launched = false;
            try {
                String extension;
                Intent intentGetContent = new Intent("android.intent.action.GET_CONTENT");
                intentGetContent.addCategory("android.intent.category.OPENABLE");
                intentGetContent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                String string2 = extension = type != null && type.startsWith(".") && type.indexOf(47) < 0 ? type.substring(1) : null;
                if (type == null) {
                    type = "*/*";
                }
                intentGetContent.setType(type);
                if (intentGetContent.resolveActivity(ProgramAndManageActivity.this.getPackageManager()) == null && extension != null && (type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)) != null) {
                    intentGetContent.setType(type);
                }
                if (intentGetContent.resolveActivity(ProgramAndManageActivity.this.getPackageManager()) == null && extension != null && (type = MimeTypesUtil.getMimeType((String)extension)) != null) {
                    intentGetContent.setType(type);
                }
                if (intentGetContent.resolveActivity(ProgramAndManageActivity.this.getPackageManager()) == null) {
                    intentGetContent.setType("image/*");
                }
                if (intentGetContent.resolveActivity(ProgramAndManageActivity.this.getPackageManager()) == null) {
                    ProgramAndManageActivity.this.showAlert(ProgramAndManageActivity.this.getString(R.string.alertMessageNoActionGetContent), null);
                    return;
                }
                LocalByRefRequestCodeHolder holder = new LocalByRefRequestCodeHolder(RequestCode.CHOOSE_FILE.ordinal(), filePathCallback);
                RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"showFileChooser(): launching get=%s", (Object[])new Object[]{intentGetContent});
                try {
                    ProgramAndManageActivity.this.startActivityForResult(intentGetContent, holder.getActualRequestCode());
                    launched = true;
                }
                catch (ActivityNotFoundException e) {
                    RobotLog.ee((String)ProgramAndManageActivity.TAG, (Throwable)e, (String)"internal error");
                }
            }
            finally {
                if (!launched) {
                    filePathCallback.onReceiveValue(null);
                }
            }
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            URI uri = URI.create(consoleMessage.sourceId());
            RobotLog.dd((String)ProgramAndManageActivity.TAG, (String)"%s(%s,%d): %s", (Object[])new Object[]{consoleMessage.messageLevel().toString().toLowerCase(Locale.getDefault()), uri.getPath(), consoleMessage.lineNumber(), consoleMessage.message()});
            return true;
        }
    }

    protected class ProgramAndManageWebViewClient
    extends WebViewClient {
        protected ProgramAndManageWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"shouldOverrideUrlLoading() url=%s", (Object[])new Object[]{url});
            return false;
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String urlString) {
            URI url = URI.create(urlString);
            if ("/exitProgramAndManage".equals(url.getPath())) {
                RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"exiting Program & Manage");
                ProgramAndManageActivity.this.finish();
                return null;
            }
            if ("/toast".equals(url.getPath())) {
                RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"toast url=%s", (Object[])new Object[]{urlString});
                String message = ProgramAndManageActivity.this.getUrlParam(urlString, "message");
                if (message != null) {
                    AppUtil.getInstance().showToast(UILocation.ONLY_LOCAL, message);
                }
                return null;
            }
            return null;
        }
    }

    protected class ProgramAndManageDownloadListener
    extends BroadcastReceiver
    implements DownloadListener {
        protected Set<Long> outstandingDownloadIds = Collections.newSetFromMap(new ConcurrentHashMap());

        protected ProgramAndManageDownloadListener() {
        }

        public void onDownloadStart(String urlString, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            String filename = null;
            URI uri = URI.create(urlString);
            if ("/downloadFile".equals(uri.getPath()) && (filename = ProgramAndManageActivity.this.getUrlParam(urlString, "name")) != null) {
                filename = new File(filename).getName();
            }
            if (filename == null) {
                filename = URLUtil.guessFileName((String)urlString, (String)contentDisposition, (String)mimetype);
            }
            RobotLog.vv((String)ProgramAndManageActivity.TAG, (String)"onDownloadStart(url=%s disp='%s' mime='%s' length=%d) filename=%s", (Object[])new Object[]{urlString, contentDisposition, mimetype, contentLength, filename});
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)urlString));
            request.setDescription((CharSequence)ProgramAndManageActivity.this.getString(R.string.webViewDownloadRequestDescription));
            request.setTitle((CharSequence)filename);
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, filename);
            DownloadManager downloadManager = (DownloadManager)ProgramAndManageActivity.this.getSystemService("download");
            long downloadId = downloadManager.enqueue(request);
            Assert.assertFalse((downloadId == 0L ? 1 : 0) != 0);
            this.outstandingDownloadIds.add(downloadId);
            AppUtil.getInstance().showToast(UILocation.ONLY_LOCAL, ProgramAndManageActivity.this.getString(R.string.toastWebViewDownloadFile, new Object[]{filename}));
        }

        public void register() {
            ProgramAndManageActivity.this.registerReceiver(this, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
        }

        public void unregister() {
            ProgramAndManageActivity.this.unregisterReceiver(this);
        }

        public void onReceive(Context context, Intent intent) {
            long downloadId;
            if (intent.getAction().equals("android.intent.action.DOWNLOAD_COMPLETE") && this.outstandingDownloadIds.remove(downloadId = intent.getLongExtra("extra_download_id", 0L)) && this.outstandingDownloadIds.size() == 0) {
                AppUtil.getInstance().showToast(UILocation.ONLY_LOCAL, ProgramAndManageActivity.this.getString(R.string.toastWebViewDownloadsComplete));
            }
        }
    }

    protected static enum RequestCode {
        NONE,
        CHOOSE_FILE;

    }
}

