/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol;

import android.content.Context;
import androidx.annotation.Nullable;
import com.qualcomm.ftccommon.FtcEventLoop;
import com.qualcomm.ftccommon.R;
import com.qualcomm.hardware.HardwareDeviceManager;
import com.qualcomm.hardware.HardwareManualControlOpMode;
import com.qualcomm.hardware.bosch.BHI260IMU;
import com.qualcomm.hardware.lynx.LynxEmbeddedBNO055IMUNew;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.commands.core.LynxFirmwareVersionManager;
import com.qualcomm.robotcore.eventloop.EventLoopManager;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManager;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.eventloop.opmode.OpModeRegistrar;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.IMU;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManager;
import com.qualcomm.robotcore.util.Device;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.firstinspires.ftc.ftccommon.external.OnCreateEventLoop;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.DeviceNotControlHubException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.FailedToOpenHubException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.ImuNotFoundException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidDeviceIdException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.UserOpModeRunningException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.WebSocketNotAuthorizedForManualControlException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.HandleIdParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.OpenHubParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.HubAddressChangedNotification;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.HubStatusChangedNotification;
import org.firstinspires.ftc.robotcore.internal.opmode.OpModeMeta;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.FtcWebSocketMessage;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;

public class ManualControlOpMode
extends HardwareManualControlOpMode {
    public static final String MANUAL_CONTROL_OP_MODE_NAME = "$Manual$Control$";
    private static final String TAG = "ManualControl";
    @Nullable
    private static volatile EventLoopManager eventLoopManager;
    private static final Object currentOpModeLock;
    @Nullable
    private static OpModeManagerImpl opModeManager;
    @Nullable
    private static CurrentOpMode currentOpMode;
    private static final OpModeManagerNotifier.Notifications opModeListener;
    private final BlockingDeque<FutureTask<?>> taskQueue = new LinkedBlockingDeque();
    private final Map<Integer, LynxUsbDevice.SystemOperationHandle> handleIdToHandleMap = new HashMap<Integer, LynxUsbDevice.SystemOperationHandle>();
    private final List<LynxUsbDevice> usbDevices = new LinkedList<LynxUsbDevice>();
    private int nextHandleId = 0;
    private IMU controlHubImu;

    public static ManualControlOpMode getInstance() {
        return (ManualControlOpMode)HardwareManualControlOpMode.getInstance();
    }

    @OpModeRegistrar
    public static void register(OpModeManager opModeManager) {
        opModeManager.register(new OpModeMeta.Builder().setFlavor(OpModeMeta.Flavor.SYSTEM).setName(MANUAL_CONTROL_OP_MODE_NAME).setSystemOpModeBaseDisplayName(AppUtil.getDefContext().getString(R.string.manual_control_op_mode_display_name)).build(), ManualControlOpMode.class);
    }

    public static void setEventLoopManager(@Nullable EventLoopManager eventLoopManager) {
        ManualControlOpMode.eventLoopManager = eventLoopManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnCreateEventLoop
    public static void updateOpModeManager(Context context, FtcEventLoop eventLoop) {
        Object object = currentOpModeLock;
        synchronized (object) {
            opModeManager = eventLoop.getOpModeManager();
            ManualControlOpMode.updateCurrentOpMode(opModeManager.registerListener(opModeListener));
            currentOpModeLock.notifyAll();
        }
    }

    private static void updateCurrentOpMode(@Nullable OpMode opMode) {
        currentOpMode = opMode == null ? CurrentOpMode.DEFAULT : (opMode instanceof OpModeManagerImpl.DefaultOpMode ? CurrentOpMode.DEFAULT : (opMode instanceof ManualControlOpMode ? CurrentOpMode.PENDING : CurrentOpMode.OTHER));
    }

    public static void startOpModeAndWait() throws UserOpModeRunningException, InterruptedException {
        Object object = currentOpModeLock;
        synchronized (object) {
            while (opModeManager == null) {
                currentOpModeLock.wait();
            }
            while (currentOpMode == CurrentOpMode.PENDING) {
                currentOpModeLock.wait();
            }
            if (currentOpMode == CurrentOpMode.MANUAL_CONTROL) {
                return;
            }
            while (currentOpMode == CurrentOpMode.DEFAULT) {
                opModeManager.initOpMode(MANUAL_CONTROL_OP_MODE_NAME, true);
                currentOpMode = CurrentOpMode.PENDING;
                while (currentOpMode == CurrentOpMode.PENDING) {
                    currentOpModeLock.wait();
                }
            }
            if (currentOpMode == CurrentOpMode.OTHER) {
                throw new UserOpModeRunningException();
            }
            if (currentOpMode == CurrentOpMode.MANUAL_CONTROL) {
                return;
            }
            throw new RuntimeException("Unexpected currentOpMode state " + (Object)((Object)currentOpMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning() {
        try {
            Object object = currentOpModeLock;
            synchronized (object) {
                while (currentOpMode == CurrentOpMode.PENDING) {
                    currentOpModeLock.wait();
                }
                return currentOpMode == CurrentOpMode.MANUAL_CONTROL;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public ManualControlOpMode() {
        HardwareManualControlOpMode.setInstance((HardwareManualControlOpMode)this);
    }

    public void initializeImu(IMU.Parameters parameters) throws ImuNotFoundException, DeviceNotControlHubException {
        LynxModule controlHub = (LynxModule)EmbeddedControlHubModule.get();
        if (!Device.isRevControlHub()) {
            throw new DeviceNotControlHubException();
        }
        if (controlHub == null) {
            throw new RuntimeException("Unable to access the Control Hub's internal module");
        }
        LynxI2cDeviceSynch i2cDevice = LynxFirmwareVersionManager.createLynxI2cDeviceSynch((Context)AppUtil.getDefContext(), (LynxModule)controlHub, (int)0);
        this.controlHubImu = this.createImu(controlHub, i2cDevice);
        boolean successful = this.controlHubImu.initialize(parameters);
        if (!successful) {
            this.controlHubImu = null;
            throw new ImuNotFoundException("Unable to initialize IMU");
        }
    }

    public IMU getImu() {
        return this.controlHubImu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOpMode() throws InterruptedException {
        FutureTask<?> task;
        try {
            Object object = currentOpModeLock;
            synchronized (object) {
                currentOpMode = CurrentOpMode.MANUAL_CONTROL;
                currentOpModeLock.notifyAll();
            }
            RobotLog.vv((String)TAG, (String)"Manual Control mode has started");
            this.telemetry.addData("Status", (Object)"Robot can be controlled via external software");
            this.telemetry.update();
            while (!this.isStopRequested()) {
                task = this.taskQueue.take();
                task.run();
            }
        }
        finally {
            task = currentOpModeLock;
            synchronized (task) {
                currentOpMode = CurrentOpMode.PENDING;
            }
            ManualControlWebSocketHandler handler = ManualControlWebSocketHandler.getInstance();
            if (handler != null) {
                handler.stopManualControl();
            }
            FutureTask<?> nextTask = this.taskQueue.poll();
            while (nextTask != null) {
                nextTask.cancel(false);
                nextTask = this.taskQueue.poll();
            }
            for (int handleId : this.handleIdToHandleMap.keySet()) {
                this.closeSystemOperationHandle(handleId);
            }
            this.handleIdToHandleMap.clear();
            this.controlHubImu.close();
            this.controlHubImu = null;
            for (LynxUsbDevice usbDevice : this.usbDevices) {
                usbDevice.close();
            }
        }
    }

    public <T> T runFromOpMode(Callable<T> callable) throws WebSocketCommandException {
        return this.runFromOpMode(callable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runFromOpMode(Callable<T> callable, boolean mustRunNext) throws WebSocketCommandException {
        FutureTask<T> task = new FutureTask<T>(callable);
        Object object = currentOpModeLock;
        synchronized (object) {
            if (!ManualControlOpMode.isRunning()) {
                throw new WebSocketNotAuthorizedForManualControlException();
            }
            if (mustRunNext) {
                this.taskQueue.addFirst(task);
            } else {
                this.taskQueue.addLast(task);
            }
        }
        try {
            return task.get();
        }
        catch (CancellationException e) {
            throw new WebSocketNotAuthorizedForManualControlException();
        }
        catch (ExecutionException exceptionWrapper) {
            Throwable e = exceptionWrapper.getCause();
            if (e instanceof InterruptedException) {
                throw new WebSocketNotAuthorizedForManualControlException();
            }
            if (e instanceof WebSocketCommandException) {
                throw (WebSocketCommandException)e;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int openHubAndGetHandleId(OpenHubParameters parameters) throws InterruptedException, FailedToOpenHubException, InvalidParameterException {
        SerialNumber parentSerialNumber = SerialNumber.fromString((String)parameters.getParentSerialNumber());
        try {
            LynxUsbDevice lynxUsb = LynxUsbDeviceImpl.findOrCreateAndArm((Context)AppUtil.getDefContext(), (SerialNumber)parentSerialNumber, (SyncdDevice.Manager)eventLoopManager, (RobotUsbManager)HardwareDeviceManager.createUsbManager());
            if (lynxUsb.getArmingState() != RobotArmingStateNotifier.ARMINGSTATE.ARMED) {
                lynxUsb.close();
                throw new RobotCoreException("The specified LynxUsbDevice is not armed");
            }
            this.usbDevices.add(lynxUsb);
            LynxUsbDevice.SystemOperationHandle handle = lynxUsb.keepConnectedModuleAliveForSystemOperations(parameters.getHubAddress(), parameters.getParentHubAddress());
            int handleId = this.nextHandleId++;
            this.handleIdToHandleMap.put(handleId, handle);
            return handleId;
        }
        catch (RobotCoreException | RuntimeException e) {
            String message = String.format(Locale.US, "Failed to open REV Hub. parentSerialNumber=%s address=%d", parentSerialNumber, parameters.getHubAddress());
            RobotLog.ee((String)TAG, (Throwable)e, (String)message);
            throw new FailedToOpenHubException(message);
        }
    }

    public LynxUsbDevice.SystemOperationHandle getSystemOperationHandle(HandleIdParameters parameters) throws InvalidDeviceIdException, InvalidParameterException {
        LynxUsbDevice.SystemOperationHandle handle = this.handleIdToHandleMap.get(parameters.getHandleId());
        if (handle == null) {
            throw new InvalidDeviceIdException();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSystemOperationHandle(int handleId) {
        LynxUsbDevice.SystemOperationHandle handleToClose = this.handleIdToHandleMap.get(handleId);
        if (handleToClose != null) {
            boolean threadWasInterrupted = Thread.interrupted();
            try {
                this.handleIdToHandleMap.remove(handleId);
                boolean thisWasTheOnlyHandleToThisHub = true;
                for (LynxUsbDevice.SystemOperationHandle openHandle : this.handleIdToHandleMap.values()) {
                    if (!openHandle.wrapsSameModule(handleToClose)) continue;
                    thisWasTheOnlyHandleToThisHub = false;
                    break;
                }
                if (thisWasTheOnlyHandleToThisHub) {
                    handleToClose.performSystemOperation(module -> {
                        try {
                            module.failSafe();
                        }
                        catch (LynxNackException | RobotCoreException | InterruptedException e) {
                            RobotLog.ww((String)TAG, (String)"Failed to put hub in failsafe mode");
                        }
                        module.setPattern((Collection)LynxModule.blinkerPolicy.getIdlePattern(module));
                    }, 25, TimeUnit.MILLISECONDS);
                }
            }
            catch (RobotCoreException | TimeoutException e) {
                RobotLog.ww((String)TAG, (Throwable)e, (String)"Failed to put hub in failsafe mode and restore default pattern");
            }
            catch (InterruptedException e) {
                RobotLog.ww((String)TAG, (Throwable)e, (String)"Failed to put hub in failsafe mode and restore default pattern");
                Thread.currentThread().interrupt();
            }
            finally {
                handleToClose.close();
                if (threadWasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void onLynxModuleStatusChanged(LynxModule module, int statusWord, int motorAlerts) {
        try {
            if (!ManualControlOpMode.isRunning()) {
                return;
            }
            this.runFromOpMode(() -> {
                ManualControlWebSocketHandler handler = ManualControlWebSocketHandler.getInstance();
                int[] matchingHandleIds = this.findHandleIdsMatchingLynxModule(module);
                if (handler != null && matchingHandleIds.length > 0) {
                    String namespace = "MC";
                    String payload = new HubStatusChangedNotification(statusWord, motorAlerts, matchingHandleIds).toJson();
                    handler.sendMessageToAllowedWebSocket(new FtcWebSocketMessage(namespace, "hubStatusChanged", payload));
                }
                return null;
            }, true);
        }
        catch (RuntimeException | WebSocketCommandException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Exception thrown in onLynxModuleAddressChanged()");
        }
    }

    public void onLynxModuleAddressChanged(LynxModule module, int oldAddress, int newAddress) {
        ThreadPool.getDefault().execute(() -> {
            try {
                if (!ManualControlOpMode.isRunning()) {
                    return;
                }
                this.runFromOpMode(() -> {
                    ManualControlWebSocketHandler handler = ManualControlWebSocketHandler.getInstance();
                    int[] matchingHandleIds = this.findHandleIdsMatchingLynxModule(module);
                    if (handler != null && matchingHandleIds.length > 0) {
                        String namespace = "MC";
                        String payload = new HubAddressChangedNotification(oldAddress, newAddress, matchingHandleIds).toJson();
                        handler.sendMessageToAllowedWebSocket(new FtcWebSocketMessage(namespace, "hubAddressChanged", payload));
                    }
                    return null;
                });
            }
            catch (RuntimeException | WebSocketCommandException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Exception thrown in onLynxModuleAddressChanged()");
            }
        });
    }

    private int[] findHandleIdsMatchingLynxModule(LynxModule module) {
        return this.handleIdToHandleMap.entrySet().stream().filter(entry -> ((LynxUsbDevice.SystemOperationHandle)entry.getValue()).wrapsModule(module)).mapToInt(Map.Entry::getKey).toArray();
    }

    private IMU createImu(LynxModule controlHub, LynxI2cDeviceSynch i2cDevice) throws ImuNotFoundException {
        switch (controlHub.getImuType()) {
            case BNO055: {
                return new LynxEmbeddedBNO055IMUNew((I2cDeviceSynchSimple)i2cDevice, true);
            }
            case BHI260: {
                return new BHI260IMU((I2cDeviceSynchSimple)i2cDevice, true);
            }
        }
        throw new ImuNotFoundException("Failed to communicate with BHI260 or BNO055 IMU.");
    }

    static {
        currentOpModeLock = new Object();
        currentOpMode = CurrentOpMode.DEFAULT;
        opModeListener = new OpModeManagerNotifier.Notifications(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOpModePreInit(OpMode opMode) {
                Object object = currentOpModeLock;
                synchronized (object) {
                    ManualControlOpMode.updateCurrentOpMode(opMode);
                    currentOpModeLock.notifyAll();
                }
            }

            public void onOpModePreStart(OpMode opMode) {
            }

            public void onOpModePostStop(OpMode opMode) {
            }
        };
    }

    private static enum CurrentOpMode {
        PENDING,
        DEFAULT,
        MANUAL_CONTROL,
        OTHER;

    }
}

