/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands;

import androidx.annotation.NonNull;
import com.qualcomm.hardware.rev.RevHubOrientationOnRobot;
import com.qualcomm.robotcore.hardware.IMU;
import com.qualcomm.robotcore.hardware.ImuOrientationOnRobot;
import java.util.Map;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlOpMode;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.GetImuVelocityParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.ImuParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.ImuAngularVelocityResponse;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.ImuQuaternionResponse;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;

public class ImuCommands {
    public static void register(Map<String, WebSocketMessageTypeHandler> handlerMap, ManualControlWebSocketHandler handler) {
        handlerMap.put("initializeImu", (WebSocketMessageTypeHandler)new InitializeImuCommand(handler));
        handlerMap.put("getImuQuaternion", (WebSocketMessageTypeHandler)new GetImuQuaternionCommand(handler));
        handlerMap.put("getImuAngularVelocity", (WebSocketMessageTypeHandler)new GetImuAngularVelocityCommand(handler));
    }

    public static class InitializeImuCommand
    extends ManualControlCommandHandler<ImuParameters, Void> {
        public InitializeImuCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<ImuParameters> getPayloadClass() {
            return ImuParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void handleManualControlCommand(ImuParameters parameters) throws WebSocketCommandException {
            RevHubOrientationOnRobot orientationOnRobot = parameters.getOrientation();
            ManualControlOpMode.getInstance().initializeImu(new IMU.Parameters((ImuOrientationOnRobot)orientationOnRobot));
            return null;
        }
    }

    public static class GetImuQuaternionCommand
    extends ManualControlCommandHandler<GetImuVelocityParameters, ImuQuaternionResponse> {
        public GetImuQuaternionCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<GetImuVelocityParameters> getPayloadClass() {
            return GetImuVelocityParameters.class;
        }

        @NonNull
        protected Class<ImuQuaternionResponse> getResultClass() {
            return ImuQuaternionResponse.class;
        }

        @Override
        public ImuQuaternionResponse handleManualControlCommand(GetImuVelocityParameters parameters) throws WebSocketCommandException {
            IMU imu = ManualControlOpMode.getInstance().getImu();
            Quaternion quaternion = imu.getRobotOrientationAsQuaternion();
            return new ImuQuaternionResponse(quaternion.w, quaternion.x, quaternion.y, quaternion.z);
        }
    }

    public static class GetImuAngularVelocityCommand
    extends ManualControlCommandHandler<GetImuVelocityParameters, ImuAngularVelocityResponse> {
        public GetImuAngularVelocityCommand(ManualControlWebSocketHandler manualControlWebSocketHandler) {
            super(manualControlWebSocketHandler);
        }

        @NonNull
        protected Class<GetImuVelocityParameters> getPayloadClass() {
            return GetImuVelocityParameters.class;
        }

        @NonNull
        protected Class<ImuAngularVelocityResponse> getResultClass() {
            return ImuAngularVelocityResponse.class;
        }

        @Override
        public ImuAngularVelocityResponse handleManualControlCommand(GetImuVelocityParameters parameters) throws WebSocketCommandException {
            IMU imu = ManualControlOpMode.getInstance().getImu();
            AngularVelocity velocity = imu.getRobotAngularVelocity(parameters.getUnit());
            return new ImuAngularVelocityResponse(velocity.xRotationRate, velocity.yRotationRate, velocity.zRotationRate);
        }
    }
}

