/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol.commands;

import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelCurrentAlertLevelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelCurrentAlertLevelResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelEnableResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelModeCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorChannelModeResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorConstantPowerCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorConstantPowerResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorEncoderPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorEncoderPositionResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDControlLoopCoefficientsResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDFControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorPIDFControlLoopCoefficientsResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetPositionResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetVelocityCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetMotorTargetVelocityResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxIsMotorAtTargetCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxIsMotorAtTargetResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxResetMotorEncoderCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelCurrentAlertLevelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelEnableCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorChannelModeCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorConstantPowerCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorPIDControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorPIDFControlLoopCoefficientsCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorTargetPositionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetMotorTargetVelocityCommand;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.Map;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlDeviceCommandHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.ManualControlWebSocketHandler;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorAlertLevelParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorChannelParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorConstantPowerParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorModeParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorPidCoefficientsParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorPidfCoefficientsParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorTargetPositionParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.MotorTargetVelocityParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.SetMotorEnableParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters.SetMotorModeParameters;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.ClosedLoopControlCoefficients;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.MotorModeResponse;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.responses.MotorTargetPosition;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketCommandException;
import org.firstinspires.ftc.robotcore.internal.webserver.websockets.WebSocketMessageTypeHandler;

public class MotorCommands {
    public static void register(Map<String, WebSocketMessageTypeHandler> handlerMap, ManualControlWebSocketHandler handler) {
        handlerMap.put("setMotorMode", (WebSocketMessageTypeHandler)new SetMotorModeCommand(handler));
        handlerMap.put("getMotorMode", (WebSocketMessageTypeHandler)new GetMotorModeCommand(handler));
        handlerMap.put("setMotorEnabled", (WebSocketMessageTypeHandler)new SetMotorEnabledCommand(handler));
        handlerMap.put("getMotorEnable", (WebSocketMessageTypeHandler)new GetMotorEnableCommand(handler));
        handlerMap.put("setMotorAlertLevel", (WebSocketMessageTypeHandler)new SetMotorAlertLevelCommand(handler));
        handlerMap.put("getMotorAlertLevel", (WebSocketMessageTypeHandler)new GetMotorAlertLevelCommand(handler));
        handlerMap.put("resetMotorEncoder", (WebSocketMessageTypeHandler)new ResetMotorEncoderCommand(handler));
        handlerMap.put("setMotorConstantPower", (WebSocketMessageTypeHandler)new SetMotorConstantPowerCommand(handler));
        handlerMap.put("getMotorConstantPower", (WebSocketMessageTypeHandler)new GetMotorConstantPowerCommand(handler));
        handlerMap.put("setMotorTargetVelocity", (WebSocketMessageTypeHandler)new SetMotorTargetVelocityCommand(handler));
        handlerMap.put("getMotorTargetVelocity", (WebSocketMessageTypeHandler)new GetMotorTargetVelocityCommand(handler));
        handlerMap.put("setMotorTargetPosition", (WebSocketMessageTypeHandler)new SetMotorTargetPositionCommand(handler));
        handlerMap.put("getMotorTargetPosition", (WebSocketMessageTypeHandler)new GetMotorTargetPositionCommand(handler));
        handlerMap.put("getMotorEncoder", (WebSocketMessageTypeHandler)new GetMotorEncoderCommand(handler));
        handlerMap.put("getIsMotorAtTarget", (WebSocketMessageTypeHandler)new GetIsMotorAtTargetCommand(handler));
        handlerMap.put("setMotorPidCoefficients", (WebSocketMessageTypeHandler)new SetMotorPidCoefficientsCommand(handler));
        handlerMap.put("getMotorClosedLoopControlCoefficients", (WebSocketMessageTypeHandler)new GetMotorClosedLoopControlCoefficientsCommand(handler));
        handlerMap.put("setMotorPidfCoefficients", (WebSocketMessageTypeHandler)new SetMotorPidfCoefficientsCommand(handler));
    }

    private static class SetMotorModeCommand
    extends ManualControlDeviceCommandHandler<SetMotorModeParameters, Void> {
        public SetMotorModeCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<SetMotorModeParameters> getPayloadClass() {
            return SetMotorModeParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, SetMotorModeParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorChannelModeCommand command = new LynxSetMotorChannelModeCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getMotorMode(), params.getZeroPowerBehavior());
            command.send();
            return null;
        }
    }

    private static class GetMotorModeCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, MotorModeResponse> {
        public GetMotorModeCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<MotorModeResponse> getResultClass() {
            return MotorModeResponse.class;
        }

        @Override
        public MotorModeResponse performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorChannelModeCommand command = new LynxGetMotorChannelModeCommand((LynxModuleIntf)module, params.getMotorChannel());
            LynxGetMotorChannelModeResponse response = (LynxGetMotorChannelModeResponse)command.sendReceive();
            byte motorMode = LynxConstants.runModeToLynxMotorMode((DcMotor.RunMode)response.getMode());
            return new MotorModeResponse(motorMode, response.getZeroPowerBehavior() == DcMotor.ZeroPowerBehavior.FLOAT);
        }
    }

    private static class SetMotorEnabledCommand
    extends ManualControlDeviceCommandHandler<SetMotorEnableParameters, Void> {
        public SetMotorEnabledCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<SetMotorEnableParameters> getPayloadClass() {
            return SetMotorEnableParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, SetMotorEnableParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorChannelEnableCommand command = new LynxSetMotorChannelEnableCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getEnable());
            command.send();
            return null;
        }
    }

    private static class GetMotorEnableCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Boolean> {
        public GetMotorEnableCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Boolean> getResultClass() {
            return Boolean.class;
        }

        @Override
        public Boolean performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorChannelEnableCommand command = new LynxGetMotorChannelEnableCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxGetMotorChannelEnableResponse)command.sendReceive()).isEnabled();
        }
    }

    private static class SetMotorAlertLevelCommand
    extends ManualControlDeviceCommandHandler<MotorAlertLevelParameters, Void> {
        public SetMotorAlertLevelCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorAlertLevelParameters> getPayloadClass() {
            return MotorAlertLevelParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorAlertLevelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorChannelCurrentAlertLevelCommand command = new LynxSetMotorChannelCurrentAlertLevelCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getCurrentLimit_mA());
            command.send();
            return null;
        }
    }

    private static class GetMotorAlertLevelCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Integer> {
        public GetMotorAlertLevelCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorChannelCurrentAlertLevelCommand command = new LynxGetMotorChannelCurrentAlertLevelCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxGetMotorChannelCurrentAlertLevelResponse)command.sendReceive()).getCurrentLimit();
        }
    }

    private static class ResetMotorEncoderCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Void> {
        public ResetMotorEncoderCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxResetMotorEncoderCommand command = new LynxResetMotorEncoderCommand((LynxModuleIntf)module, params.getMotorChannel());
            command.send();
            return null;
        }
    }

    private static class SetMotorConstantPowerCommand
    extends ManualControlDeviceCommandHandler<MotorConstantPowerParameters, Void> {
        public SetMotorConstantPowerCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorConstantPowerParameters> getPayloadClass() {
            return MotorConstantPowerParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorConstantPowerParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            int power = (int)(params.getMotorPower() * 32767.0);
            LynxSetMotorConstantPowerCommand command = new LynxSetMotorConstantPowerCommand((LynxModuleIntf)module, params.getMotorChannel(), power);
            command.send();
            return null;
        }
    }

    private static class GetMotorConstantPowerCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Integer> {
        public GetMotorConstantPowerCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorConstantPowerCommand command = new LynxGetMotorConstantPowerCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxGetMotorConstantPowerResponse)command.sendReceive()).getPower() / Short.MAX_VALUE;
        }
    }

    private static class SetMotorTargetVelocityCommand
    extends ManualControlDeviceCommandHandler<MotorTargetVelocityParameters, Void> {
        public SetMotorTargetVelocityCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorTargetVelocityParameters> getPayloadClass() {
            return MotorTargetVelocityParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorTargetVelocityParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorTargetVelocityCommand command = new LynxSetMotorTargetVelocityCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getTargetVelocityCountsPerSecond());
            command.send();
            return null;
        }
    }

    private static class GetMotorTargetVelocityCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Integer> {
        public GetMotorTargetVelocityCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws WebSocketCommandException, LynxNackException, InterruptedException {
            LynxGetMotorTargetVelocityCommand command = new LynxGetMotorTargetVelocityCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxGetMotorTargetVelocityResponse)command.sendReceive()).getVelocity();
        }
    }

    private static class SetMotorTargetPositionCommand
    extends ManualControlDeviceCommandHandler<MotorTargetPositionParameters, Void> {
        public SetMotorTargetPositionCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorTargetPositionParameters> getPayloadClass() {
            return MotorTargetPositionParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorTargetPositionParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorTargetPositionCommand command = new LynxSetMotorTargetPositionCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getTargetPositionCounts(), params.getTargetToleranceCounts());
            command.send();
            return null;
        }
    }

    private static class GetMotorTargetPositionCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, MotorTargetPosition> {
        public GetMotorTargetPositionCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<MotorTargetPosition> getResultClass() {
            return MotorTargetPosition.class;
        }

        @Override
        public MotorTargetPosition performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorTargetPositionCommand command = new LynxGetMotorTargetPositionCommand((LynxModuleIntf)module, params.getMotorChannel());
            LynxGetMotorTargetPositionResponse response = (LynxGetMotorTargetPositionResponse)command.sendReceive();
            return new MotorTargetPosition(response.getTarget(), response.getTolerance());
        }
    }

    private static class GetMotorEncoderCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Integer> {
        public GetMotorEncoderCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Integer> getResultClass() {
            return Integer.class;
        }

        @Override
        public Integer performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxGetMotorEncoderPositionCommand command = new LynxGetMotorEncoderPositionCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxGetMotorEncoderPositionResponse)command.sendReceive()).getPosition();
        }
    }

    private static class GetIsMotorAtTargetCommand
    extends ManualControlDeviceCommandHandler<MotorChannelParameters, Boolean> {
        public GetIsMotorAtTargetCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorChannelParameters> getPayloadClass() {
            return MotorChannelParameters.class;
        }

        @NonNull
        protected Class<Boolean> getResultClass() {
            return Boolean.class;
        }

        @Override
        public Boolean performOperationOnDevice(LynxModule module, MotorChannelParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxIsMotorAtTargetCommand command = new LynxIsMotorAtTargetCommand((LynxModuleIntf)module, params.getMotorChannel());
            return ((LynxIsMotorAtTargetResponse)command.sendReceive()).isAtTarget();
        }
    }

    private static class SetMotorPidCoefficientsCommand
    extends ManualControlDeviceCommandHandler<MotorPidCoefficientsParameters, Void> {
        public SetMotorPidCoefficientsCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorPidCoefficientsParameters> getPayloadClass() {
            return MotorPidCoefficientsParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorPidCoefficientsParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorPIDControlLoopCoefficientsCommand command = new LynxSetMotorPIDControlLoopCoefficientsCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getMotorMode(), params.getInternalP(), params.getInternalI(), params.getInternalD());
            command.send();
            RobotLog.dd((String)TAG, (String)"Set Motor PID Coefficients");
            return null;
        }
    }

    private static class GetMotorClosedLoopControlCoefficientsCommand
    extends ManualControlDeviceCommandHandler<MotorModeParameters, ClosedLoopControlCoefficients> {
        public GetMotorClosedLoopControlCoefficientsCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorModeParameters> getPayloadClass() {
            return MotorModeParameters.class;
        }

        @NonNull
        protected Class<ClosedLoopControlCoefficients> getResultClass() {
            return ClosedLoopControlCoefficients.class;
        }

        @Override
        public ClosedLoopControlCoefficients performOperationOnDevice(LynxModule module, MotorModeParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            if (module.isCommandSupported(LynxGetMotorPIDFControlLoopCoefficientsCommand.class)) {
                LynxGetMotorPIDFControlLoopCoefficientsCommand command = new LynxGetMotorPIDFControlLoopCoefficientsCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getMotorMode());
                LynxGetMotorPIDFControlLoopCoefficientsResponse response = (LynxGetMotorPIDFControlLoopCoefficientsResponse)command.sendReceive();
                return new ClosedLoopControlCoefficients(response.getP(), response.getI(), response.getD(), response.getF(), response.getInternalMotorControlAlgorithm().getValue());
            }
            LynxGetMotorPIDControlLoopCoefficientsCommand command = new LynxGetMotorPIDControlLoopCoefficientsCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getMotorMode());
            LynxGetMotorPIDControlLoopCoefficientsResponse response = (LynxGetMotorPIDControlLoopCoefficientsResponse)command.sendReceive();
            return new ClosedLoopControlCoefficients(response.getP(), response.getI(), response.getD(), 0, LynxSetMotorPIDFControlLoopCoefficientsCommand.InternalMotorControlAlgorithm.LegacyPID.getValue());
        }
    }

    private static class SetMotorPidfCoefficientsCommand
    extends ManualControlDeviceCommandHandler<MotorPidfCoefficientsParameters, Void> {
        public SetMotorPidfCoefficientsCommand(ManualControlWebSocketHandler handler) {
            super(handler);
        }

        @NonNull
        protected Class<MotorPidfCoefficientsParameters> getPayloadClass() {
            return MotorPidfCoefficientsParameters.class;
        }

        @NonNull
        protected Class<Void> getResultClass() {
            return Void.class;
        }

        @Override
        public Void performOperationOnDevice(LynxModule module, MotorPidfCoefficientsParameters params) throws InvalidParameterException, LynxNackException, InterruptedException {
            LynxSetMotorPIDFControlLoopCoefficientsCommand command = new LynxSetMotorPIDFControlLoopCoefficientsCommand((LynxModuleIntf)module, params.getMotorChannel(), params.getMotorMode(), params.getInternalP(), params.getInternalI(), params.getInternalD(), params.getInternalF(), LynxSetMotorPIDFControlLoopCoefficientsCommand.InternalMotorControlAlgorithm.PIDF);
            command.send();
            RobotLog.dd((String)TAG, (String)"Set Motor PIDF Coefficients");
            return null;
        }
    }
}

