/*
 * Decompiled with CFR 0.152.
 */
package org.firstinspires.ftc.ftccommon.internal.manualcontrol.parameters;

import androidx.annotation.Nullable;
import com.qualcomm.hardware.rev.RevHubOrientationOnRobot;
import java.util.Arrays;
import java.util.Optional;
import org.firstinspires.ftc.ftccommon.internal.manualcontrol.exceptions.InvalidParameterException;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;

public class ImuParameters {
    @Nullable
    private Float w;
    @Nullable
    private Float x;
    @Nullable
    private Float y;
    @Nullable
    private Float z;
    @Nullable
    private String logoFacing;
    @Nullable
    private String usbFacing;

    public RevHubOrientationOnRobot getOrientation() throws InvalidParameterException {
        if (this.w != null && this.x != null & this.y != null && this.z != null) {
            return new RevHubOrientationOnRobot(new Quaternion(this.w.floatValue(), this.x.floatValue(), this.y.floatValue(), this.z.floatValue(), 0L));
        }
        if (this.logoFacing != null && this.usbFacing != null) {
            return new RevHubOrientationOnRobot(this.getLogoDirection(this.logoFacing), this.getUsbDirection(this.usbFacing));
        }
        return new RevHubOrientationOnRobot(RevHubOrientationOnRobot.LogoFacingDirection.UP, RevHubOrientationOnRobot.UsbFacingDirection.FORWARD);
    }

    private RevHubOrientationOnRobot.LogoFacingDirection getLogoDirection(String s) throws InvalidParameterException {
        Optional<RevHubOrientationOnRobot.LogoFacingDirection> direction = Arrays.stream(RevHubOrientationOnRobot.LogoFacingDirection.values()).filter(d -> d.name().equalsIgnoreCase(s)).findFirst();
        if (!direction.isPresent()) {
            throw new InvalidParameterException(s + " is not a valid Logo Direction");
        }
        return direction.get();
    }

    private RevHubOrientationOnRobot.UsbFacingDirection getUsbDirection(String s) throws InvalidParameterException {
        Optional<RevHubOrientationOnRobot.UsbFacingDirection> direction = Arrays.stream(RevHubOrientationOnRobot.UsbFacingDirection.values()).filter(d -> d.name().equalsIgnoreCase(s)).findFirst();
        if (!direction.isPresent()) {
            throw new InvalidParameterException(s + " is not a valid Logo Direction");
        }
        return direction.get();
    }
}

