/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.adafruit.AdafruitI2cColorSensor;
import com.qualcomm.hardware.limelightvision.Limelight3A;
import com.qualcomm.hardware.lynx.LynxI2cColorRangeSensor;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.commands.core.LynxFirmwareVersionManager;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cColorSensor;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cGyro;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsI2cIrSeekerSensorV3;
import com.qualcomm.hardware.modernrobotics.ModernRoboticsTouchSensor;
import com.qualcomm.hardware.modernrobotics.comm.ModernRoboticsUsbUtil;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.CRServo;
import com.qualcomm.robotcore.hardware.CRServoImplEx;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.DcMotorImpl;
import com.qualcomm.robotcore.hardware.DcMotorImplEx;
import com.qualcomm.robotcore.hardware.DcMotorSimple;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.GyroSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchImplOnSimple;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.IrSeekerSensor;
import com.qualcomm.robotcore.hardware.LED;
import com.qualcomm.robotcore.hardware.PWMOutput;
import com.qualcomm.robotcore.hardware.PWMOutputController;
import com.qualcomm.robotcore.hardware.PWMOutputImpl;
import com.qualcomm.robotcore.hardware.RobotCoreLynxModule;
import com.qualcomm.robotcore.hardware.RobotCoreLynxUsbDevice;
import com.qualcomm.robotcore.hardware.ScannedDevices;
import com.qualcomm.robotcore.hardware.Servo;
import com.qualcomm.robotcore.hardware.ServoControllerEx;
import com.qualcomm.robotcore.hardware.ServoImplEx;
import com.qualcomm.robotcore.hardware.TouchSensor;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.AnalogSensorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.DigitalIoDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.I2cDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.MotorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.ServoConfigurationType;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDeviceImplBase;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManager;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManagerCombining;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.hardware.usb.ftdi.RobotUsbManagerFtdi;
import com.qualcomm.robotcore.hardware.usb.serial.RobotUsbManagerTty;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraManager;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.firstinspires.ftc.robotcore.internal.camera.CameraManagerInternal;
import org.firstinspires.ftc.robotcore.internal.hardware.UserNameable;
import org.firstinspires.ftc.robotcore.internal.hardware.usb.ArmableUsbDevice;
import org.firstinspires.ftc.robotcore.internal.usb.EthernetOverUsbSerialNumber;
import org.firstinspires.ftc.robotcore.internal.usb.VendorProductSerialNumber;

public class HardwareDeviceManager
implements DeviceManager {
    public static final String TAG = "HardwareDeviceManager";
    public static final String TAG_USB_SCAN = "USBScan";
    public static final Object scanDevicesLock = new Object();
    private RobotUsbManager usbManager;
    private final SyncdDevice.Manager manager;
    private final Context context;

    public HardwareDeviceManager(Context context, SyncdDevice.Manager manager) {
        this.context = context;
        this.manager = manager;
        this.usbManager = HardwareDeviceManager.createUsbManager();
    }

    public static RobotUsbManager createUsbManager() {
        RobotUsbManagerFtdi usbManager = new RobotUsbManagerFtdi();
        if (LynxConstants.isRevControlHub()) {
            RobotUsbManagerCombining combiner = new RobotUsbManagerCombining();
            combiner.addManager((RobotUsbManager)usbManager);
            combiner.addManager((RobotUsbManager)new RobotUsbManagerTty());
            usbManager = combiner;
        }
        return usbManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannedDevices scanForUsbDevices() throws RobotCoreException {
        Object object = scanDevicesLock;
        synchronized (object) {
            long start = System.nanoTime();
            ScannedDevices deviceMap = new ScannedDevices();
            List serialNumbers = this.usbManager.scanForDevices();
            int devCount = serialNumbers.size();
            RobotLog.vv((String)TAG_USB_SCAN, (String)"device count=%d", (Object[])new Object[]{devCount});
            if (devCount > 0) {
                ExecutorService executorService = ThreadPool.newFixedThreadPool((int)devCount, (String)"hw mgr usb scan");
                final ConcurrentHashMap newlyFoundDevices = new ConcurrentHashMap();
                try {
                    for (final SerialNumber serialNumber : serialNumbers) {
                        executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RobotLog.vv((String)HardwareDeviceManager.TAG_USB_SCAN, (String)"opening %s...", (Object[])new Object[]{serialNumber});
                                    RobotUsbDevice device = ModernRoboticsUsbUtil.openRobotUsbDevice(false, HardwareDeviceManager.this.usbManager, serialNumber);
                                    newlyFoundDevices.put(serialNumber, device);
                                }
                                catch (Exception e) {
                                    try {
                                        RobotLog.vv((String)HardwareDeviceManager.TAG_USB_SCAN, (String)"%s(%s) exception while opening %s", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage(), serialNumber});
                                    }
                                    catch (Throwable throwable) {
                                        RobotLog.vv((String)HardwareDeviceManager.TAG_USB_SCAN, (String)"... done opening %s", (Object[])new Object[]{serialNumber});
                                        throw throwable;
                                    }
                                    RobotLog.vv((String)HardwareDeviceManager.TAG_USB_SCAN, (String)"... done opening %s", (Object[])new Object[]{serialNumber});
                                }
                                RobotLog.vv((String)HardwareDeviceManager.TAG_USB_SCAN, (String)"... done opening %s", (Object[])new Object[]{serialNumber});
                            }
                        });
                    }
                    executorService.shutdown();
                    ThreadPool.awaitTerminationOrExitApplication((ExecutorService)executorService, (long)30L, (TimeUnit)TimeUnit.SECONDS, (String)"USB Scanning Service", (String)"internal error");
                    for (Map.Entry entry : newlyFoundDevices.entrySet()) {
                        this.determineDeviceType((RobotUsbDevice)entry.getValue(), (SerialNumber)entry.getKey(), deviceMap);
                    }
                    for (RobotUsbDevice robotUsbDevice : RobotUsbDeviceImplBase.getExtantDevices()) {
                        DeviceManager.UsbDeviceType deviceType;
                        SerialNumber serialNumber = robotUsbDevice.getSerialNumber();
                        if (newlyFoundDevices.containsKey(serialNumber) || (deviceType = robotUsbDevice.getDeviceType()) == DeviceManager.UsbDeviceType.FTDI_USB_UNKNOWN_DEVICE) continue;
                        RobotLog.vv((String)TAG_USB_SCAN, (String)"added extant device %s type=%s", (Object[])new Object[]{serialNumber, deviceType.toString()});
                        deviceMap.put(serialNumber, deviceType);
                    }
                }
                catch (Throwable throwable) {
                    for (Map.Entry pair : newlyFoundDevices.entrySet()) {
                        RobotLog.vv((String)TAG_USB_SCAN, (String)"closing %s", (Object[])new Object[]{pair.getKey()});
                        ((RobotUsbDevice)pair.getValue()).close();
                    }
                    throw throwable;
                }
                for (Map.Entry entry : newlyFoundDevices.entrySet()) {
                    RobotLog.vv((String)TAG_USB_SCAN, (String)"closing %s", (Object[])new Object[]{entry.getKey()});
                    ((RobotUsbDevice)entry.getValue()).close();
                }
            }
            this.scanForWebcams(deviceMap);
            this.scanForEthernetOverUsbDevices(deviceMap);
            long end = System.nanoTime();
            RobotLog.vv((String)TAG_USB_SCAN, (String)"scanForUsbDevices() took %dms count=%d", (Object[])new Object[]{(int)((end - start) / 1000000L), deviceMap.size()});
            return deviceMap;
        }
    }

    Integer countVidPid(Map<Pair<Integer, Integer>, Integer> map, VendorProductSerialNumber vendorProduct) {
        Pair pair = new Pair((Object)vendorProduct.getVendorId(), (Object)vendorProduct.getProductId());
        Integer count = map.get(pair);
        if (count != null) {
            return count;
        }
        return 0;
    }

    void addVidPid(Map<Pair<Integer, Integer>, Integer> map, VendorProductSerialNumber vendorProduct, int delta) {
        int count = this.countVidPid(map, vendorProduct);
        Pair pair = new Pair((Object)vendorProduct.getVendorId(), (Object)vendorProduct.getProductId());
        map.put((Pair<Integer, Integer>)pair, count + delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanForEthernetOverUsbDevices(ScannedDevices scannedDevices) {
        Object object = scanDevicesLock;
        synchronized (object) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    if (!networkInterface.getName().startsWith("eth")) continue;
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.getAddress().length != 4) continue;
                        RobotLog.dd((String)TAG, (String)("IP Address: " + address.getHostAddress()));
                        scannedDevices.put((SerialNumber)EthernetOverUsbSerialNumber.fromIpAddress((String)address.getHostAddress(), (String)networkInterface.getName()), DeviceManager.UsbDeviceType.ETHERNET_DEVICE);
                    }
                }
            }
            catch (SocketException e) {
                RobotLog.e((String)TAG, (Object[])new Object[]{"Error getting network interfaces", e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanForWebcams(ScannedDevices scannedDevices) {
        Object object = scanDevicesLock;
        synchronized (object) {
            VendorProductSerialNumber vendorProduct;
            SerialNumber serialNumber;
            CameraManager cameraManager = ClassFactory.getInstance().getCameraManager();
            List webcams = cameraManager.getAllWebcams();
            HashMap<Pair<Integer, Integer>, Integer> vidpidConnections = new HashMap<Pair<Integer, Integer>, Integer>();
            HashMap<Pair<Integer, Integer>, Integer> vidpidConnectionless = new HashMap<Pair<Integer, Integer>, Integer>();
            for (WebcamName webcamName : webcams) {
                serialNumber = webcamName.getSerialNumber();
                if (!serialNumber.isVendorProduct()) continue;
                vendorProduct = (VendorProductSerialNumber)serialNumber;
                if (TextUtils.isEmpty((CharSequence)vendorProduct.getConnectionPath())) {
                    this.addVidPid(vidpidConnectionless, vendorProduct, 1);
                    continue;
                }
                this.addVidPid(vidpidConnections, vendorProduct, 1);
            }
            for (WebcamName webcamName : webcams) {
                serialNumber = webcamName.getSerialNumber();
                if (serialNumber.isVendorProduct()) {
                    vendorProduct = (VendorProductSerialNumber)serialNumber;
                    int count = this.countVidPid(vidpidConnectionless, vendorProduct);
                    if (count > 1) {
                        RobotLog.ee((String)TAG, (String)"%d serialnumless webcams w/o connection info; ignoring", (Object[])new Object[]{count, vendorProduct});
                        continue;
                    }
                    if (this.countVidPid(vidpidConnectionless, vendorProduct) == 0 && this.countVidPid(vidpidConnections, vendorProduct) == 1) {
                        serialNumber = SerialNumber.fromVidPid((int)vendorProduct.getVendorId(), (int)vendorProduct.getProductId(), (String)"");
                    }
                }
                RobotLog.vv((String)TAG, (String)"scanned webcam serial=%s", (Object[])new Object[]{serialNumber});
                scannedDevices.put(serialNumber, DeviceManager.UsbDeviceType.WEBCAM);
            }
        }
    }

    void determineDeviceType(RobotUsbDevice dev, SerialNumber serialNumber, ScannedDevices deviceMap) {
        DeviceManager.UsbDeviceType usbDeviceType = RobotUsbDeviceImplBase.getDeviceType((SerialNumber)serialNumber);
        if (usbDeviceType == DeviceManager.UsbDeviceType.UNKNOWN_DEVICE) {
            RobotUsbDevice.USBIdentifiers ids = dev.getUsbIdentifiers();
            if (ids.isLynxDevice()) {
                RobotLog.vv((String)TAG_USB_SCAN, (String)"%s is a lynx device", (Object[])new Object[]{serialNumber});
                usbDeviceType = this.getLynxDeviceType(dev);
            } else {
                return;
            }
        }
        deviceMap.put(serialNumber, usbDeviceType);
    }

    DeviceManager.UsbDeviceType getLynxDeviceType(RobotUsbDevice dev) {
        DeviceManager.UsbDeviceType usbDeviceType = DeviceManager.UsbDeviceType.LYNX_USB_DEVICE;
        dev.setDeviceType(usbDeviceType);
        return usbDeviceType;
    }

    public RobotCoreLynxUsbDevice createLynxUsbDevice(SerialNumber serialNumber, @Nullable String name) throws RobotCoreException, InterruptedException {
        HardwareFactory.noteSerialNumberType(this.context, serialNumber, this.context.getString(R.string.moduleDisplayNameLynxUsbDevice));
        RobotLog.v((String)"Creating %s", (Object[])new Object[]{HardwareFactory.getDeviceDisplayName(this.context, serialNumber)});
        return LynxUsbDeviceImpl.findOrCreateAndArm(this.context, serialNumber, this.manager, this.usbManager);
    }

    public DcMotor createDcMotor(DcMotorController controller, int portNumber, @NonNull MotorConfigurationType motorType, String name) {
        return new DcMotorImpl(controller, portNumber, DcMotorSimple.Direction.FORWARD, motorType);
    }

    public DcMotor createDcMotorEx(DcMotorController controller, int portNumber, @NonNull MotorConfigurationType motorType, String name) {
        return new DcMotorImplEx(controller, portNumber, DcMotorSimple.Direction.FORWARD, motorType);
    }

    public Servo createServoEx(ServoControllerEx controller, int portNumber, String name, ServoConfigurationType servoType) {
        return new ServoImplEx(controller, portNumber, Servo.Direction.FORWARD, servoType);
    }

    public CRServo createCRServoEx(ServoControllerEx controller, int portNumber, String name, ServoConfigurationType servoType) {
        return new CRServoImplEx(controller, portNumber, DcMotorSimple.Direction.FORWARD, servoType);
    }

    public List<HardwareDevice> createCustomServoDeviceInstances(ServoControllerEx controller, int portNumber, ServoConfigurationType servoConfigurationType) {
        return servoConfigurationType.createInstances(controller, portNumber);
    }

    @Nullable
    public WebcamName createWebcamName(final SerialNumber serialNumber, String name) throws RobotCoreException, InterruptedException {
        HardwareFactory.noteSerialNumberType(this.context, serialNumber, this.context.getString(R.string.moduleDisplayNameWebcam));
        RobotLog.v((String)"Creating %s", (Object[])new Object[]{HardwareFactory.getDeviceDisplayName(this.context, serialNumber)});
        ArmableUsbDevice.OpenRobotUsbDevice openWebcam = new ArmableUsbDevice.OpenRobotUsbDevice(){

            @Nullable
            public RobotUsbDevice open() throws RobotCoreException {
                CameraManagerInternal cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
                if (!cameraManager.isWebcamAttached(serialNumber)) {
                    RobotLog.logAndThrow((String)("Unable to find webcam with serial number " + serialNumber));
                }
                return null;
            }
        };
        CameraManagerInternal cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
        WebcamName webcamName = cameraManager.webcamNameFromSerialNumber(serialNumber, openWebcam, this.manager);
        if (webcamName instanceof UserNameable) {
            ((UserNameable)webcamName).setUserName(name);
        }
        ((RobotUsbModule)webcamName).armOrPretend();
        return webcamName;
    }

    public TouchSensor createMRDigitalTouchSensor(DigitalChannelController digitalChannelController, int physicalPort, String name) {
        RobotLog.v((String)("Creating Modern Robotics digital Touch Sensor - Port: " + physicalPort));
        return new ModernRoboticsTouchSensor(digitalChannelController, physicalPort);
    }

    public IrSeekerSensor createMRI2cIrSeekerSensorV3(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating Modern Robotics I2C IR Seeker Sensor V3 - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        return new ModernRoboticsI2cIrSeekerSensorV3(this.createI2cDeviceSynch(lynxModule, channel, name), true);
    }

    public List<HardwareDevice> createAnalogSensorInstances(AnalogInputController controller, int channel, AnalogSensorConfigurationType type) {
        RobotLog.v((String)("Creating Analog Sensor - Type: " + type.getName() + " - Port: " + channel));
        return type.createInstances(controller, channel);
    }

    public List<HardwareDevice> createDigitalDeviceInstances(DigitalChannelController controller, int channel, DigitalIoDeviceConfigurationType type) {
        RobotLog.v((String)("Creating Digital Channel Device - Type: " + type.getName() + " - Port: " + channel));
        return type.createInstances(controller, channel);
    }

    public PWMOutput createPwmOutputDevice(PWMOutputController controller, int channel, String name) {
        RobotLog.v((String)("Creating PWM Output Device - Port: " + channel));
        return new PWMOutputImpl(controller, channel);
    }

    public List<HardwareDevice> createI2cDeviceInstances(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel bus, I2cDeviceConfigurationType type, String name) {
        RobotLog.v((String)"Creating user sensor %s - on Lynx module=%d bus=%d", (Object[])new Object[]{type.getName(), lynxModule.getModuleAddress(), bus.channel});
        return type.createInstances(() -> this.createI2cDeviceSynchSimple(lynxModule, bus, name));
    }

    public HardwareDevice createLimelight3A(SerialNumber serialNumber, @Nullable String name, InetAddress ipAddress) {
        RobotLog.v((String)"Creating Limelight3A named %s at %s", (Object[])new Object[]{name, serialNumber.getString()});
        return new Limelight3A(serialNumber, name, ipAddress);
    }

    public ColorSensor createAdafruitI2cColorSensor(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating Adafruit Color Sensor (Lynx) - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        return new AdafruitI2cColorSensor(this.createI2cDeviceSynchSimple(lynxModule, channel, name), true);
    }

    public ColorSensor createLynxColorRangeSensor(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating Lynx Color/Range Sensor - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        return new LynxI2cColorRangeSensor(this.createI2cDeviceSynchSimple(lynxModule, channel, name), true);
    }

    public ColorSensor createModernRoboticsI2cColorSensor(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating Modern Robotics I2C Color Sensor - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        return new ModernRoboticsI2cColorSensor(this.createI2cDeviceSynch(lynxModule, channel, name), true);
    }

    public GyroSensor createModernRoboticsI2cGyroSensor(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating Modern Robotics I2C Gyro Sensor - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        return new ModernRoboticsI2cGyro(this.createI2cDeviceSynch(lynxModule, channel, name), true);
    }

    public LED createLED(DigitalChannelController controller, int channel, String name) {
        RobotLog.v((String)("Creating LED - Port: " + channel));
        return new LED(controller, channel);
    }

    public I2cDeviceSynch createI2cDeviceSynch(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        RobotLog.v((String)"Creating I2cDeviceSynch (Lynx) - mod=%d bus=%d", (Object[])new Object[]{lynxModule.getModuleAddress(), channel.channel});
        I2cDeviceSynchSimple i2cDeviceSynchSimple = this.createI2cDeviceSynchSimple(lynxModule, channel, name);
        I2cDeviceSynchImplOnSimple result = new I2cDeviceSynchImplOnSimple(i2cDeviceSynchSimple, true);
        return result;
    }

    protected I2cDeviceSynchSimple createI2cDeviceSynchSimple(RobotCoreLynxModule lynxModule, DeviceConfiguration.I2cChannel channel, String name) {
        LynxI2cDeviceSynch result = LynxFirmwareVersionManager.createLynxI2cDeviceSynch(this.context, (LynxModule)lynxModule, channel.channel);
        result.setUserConfiguredName(name);
        return result;
    }

    private RobotUsbDevice.FirmwareVersion getModernRoboticsFirmwareVersion(byte[] modernRoboticsDeviceHeader) {
        return new RobotUsbDevice.FirmwareVersion((int)modernRoboticsDeviceHeader[0]);
    }
}

