/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware;

import android.content.Context;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.HardwareDeviceManager;
import com.qualcomm.hardware.lynx.LynxAnalogInputController;
import com.qualcomm.hardware.lynx.LynxDcMotorController;
import com.qualcomm.hardware.lynx.LynxDigitalChannelController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxServoController;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.LynxVoltageSensor;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.DcMotor;
import com.qualcomm.robotcore.hardware.DcMotorController;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.GyroSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.IrSeekerSensor;
import com.qualcomm.robotcore.hardware.LynxModuleDescription;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;
import com.qualcomm.robotcore.hardware.PWMOutput;
import com.qualcomm.robotcore.hardware.PWMOutputController;
import com.qualcomm.robotcore.hardware.RobotCoreLynxModule;
import com.qualcomm.robotcore.hardware.Servo;
import com.qualcomm.robotcore.hardware.ServoControllerEx;
import com.qualcomm.robotcore.hardware.configuration.BuiltInConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.ControllerConfiguration;
import com.qualcomm.robotcore.hardware.configuration.DeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.EthernetOverUsbConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.configuration.LynxI2cDeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.LynxUsbDeviceConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ReadXMLFileHandler;
import com.qualcomm.robotcore.hardware.configuration.RhspModuleConfiguration;
import com.qualcomm.robotcore.hardware.configuration.ServoFlavor;
import com.qualcomm.robotcore.hardware.configuration.ServoHubConfiguration;
import com.qualcomm.robotcore.hardware.configuration.WebcamConfiguration;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.AnalogSensorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.DigitalIoDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.I2cDeviceConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.MotorConfigurationType;
import com.qualcomm.robotcore.hardware.configuration.typecontainers.ServoConfigurationType;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.xmlpull.v1.XmlPullParser;

public class HardwareFactory {
    public static final String TAG = "HardwareFactory";
    private Context context;
    private XmlPullParser xmlPullParser = null;

    public HardwareFactory(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public HardwareMap createHardwareMap(SyncdDevice.Manager manager, OpModeManagerNotifier opModeNotifier) throws RobotCoreException, InterruptedException {
        Object object = HardwareDeviceManager.scanDevicesLock;
        synchronized (object) {
            RobotLog.vv((String)TAG, (String)"createHardwareMap()");
            EmbeddedControlHubModule.clear();
            HardwareMap map = new HardwareMap(this.context, opModeNotifier);
            if (this.xmlPullParser != null) {
                HardwareDeviceManager deviceMgr = new HardwareDeviceManager(this.context, manager);
                ReadXMLFileHandler readXmlFileHandler = new ReadXMLFileHandler((DeviceManager)deviceMgr);
                List ctrlConfList = readXmlFileHandler.parse(this.xmlPullParser);
                for (ControllerConfiguration ctrlConf : ctrlConfList) {
                    this.mapControllerConfiguration(map, deviceMgr, ctrlConf);
                }
            } else {
                RobotLog.vv((String)TAG, (String)"no xml to parse: using empty map");
            }
            return map;
        }
    }

    protected void mapControllerConfiguration(HardwareMap map, DeviceManager deviceMgr, ControllerConfiguration ctrlConf) throws RobotCoreException, InterruptedException {
        ConfigurationType type = ctrlConf.getConfigurationType();
        if (type == BuiltInConfigurationType.LYNX_USB_DEVICE) {
            this.mapLynxUsbDevice(map, deviceMgr, (LynxUsbDeviceConfiguration)ctrlConf);
        } else if (type == BuiltInConfigurationType.WEBCAM) {
            this.mapWebcam(map, deviceMgr, (WebcamConfiguration)ctrlConf);
        } else if (type == BuiltInConfigurationType.ETHERNET_OVER_USB_DEVICE) {
            this.mapEthernetOverUsb(map, deviceMgr, (EthernetOverUsbConfiguration)ctrlConf);
        } else {
            RobotLog.ee((String)TAG, (String)"unexpected controller configuration type: %s", (Object[])new Object[]{type});
        }
    }

    public void setXmlPullParser(XmlPullParser xmlPullParser) {
        this.xmlPullParser = xmlPullParser;
    }

    public XmlPullParser getXmlPullParser() {
        return this.xmlPullParser;
    }

    private void mapMotor(HardwareMap map, DeviceManager deviceMgr, DeviceConfiguration motorConf, DcMotorController dcMotorController) {
        if (!motorConf.isEnabled()) {
            return;
        }
        DcMotor dcMotor = deviceMgr.createDcMotor(dcMotorController, motorConf.getPort(), (MotorConfigurationType)motorConf.getConfigurationType(), motorConf.getName());
        map.dcMotor.put(motorConf.getName(), (HardwareDevice)dcMotor);
    }

    private void mapLynxServoDevice(HardwareMap map, DeviceManager deviceMgr, DeviceConfiguration servoConf, ServoControllerEx servoController) {
        if (!servoConf.isEnabled() || !servoConf.getConfigurationType().isDeviceFlavor(ConfigurationType.DeviceFlavor.SERVO)) {
            return;
        }
        ServoConfigurationType servoType = (ServoConfigurationType)servoConf.getConfigurationType();
        if (servoType.getServoFlavor() == ServoFlavor.CUSTOM) {
            List customServoDeviceInstances = deviceMgr.createCustomServoDeviceInstances(servoController, servoConf.getPort(), servoType);
            this.addUserDevicesToMap(map, servoConf, customServoDeviceInstances);
        } else {
            Servo servoDevice = null;
            if (servoType.getServoFlavor() == ServoFlavor.STANDARD) {
                servoDevice = deviceMgr.createServoEx(servoController, servoConf.getPort(), servoConf.getName(), servoType);
            } else if (servoType.getServoFlavor() == ServoFlavor.CONTINUOUS) {
                servoDevice = deviceMgr.createCRServoEx(servoController, servoConf.getPort(), servoConf.getName(), servoType);
            }
            if (servoDevice != null) {
                this.addUserDeviceToMap(map, servoConf, (HardwareDevice)servoDevice);
            }
        }
    }

    private void buildLynxDevices(List<DeviceConfiguration> list, HardwareMap map, DeviceManager deviceMgr, AnalogInputController lynxModule) {
        for (DeviceConfiguration deviceConfiguration : list) {
            ConfigurationType devType = deviceConfiguration.getConfigurationType();
            if (!devType.isDeviceFlavor(ConfigurationType.DeviceFlavor.ANALOG_SENSOR)) continue;
            this.mapAnalogSensor(map, deviceMgr, lynxModule, deviceConfiguration);
        }
    }

    private void buildLynxDevices(List<DeviceConfiguration> list, HardwareMap map, DeviceManager deviceMgr, DigitalChannelController lynxModule) {
        for (DeviceConfiguration deviceConfiguration : list) {
            ConfigurationType devType = deviceConfiguration.getConfigurationType();
            if (!devType.isDeviceFlavor(ConfigurationType.DeviceFlavor.DIGITAL_IO)) continue;
            this.mapDigitalDevice(map, deviceMgr, lynxModule, deviceConfiguration);
        }
    }

    private void buildLynxI2cDevices(List<LynxI2cDeviceConfiguration> list, HardwareMap map, DeviceManager deviceMgr, LynxModule module) {
        for (LynxI2cDeviceConfiguration deviceConfiguration : list) {
            ConfigurationType devType = deviceConfiguration.getConfigurationType();
            if (devType == BuiltInConfigurationType.IR_SEEKER_V3) {
                this.mapIrSeekerV3Device(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            if (devType == BuiltInConfigurationType.ADAFRUIT_COLOR_SENSOR) {
                this.mapAdafruitColorSensor(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            if (devType == BuiltInConfigurationType.LYNX_COLOR_SENSOR) {
                this.mapLynxColorSensor(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            if (devType == BuiltInConfigurationType.COLOR_SENSOR) {
                this.mapModernRoboticsColorSensor(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            if (devType == BuiltInConfigurationType.GYRO) {
                this.mapModernRoboticsGyro(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            if (devType == BuiltInConfigurationType.NOTHING) continue;
            if (devType.isDeviceFlavor(ConfigurationType.DeviceFlavor.I2C)) {
                if (!(devType instanceof I2cDeviceConfigurationType)) continue;
                this.mapUserI2cDevice(map, deviceMgr, module, (DeviceConfiguration)deviceConfiguration);
                continue;
            }
            RobotLog.w((String)("Unexpected device type connected to I2c Controller while parsing XML: " + devType.toString()));
        }
    }

    private void mapIrSeekerV3Device(HardwareMap map, DeviceManager deviceMgr, LynxModule module, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        IrSeekerSensor irSeekerSensor = deviceMgr.createMRI2cIrSeekerSensorV3((RobotCoreLynxModule)module, devConf.getI2cChannel(), devConf.getName());
        map.irSeekerSensor.put(devConf.getName(), (HardwareDevice)irSeekerSensor);
    }

    private void mapDigitalDevice(HardwareMap map, DeviceManager deviceMgr, DigitalChannelController digitalChannelController, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        if (devConf.getConfigurationType().isDeviceFlavor(ConfigurationType.DeviceFlavor.DIGITAL_IO)) {
            DigitalIoDeviceConfigurationType digitalDeviceType = (DigitalIoDeviceConfigurationType)devConf.getConfigurationType();
            List digitalDeviceInstances = deviceMgr.createDigitalDeviceInstances(digitalChannelController, devConf.getPort(), digitalDeviceType);
            this.addUserDevicesToMap(map, devConf, digitalDeviceInstances);
        }
    }

    private void mapAnalogSensor(HardwareMap map, DeviceManager deviceMgr, AnalogInputController analogInputController, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        if (devConf.getConfigurationType().isDeviceFlavor(ConfigurationType.DeviceFlavor.ANALOG_SENSOR)) {
            AnalogSensorConfigurationType analogSensorType = (AnalogSensorConfigurationType)devConf.getConfigurationType();
            List analogSensorDeviceInstances = deviceMgr.createAnalogSensorInstances(analogInputController, devConf.getPort(), analogSensorType);
            this.addUserDevicesToMap(map, devConf, analogSensorDeviceInstances);
        }
    }

    private void mapPwmOutputDevice(HardwareMap map, DeviceManager deviceMgr, PWMOutputController pwmOutputController, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        PWMOutput pwmOutput = deviceMgr.createPwmOutputDevice(pwmOutputController, devConf.getPort(), devConf.getName());
        map.pwmOutput.put(devConf.getName(), (HardwareDevice)pwmOutput);
    }

    private void mapI2cDeviceSynch(HardwareMap map, DeviceManager deviceMgr, LynxModule module, DeviceConfiguration devConf) {
        I2cDeviceSynch i2cDeviceSynch = deviceMgr.createI2cDeviceSynch((RobotCoreLynxModule)module, devConf.getI2cChannel(), devConf.getName());
        map.i2cDeviceSynch.put(devConf.getName(), (HardwareDevice)i2cDeviceSynch);
    }

    private void addUserDeviceToMap(HardwareMap map, DeviceConfiguration deviceConf, HardwareDevice deviceInstance) {
        map.put(deviceConf.getName(), deviceInstance);
        for (HardwareMap.DeviceMapping mapping : map.allDeviceMappings) {
            if (!mapping.getDeviceTypeClass().isInstance(deviceInstance)) continue;
            this.maybeAddToMapping(mapping, deviceConf.getName(), mapping.cast((Object)deviceInstance));
        }
    }

    private void addUserDevicesToMap(HardwareMap map, DeviceConfiguration deviceConf, List<HardwareDevice> deviceInstances) {
        if (deviceInstances.size() == 1) {
            this.addUserDeviceToMap(map, deviceConf, deviceInstances.get(0));
            return;
        }
        map.put(deviceConf.getName(), deviceInstances);
        for (HardwareMap.DeviceMapping mapping : map.allDeviceMappings) {
            for (HardwareDevice deviceInstance : deviceInstances) {
                if (!mapping.getDeviceTypeClass().isInstance(deviceInstance)) continue;
                this.maybeAddToMapping(mapping, deviceConf.getName(), mapping.cast((Object)deviceInstance));
            }
        }
    }

    private <T extends HardwareDevice> void maybeAddToMapping(HardwareMap.DeviceMapping<T> mapping, String name, T device) {
        if (!mapping.contains(name)) {
            mapping.putLocal(name, device);
        }
    }

    private void mapUserI2cDevice(HardwareMap map, DeviceManager deviceMgr, LynxModule lynxModule, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        I2cDeviceConfigurationType userType = (I2cDeviceConfigurationType)devConf.getConfigurationType();
        List i2cDeviceInstances = deviceMgr.createI2cDeviceInstances((RobotCoreLynxModule)lynxModule, devConf.getI2cChannel(), userType, devConf.getName());
        this.addUserDevicesToMap(map, devConf, i2cDeviceInstances);
    }

    private void mapWebcam(HardwareMap map, DeviceManager deviceManager, WebcamConfiguration webcamConfiguration) throws RobotCoreException, InterruptedException {
        if (!webcamConfiguration.isEnabled()) {
            return;
        }
        SerialNumber serialNumber = webcamConfiguration.getSerialNumber();
        if (webcamConfiguration.getAutoOpen()) {
            RobotLog.ee((String)TAG, (String)"support for auto-opening webcams is not yet implemented: %s", (Object[])new Object[]{serialNumber});
            return;
        }
        WebcamName webcamName = deviceManager.createWebcamName(serialNumber, webcamConfiguration.getName());
        if (webcamName != null) {
            map.put(serialNumber, webcamConfiguration.getName(), (HardwareDevice)webcamName);
        }
    }

    private void mapEthernetOverUsb(HardwareMap map, DeviceManager deviceManager, EthernetOverUsbConfiguration ethernetOverUsbConfiguration) throws RobotCoreException, InterruptedException {
        if (!ethernetOverUsbConfiguration.isEnabled()) {
            return;
        }
        SerialNumber serialNumber = ethernetOverUsbConfiguration.getSerialNumber();
        HardwareDevice limelight = deviceManager.createLimelight3A(serialNumber, ethernetOverUsbConfiguration.getName(), ethernetOverUsbConfiguration.getIpAddress());
        if (limelight != null) {
            map.put(serialNumber, ethernetOverUsbConfiguration.getName(), limelight);
        }
    }

    private void mapLynxUsbDevice(HardwareMap map, DeviceManager deviceMgr, LynxUsbDeviceConfiguration lynxUsbDeviceConfiguration) throws RobotCoreException, InterruptedException {
        if (!lynxUsbDeviceConfiguration.isEnabled()) {
            return;
        }
        SerialNumber serialNumber = lynxUsbDeviceConfiguration.getSerialNumber();
        LynxUsbDevice lynxUsbDevice = (LynxUsbDevice)deviceMgr.createLynxUsbDevice(serialNumber, lynxUsbDeviceConfiguration.getName());
        try {
            if (lynxUsbDeviceConfiguration.isSystemSynthetic()) {
                lynxUsbDevice.setSystemSynthetic(true);
            }
            boolean isFirstLynxUsbDevice = !LynxConstants.isEmbeddedSerialNumber((SerialNumber)serialNumber);
            for (LynxUsbDevice usbDevice : map.getAll(LynxUsbDevice.class)) {
                if (LynxConstants.isEmbeddedSerialNumber((SerialNumber)usbDevice.getSerialNumber())) continue;
                isFirstLynxUsbDevice = false;
                break;
            }
            ArrayList<LynxModuleDescription> moduleDescriptions = new ArrayList<LynxModuleDescription>();
            HashMap<Integer, String> moduleNames = new HashMap<Integer, String>();
            int parentModuleAddress = lynxUsbDeviceConfiguration.getParentModuleAddress();
            for (RhspModuleConfiguration moduleConfiguration : lynxUsbDeviceConfiguration.getModules()) {
                int n = moduleConfiguration.getPort();
                moduleNames.put(n, moduleConfiguration.getName());
                LynxModuleDescription.Builder moduleDescriptionBuilder = new LynxModuleDescription.Builder(n, parentModuleAddress == n);
                moduleDescriptionBuilder.setUserModule();
                if (moduleConfiguration.isSystemSynthetic()) {
                    moduleDescriptionBuilder.setSystemSynthetic();
                }
                moduleDescriptions.add(moduleDescriptionBuilder.build());
            }
            HashMap<Integer, LynxModule> connectedModules = new HashMap<Integer, LynxModule>();
            for (LynxModuleDescription lynxModuleDescription : moduleDescriptions) {
                if (!lynxModuleDescription.isParent) continue;
                this.connectModule(lynxUsbDevice, lynxModuleDescription, moduleNames, connectedModules, isFirstLynxUsbDevice && connectedModules.isEmpty());
            }
            for (LynxModuleDescription lynxModuleDescription : moduleDescriptions) {
                if (lynxModuleDescription.isParent) continue;
                this.connectModule(lynxUsbDevice, lynxModuleDescription, moduleNames, connectedModules, false);
            }
            this.mapLynxModuleComponents(map, deviceMgr, lynxUsbDeviceConfiguration, lynxUsbDevice, connectedModules);
            for (Map.Entry entry : connectedModules.entrySet()) {
                int moduleAddress = (Integer)entry.getKey();
                LynxModule lynxModule = (LynxModule)entry.getValue();
                map.put(lynxModule.getModuleSerialNumber(), (String)moduleNames.get(moduleAddress), (HardwareDevice)lynxModule);
            }
            map.put(serialNumber, lynxUsbDeviceConfiguration.getName(), (HardwareDevice)lynxUsbDevice);
        }
        catch (LynxNackException e) {
            throw e.wrap();
        }
        catch (RobotCoreException | RuntimeException e) {
            lynxUsbDevice.close();
            map.remove(serialNumber, lynxUsbDeviceConfiguration.getName(), (HardwareDevice)lynxUsbDevice);
            throw e;
        }
    }

    private void connectModule(LynxUsbDevice lynxUsbDevice, LynxModuleDescription moduleDescription, Map<Integer, String> moduleNames, Map<Integer, LynxModule> connectedModules, boolean enableCharging) throws InterruptedException {
        try {
            LynxModule module = lynxUsbDevice.getOrAddModule(moduleDescription);
            if (enableCharging) {
                module.enablePhoneCharging(true);
            }
            connectedModules.put(module.getModuleAddress(), module);
        }
        catch (LynxNackException | RobotCoreException | RuntimeException e) {
            int moduleAddress = moduleDescription.address;
            lynxUsbDevice.noteMissingModule(moduleAddress, moduleNames.get(moduleAddress));
        }
    }

    private void mapLynxModuleComponents(HardwareMap map, DeviceManager deviceMgr, LynxUsbDeviceConfiguration lynxUsbDeviceConfiguration, LynxUsbDevice lynxUsbDevice, Map<Integer, LynxModule> connectedModules) throws LynxNackException, RobotCoreException, InterruptedException {
        for (RhspModuleConfiguration moduleConfiguration : lynxUsbDeviceConfiguration.getModules()) {
            LynxServoController sc;
            LynxModule module = connectedModules.get(moduleConfiguration.getPort());
            if (module == null) continue;
            if (moduleConfiguration instanceof LynxModuleConfiguration) {
                LynxDcMotorController mc = new LynxDcMotorController(this.context, module);
                map.dcMotorController.put(moduleConfiguration.getName(), (HardwareDevice)mc);
                for (DeviceConfiguration motorConf : ((LynxModuleConfiguration)moduleConfiguration).getMotors()) {
                    if (!motorConf.isEnabled()) continue;
                    DcMotor m = deviceMgr.createDcMotorEx((DcMotorController)mc, motorConf.getPort(), (MotorConfigurationType)motorConf.getConfigurationType(), motorConf.getName());
                    map.dcMotor.put(motorConf.getName(), (HardwareDevice)m);
                }
            }
            if (moduleConfiguration instanceof LynxModuleConfiguration) {
                sc = new LynxServoController(this.context, module);
                map.servoController.put(moduleConfiguration.getName(), (HardwareDevice)sc);
                for (DeviceConfiguration servoConf : ((LynxModuleConfiguration)moduleConfiguration).getServos()) {
                    this.mapLynxServoDevice(map, deviceMgr, servoConf, sc);
                }
            }
            if (moduleConfiguration instanceof ServoHubConfiguration) {
                sc = new LynxServoController(this.context, module);
                map.servoController.put(moduleConfiguration.getName(), (HardwareDevice)sc);
                for (DeviceConfiguration servoConf : ((ServoHubConfiguration)moduleConfiguration).getServos()) {
                    this.mapLynxServoDevice(map, deviceMgr, servoConf, sc);
                }
            }
            LynxVoltageSensor voltageSensor = new LynxVoltageSensor(this.context, module);
            map.voltageSensor.put(moduleConfiguration.getName(), (HardwareDevice)voltageSensor);
            if (moduleConfiguration instanceof LynxModuleConfiguration) {
                LynxAnalogInputController analogInputController = new LynxAnalogInputController(this.context, module);
                map.put(moduleConfiguration.getName(), (HardwareDevice)analogInputController);
                this.buildLynxDevices((List<DeviceConfiguration>)((LynxModuleConfiguration)moduleConfiguration).getAnalogInputs(), map, deviceMgr, analogInputController);
            }
            if (moduleConfiguration instanceof LynxModuleConfiguration) {
                LynxDigitalChannelController digitalChannelController = new LynxDigitalChannelController(this.context, module);
                map.put(moduleConfiguration.getName(), (HardwareDevice)digitalChannelController);
                this.buildLynxDevices((List<DeviceConfiguration>)((LynxModuleConfiguration)moduleConfiguration).getDigitalDevices(), map, deviceMgr, digitalChannelController);
            }
            if (!(moduleConfiguration instanceof LynxModuleConfiguration)) continue;
            this.buildLynxI2cDevices(((LynxModuleConfiguration)moduleConfiguration).getI2cDevices(), map, deviceMgr, module);
        }
    }

    private void mapAdafruitColorSensor(HardwareMap map, DeviceManager deviceMgr, LynxModule module, DeviceConfiguration devConf) {
        ColorSensor colorSensor = deviceMgr.createAdafruitI2cColorSensor((RobotCoreLynxModule)module, devConf.getI2cChannel(), devConf.getName());
        map.colorSensor.put(devConf.getName(), (HardwareDevice)colorSensor);
    }

    private void mapLynxColorSensor(HardwareMap map, DeviceManager deviceMgr, LynxModule module, DeviceConfiguration devConf) {
        ColorSensor sensor = deviceMgr.createLynxColorRangeSensor((RobotCoreLynxModule)module, devConf.getI2cChannel(), devConf.getName());
        map.colorSensor.put(devConf.getName(), (HardwareDevice)sensor);
        map.opticalDistanceSensor.put(devConf.getName(), (HardwareDevice)((OpticalDistanceSensor)sensor));
    }

    private void mapModernRoboticsColorSensor(HardwareMap map, DeviceManager deviceMgr, LynxModule lynxModule, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        ColorSensor colorSensor = deviceMgr.createModernRoboticsI2cColorSensor((RobotCoreLynxModule)lynxModule, devConf.getI2cChannel(), devConf.getName());
        map.colorSensor.put(devConf.getName(), (HardwareDevice)colorSensor);
    }

    private void mapModernRoboticsGyro(HardwareMap map, DeviceManager deviceMgr, LynxModule module, DeviceConfiguration devConf) {
        if (!devConf.isEnabled()) {
            return;
        }
        GyroSensor gyroSensor = deviceMgr.createModernRoboticsI2cGyroSensor((RobotCoreLynxModule)module, devConf.getI2cChannel(), devConf.getName());
        map.gyroSensor.put(devConf.getName(), (HardwareDevice)gyroSensor);
    }

    public static void noteSerialNumberType(Context context, SerialNumber serialNumber, String typeName) {
        SerialNumber.noteSerialNumberType((SerialNumber)serialNumber, (String)typeName);
    }

    public static String getDeviceDisplayName(Context context, SerialNumber serialNumber) {
        return SerialNumber.getDeviceDisplayName((SerialNumber)serialNumber);
    }
}

