/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.commands.core.LynxFirmwareVersionManager;
import com.qualcomm.hardware.rev.RevHubOrientationOnRobot;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.EmbeddedControlHubModule;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealth;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDeviceWithParameters;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.IMU;
import com.qualcomm.robotcore.hardware.ImuOrientationOnRobot;
import com.qualcomm.robotcore.hardware.QuaternionBasedImuHelper;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.TypeConversion;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.AngularVelocity;
import org.firstinspires.ftc.robotcore.external.navigation.AxesOrder;
import org.firstinspires.ftc.robotcore.external.navigation.AxesReference;
import org.firstinspires.ftc.robotcore.external.navigation.Orientation;
import org.firstinspires.ftc.robotcore.external.navigation.Quaternion;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;
import org.firstinspires.ftc.robotcore.internal.hardware.android.AndroidBoard;
import org.firstinspires.ftc.robotcore.internal.hardware.android.GpioPin;
import org.firstinspires.ftc.robotcore.internal.system.AppAliveNotifier;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.SystemProperties;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;
import org.firstinspires.ftc.robotcore.internal.ui.UILocation;

@I2cDeviceType
@DeviceProperties(name="@string/lynx_embedded_bhi260ap_imu_name", xmlTag="ControlHubImuBHI260AP", description="@string/lynx_embedded_imu_description", builtIn=true)
public class BHI260IMU
extends I2cDeviceSynchDeviceWithParameters<I2cDeviceSynchSimple, IMU.Parameters>
implements IMU {
    private static final String TAG = "BHI260IMU";
    public static final boolean DIAGNOSTIC_MODE = false;
    public static final boolean DIAGNOSTIC_MODE_FIFO_PARSING = false;
    private static final I2cAddr I2C_ADDR = I2cAddr.create7bit((int)40);
    private static final double QUATERNION_SCALE_FACTOR = Math.pow(2.0, -14.0);
    private static final int PRODUCT_ID = 137;
    private static final int BOOT_FROM_FLASH_TIMEOUT_MS = 2000;
    private static final int ERASE_FLASH_TIMEOUT_MS = 14000;
    private static final int MAX_ANGULAR_VELOCITY_DEG_PER_S = 2000;
    private static final int COMMAND_HEADER_LENGTH = 4;
    private static final int MAX_SEND_I2C_BYTES_NO_REGISTER = 100;
    private static final int MAX_SEND_I2C_BYTES_WITH_REGISTER = 99;
    private static final int MAX_READ_I2C_BYTES = 100;
    private static final boolean DEBUG_FW_FLASHING = false;
    private static final int FW_START_ADDRESS = 8068;
    private static final int FW_RESOURCE = R.raw.rev_bhi260_ap_fw_20;
    private static final int BUNDLED_FW_VERSION = 20;
    private static final int WRITE_FLASH_COMMAND_HEADER_LENGTH = 8;
    private static final int MAX_WRITE_FLASH_FIRMWARE_AND_PADDING_BYTES = 91;
    private static final int MAX_WRITE_FLASH_FIRMWARE_BYTES = 88;
    private static final int WRITE_FLASH_RESPONSE_TIMEOUT_MS = 1000;
    private static final StatusAndDebugFifoModeManager statusAndDebugFifoModeManager = new StatusAndDebugFifoModeManager();
    private static volatile Thread diagnosticModeThread;
    private static final Object i2cLock;
    private static final Object genPurposeRegisterDataRetrievalLock;
    private int fwVersion = 0;
    private final QuaternionBasedImuHelper helper;
    private DigitalChannel gameRVRequestGpio;
    private DigitalChannel correctedGyroRequestGpio;
    private static final int COMMAND_ERROR_RESPONSE = 15;

    public static boolean imuIsPresent(I2cDeviceSynchSimple deviceClient) {
        deviceClient.setI2cAddress(I2C_ADDR);
        RobotLog.vv((String)TAG, (String)"Suppressing I2C warnings while we check for a BHI260AP IMU");
        I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)true);
        try {
            int productId = BHI260IMU.read8(deviceClient, Register.PRODUCT_IDENTIFIER);
            if (productId == 137) {
                RobotLog.vv((String)TAG, (String)"Found BHI260AP IMU");
                boolean bl = true;
                return bl;
            }
            RobotLog.vv((String)TAG, (String)"No BHI260AP IMU found");
            boolean bl = false;
            return bl;
        }
        finally {
            I2cWarningManager.suppressNewProblemDeviceWarnings((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flashFirmwareIfNecessary(I2cDeviceSynchSimple deviceClient) {
        block18: {
            deviceClient.setI2cAddress(I2C_ADDR);
            try {
                BHI260IMU.waitForHostInterface(deviceClient);
                BHI260IMU.checkForFlashPresence(deviceClient);
                boolean alreadyFlashed = BHI260IMU.waitForFlashVerification(deviceClient);
                int firmwareVersion = alreadyFlashed ? BHI260IMU.read16(deviceClient, Register.USER_VERSION) : 0;
                RobotLog.vv((String)TAG, (String)"flashFirmwareIfNecessary() alreadyFlashed=%b firmwareVersion=%d", (Object[])new Object[]{alreadyFlashed, firmwareVersion});
                if (firmwareVersion == 20) break block18;
                try {
                    ByteBuffer fwBuffer;
                    if (SystemProperties.getBoolean((String)"persist.bhi260.flash400khz", (boolean)false)) {
                        RobotLog.vv((String)TAG, (String)"Setting I2C bus speed to 400KHz for firmware flashing");
                        ((LynxI2cDeviceSynch)deviceClient).setBusSpeed(LynxI2cDeviceSynch.BusSpeed.FAST_400K);
                    } else {
                        RobotLog.vv((String)TAG, (String)"Setting I2C bus speed to 100KHz for firmware flashing");
                        ((LynxI2cDeviceSynch)deviceClient).setBusSpeed(LynxI2cDeviceSynch.BusSpeed.STANDARD_100K);
                    }
                    RobotLog.ii((String)TAG, (String)"Flashing IMU firmware version %d", (Object[])new Object[]{20});
                    ElapsedTime fwFlashTimer = new ElapsedTime();
                    try {
                        fwBuffer = ByteBuffer.wrap(ReadWriteFile.readRawResourceBytesOrThrow((int)FW_RESOURCE));
                    }
                    catch (IOException e) {
                        RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to read IMU firmware file");
                        throw new InitException();
                    }
                    int fwLength = fwBuffer.remaining();
                    RobotLog.vv((String)TAG, (String)"Resetting IMU");
                    BHI260IMU.write8(deviceClient, Register.RESET_REQUEST, 1, I2cWaitControl.WRITTEN);
                    BHI260IMU.waitForHostInterface(deviceClient);
                    RobotLog.dd((String)TAG, (String)"Flash device's JDEC manufacturer ID: 0x%X", (Object[])new Object[]{BHI260IMU.read8(deviceClient, Register.GEN_PURPOSE_READ)});
                    RobotLog.vv((String)TAG, (String)"Wiping IMU flash memory");
                    AppUtil.getInstance().showProgress(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.flashingControlHubImu), new ProgressParameters(0, fwLength));
                    ByteBuffer eraseFlashPayload = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt(8068).putInt(8068 + fwLength);
                    try {
                        BHI260IMU.sendCommandAndWaitForResponse(deviceClient, CommandType.ERASE_FLASH, eraseFlashPayload.array(), 14000);
                    }
                    catch (CommandFailureException e) {
                        RobotLog.ee((String)TAG, (Throwable)e, (String)"IMU flash erase failed");
                        throw new InitException();
                    }
                    finally {
                        AppAliveNotifier.getInstance().notifyAppAlive();
                    }
                    int nextStartAddress = 8068;
                    int numBytesAlreadyWritten = 0;
                    RobotLog.ii((String)TAG, (String)"Sending firmware data");
                    while (fwBuffer.hasRemaining()) {
                        int fwBytesToTransmitInCommand = Math.min(fwBuffer.remaining(), 88);
                        try {
                            BHI260IMU.sendWriteFlashCommandAndWaitForResponse(deviceClient, nextStartAddress, fwBytesToTransmitInCommand, fwBuffer);
                        }
                        catch (CommandFailureException e) {
                            RobotLog.ee((String)TAG, (Throwable)e, (String)"Write Flash command failed");
                            throw new InitException();
                        }
                        nextStartAddress += fwBytesToTransmitInCommand;
                        AppUtil.getInstance().showProgress(UILocation.BOTH, AppUtil.getDefContext().getString(R.string.flashingControlHubImu), new ProgressParameters(numBytesAlreadyWritten += fwBytesToTransmitInCommand, fwLength));
                    }
                    RobotLog.vv((String)TAG, (String)"Booting into newly-flashed firmware");
                    BHI260IMU.sendCommand(deviceClient, CommandType.BOOT_FLASH, null);
                    BHI260IMU.waitForHostInterface(deviceClient);
                    BHI260IMU.checkForFlashPresence(deviceClient);
                    boolean flashSucceeded = BHI260IMU.waitForFlashVerification(deviceClient);
                    if (flashSucceeded) {
                        RobotLog.vv((String)TAG, (String)"Successfully flashed Control Hub IMU firmware in %.2f seconds", (Object[])new Object[]{fwFlashTimer.seconds()});
                        break block18;
                    }
                    RobotLog.ee((String)TAG, (String)"IMU flash verification failed after flashing firmware");
                    throw new InitException();
                }
                finally {
                    AppUtil.getInstance().dismissProgress(UILocation.BOTH);
                }
            }
            catch (InitException e) {
                RobotLog.addGlobalWarningMessage((String)AppUtil.getDefContext().getString(R.string.controlHubImuFwFlashFailed));
            }
        }
    }

    public BHI260IMU(I2cDeviceSynchSimple i2cDeviceSynchSimple, boolean deviceClientIsOwned) {
        super(i2cDeviceSynchSimple, deviceClientIsOwned, (Object)new IMU.Parameters((ImuOrientationOnRobot)new RevHubOrientationOnRobot(RevHubOrientationOnRobot.LogoFacingDirection.UP, RevHubOrientationOnRobot.UsbFacingDirection.FORWARD)));
        this.helper = new QuaternionBasedImuHelper(((IMU.Parameters)this.parameters).imuOrientationOnRobot);
        if (BHI260IMU.imuIsPresent(this.deviceClient) && this.internalInitialize((IMU.Parameters)this.parameters)) {
            this.helper.resetYaw(TAG, this::getRawQuaternion, 500);
        }
    }

    protected boolean internalInitialize(@NonNull IMU.Parameters parameters) {
        if (!parameters.getClass().equals(IMU.Parameters.class)) {
            RobotLog.addGlobalWarningMessage((String)AppUtil.getDefContext().getString(R.string.parametersForOtherDeviceUsed));
        }
        parameters = parameters.copy();
        this.parameters = parameters;
        this.gameRVRequestGpio = AndroidBoard.getInstance().getBhi260Gpio5();
        this.correctedGyroRequestGpio = AndroidBoard.getInstance().getBhi260Gpio6();
        this.gameRVRequestGpio.setMode(DigitalChannel.Mode.OUTPUT);
        this.correctedGyroRequestGpio.setMode(DigitalChannel.Mode.OUTPUT);
        this.helper.setImuOrientationOnRobot(parameters.imuOrientationOnRobot);
        this.deviceClient.setI2cAddress(I2C_ADDR);
        if (!BHI260IMU.imuIsPresent(this.deviceClient)) {
            RobotLog.ee((String)TAG, (String)"Could not find Control Hub IMU (BHI260AP)");
            return false;
        }
        try {
            BHI260IMU.waitForHostInterface(this.deviceClient);
            BHI260IMU.checkForFlashPresence(this.deviceClient);
            boolean flashContentsVerified = BHI260IMU.waitForFlashVerification(this.deviceClient);
            if (!flashContentsVerified) {
                RobotLog.ee((String)TAG, (String)"IMU flash contents were not verified");
                throw new InitException();
            }
            if (BHI260IMU.readBootStatusFlags(this.deviceClient).contains((Object)BootStatusFlag.FIRMWARE_HALTED)) {
                RobotLog.ee((String)TAG, (String)"IMU reports that its firmware is not running");
                return false;
            }
            BHI260IMU.disableFifoTimestamps(this.deviceClient);
            this.fwVersion = BHI260IMU.read16(this.deviceClient, Register.USER_VERSION);
            if (this.fwVersion != 20) {
                RobotLog.ee((String)TAG, (String)"Firmware version is incorrect. expected=%d actual=%d", (Object[])new Object[]{20, this.fwVersion});
                throw new InitException();
            }
            RobotLog.dd((String)TAG, (String)"Firmware version: %d", (Object[])new Object[]{this.fwVersion});
            BHI260IMU.write8(this.deviceClient, Register.HOST_CONTROL, 0, I2cWaitControl.ATOMIC);
            this.setSensorDynamicRange(Sensor.GYROSCOPE_CORRECTED_DATA_HOLDER, 2000);
            this.configureSensor(Sensor.GAME_ROTATION_VECTOR_DATA_HOLDER, 800.0f, 0);
            this.configureSensor(Sensor.GAME_ROTATION_VECTOR_GPIO_HANDLER, 800.0f, 0);
            this.configureSensor(Sensor.GYROSCOPE_CORRECTED_DATA_HOLDER, 800.0f, 0);
            this.configureSensor(Sensor.GYROSCOPE_CORRECTED_GPIO_HANDLER, 800.0f, 0);
        }
        catch (InitException e) {
            return false;
        }
        return true;
    }

    public void resetYaw() {
        this.helper.resetYaw(TAG, this::getRawQuaternion, 50);
    }

    public YawPitchRollAngles getRobotYawPitchRollAngles() {
        return this.helper.getRobotYawPitchRollAngles(TAG, this::getRawQuaternion);
    }

    public Orientation getRobotOrientation(AxesReference reference, AxesOrder order, AngleUnit angleUnit) {
        return this.helper.getRobotOrientation(TAG, this::getRawQuaternion, reference, order, angleUnit);
    }

    public Quaternion getRobotOrientationAsQuaternion() {
        return this.helper.getRobotOrientationAsQuaternion(TAG, this::getRawQuaternion, true);
    }

    public AngularVelocity getRobotAngularVelocity(AngleUnit angleUnit) {
        return this.helper.getRobotAngularVelocity(this.getRawAngularVelocity(), angleUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Quaternion getRawQuaternion() throws QuaternionBasedImuHelper.FailedToRetrieveQuaternionException {
        ByteBuffer data;
        long timestamp;
        if (!(this.gameRVRequestGpio instanceof GpioPin)) {
            throw new QuaternionBasedImuHelper.FailedToRetrieveQuaternionException();
        }
        Object object = genPurposeRegisterDataRetrievalLock;
        synchronized (object) {
            this.gameRVRequestGpio.setState(true);
            timestamp = System.nanoTime();
            data = BHI260IMU.readMultiple(this.deviceClient, Register.GEN_PURPOSE_READ, 8);
            this.gameRVRequestGpio.setState(false);
        }
        short xInt = data.getShort();
        short yInt = data.getShort();
        short zInt = data.getShort();
        short wInt = data.getShort();
        if (xInt == 0 && yInt == 0 && zInt == 0 && wInt == 0) {
            throw new QuaternionBasedImuHelper.FailedToRetrieveQuaternionException();
        }
        float x = (float)((double)xInt * QUATERNION_SCALE_FACTOR);
        float y = (float)((double)yInt * QUATERNION_SCALE_FACTOR);
        float z = (float)((double)zInt * QUATERNION_SCALE_FACTOR);
        float w = (float)((double)wInt * QUATERNION_SCALE_FACTOR);
        return new Quaternion(w, x, y, z, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AngularVelocity getRawAngularVelocity() {
        ByteBuffer data;
        long timestamp;
        if (!(this.correctedGyroRequestGpio instanceof GpioPin)) {
            return new AngularVelocity(AngleUnit.DEGREES, 0.0f, 0.0f, 0.0f, 0L);
        }
        Object object = genPurposeRegisterDataRetrievalLock;
        synchronized (object) {
            this.correctedGyroRequestGpio.setState(true);
            timestamp = System.nanoTime();
            data = BHI260IMU.readMultiple(this.deviceClient, Register.GEN_PURPOSE_READ, 6);
            this.correctedGyroRequestGpio.setState(false);
        }
        short xInt = data.getShort();
        short yInt = data.getShort();
        short zInt = data.getShort();
        double scaleFactor = 0.08415029242226617;
        float x = (float)((double)xInt * 0.08415029242226617);
        float y = (float)((double)yInt * 0.08415029242226617);
        float z = (float)((double)zInt * 0.08415029242226617);
        return new AngularVelocity(AngleUnit.DEGREES, x, y, z, timestamp);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public String getDeviceName() {
        return AppUtil.getDefContext().getString(R.string.lynx_embedded_bhi260ap_imu_name);
    }

    public String getConnectionInfo() {
        return String.format("BHI260 IMU on %s", this.deviceClient.getConnectionInfo());
    }

    public int getFirmwareVersion() {
        return this.fwVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int read8(I2cDeviceSynchSimple deviceClient, Register register) {
        Object object = i2cLock;
        synchronized (object) {
            return TypeConversion.unsignedByteToInt((byte)deviceClient.read8(register.address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int read16(I2cDeviceSynchSimple deviceClient, Register register) {
        Object object = i2cLock;
        synchronized (object) {
            return TypeConversion.byteArrayToShort((byte[])deviceClient.read(register.address, 2), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readMultiple(I2cDeviceSynchSimple deviceClient, Register register, int numBytes) {
        Object object = i2cLock;
        synchronized (object) {
            return ByteBuffer.wrap(deviceClient.read(register.address, numBytes)).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readMultiple(I2cDeviceSynchSimple deviceClient, int numBytes) {
        Object object = i2cLock;
        synchronized (object) {
            return ByteBuffer.wrap(deviceClient.read(numBytes)).order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Enum<T>> EnumSet<T> read8Flags(I2cDeviceSynchSimple deviceClient, Register register, Class<T> enumClass) {
        Object object = i2cLock;
        synchronized (object) {
            return BHI260IMU.convertIntToEnumSet(BHI260IMU.read8(deviceClient, register), enumClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EnumSet<BootStatusFlag> readBootStatusFlags(I2cDeviceSynchSimple deviceClient) {
        Object object = i2cLock;
        synchronized (object) {
            return BHI260IMU.read8Flags(deviceClient, Register.BOOT_STATUS, BootStatusFlag.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write8(I2cDeviceSynchSimple deviceClient, Register register, int data, I2cWaitControl waitControl) {
        Object object = i2cLock;
        synchronized (object) {
            deviceClient.write8(register.address, data, waitControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Enum<T>> void write8Flags(I2cDeviceSynchSimple deviceClient, Register register, EnumSet<T> flags, I2cWaitControl waitControl) {
        Object object = i2cLock;
        synchronized (object) {
            BHI260IMU.write8(deviceClient, register, BHI260IMU.convertEnumSetToInt(flags), waitControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMultiple(I2cDeviceSynchSimple deviceClient, Register register, byte[] data) {
        Object object = i2cLock;
        synchronized (object) {
            deviceClient.write(register.address, data);
        }
    }

    private static void waitForHostInterface(I2cDeviceSynchSimple deviceClient) throws InitException {
        ElapsedTime timeoutTimer = new ElapsedTime();
        EnumSet<BootStatusFlag> bootStatusFlags = BHI260IMU.readBootStatusFlags(deviceClient);
        try {
            while (!bootStatusFlags.contains((Object)BootStatusFlag.HOST_INTERFACE_READY) && timeoutTimer.milliseconds() < 2000.0) {
                Thread.sleep(10L);
                bootStatusFlags = BHI260IMU.readBootStatusFlags(deviceClient);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InitException();
        }
        if (!bootStatusFlags.contains((Object)BootStatusFlag.HOST_INTERFACE_READY)) {
            RobotLog.ee((String)TAG, (String)"Timeout expired while waiting for IMU host interface to become ready. bootStatusFlags=%s", (Object[])new Object[]{bootStatusFlags});
            throw new InitException();
        }
    }

    private static void checkForFlashPresence(I2cDeviceSynchSimple deviceClient) throws InitException {
        EnumSet<BootStatusFlag> bootStatusFlags = BHI260IMU.readBootStatusFlags(deviceClient);
        if (!bootStatusFlags.contains((Object)BootStatusFlag.FLASH_DETECTED) || bootStatusFlags.contains((Object)BootStatusFlag.NO_FLASH)) {
            RobotLog.ee((String)TAG, (String)"IMU did not detect flash chip");
            throw new InitException();
        }
    }

    private static boolean waitForFlashVerification(I2cDeviceSynchSimple deviceClient) throws InitException {
        ElapsedTime timeoutTimer = new ElapsedTime();
        EnumSet<BootStatusFlag> bootStatusFlags = BHI260IMU.readBootStatusFlags(deviceClient);
        AppAliveNotifier.getInstance().notifyAppAlive();
        try {
            while (!bootStatusFlags.contains((Object)BootStatusFlag.FLASH_VERIFY_DONE) && timeoutTimer.milliseconds() < 1500.0) {
                if (bootStatusFlags.contains((Object)BootStatusFlag.FLASH_VERIFY_ERROR)) {
                    RobotLog.ee((String)TAG, (String)"Error verifying IMU firmware");
                    return false;
                }
                Thread.sleep(10L);
                bootStatusFlags = BHI260IMU.readBootStatusFlags(deviceClient);
            }
            if (!bootStatusFlags.contains((Object)BootStatusFlag.FLASH_VERIFY_DONE)) {
                RobotLog.ww((String)TAG, (String)"Timeout expired while waiting for IMU to load its firmware from flash");
                return false;
            }
            if (bootStatusFlags.contains((Object)BootStatusFlag.FLASH_VERIFY_ERROR)) {
                RobotLog.ee((String)TAG, (String)"Error verifying IMU firmware");
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InitException();
        }
    }

    private static void disableFifoTimestamps(I2cDeviceSynchSimple deviceClient) {
        BHI260IMU.sendCommand(deviceClient, CommandType.CONTROL_FIFO_FORMAT, new byte[]{3});
    }

    private static void sendCommand(I2cDeviceSynchSimple deviceClient, CommandType commandType, @Nullable byte[] payload) {
        if (payload == null) {
            payload = new byte[]{};
        }
        int totalLength = 4 + payload.length;
        int numPaddingBytes = 0;
        if (totalLength % 4 != 0) {
            numPaddingBytes = 4 - payload.length % 4;
            totalLength += numPaddingBytes;
        }
        if (totalLength > 99) {
            throw new IllegalArgumentException("sendCommand() called with too large of a payload. Update sendCommand() to break into multiple I2C writes");
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalLength).order(ByteOrder.LITTLE_ENDIAN).putShort((short)commandType.id).putShort((short)(totalLength - 4)).put(payload);
        if (numPaddingBytes > 0) {
            buffer.put(new byte[numPaddingBytes]);
        }
        BHI260IMU.writeMultiple(deviceClient, Register.COMMAND_INPUT, buffer.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatusPacket sendCommandAndWaitForResponse(I2cDeviceSynchSimple deviceClient, CommandType commandType, @Nullable byte[] payload, int responseTimeoutMs) throws CommandFailureException {
        statusAndDebugFifoModeManager.lockStatusAndDebugFifoMode(deviceClient, StatusAndDebugFifoMode.SYNCHRONOUS);
        try {
            BHI260IMU.sendCommand(deviceClient, commandType, payload);
            StatusPacket statusPacket = BHI260IMU.waitForCommandResponse(deviceClient, commandType, responseTimeoutMs);
            return statusPacket;
        }
        finally {
            statusAndDebugFifoModeManager.unlockStatusAndDebugFifoMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendWriteFlashCommandAndWaitForResponse(I2cDeviceSynchSimple deviceClient, int startAddress, int numFwBytesInCommand, ByteBuffer bytesSource) throws CommandFailureException {
        if (numFwBytesInCommand > 88) {
            throw new IllegalArgumentException("Tried to write too many bytes in a single Write Flash command");
        }
        AppAliveNotifier.getInstance().notifyAppAlive();
        int totalLengthOfCommand = 8 + numFwBytesInCommand;
        int numPaddingBytes = 0;
        if (totalLengthOfCommand % 4 != 0) {
            numPaddingBytes = 4 - numFwBytesInCommand % 4;
            totalLengthOfCommand += numPaddingBytes;
        }
        int numFwPlusPaddingBytes = numFwBytesInCommand + numPaddingBytes;
        ByteBuffer buffer = ByteBuffer.allocate(totalLengthOfCommand).order(ByteOrder.LITTLE_ENDIAN).putShort((short)CommandType.WRITE_FLASH.id);
        short writeFlashCommandLength = (short)(totalLengthOfCommand - 4);
        buffer.putShort(writeFlashCommandLength);
        buffer.putInt(startAddress);
        int bufferPositionFirmwareBytes = buffer.position();
        bytesSource.get(buffer.array(), bufferPositionFirmwareBytes, numFwBytesInCommand);
        buffer.position(8 + numFwBytesInCommand);
        if (numPaddingBytes > 0) {
            buffer.put(new byte[numPaddingBytes]);
        }
        statusAndDebugFifoModeManager.lockStatusAndDebugFifoMode(deviceClient, StatusAndDebugFifoMode.SYNCHRONOUS);
        try {
            BHI260IMU.writeMultiple(deviceClient, Register.COMMAND_INPUT, buffer.array());
            BHI260IMU.waitForCommandResponse(deviceClient, CommandType.WRITE_FLASH, 1000);
        }
        finally {
            statusAndDebugFifoModeManager.unlockStatusAndDebugFifoMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatusPacket waitForCommandResponse(I2cDeviceSynchSimple deviceClient, CommandType commandType, int timeoutMs) throws CommandFailureException {
        byte[] responsePayload;
        int responseStatusCode;
        block13: {
            EnumSet<InterruptStatusFlag> interruptStatusFlags;
            ElapsedTime timeoutTimer = new ElapsedTime();
            ElapsedTime notifyAppAliveTimer = new ElapsedTime();
            AppAliveNotifier.getInstance().notifyAppAlive();
            do {
                if (notifyAppAliveTimer.seconds() > 8.0) {
                    AppAliveNotifier.getInstance().notifyAppAlive();
                    notifyAppAliveTimer.reset();
                }
                if (timeoutTimer.milliseconds() >= (double)timeoutMs) {
                    throw new CommandFailureException(String.format(Locale.ENGLISH, "%dms timeout expired while waiting for response", timeoutMs));
                }
                interruptStatusFlags = BHI260IMU.read8Flags(deviceClient, Register.INTERRUPT_STATUS, InterruptStatusFlag.class);
                if (!interruptStatusFlags.contains((Object)InterruptStatusFlag.RESET_OR_FAULT) || commandType == CommandType.ERASE_FLASH) continue;
                RobotLog.ww((String)TAG, (String)"Reset or Fault interrupt status was set while waiting for %s response", (Object[])new Object[]{commandType});
                RobotLog.ww((String)TAG, (String)"Interrupt status: %s", (Object[])new Object[]{interruptStatusFlags});
                RobotLog.ww((String)TAG, (String)"Error value: 0x%X", (Object[])new Object[]{BHI260IMU.read8(deviceClient, Register.ERROR_VALUE)});
            } while (!interruptStatusFlags.contains((Object)InterruptStatusFlag.STATUS_STATUS));
            while (true) {
                if (notifyAppAliveTimer.seconds() > 8.0) {
                    AppAliveNotifier.getInstance().notifyAppAlive();
                    notifyAppAliveTimer.reset();
                }
                if (timeoutTimer.milliseconds() >= (double)timeoutMs) {
                    throw new CommandFailureException(String.format(Locale.ENGLISH, "%dms timeout expired while waiting for response", timeoutMs));
                }
                Object object = i2cLock;
                synchronized (object) {
                    ByteBuffer responseHeader = BHI260IMU.readMultiple(deviceClient, Register.STATUS_AND_DEBUG_FIFO_OUTPUT, 3);
                    responseStatusCode = TypeConversion.unsignedShortToInt((short)responseHeader.getShort());
                    int responsePayloadLength = TypeConversion.unsignedByteToInt((byte)responseHeader.get());
                    if (responsePayloadLength > 100) {
                        throw new RuntimeException(String.format(Locale.ENGLISH, "IMU sent payload that was too long (%d bytes)", responsePayloadLength));
                    }
                    responsePayload = responsePayloadLength == 0 ? new byte[]{} : BHI260IMU.readMultiple(deviceClient, responsePayloadLength).array();
                }
                if (responseStatusCode == commandType.successStatusCode) break block13;
                if (responseStatusCode != 0) break;
                RobotLog.ww((String)TAG, (String)"Received status code 0, trying again");
            }
            String errorMessage = null;
            if (responseStatusCode == 15) {
                CommandType erroredCommandType;
                CommandError commandError = null;
                int commandErrorCode = -1;
                int erroredCommandId = -1;
                if (responsePayload.length >= 3) {
                    ByteBuffer errorPayload = ByteBuffer.wrap(responsePayload).order(ByteOrder.LITTLE_ENDIAN);
                    erroredCommandId = TypeConversion.unsignedShortToInt((short)errorPayload.getShort());
                    commandErrorCode = TypeConversion.unsignedByteToInt((byte)errorPayload.get());
                    commandError = CommandError.fromInt(commandErrorCode);
                }
                String erroredCommandDesc = erroredCommandId == commandType.id ? (Object)((Object)commandType) + " command" : ((erroredCommandType = CommandType.findById(erroredCommandId)) == null ? String.format(Locale.US, "unknown command 0x%4X (just sent %s command)", new Object[]{erroredCommandId, commandType}) : String.format(Locale.US, "%s command (just sent %s command)", new Object[]{erroredCommandType, commandType}));
                errorMessage = commandError == null ? String.format(Locale.US, "Received unknown Command Error code 0x%2X in response to %s", commandErrorCode, erroredCommandDesc) : String.format(Locale.US, "Received Command Error %s in response to %s", new Object[]{commandError, erroredCommandDesc});
            }
            if (errorMessage == null) {
                errorMessage = String.format(Locale.US, "Received unexpected response status 0x%X for %s command", new Object[]{responseStatusCode, commandType});
            }
            throw new CommandFailureException(errorMessage);
        }
        return new StatusPacket(responseStatusCode, responsePayload);
    }

    private void configureSensor(Sensor sensor, float sampleRateHz, int latencyMs) {
        if (latencyMs > 0xFFFFFF) {
            throw new IllegalArgumentException("Sensor latency must be less than 1,6777,215 milliseconds");
        }
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).put((byte)sensor.id).putFloat(sampleRateHz);
        byte[] latency4Bytes = TypeConversion.intToByteArray((int)latencyMs, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        buffer.put(latency4Bytes, 0, 3);
        BHI260IMU.sendCommand(this.deviceClient, CommandType.CONFIGURE_SENSOR, buffer.array());
    }

    private void setSensorDynamicRange(Sensor sensor, int maxSensorValue) {
        if (maxSensorValue > 65535) {
            throw new IllegalArgumentException("Sensor dynamic range must be less than 65,535");
        }
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).put((byte)sensor.id).putShort((short)maxSensorValue).put((byte)0);
        BHI260IMU.sendCommand(this.deviceClient, CommandType.CHANGE_SENSOR_DYNAMIC_RANGE, buffer.array());
    }

    private static <T extends Enum<T>> EnumSet<T> convertIntToEnumSet(int value, Class<T> enumClass) {
        EnumSet<T> flags = EnumSet.noneOf(enumClass);
        for (Enum flag : (Enum[])enumClass.getEnumConstants()) {
            if ((1 << flag.ordinal() & value) != 1 << flag.ordinal()) continue;
            flags.add(flag);
        }
        return flags;
    }

    private static <T extends Enum<T>> int convertEnumSetToInt(EnumSet<T> enumSet) {
        int result = 0;
        for (Enum flag : enumSet) {
            result |= 1 << flag.ordinal();
        }
        return result;
    }

    private static void printByteBuffer(String tag, ByteBuffer buffer, boolean printFromBeginning) {
        String contentsString;
        int length;
        int initialPosition = buffer.position();
        if (printFromBeginning) {
            buffer.position(0);
        }
        if ((length = buffer.remaining()) > 0) {
            StringBuilder stringBuilder = new StringBuilder(String.format("%X", buffer.get()));
            while (buffer.hasRemaining()) {
                stringBuilder.append(String.format("-%X", buffer.get()));
            }
            contentsString = stringBuilder.toString();
        } else {
            contentsString = "[]";
        }
        RobotLog.dd((String)TAG, (String)"%s (%d bytes): %s", (Object[])new Object[]{tag, length, contentsString});
        buffer.position(initialPosition);
    }

    private static void printByteBuffer(String tag, ByteBuffer buffer) {
        BHI260IMU.printByteBuffer(tag, buffer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFifo(I2cDeviceSynchSimple deviceClient, Fifo fifo) {
        ByteBuffer fifoContents;
        Object object = i2cLock;
        synchronized (object) {
            ByteBuffer fifoDescriptor = BHI260IMU.readMultiple(deviceClient, fifo.register, 3);
            int fifoTransferLength = TypeConversion.unsignedShortToInt((short)fifoDescriptor.getShort());
            if (fifoTransferLength == 0) {
                RobotLog.ww((String)TAG, (String)"Attempted to read empty %s FIFO", (Object[])new Object[]{fifo});
                return;
            }
            int remainingBytes = fifoTransferLength - 4;
            if (remainingBytes <= 100) {
                fifoContents = BHI260IMU.readMultiple(deviceClient, remainingBytes - 1);
            } else {
                int discardFlushValue;
                HostInterfaceControlFlag abortFlag;
                fifoContents = BHI260IMU.readMultiple(deviceClient, 100);
                RobotLog.ww((String)TAG, (String)"FIFO was too large. Aborting transfer and discarding data.");
                switch (fifo) {
                    case WAKE_UP: {
                        abortFlag = HostInterfaceControlFlag.ABORT_TRANSFER_CHANNEL_1;
                        discardFlushValue = -5;
                        break;
                    }
                    case NON_WAKE_UP: {
                        abortFlag = HostInterfaceControlFlag.ABORT_TRANSFER_CHANNEL_2;
                        discardFlushValue = -6;
                        break;
                    }
                    default: {
                        abortFlag = HostInterfaceControlFlag.ABORT_TRANSFER_CHANNEL_3;
                        discardFlushValue = -7;
                    }
                }
                EnumSet<HostInterfaceControlFlag> hostInterfaceControlFlags = BHI260IMU.read8Flags(deviceClient, Register.HOST_INTERFACE_CONTROL, HostInterfaceControlFlag.class);
                hostInterfaceControlFlags.add(abortFlag);
                BHI260IMU.write8Flags(deviceClient, Register.HOST_INTERFACE_CONTROL, hostInterfaceControlFlags, I2cWaitControl.ATOMIC);
                byte[] flushPayload = new byte[4];
                flushPayload[0] = discardFlushValue;
                BHI260IMU.sendCommand(deviceClient, CommandType.FIFO_FLUSH, flushPayload);
            }
        }
        while (fifoContents.hasRemaining()) {
            NonSensorEventType eventType;
            int eventId = TypeConversion.unsignedByteToInt((byte)fifoContents.get());
            if (eventId != 0 && eventId < 224) {
                RobotLog.ww((String)TAG, (String)"%s FIFO contained sensor data", (Object[])new Object[]{fifo});
                int sensorPayloadLength = -1;
                if (sensorPayloadLength > 0) {
                    try {
                        byte[] tmp = new byte[sensorPayloadLength];
                        fifoContents.get(tmp);
                    }
                    catch (BufferUnderflowException e) {
                        byte[] tmp = new byte[sensorPayloadLength - 1];
                        fifoContents.get(tmp);
                    }
                    continue;
                }
            }
            if ((eventType = NonSensorEventType.findById(eventId)) == null) {
                RobotLog.ee((String)TAG, (String)"%s FIFO contained unknown event ID %d. Unable to process the rest of the FIFO's contents", (Object[])new Object[]{fifo, eventId});
                return;
            }
            try {
                switch (eventType) {
                    case DEBUG_DATA: {
                        BHI260IMU.printDebugData(fifoContents);
                        break;
                    }
                    case TIMESTAMP_SMALL_DELTA: {
                        fifoContents.get();
                        break;
                    }
                    case TIMESTAMP_LARGE_DELTA: {
                        fifoContents.getShort();
                        break;
                    }
                    case TIMESTAMP_FULL: {
                        byte[] temp = new byte[5];
                        fifoContents.get(temp);
                        break;
                    }
                    case META_EVENT: {
                        BHI260IMU.parseMetaEvent(fifoContents, fifo);
                        break;
                    }
                    case FILLER: {
                        break;
                    }
                    case PADDING: {
                        return;
                    }
                    default: {
                        RobotLog.ee((String)TAG, (String)"No handler is defined for event type %s", (Object[])new Object[]{eventType});
                        return;
                    }
                }
            }
            catch (BufferUnderflowException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"BufferUnderflowException was caught at the top level of readFifo(). It should be caught closer to where it was thrown so that it can be handled more intelligently.");
                return;
            }
        }
    }

    private static void startDiagnosticMode() {
        if (diagnosticModeThread == null) {
            diagnosticModeThread = new Thread(new Runnable(){
                private I2cDeviceSynchSimple deviceClient;

                @Override
                public void run() {
                    RobotLog.vv((String)BHI260IMU.TAG, (String)"Diagnostic mode thread started");
                    boolean fifoTimestampsDisabled = false;
                    int previousErrorValue = 0;
                    while (!Thread.currentThread().isInterrupted()) {
                        int errorValue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (!this.refreshDeviceClient()) continue;
                        if (!fifoTimestampsDisabled) {
                            BHI260IMU.disableFifoTimestamps(this.deviceClient);
                            fifoTimestampsDisabled = true;
                        }
                        if ((errorValue = BHI260IMU.read8(this.deviceClient, Register.ERROR_VALUE)) != previousErrorValue) {
                            if (errorValue == 0) {
                                RobotLog.vv((String)BHI260IMU.TAG, (String)"Error cleared");
                            } else {
                                RobotLog.ww((String)BHI260IMU.TAG, (String)"Error value: 0x%X", (Object[])new Object[]{errorValue});
                            }
                        }
                        previousErrorValue = errorValue;
                    }
                }

                private boolean refreshDeviceClient() {
                    if (this.deviceClient == null || this.deviceClient.getHealthStatus() == HardwareDeviceHealth.HealthStatus.CLOSED) {
                        LynxModule embeddedControlHubModule = (LynxModule)EmbeddedControlHubModule.get();
                        if (embeddedControlHubModule == null || !embeddedControlHubModule.isOpen()) {
                            this.deviceClient = null;
                            return false;
                        }
                        this.deviceClient = LynxFirmwareVersionManager.createLynxI2cDeviceSynch((Context)AppUtil.getDefContext(), embeddedControlHubModule, 0);
                        this.deviceClient.setI2cAddress(I2C_ADDR);
                        return true;
                    }
                    return true;
                }
            });
            diagnosticModeThread.setName("Diagnostic mode thread");
            diagnosticModeThread.start();
        }
    }

    private static void printDebugData(ByteBuffer fifoContents) {
        int sensorId = TypeConversion.unsignedByteToInt((byte)fifoContents.get());
        int flags = TypeConversion.unsignedByteToInt((byte)fifoContents.get());
        int validLength = flags & 0x3F;
        boolean isBinary = (flags & 0x40) > 0;
        byte[] data = new byte[16];
        fifoContents.get(data);
        byte[] validData = Arrays.copyOfRange(data, 0, validLength);
        String tag = String.format(Locale.ENGLISH, "Debug data (sensor %d)", sensorId);
        if (isBinary) {
            BHI260IMU.printByteBuffer(tag, ByteBuffer.wrap(validData));
        } else {
            RobotLog.dd((String)TAG, (String)"%s: %s", (Object[])new Object[]{tag, new String(validData, StandardCharsets.UTF_8)});
        }
    }

    private static void parseMetaEvent(ByteBuffer fifoContents, Fifo fifo) {
        int metaEventType = TypeConversion.unsignedByteToInt((byte)fifoContents.get());
        byte[] payload = new byte[2];
        try {
            fifoContents.get(payload);
        }
        catch (BufferUnderflowException e) {
            byte firstPayloadByte = fifoContents.get();
            payload = new byte[]{firstPayloadByte, -1};
        }
        int firstByteUnsigned = TypeConversion.unsignedByteToInt((byte)payload[0]);
        int secondByteUnsigned = TypeConversion.unsignedByteToInt((byte)payload[1]);
        switch (metaEventType) {
            case 1: {
                RobotLog.vv((String)TAG, (String)"Sensor %d flush complete", (Object[])new Object[]{firstByteUnsigned});
                break;
            }
            case 2: {
                RobotLog.vv((String)TAG, (String)"Sensor %d sample rate changed", (Object[])new Object[]{firstByteUnsigned});
                break;
            }
            case 3: {
                RobotLog.vv((String)TAG, (String)"Sensor %d power mode is now %d", (Object[])new Object[]{firstByteUnsigned, secondByteUnsigned});
                break;
            }
            case 4: {
                RobotLog.vv((String)TAG, (String)"IMU system error. errorCode=0x%X interruptStatus=%s", (Object[])new Object[]{firstByteUnsigned, BHI260IMU.convertIntToEnumSet(secondByteUnsigned, InterruptStatusFlag.class)});
                break;
            }
            case 6: {
                String accuracy = "unknown";
                if (secondByteUnsigned == 0) {
                    accuracy = "unreliable";
                } else if (secondByteUnsigned == 1) {
                    accuracy = "low";
                } else if (secondByteUnsigned == 2) {
                    accuracy = "medium";
                } else if (secondByteUnsigned == 3) {
                    accuracy = "high";
                }
                RobotLog.vv((String)TAG, (String)"Sensor %d accuracy is now \"%s\"", (Object[])new Object[]{firstByteUnsigned, accuracy});
                break;
            }
            case 11: {
                RobotLog.vv((String)TAG, (String)"Sensor %d experienced an error. errorCode=0x%X", (Object[])new Object[]{firstByteUnsigned, secondByteUnsigned});
                break;
            }
            case 12: {
                RobotLog.vv((String)TAG, (String)"FIFO %s overflowed", (Object[])new Object[]{fifo});
                byte[] temp = new byte[5];
                fifoContents.get(temp);
                break;
            }
            case 13: {
                RobotLog.vv((String)TAG, (String)"Sensor %d dynamic range changed", (Object[])new Object[]{firstByteUnsigned});
                break;
            }
            case 14: {
                RobotLog.ww((String)TAG, (String)"FIFO %s has reached its watermark level", (Object[])new Object[]{fifo});
                break;
            }
            case 16: {
                RobotLog.vv((String)TAG, (String)"Firmware has finished initializing");
                break;
            }
            case 17: {
                RobotLog.ww((String)TAG, (String)"Unexpectedly received a Transfer Cause event for sensor %d", (Object[])new Object[]{firstByteUnsigned});
                break;
            }
            case 18: {
                String error = "unknown";
                if (secondByteUnsigned == 1) {
                    error = "Trigger was delayed";
                } else if (secondByteUnsigned == 2) {
                    error = "Trigger was dropped";
                } else if (secondByteUnsigned == 3) {
                    error = "Hang detection disabled";
                } else if (secondByteUnsigned == 4) {
                    error = "Parent is not enabled";
                }
                RobotLog.ww((String)TAG, (String)"Software Framework error for sensor %d: %s", (Object[])new Object[]{firstByteUnsigned, error});
                break;
            }
            case 19: {
                String cause = "unknown";
                boolean warn = false;
                if (secondByteUnsigned == 0) {
                    cause = "Power-on reset";
                } else if (secondByteUnsigned == 1) {
                    cause = "External reset";
                } else if (secondByteUnsigned == 2) {
                    cause = "Host commanded reset";
                } else if (secondByteUnsigned == 4) {
                    cause = "Watchdog reset";
                    warn = true;
                }
                String log = "IMU was reset: %s";
                if (warn) {
                    RobotLog.ww((String)TAG, (String)log, (Object[])new Object[]{cause});
                    break;
                }
                RobotLog.vv((String)TAG, (String)log, (Object[])new Object[]{cause});
                break;
            }
            case 20: {
                break;
            }
            default: {
                RobotLog.ww((String)TAG, (String)"Received unknown meta event type %d", (Object[])new Object[]{metaEventType});
            }
        }
    }

    static {
        i2cLock = new Object();
        genPurposeRegisterDataRetrievalLock = new Object();
    }

    private static class StatusAndDebugFifoModeManager {
        private final boolean DEBUG = false;
        @Nullable
        private StatusAndDebugFifoMode statusAndDebugFifoMode = null;
        private final ReentrantLock operationInProgressLock = new ReentrantLock();

        private StatusAndDebugFifoModeManager() {
        }

        public void lockStatusAndDebugFifoMode(I2cDeviceSynchSimple deviceClient, StatusAndDebugFifoMode mode) {
            this.operationInProgressLock.lock();
            if (this.statusAndDebugFifoMode == null) {
                EnumSet hostInterfaceControlStatus = BHI260IMU.read8Flags(deviceClient, Register.HOST_INTERFACE_CONTROL, HostInterfaceControlFlag.class);
                this.statusAndDebugFifoMode = hostInterfaceControlStatus.contains((Object)HostInterfaceControlFlag.ASYNC_STATUS_CHANNEL) ? StatusAndDebugFifoMode.ASYNCHRONOUS : StatusAndDebugFifoMode.SYNCHRONOUS;
                RobotLog.vv((String)BHI260IMU.TAG, (String)"Initial Status and Debug FIFO mode: %s", (Object[])new Object[]{this.statusAndDebugFifoMode});
            }
            if (this.statusAndDebugFifoMode != mode) {
                this.statusAndDebugFifoMode = mode;
                EnumSet<HostInterfaceControlFlag> hostInterfaceControlFlags = EnumSet.noneOf(HostInterfaceControlFlag.class);
                if (mode == StatusAndDebugFifoMode.ASYNCHRONOUS) {
                    hostInterfaceControlFlags.add(HostInterfaceControlFlag.ASYNC_STATUS_CHANNEL);
                }
                BHI260IMU.write8Flags(deviceClient, Register.HOST_INTERFACE_CONTROL, hostInterfaceControlFlags, I2cWaitControl.ATOMIC);
            }
        }

        public void unlockStatusAndDebugFifoMode() {
            this.operationInProgressLock.unlock();
        }
    }

    private static class StatusPacket {
        public final int statusCode;
        public final byte[] payload;

        private StatusPacket(int statusCode, byte[] payload) {
            this.statusCode = statusCode;
            this.payload = payload;
        }
    }

    private static class CommandFailureException
    extends Exception {
        public CommandFailureException(String message) {
            super(message);
        }
    }

    private static class InitException
    extends Exception {
        private InitException() {
        }
    }

    private static enum HostInterfaceControlFlag {
        ABORT_TRANSFER_CHANNEL_0,
        ABORT_TRANSFER_CHANNEL_1,
        ABORT_TRANSFER_CHANNEL_2,
        ABORT_TRANSFER_CHANNEL_3,
        APPLICATION_PROCESSOR_SUSPENDED,
        RESERVED,
        TIMESTAMP_EVENT_REQUEST,
        ASYNC_STATUS_CHANNEL;

    }

    private static enum InterruptStatusFlag {
        HOST_INTERRUPT_ASSERTED,
        WAKE_UP_FIFO_STATUS_1,
        WAKE_UP_FIFO_STATUS_2,
        NON_WAKE_UP_FIFO_STATUS_1,
        NON_WAKE_UP_FIFO_STATUS_2,
        STATUS_STATUS,
        DEBUG_STATUS,
        RESET_OR_FAULT;

    }

    private static enum BootStatusFlag {
        FLASH_DETECTED,
        FLASH_VERIFY_DONE,
        FLASH_VERIFY_ERROR,
        NO_FLASH,
        HOST_INTERFACE_READY,
        FIRMWARE_VERIFY_DONE,
        FIRMWARE_VERIFY_ERROR,
        FIRMWARE_HALTED;

    }

    private static enum Sensor {
        GAME_ROTATION_VECTOR_WAKE_UP(38),
        GAME_ROTATION_VECTOR_DATA_HOLDER(176),
        GAME_ROTATION_VECTOR_GPIO_HANDLER(177),
        GYROSCOPE_CORRECTED_DATA_HOLDER(178),
        GYROSCOPE_CORRECTED_GPIO_HANDLER(179);

        private final int id;

        private Sensor(int id) {
            this.id = id;
        }
    }

    private static enum CommandError {
        INCORRECT_LENGTH(1),
        TOO_LONG(2),
        PARAM_WRITE_ERROR(3),
        PARAM_READ_ERROR(4),
        INVALID_COMMAND(5),
        INVALID_PARAM(6),
        COMMAND_FAILED(255);

        private final int value;

        private CommandError(int value) {
            this.value = value;
        }

        @Nullable
        public static CommandError fromInt(int intValue) {
            for (CommandError value : CommandError.values()) {
                if (intValue != value.value) continue;
                return value;
            }
            return null;
        }
    }

    private static enum CommandType {
        ERASE_FLASH(4, 10),
        WRITE_FLASH(5, 11),
        BOOT_FLASH(6, 0),
        FIFO_FLUSH(9, 0),
        CONFIGURE_SENSOR(13, 0),
        CHANGE_SENSOR_DYNAMIC_RANGE(14, 0),
        CONTROL_FIFO_FORMAT(21, 0);

        private final int id;
        private final int successStatusCode;

        private CommandType(int id, int successStatusCode) {
            this.id = id;
            this.successStatusCode = successStatusCode;
        }

        @Nullable
        public static CommandType findById(int id) {
            for (CommandType commandType : CommandType.values()) {
                if (commandType.id != id) continue;
                return commandType;
            }
            return null;
        }
    }

    private static enum NonSensorEventType {
        DEBUG_DATA(250, -1),
        TIMESTAMP_SMALL_DELTA(251, 245),
        TIMESTAMP_LARGE_DELTA(252, 246),
        TIMESTAMP_FULL(253, 247),
        META_EVENT(254, 248),
        FILLER(255, 255),
        PADDING(0, 0);

        final int nonWakeUpId;
        final int wakeUpId;

        private NonSensorEventType(int nonWakeUpId, int wakeUpId) {
            this.wakeUpId = wakeUpId;
            this.nonWakeUpId = nonWakeUpId;
        }

        @Nullable
        public static NonSensorEventType findById(int id) {
            for (NonSensorEventType event : NonSensorEventType.values()) {
                if (event.nonWakeUpId != id && event.wakeUpId != id) continue;
                return event;
            }
            return null;
        }
    }

    private static enum StatusAndDebugFifoMode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    private static enum Fifo {
        WAKE_UP(Register.WAKE_UP_FIFO_OUTPUT),
        NON_WAKE_UP(Register.NON_WAKE_UP_FIFO_OUTPUT),
        STATUS_AND_DEBUG(Register.STATUS_AND_DEBUG_FIFO_OUTPUT);

        private final Register register;

        private Fifo(Register register) {
            this.register = register;
        }
    }

    private static enum Register {
        COMMAND_INPUT(0),
        WAKE_UP_FIFO_OUTPUT(1),
        NON_WAKE_UP_FIFO_OUTPUT(2),
        STATUS_AND_DEBUG_FIFO_OUTPUT(3),
        CHIP_CONTROL(5),
        HOST_INTERFACE_CONTROL(6),
        HOST_INTERRUPT_CONTROL(7),
        RESET_REQUEST(20),
        TIMESTAMP_EVENT_REQUEST(21),
        HOST_CONTROL(22),
        HOST_STATUS(23),
        PRODUCT_IDENTIFIER(28),
        REVISION_IDENTIFIER(29),
        ROM_VERSION(30),
        KERNEL_VERSION(32),
        USER_VERSION(34),
        FEATURE_STATUS(36),
        BOOT_STATUS(37),
        CHIP_ID(43),
        INTERRUPT_STATUS(45),
        ERROR_VALUE(46),
        GEN_PURPOSE_READ(50);

        private final int address;

        private Register(int address) {
            this.address = address;
        }
    }
}

