/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.bosch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.bosch.BNO055IMU;
import com.qualcomm.robotcore.util.RobotLog;
import org.firstinspires.ftc.robotcore.external.navigation.Acceleration;
import org.firstinspires.ftc.robotcore.external.navigation.NavUtil;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.Velocity;

public class NaiveAccelerationIntegrator
implements BNO055IMU.AccelerationIntegrator {
    BNO055IMU.Parameters parameters = null;
    Position position = new Position();
    Velocity velocity = new Velocity();
    Acceleration acceleration = null;

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Velocity getVelocity() {
        return this.velocity;
    }

    @Override
    public Acceleration getAcceleration() {
        return this.acceleration;
    }

    NaiveAccelerationIntegrator() {
    }

    @Override
    public void initialize(@NonNull BNO055IMU.Parameters parameters, @Nullable Position initialPosition, @Nullable Velocity initialVelocity) {
        this.parameters = parameters;
        this.position = initialPosition != null ? initialPosition : this.position;
        this.velocity = initialVelocity != null ? initialVelocity : this.velocity;
        this.acceleration = null;
    }

    @Override
    public void update(Acceleration linearAcceleration) {
        if (linearAcceleration.acquisitionTime != 0L) {
            if (this.acceleration != null) {
                Acceleration accelPrev = this.acceleration;
                Velocity velocityPrev = this.velocity;
                this.acceleration = linearAcceleration;
                if (accelPrev.acquisitionTime != 0L) {
                    Velocity deltaVelocity = NavUtil.meanIntegrate((Acceleration)this.acceleration, (Acceleration)accelPrev);
                    this.velocity = NavUtil.plus((Velocity)this.velocity, (Velocity)deltaVelocity);
                }
                if (velocityPrev.acquisitionTime != 0L) {
                    Position deltaPosition = NavUtil.meanIntegrate((Velocity)this.velocity, (Velocity)velocityPrev);
                    this.position = NavUtil.plus((Position)this.position, (Position)deltaPosition);
                }
                if (this.parameters != null && this.parameters.loggingEnabled) {
                    RobotLog.vv((String)this.parameters.loggingTag, (String)"dt=%.3fs accel=%s vel=%s pos=%s", (Object[])new Object[]{(double)(this.acceleration.acquisitionTime - accelPrev.acquisitionTime) * 1.0E-9, this.acceleration, this.velocity, this.position});
                }
            } else {
                this.acceleration = linearAcceleration;
            }
        }
    }
}

