/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.broadcom;

import com.qualcomm.robotcore.hardware.ColorSensor;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynch;
import com.qualcomm.robotcore.hardware.NormalizedColorSensor;

public interface BroadcomColorSensor
extends ColorSensor,
NormalizedColorSensor {
    public static final I2cAddr BROADCOM_APDS9151_ADDRESS = I2cAddr.create7bit((int)82);
    public static final byte BROADCOM_APDS9151_ID = -62;

    public boolean initialize(Parameters var1);

    public Parameters getParameters();

    public byte getDeviceID();

    public byte read8(Register var1);

    public byte[] read(Register var1, int var2);

    public void write8(Register var1, int var2);

    public void write(Register var1, byte[] var2);

    public static enum LSMeasurementRate {
        R25ms(0),
        R50ms(1),
        R100ms(2),
        R200ms(3),
        R500ms(4),
        R1000ms(5),
        R2000ms_1(6),
        R2000ms_2(7);

        public final byte bVal;

        public byte bitOr(PSMeasurementRate him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private LSMeasurementRate(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum LSResolution {
        R20BIT(0),
        R19BIT(1),
        R18BIT(2),
        R17BIT(3),
        R16BIT(4),
        R13BIT(5),
        RES_1(6),
        RES_2(7);

        public final byte bVal;

        public byte bitOr(LSResolution him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private LSResolution(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum PSMeasurementRate {
        RES(0),
        R6_25ms(1),
        R12_5ms(2),
        R25ms(3),
        R50ms(4),
        R100ms(5),
        R200ms(6),
        R400ms(7);

        public final byte bVal;

        public byte bitOr(PSMeasurementRate him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private PSMeasurementRate(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum PSResolution {
        R8BIT(0),
        R9BIT(1),
        R10BIT(2),
        R11BIT(3);

        public final byte bVal;

        public byte bitOr(PSResolution him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private PSResolution(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum LEDPulseModulation {
        RES0(0),
        RES1(1),
        RES2(2),
        LED_PULSE_60kHz(3),
        LED_PULSE_70kHz(4),
        LED_PULSE_80kHz(5),
        LED_PULSE_90kHz(6),
        LED_PULSE_100kHz(7);

        public final byte bVal;

        public byte bitOr(LEDPulseModulation him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private LEDPulseModulation(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum LEDCurrent {
        CURRENT_2_5mA(0),
        CURRENT_5mA(1),
        CURRENT_10mA(2),
        CURRENT_25mA(3),
        CURRENT_50mA(4),
        CURRENT_75mA(5),
        CURRENT_100mA(6),
        CURRENT_125mA(7);

        public final byte bVal;

        public byte bitOr(LEDCurrent him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private LEDCurrent(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum Gain {
        UNKNOWN(-1),
        GAIN_1(0),
        GAIN_3(1),
        GAIN_6(2),
        GAIN_9(3),
        GAIN_18(4);

        public final byte bVal;

        private Gain(int i) {
            this.bVal = (byte)i;
        }

        public static Gain fromByte(byte byteVal) {
            for (Gain value : Gain.values()) {
                if (value.bVal != byteVal) continue;
                return value;
            }
            return UNKNOWN;
        }
    }

    public static enum MainStatus {
        POWER_ON_STATUS(32),
        LS_INT_STAT(16),
        LS_DATA_STATUS(8),
        PS_LOGIC_SIG_STAT(4),
        PS_INT_STAT(2),
        PS_DATA_STAT(1);

        public final byte bVal;

        public byte bitOr(MainStatus him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private MainStatus(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum MainControl {
        RES7(128),
        SAI_PS(64),
        SAI_LS(32),
        SW_RESET(16),
        RES3(8),
        RGB_MODE(4),
        LS_EN(2),
        PS_EN(1),
        OFF(0);

        public final byte bVal;

        public byte bitOr(MainControl him) {
            return (byte)(this.bVal | him.bVal);
        }

        public byte bitOr(byte him) {
            return (byte)(this.bVal | him);
        }

        private MainControl(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum Register {
        MAIN_CTRL(0),
        PS_LED(1),
        PS_PULSES(2),
        PS_MEAS_RATE(3),
        LS_MEAS_RATE(4),
        LS_GAIN(5),
        PART_ID(6),
        MAIN_STATUS(7),
        PS_DATA(8),
        LS_DATA_IR(10),
        LS_DATA_GREEN(13),
        LS_DATA_BLUE(16),
        LS_DATA_RED(19),
        INT_CFG(25),
        INT_PST(26),
        PS_THRES_UP(27),
        PS_THRES_LOW(30),
        PS_CAN(31),
        LS_THRES_UP(33),
        LS_THRES_LOW(36),
        LS_THRES_VAR(39),
        READ_WINDOW_FIRST(Register.PS_DATA.bVal),
        READ_WINDOW_LAST(Register.LS_DATA_RED.bVal + 1);

        public final byte bVal;

        private Register(int i) {
            this.bVal = (byte)i;
        }
    }

    public static class Parameters
    implements Cloneable {
        public int deviceId;
        public I2cAddr i2cAddr;
        public Gain gain = Gain.GAIN_3;
        public int proximityPulseCount = 32;
        public static PSResolution proximityResolution = PSResolution.R11BIT;
        public PSMeasurementRate proximityMeasRate = PSMeasurementRate.R100ms;
        public static LSResolution lightSensorResolution = LSResolution.R16BIT;
        public LSMeasurementRate lightSensorMeasRate = LSMeasurementRate.R100ms;
        public LEDCurrent ledCurrent = LEDCurrent.CURRENT_125mA;
        public int proximitySaturation = 2047;
        public int colorSaturation = 65535;
        public LEDPulseModulation pulseModulation = LEDPulseModulation.LED_PULSE_60kHz;
        public boolean loggingEnabled = false;
        public String loggingTag = "BroadcomColorSensor";
        public I2cDeviceSynch.ReadWindow readWindow;

        public Parameters(I2cAddr i2cAddr, int deviceId) {
            this.readWindow = new I2cDeviceSynch.ReadWindow((int)Register.READ_WINDOW_FIRST.bVal, Register.READ_WINDOW_LAST.bVal - Register.READ_WINDOW_FIRST.bVal + 1, I2cDeviceSynch.ReadMode.REPEAT);
            this.i2cAddr = i2cAddr;
            this.deviceId = deviceId;
        }

        public static Parameters createForAPDS9151() {
            return new Parameters(BROADCOM_APDS9151_ADDRESS, -62);
        }

        public Parameters clone() {
            try {
                return (Parameters)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("internal error: Parameters not cloneable");
            }
        }
    }
}

