/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.digitalchickenlabs;

public interface OctoQuadBase {
    public static final byte OCTOQUAD_CHIP_ID = 81;
    public static final int SUPPORTED_FW_VERSION_MAJ = 2;
    public static final int ENCODER_FIRST = 0;
    public static final int ENCODER_LAST = 7;
    public static final int NUM_ENCODERS = 8;
    public static final int MIN_VELOCITY_MEASUREMENT_INTERVAL_MS = 1;
    public static final int MAX_VELOCITY_MEASUREMENT_INTERVAL_MS = 255;
    public static final int MIN_PULSE_WIDTH_US = 1;
    public static final int MAX_PULSE_WIDTH_US = 65535;

    public byte getChipId();

    public String getFirmwareVersionString();

    public void resetSinglePosition(int var1);

    public void resetAllPositions();

    public void setSingleEncoderDirection(int var1, EncoderDirection var2);

    public EncoderDirection getSingleEncoderDirection(int var1);

    public void setSingleVelocitySampleInterval(int var1, int var2);

    public void setAllVelocitySampleIntervals(int var1);

    public int getSingleVelocitySampleInterval(int var1);

    public void setSingleChannelPulseWidthParams(int var1, int var2, int var3);

    public void resetEverything();

    public void setChannelBankConfig(ChannelBankConfig var1);

    public ChannelBankConfig getChannelBankConfig();

    public void setI2cRecoveryMode(I2cRecoveryMode var1);

    public I2cRecoveryMode getI2cRecoveryMode();

    public void saveParametersToFlash();

    public static enum I2cRecoveryMode {
        NONE(0),
        MODE_1_PERIPH_RST_ON_FRAME_ERR(1),
        MODE_2_M1_PLUS_SCL_IDLE_ONESHOT_TGL(2);

        public byte bVal;

        private I2cRecoveryMode(int bVal) {
            this.bVal = (byte)bVal;
        }
    }

    public static enum ChannelBankConfig {
        ALL_QUADRATURE(0),
        ALL_PULSE_WIDTH(1),
        BANK1_QUADRATURE_BANK2_PULSE_WIDTH(2);

        public byte bVal;

        private ChannelBankConfig(int bVal) {
            this.bVal = (byte)bVal;
        }
    }

    public static enum EncoderDirection {
        FORWARD,
        REVERSE;

    }
}

