/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.digitalchickenlabs;

import com.qualcomm.hardware.digitalchickenlabs.CachingOctoQuad;
import com.qualcomm.hardware.digitalchickenlabs.OctoQuad;
import com.qualcomm.hardware.digitalchickenlabs.OctoQuadBase;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.configuration.annotations.DeviceProperties;
import com.qualcomm.robotcore.hardware.configuration.annotations.I2cDeviceType;
import com.qualcomm.robotcore.util.Range;
import com.qualcomm.robotcore.util.RobotLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@I2cDeviceType
@DeviceProperties(xmlTag="OctoQuadFTC", name="OctoQuadFTC")
public class OctoQuadImpl
extends I2cDeviceSynchDevice<I2cDeviceSynchSimple>
implements OctoQuad,
CachingOctoQuad {
    private static final int I2C_ADDRESS = 48;
    private static final ByteOrder OCTOQUAD_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    private static final byte CMD_SET_PARAM = 1;
    private static final byte CMD_READ_PARAM = 2;
    private static final byte CMD_WRITE_PARAMS_TO_FLASH = 3;
    private static final byte CMD_RESET_EVERYTHING = 20;
    private static final byte CMD_RESET_ENCODERS = 21;
    private static final byte PARAM_ENCODER_DIRECTIONS = 0;
    private static final byte PARAM_I2C_RECOVERY_MODE = 1;
    private static final byte PARAM_CHANNEL_BANK_CONFIG = 2;
    private static final byte PARAM_CHANNEL_VEL_INTVL = 3;
    private static final byte PARAM_CHANNEL_PULSE_WIDTH_MIN_MAX = 4;
    private byte directionRegisterData = 0;
    private boolean isInitialized = false;
    protected CachingOctoQuad.CachingMode cachingMode = CachingOctoQuad.CachingMode.AUTO;
    protected OctoQuad.EncoderDataBlock cachedData = new OctoQuad.EncoderDataBlock();
    protected boolean[] posHasBeenRead = new boolean[8];
    protected boolean[] velHasBeenRead = new boolean[8];

    public OctoQuadImpl(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(deviceClient, deviceClientIsOwned);
        this.deviceClient.setI2cAddress(I2cAddr.create7bit((int)48));
        super.registerArmingStateCallback(false);
    }

    protected boolean doInitialize() {
        ((LynxI2cDeviceSynch)this.deviceClient).setBusSpeed(LynxI2cDeviceSynch.BusSpeed.FAST_400K);
        this.isInitialized = false;
        this.verifyInitialization();
        return true;
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.DigitalChickenLabs;
    }

    public String getDeviceName() {
        return "OctoQuadFTC";
    }

    @Override
    public byte getChipId() {
        return this.readRegister(Register.CHIP_ID)[0];
    }

    @Override
    public OctoQuad.FirmwareVersion getFirmwareVersion() {
        byte[] fw = this.readContiguousRegisters(Register.FIRMWARE_VERSION_MAJOR, Register.FIRMWARE_VERSION_ENGINEERING);
        int maj = fw[0] & 0xFF;
        int min = fw[1] & 0xFF;
        int eng = fw[2] & 0xFF;
        return new OctoQuad.FirmwareVersion(maj, min, eng);
    }

    @Override
    public String getFirmwareVersionString() {
        return this.getFirmwareVersion().toString();
    }

    @Override
    public int readSinglePosition(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Register register = Register.all[Register.ENCODER_0_POSITION.ordinal() + idx];
        return OctoQuadImpl.intFromBytes(this.readRegister(register));
    }

    @Override
    public void readAllPositions(int[] out) {
        this.verifyInitialization();
        if (out.length != 8) {
            throw new IllegalArgumentException("out.length != 8");
        }
        byte[] bytes = this.readContiguousRegisters(Register.ENCODER_0_POSITION, Register.ENCODER_7_POSITION);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        for (int i = 0; i < 8; ++i) {
            out[i] = buffer.getInt();
        }
    }

    @Override
    public int[] readAllPositions() {
        this.verifyInitialization();
        int[] block = new int[8];
        this.readAllPositions(block);
        return block;
    }

    @Override
    public int[] readPositionRange(int idxFirst, int idxLast) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idxFirst, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)idxLast, (int)0, (int)7);
        Register registerFirst = Register.all[Register.ENCODER_0_POSITION.ordinal() + idxFirst];
        Register registerLast = Register.all[Register.ENCODER_0_POSITION.ordinal() + idxLast];
        byte[] data = this.readContiguousRegisters(registerFirst, registerLast);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int numEncodersRead = idxLast - idxFirst + 1;
        int[] encoderCounts = new int[numEncodersRead];
        for (int i = 0; i < numEncodersRead; ++i) {
            encoderCounts[i] = buffer.getInt();
        }
        return encoderCounts;
    }

    @Override
    public void resetSinglePosition(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        byte dat = (byte)(1 << idx);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
        if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void resetAllPositions() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, -1});
        if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO) {
            this.refreshCache();
        }
    }

    @Override
    public void resetMultiplePositions(boolean[] resets) {
        this.verifyInitialization();
        if (resets.length != 8) {
            throw new IllegalArgumentException("resets.length != 8");
        }
        byte dat = 0;
        for (int i = 0; i <= 7; ++i) {
            dat = (byte)(dat | (resets[i] ? (byte)(1 << i) : (byte)0));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
    }

    @Override
    public void resetMultiplePositions(int ... indices) {
        this.verifyInitialization();
        for (int idx : indices) {
            Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        }
        byte dat = 0;
        for (int idx : indices) {
            dat = (byte)(dat | 1 << idx);
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{21, dat});
    }

    @Override
    public void setSingleEncoderDirection(int idx, OctoQuadBase.EncoderDirection direction) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.directionRegisterData = direction == OctoQuadBase.EncoderDirection.REVERSE ? (byte)(this.directionRegisterData | (byte)(1 << idx)) : (byte)(this.directionRegisterData & (byte)(~(1 << idx)));
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 0, this.directionRegisterData});
    }

    @Override
    public OctoQuadBase.EncoderDirection getSingleEncoderDirection(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 0});
        byte directions = this.readRegister(Register.COMMAND_DAT_0)[0];
        boolean reversed = (directions & 1 << idx) != 0;
        return reversed ? OctoQuadBase.EncoderDirection.REVERSE : OctoQuadBase.EncoderDirection.FORWARD;
    }

    @Override
    public void setAllEncoderDirections(boolean[] reverse) {
        this.verifyInitialization();
        if (reverse.length != 8) {
            throw new IllegalArgumentException("reverse.length != 8");
        }
        this.directionRegisterData = 0;
        for (int i = 0; i <= 7; ++i) {
            if (!reverse[i]) continue;
            this.directionRegisterData = (byte)(this.directionRegisterData | (byte)(1 << i));
        }
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 0, this.directionRegisterData});
    }

    @Override
    public short readSingleVelocity(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Register register = Register.all[Register.ENCODER_0_VELOCITY.ordinal() + idx];
        return OctoQuadImpl.shortFromBytes(this.readRegister(register));
    }

    @Override
    public void readAllVelocities(short[] out) {
        this.verifyInitialization();
        if (out.length != 8) {
            throw new IllegalArgumentException("out.length != 8");
        }
        byte[] bytes = this.readContiguousRegisters(Register.ENCODER_0_VELOCITY, Register.ENCODER_7_VELOCITY);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        for (int i = 0; i < 8; ++i) {
            out[i] = buffer.getShort();
        }
    }

    @Override
    public short[] readAllVelocities() {
        this.verifyInitialization();
        short[] block = new short[8];
        this.readAllVelocities(block);
        return block;
    }

    @Override
    public short[] readVelocityRange(int idxFirst, int idxLast) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idxFirst, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)idxLast, (int)0, (int)7);
        Register registerFirst = Register.all[Register.ENCODER_0_VELOCITY.ordinal() + idxFirst];
        Register registerLast = Register.all[Register.ENCODER_0_VELOCITY.ordinal() + idxLast];
        byte[] data = this.readContiguousRegisters(registerFirst, registerLast);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int numVelocitiesRead = idxLast - idxFirst + 1;
        short[] velocities = new short[numVelocitiesRead];
        for (int i = 0; i < numVelocitiesRead; ++i) {
            velocities[i] = buffer.getShort();
        }
        return velocities;
    }

    @Override
    public void readAllEncoderData(OctoQuad.EncoderDataBlock out) {
        int i;
        this.verifyInitialization();
        if (out.positions.length != 8) {
            throw new IllegalArgumentException("out.counts.length != 8");
        }
        if (out.velocities.length != 8) {
            throw new IllegalArgumentException("out.velocities.length != 8");
        }
        byte[] bytes = this.readContiguousRegisters(Register.ENCODER_0_POSITION, Register.ENCODER_7_VELOCITY);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(OCTOQUAD_ENDIAN);
        for (i = 0; i < 8; ++i) {
            out.positions[i] = buffer.getInt();
        }
        for (i = 0; i < 8; ++i) {
            out.velocities[i] = buffer.getShort();
        }
    }

    @Override
    public OctoQuad.EncoderDataBlock readAllEncoderData() {
        this.verifyInitialization();
        OctoQuad.EncoderDataBlock block = new OctoQuad.EncoderDataBlock();
        this.readAllEncoderData(block);
        return block;
    }

    @Override
    public void setSingleVelocitySampleInterval(int idx, int intvlms) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)intvlms, (int)1, (int)255);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_2, new byte[]{1, 3, (byte)idx, (byte)intvlms});
    }

    @Override
    public void setAllVelocitySampleIntervals(int intvlms) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)intvlms, (int)1, (int)255);
        for (int i = 0; i <= 7; ++i) {
            this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_2, new byte[]{1, 3, (byte)i, (byte)intvlms});
        }
    }

    @Override
    public void setAllVelocitySampleIntervals(int[] intvlms) {
        this.verifyInitialization();
        if (intvlms.length != 8) {
            throw new IllegalArgumentException("intvls.length != 8");
        }
        for (int i : intvlms) {
            Range.throwIfRangeIsInvalid((int)i, (int)1, (int)255);
        }
        for (int i = 0; i <= 7; ++i) {
            this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_2, new byte[]{1, 3, (byte)i, (byte)intvlms[i]});
        }
    }

    @Override
    public int getSingleVelocitySampleInterval(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{2, 3, (byte)idx});
        byte ms = this.readRegister(Register.COMMAND_DAT_0)[0];
        return ms & 0xFF;
    }

    @Override
    public int[] getAllVelocitySampleIntervals() {
        this.verifyInitialization();
        int[] ret = new int[8];
        for (int i = 0; i <= 0; ++i) {
            this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{2, 3, (byte)i});
            byte ms = this.readRegister(Register.COMMAND_DAT_0)[0];
            ret[i] = ms & 0xFF;
        }
        return ret;
    }

    @Override
    public void setSingleChannelPulseWidthParams(int idx, int min, int max) {
        this.setSingleChannelPulseWidthParams(idx, new OctoQuad.ChannelPulseWidthParams(min, max));
    }

    @Override
    public void setSingleChannelPulseWidthParams(int idx, OctoQuad.ChannelPulseWidthParams params) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        Range.throwIfRangeIsInvalid((int)params.min_length_us, (int)1, (int)65535);
        Range.throwIfRangeIsInvalid((int)params.max_length_us, (int)1, (int)65535);
        if (params.max_length_us <= params.min_length_us) {
            throw new RuntimeException("params.max_length_us <= params.min_length_us");
        }
        ByteBuffer outgoing = ByteBuffer.allocate(7);
        outgoing.order(OCTOQUAD_ENDIAN);
        outgoing.put((byte)1);
        outgoing.put((byte)4);
        outgoing.put((byte)idx);
        outgoing.putShort((short)params.min_length_us);
        outgoing.putShort((short)params.max_length_us);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_5, outgoing.array());
    }

    @Override
    public OctoQuad.ChannelPulseWidthParams getSingleChannelPulseWidthParams(int idx) {
        this.verifyInitialization();
        Range.throwIfRangeIsInvalid((int)idx, (int)0, (int)7);
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{2, 4, (byte)idx});
        byte[] result = this.readContiguousRegisters(Register.COMMAND_DAT_0, Register.COMMAND_DAT_3);
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.order(OCTOQUAD_ENDIAN);
        OctoQuad.ChannelPulseWidthParams params = new OctoQuad.ChannelPulseWidthParams();
        params.min_length_us = buffer.getShort() & 0xFFFF;
        params.max_length_us = buffer.getShort() & 0xFFFF;
        return params;
    }

    @Override
    public void resetEverything() {
        this.verifyInitialization();
        this.writeRegister(Register.COMMAND, new byte[]{20});
    }

    @Override
    public void setChannelBankConfig(OctoQuadBase.ChannelBankConfig config) {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 2, config.bVal});
    }

    @Override
    public OctoQuadBase.ChannelBankConfig getChannelBankConfig() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 2});
        byte result = this.readRegister(Register.COMMAND_DAT_0)[0];
        for (OctoQuadBase.ChannelBankConfig c : OctoQuadBase.ChannelBankConfig.values()) {
            if (c.bVal != result) continue;
            return c;
        }
        return OctoQuadBase.ChannelBankConfig.ALL_QUADRATURE;
    }

    @Override
    public void setI2cRecoveryMode(OctoQuadBase.I2cRecoveryMode mode) {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_1, new byte[]{1, 1, mode.bVal});
    }

    @Override
    public OctoQuadBase.I2cRecoveryMode getI2cRecoveryMode() {
        this.verifyInitialization();
        this.writeContiguousRegisters(Register.COMMAND, Register.COMMAND_DAT_0, new byte[]{2, 1});
        byte result = this.readRegister(Register.COMMAND_DAT_0)[0];
        for (OctoQuadBase.I2cRecoveryMode m : OctoQuadBase.I2cRecoveryMode.values()) {
            if (m.bVal != result) continue;
            return m;
        }
        return OctoQuadBase.I2cRecoveryMode.NONE;
    }

    @Override
    public void saveParametersToFlash() {
        this.verifyInitialization();
        this.writeRegister(Register.COMMAND, new byte[]{3});
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    @Override
    public void setCachingMode(CachingOctoQuad.CachingMode mode) {
        this.cachingMode = mode;
        if (this.cachingMode != CachingOctoQuad.CachingMode.NONE) {
            this.refreshCache();
        }
    }

    @Override
    public void refreshCache() {
        this.readAllEncoderData(this.cachedData);
        Arrays.fill(this.posHasBeenRead, false);
        Arrays.fill(this.velHasBeenRead, false);
    }

    @Override
    public int readSinglePosition_Caching(int idx) {
        if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO || this.cachingMode == CachingOctoQuad.CachingMode.MANUAL) {
            if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO && this.posHasBeenRead[idx]) {
                this.refreshCache();
            }
            this.posHasBeenRead[idx] = true;
            return this.cachedData.positions[idx];
        }
        return this.readSinglePosition(idx);
    }

    @Override
    public short readSingleVelocity_Caching(int idx) {
        if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO || this.cachingMode == CachingOctoQuad.CachingMode.MANUAL) {
            if (this.cachingMode == CachingOctoQuad.CachingMode.AUTO && this.velHasBeenRead[idx]) {
                this.refreshCache();
            }
            this.velHasBeenRead[idx] = true;
            return this.cachedData.velocities[idx];
        }
        return this.readSingleVelocity(idx);
    }

    private void verifyInitialization() {
        if (!this.isInitialized) {
            byte chipId = this.getChipId();
            if (chipId != 81) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad does not report correct CHIP_ID value; (got 0x%X; expected 0x%X) this likely indicates I2C comms are not working", (Object[])new Object[]{chipId, (byte)81});
            }
            OctoQuad.FirmwareVersion fw = this.getFirmwareVersion();
            if (fw.maj != 2) {
                RobotLog.addGlobalWarningMessage((String)"OctoQuad is running a different major firmware version than this driver was built for (current=%d; expected=%d) IT IS HIGHLY LIKELY THAT NOTHING WILL WORK!", (Object[])new Object[]{fw.maj, 2});
            }
            this.isInitialized = true;
        }
    }

    private static int intFromBytes(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(OCTOQUAD_ENDIAN);
        return byteBuffer.getInt();
    }

    private static short shortFromBytes(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(OCTOQUAD_ENDIAN);
        return byteBuffer.getShort();
    }

    private byte[] readRegister(Register reg) {
        return this.deviceClient.read((int)reg.addr, reg.length);
    }

    private byte[] readContiguousRegisters(Register first, Register last) {
        byte addrStart = first.addr;
        int addrEnd = last.addr + last.length;
        int bytesToRead = addrEnd - addrStart;
        return this.deviceClient.read((int)addrStart, bytesToRead);
    }

    private void writeRegister(Register reg, byte[] bytes) {
        if (reg.length != bytes.length) {
            throw new IllegalArgumentException("reg.length != bytes.length");
        }
        this.deviceClient.write((int)reg.addr, bytes);
    }

    private void writeContiguousRegisters(Register first, Register last, byte[] dat) {
        int addrEnd = last.addr + last.length;
        byte addrStart = first.addr;
        int bytesToWrite = addrEnd - addrStart;
        if (bytesToWrite != dat.length) {
            throw new IllegalArgumentException("bytesToWrite != dat.length");
        }
        this.deviceClient.write((int)addrStart, dat);
    }

    static enum Register {
        CHIP_ID(0, RegisterType.uint8_t),
        FIRMWARE_VERSION_MAJOR(1, RegisterType.uint8_t),
        FIRMWARE_VERSION_MINOR(2, RegisterType.uint8_t),
        FIRMWARE_VERSION_ENGINEERING(3, RegisterType.uint8_t),
        COMMAND(4, RegisterType.uint8_t),
        COMMAND_DAT_0(5, RegisterType.uint8_t),
        COMMAND_DAT_1(6, RegisterType.uint8_t),
        COMMAND_DAT_2(7, RegisterType.uint8_t),
        COMMAND_DAT_3(8, RegisterType.uint8_t),
        COMMAND_DAT_4(9, RegisterType.uint8_t),
        COMMAND_DAT_5(10, RegisterType.uint8_t),
        COMMAND_DAT_6(11, RegisterType.uint8_t),
        ENCODER_0_POSITION(12, RegisterType.int32_t),
        ENCODER_1_POSITION(16, RegisterType.int32_t),
        ENCODER_2_POSITION(20, RegisterType.int32_t),
        ENCODER_3_POSITION(24, RegisterType.int32_t),
        ENCODER_4_POSITION(28, RegisterType.int32_t),
        ENCODER_5_POSITION(32, RegisterType.int32_t),
        ENCODER_6_POSITION(36, RegisterType.int32_t),
        ENCODER_7_POSITION(40, RegisterType.int32_t),
        ENCODER_0_VELOCITY(44, RegisterType.int16_t),
        ENCODER_1_VELOCITY(46, RegisterType.int16_t),
        ENCODER_2_VELOCITY(48, RegisterType.int16_t),
        ENCODER_3_VELOCITY(50, RegisterType.int16_t),
        ENCODER_4_VELOCITY(52, RegisterType.int16_t),
        ENCODER_5_VELOCITY(54, RegisterType.int16_t),
        ENCODER_6_VELOCITY(56, RegisterType.int16_t),
        ENCODER_7_VELOCITY(58, RegisterType.int16_t);

        public final byte addr;
        public final int length;
        public static final Register[] all;

        private Register(int addr, RegisterType type) {
            this.addr = (byte)addr;
            this.length = type.length;
        }

        static {
            all = Register.values();
        }
    }

    static enum RegisterType {
        uint8_t(1),
        int32_t(4),
        int16_t(2);

        public final int length;

        private RegisterType(int length) {
            this.length = length;
        }
    }

    public class OctoQuadException
    extends RuntimeException {
        public OctoQuadException(String msg) {
            super(msg);
        }
    }
}

