/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.limelightvision;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class LLFieldMap {
    private List<Fiducial> fiducials;
    private String type;

    public LLFieldMap() {
        this(new ArrayList<Fiducial>(), "");
    }

    public LLFieldMap(List<Fiducial> fiducials, String type) {
        this.fiducials = new ArrayList<Fiducial>(fiducials);
        this.type = type;
    }

    protected LLFieldMap(JSONObject json) {
        this();
        if (json != null) {
            try {
                this.type = json.optString("type", "");
                JSONArray fiducialsArray = json.optJSONArray("fiducials");
                if (fiducialsArray != null) {
                    for (int i = 0; i < fiducialsArray.length(); ++i) {
                        JSONObject fiducialJson = fiducialsArray.optJSONObject(i);
                        if (fiducialJson == null) continue;
                        this.fiducials.add(new Fiducial(fiducialJson));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<Fiducial> getFiducials() {
        return new ArrayList<Fiducial>(this.fiducials);
    }

    public String getType() {
        return this.type;
    }

    public int getNumberOfTags() {
        return this.fiducials.size();
    }

    public boolean isValid() {
        if (this.getNumberOfTags() == 0) {
            return false;
        }
        return this.getType() == "ftc" || this.getType() == "frc";
    }

    protected JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            JSONArray fiducialsArray = new JSONArray();
            for (Fiducial fiducial : this.fiducials) {
                fiducialsArray.put((Object)fiducial.toJson());
            }
            json.put("fiducials", (Object)fiducialsArray);
            json.put("type", (Object)this.type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }

    public static class Fiducial {
        private int id;
        private double size;
        private String family;
        private List<Double> transform;
        private boolean isUnique;

        public Fiducial() {
            this(-1, 165.1, "apriltag3_36h11_classic", new ArrayList<Double>(16), true);
        }

        public Fiducial(int id, double size, String family, List<Double> transform, boolean isUnique) {
            this.id = id;
            this.size = size;
            this.family = family;
            this.transform = new ArrayList<Double>(transform);
            this.isUnique = isUnique;
        }

        protected Fiducial(JSONObject json) {
            this();
            if (json != null) {
                try {
                    this.id = json.optInt("id", -1);
                    this.size = json.optDouble("size", 165.1);
                    this.family = json.optString("family", "apriltag3_36h11_classic");
                    this.transform = new ArrayList<Double>();
                    JSONArray transformArray = json.optJSONArray("transform");
                    if (transformArray != null) {
                        for (int i = 0; i < transformArray.length(); ++i) {
                            this.transform.add(transformArray.optDouble(i, 0.0));
                        }
                    }
                    this.isUnique = json.optBoolean("unique", true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public int getId() {
            return this.id;
        }

        public double getSize() {
            return this.size;
        }

        public String getFamily() {
            return this.family;
        }

        public List<Double> getTransform() {
            return new ArrayList<Double>(this.transform);
        }

        public boolean isUnique() {
            return this.isUnique;
        }

        protected JSONObject toJson() {
            JSONObject json = new JSONObject();
            try {
                json.put("id", this.id);
                json.put("size", this.size);
                json.put("family", (Object)this.family);
                json.put("transform", (Object)new JSONArray(this.transform));
                json.put("unique", this.isUnique);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return json;
        }
    }
}

