/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.limelightvision;

import com.qualcomm.hardware.limelightvision.LLResultTypes;
import java.util.ArrayList;
import java.util.List;
import org.firstinspires.ftc.robotcore.external.navigation.AngleUnit;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.external.navigation.Pose3D;
import org.firstinspires.ftc.robotcore.external.navigation.Position;
import org.firstinspires.ftc.robotcore.external.navigation.YawPitchRollAngles;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LLResult {
    private JSONObject jsonData;
    private List<LLResultTypes.BarcodeResult> barcodeResults;
    private List<LLResultTypes.ClassifierResult> classifierResults;
    private List<LLResultTypes.DetectorResult> detectorResults;
    private List<LLResultTypes.FiducialResult> fiducialResults;
    private List<LLResultTypes.ColorResult> colorResults;
    private double parseLatency;
    private long controlHubTimeStamp;

    protected LLResult(JSONObject json) throws JSONException {
        this.jsonData = json;
        this.barcodeResults = new ArrayList<LLResultTypes.BarcodeResult>();
        this.classifierResults = new ArrayList<LLResultTypes.ClassifierResult>();
        this.detectorResults = new ArrayList<LLResultTypes.DetectorResult>();
        this.fiducialResults = new ArrayList<LLResultTypes.FiducialResult>();
        this.colorResults = new ArrayList<LLResultTypes.ColorResult>();
        this.parseLatency = 0.0;
        this.setControlHubTimeStamp(System.currentTimeMillis());
        this.parseResults();
    }

    void setControlHubTimeStamp(long timestamp) {
        this.controlHubTimeStamp = timestamp;
    }

    public long getControlHubTimeStamp() {
        return this.controlHubTimeStamp;
    }

    public long getControlHubTimeStampNanos() {
        return this.controlHubTimeStamp * 1000000L;
    }

    public long getStaleness() {
        return System.currentTimeMillis() - this.controlHubTimeStamp;
    }

    private void parseResults() throws JSONException {
        JSONArray colorArray;
        JSONArray fiducialArray;
        JSONArray detectorArray;
        JSONArray classifierArray;
        long startTime = System.nanoTime();
        JSONArray barcodeArray = this.jsonData.optJSONArray("Barcode");
        if (barcodeArray != null) {
            for (int i = 0; i < barcodeArray.length(); ++i) {
                this.barcodeResults.add(new LLResultTypes.BarcodeResult(barcodeArray.getJSONObject(i)));
            }
        }
        if ((classifierArray = this.jsonData.optJSONArray("Classifier")) != null) {
            for (int i = 0; i < classifierArray.length(); ++i) {
                this.classifierResults.add(new LLResultTypes.ClassifierResult(classifierArray.getJSONObject(i)));
            }
        }
        if ((detectorArray = this.jsonData.optJSONArray("Detector")) != null) {
            for (int i = 0; i < detectorArray.length(); ++i) {
                this.detectorResults.add(new LLResultTypes.DetectorResult(detectorArray.getJSONObject(i)));
            }
        }
        if ((fiducialArray = this.jsonData.optJSONArray("Fiducial")) != null) {
            for (int i = 0; i < fiducialArray.length(); ++i) {
                this.fiducialResults.add(new LLResultTypes.FiducialResult(fiducialArray.getJSONObject(i)));
            }
        }
        if ((colorArray = this.jsonData.optJSONArray("Retro")) != null) {
            for (int i = 0; i < colorArray.length(); ++i) {
                this.colorResults.add(new LLResultTypes.ColorResult(colorArray.getJSONObject(i)));
            }
        }
        long endTime = System.nanoTime();
        this.parseLatency = (double)(endTime - startTime) / 1000000.0;
    }

    public List<LLResultTypes.BarcodeResult> getBarcodeResults() {
        return this.barcodeResults;
    }

    public List<LLResultTypes.ClassifierResult> getClassifierResults() {
        return this.classifierResults;
    }

    public List<LLResultTypes.DetectorResult> getDetectorResults() {
        return this.detectorResults;
    }

    public List<LLResultTypes.FiducialResult> getFiducialResults() {
        return this.fiducialResults;
    }

    public List<LLResultTypes.ColorResult> getColorResults() {
        return this.colorResults;
    }

    public double getFocusMetric() {
        return this.jsonData.optDouble("focus_metric", 0.0);
    }

    public Pose3D getBotpose() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose", 6));
    }

    private Pose3D getBotposeWpiblue() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose_wpiblue", 6));
    }

    private Pose3D getBotposeWpired() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose_wpired", 6));
    }

    public Pose3D getBotpose_MT2() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose_orb", 6));
    }

    private Pose3D getBotposeWpiblue_MT2() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose_orb_wpiblue", 6));
    }

    private Pose3D getBotposeOrbWpired_MT2() {
        return LLResult.createPose3DRobot(this.getDoubleArray("botpose_orb_wpired", 6));
    }

    public double[] getStddevMt1() {
        return this.getDoubleArray("stdev_mt1", 6);
    }

    public double[] getStddevMt2() {
        return this.getDoubleArray("stdev_mt2", 6);
    }

    public int getBotposeTagCount() {
        return this.jsonData.optInt("botpose_tagcount", 0);
    }

    public double getBotposeSpan() {
        return this.jsonData.optDouble("botpose_span", 0.0);
    }

    public double getBotposeAvgDist() {
        return this.jsonData.optDouble("botpose_avgdist", 0.0);
    }

    public double getBotposeAvgArea() {
        return this.jsonData.optDouble("botpose_avgarea", 0.0);
    }

    public double[] getPythonOutput() {
        double[] output = this.getDoubleArray("PythonOut", 0);
        double[] result = new double[32];
        int lengthToCopy = Math.min(output.length, 32);
        System.arraycopy(output, 0, result, 0, lengthToCopy);
        return result;
    }

    public double getCaptureLatency() {
        return this.jsonData.optDouble("cl", 0.0);
    }

    public String getPipelineType() {
        return this.jsonData.optString("pipelineType", "");
    }

    public double getTx() {
        return this.jsonData.optDouble("tx", 0.0);
    }

    public double getTy() {
        return this.jsonData.optDouble("ty", 0.0);
    }

    public double getTxNC() {
        return this.jsonData.optDouble("txnc", 0.0);
    }

    public double getTyNC() {
        return this.jsonData.optDouble("tync", 0.0);
    }

    public double getTa() {
        return this.jsonData.optDouble("ta", 0.0);
    }

    public int getPipelineIndex() {
        return this.jsonData.optInt("pID", 0);
    }

    private Pose3D getCameraPose_RobotSpace() {
        return LLResult.createPose3DRobot(this.getDoubleArray("t6c_rs", 6));
    }

    public double getTargetingLatency() {
        return this.jsonData.optDouble("tl", 0.0);
    }

    public double getTimestamp() {
        return this.jsonData.optDouble("ts", 0.0);
    }

    public boolean isValid() {
        int v = this.jsonData.optInt("v", 0);
        return v == 1;
    }

    public double getParseLatency() {
        return this.parseLatency;
    }

    private double[] getDoubleArray(String key, int defaultCount) {
        JSONArray array = this.jsonData.optJSONArray(key);
        if (array == null) {
            return new double[defaultCount];
        }
        double[] result = new double[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            result[i] = array.optDouble(i);
        }
        return result;
    }

    protected static Pose3D createPose3DRobot(double[] pose) {
        if (pose.length < 6) {
            return new Pose3D(new Position(), new YawPitchRollAngles(AngleUnit.DEGREES, 0.0, 0.0, 0.0, 0L));
        }
        Position position = new Position(DistanceUnit.METER, pose[0], pose[1], pose[2], 0L);
        YawPitchRollAngles orientation = new YawPitchRollAngles(AngleUnit.DEGREES, pose[5], pose[4], pose[3], 0L);
        return new Pose3D(position, orientation);
    }

    protected static LLResult parse(JSONObject json) {
        try {
            return new LLResult(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.jsonData.toString();
    }
}

