/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.limelightvision;

import com.qualcomm.hardware.limelightvision.LLResult;
import java.util.ArrayList;
import java.util.List;
import org.firstinspires.ftc.robotcore.external.navigation.Pose3D;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LLResultTypes {
    private static List<List<Double>> parsePoints(JSONArray cornersArray) {
        ArrayList<List<Double>> points = new ArrayList<List<Double>>();
        if (cornersArray != null) {
            for (int i = 0; i < cornersArray.length(); ++i) {
                JSONArray point = cornersArray.optJSONArray(i);
                if (point == null || point.length() != 2) continue;
                ArrayList<Double> cornerPoint = new ArrayList<Double>();
                cornerPoint.add(point.optDouble(0, 0.0));
                cornerPoint.add(point.optDouble(1, 0.0));
                points.add(cornerPoint);
            }
        }
        return points;
    }

    private static double[] parsePoseArray(JSONArray array) {
        double[] pose = new double[6];
        if (array != null && array.length() >= 6) {
            for (int i = 0; i < 6; ++i) {
                pose[i] = array.optDouble(i, 0.0);
            }
        }
        return pose;
    }

    public static class CalibrationResult {
        private String displayName;
        private double resX;
        private double resY;
        private double reprojectionError;
        private double[] camMatVector;
        private double[] distortionCoefficients;
        private boolean valid;
        private static final double DEFAULT_REPORT_VAL = 0.0;

        public CalibrationResult() {
            this("", 0.0, 0.0, 0.0, new double[9], new double[5]);
        }

        public CalibrationResult(String displayName, double resX, double resY, double reprojectionError, double[] camMatVector, double[] distortionCoefficients) {
            this.displayName = displayName;
            this.resX = resX;
            this.resY = resY;
            this.reprojectionError = reprojectionError;
            this.camMatVector = (double[])camMatVector.clone();
            this.distortionCoefficients = (double[])distortionCoefficients.clone();
            this.valid = true;
        }

        protected CalibrationResult(JSONObject json) {
            this();
            if (json != null) {
                try {
                    JSONArray distortionCoeffs;
                    this.displayName = json.optString("DISPLAY_NAME", "");
                    this.reprojectionError = json.optDouble("REPROJECTION_ERROR", 0.0);
                    this.resX = json.optDouble("RES_X", 0.0);
                    this.resY = json.optDouble("RES_Y", 0.0);
                    JSONArray intrinsicsMatrix = json.optJSONArray("INTRINSICS_MATRIX");
                    if (intrinsicsMatrix != null && intrinsicsMatrix.length() == 9) {
                        for (int i = 0; i < 9; ++i) {
                            this.camMatVector[i] = intrinsicsMatrix.optDouble(i, 0.0);
                        }
                    } else {
                        this.valid = false;
                    }
                    if ((distortionCoeffs = json.optJSONArray("DISTORTION_COEFFICIENTS")) != null && distortionCoeffs.length() == 5) {
                        for (int i = 0; i < 5; ++i) {
                            this.distortionCoefficients[i] = distortionCoeffs.optDouble(i, 0.0);
                        }
                    } else {
                        this.valid = false;
                    }
                    if (this.resX == 0.0 || this.resY == 0.0) {
                        this.valid = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean isValid() {
            return this.valid && this.resX != 0.0 && this.resY != 0.0 && this.camMatVector[0] != 0.0;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public double getResX() {
            return this.resX;
        }

        public double getResY() {
            return this.resY;
        }

        public double getReprojectionError() {
            return this.reprojectionError;
        }

        public double[] getCamMatVector() {
            return (double[])this.camMatVector.clone();
        }

        public double[] getDistortionCoefficients() {
            return (double[])this.distortionCoefficients.clone();
        }

        protected JSONObject toJson() {
            JSONObject json = new JSONObject();
            try {
                json.put("DISPLAY_NAME", (Object)this.getDisplayName());
                json.put("REPROJECTION_ERROR", this.getReprojectionError());
                json.put("RES_X", this.getResX());
                json.put("RES_Y", this.getResY());
                json.put("INTRINSICS_MATRIX", (Object)new JSONArray((Object)this.getCamMatVector()));
                json.put("DISTORTION_COEFFICIENTS", (Object)new JSONArray((Object)this.getDistortionCoefficients()));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return json;
        }
    }

    public static class ColorResult {
        private Pose3D cameraPoseTargetSpace;
        private Pose3D robotPoseFieldSpace;
        private Pose3D robotPoseTargetSpace;
        private Pose3D targetPoseCameraSpace;
        private Pose3D targetPoseRobotSpace;
        private double targetArea;
        private double targetXPixels;
        private double targetYPixels;
        private double targetXDegrees;
        private double targetYDegrees;
        private double targetXDegreesNoCrosshair;
        private double targetYDegreesNoCrosshair;
        private List<List<Double>> targetCorners;

        protected ColorResult(JSONObject data) {
            this.cameraPoseTargetSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6c_ts")));
            this.robotPoseFieldSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6r_fs")));
            this.robotPoseTargetSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6r_ts")));
            this.targetPoseCameraSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6t_cs")));
            this.targetPoseRobotSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6t_rs")));
            this.targetArea = data.optDouble("ta", 0.0);
            this.targetXPixels = data.optDouble("txp", 0.0);
            this.targetYPixels = data.optDouble("typ", 0.0);
            this.targetXDegrees = data.optDouble("tx", 0.0);
            this.targetYDegrees = data.optDouble("ty", 0.0);
            this.targetXDegreesNoCrosshair = data.optDouble("tx_nocross", 0.0);
            this.targetYDegreesNoCrosshair = data.optDouble("ty_nocross", 0.0);
            this.targetCorners = LLResultTypes.parsePoints(data.optJSONArray("pts"));
        }

        public List<List<Double>> getTargetCorners() {
            return this.targetCorners;
        }

        public Pose3D getCameraPoseTargetSpace() {
            return this.cameraPoseTargetSpace;
        }

        public Pose3D getRobotPoseFieldSpace() {
            return this.robotPoseFieldSpace;
        }

        public Pose3D getRobotPoseTargetSpace() {
            return this.robotPoseTargetSpace;
        }

        public Pose3D getTargetPoseCameraSpace() {
            return this.targetPoseCameraSpace;
        }

        public Pose3D getTargetPoseRobotSpace() {
            return this.targetPoseRobotSpace;
        }

        public double getTargetArea() {
            return this.targetArea;
        }

        public double getTargetXPixels() {
            return this.targetXPixels;
        }

        public double getTargetYPixels() {
            return this.targetYPixels;
        }

        public double getTargetXDegrees() {
            return this.targetXDegrees;
        }

        public double getTargetYDegrees() {
            return this.targetYDegrees;
        }

        public double getTargetXDegreesNoCrosshair() {
            return this.targetXDegreesNoCrosshair;
        }

        public double getTargetYDegreesNoCrosshair() {
            return this.targetYDegreesNoCrosshair;
        }
    }

    public static class FiducialResult {
        private int fiducialId;
        private String family;
        private double skew;
        private Pose3D cameraPoseTargetSpace;
        private Pose3D robotPoseFieldSpace;
        private Pose3D robotPoseTargetSpace;
        private Pose3D targetPoseCameraSpace;
        private Pose3D targetPoseRobotSpace;
        private double targetArea;
        private double targetXPixels;
        private double targetYPixels;
        private double targetXDegrees;
        private double targetYDegrees;
        private double targetXDegreesNoCrosshair;
        private double targetYDegreesNoCrosshair;
        private List<List<Double>> targetCorners;

        protected FiducialResult(JSONObject data) {
            this.fiducialId = data.optInt("fID", 0);
            this.family = data.optString("fam", "");
            this.skew = data.optDouble("skew", 0.0);
            this.cameraPoseTargetSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6c_ts")));
            this.robotPoseFieldSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6r_fs")));
            this.robotPoseTargetSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6r_ts")));
            this.targetPoseCameraSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6t_cs")));
            this.targetPoseRobotSpace = LLResult.createPose3DRobot(LLResultTypes.parsePoseArray(data.optJSONArray("t6t_rs")));
            this.targetArea = data.optDouble("ta", 0.0);
            this.targetXPixels = data.optDouble("txp", 0.0);
            this.targetYPixels = data.optDouble("typ", 0.0);
            this.targetXDegrees = data.optDouble("tx", 0.0);
            this.targetYDegrees = data.optDouble("ty", 0.0);
            this.targetXDegreesNoCrosshair = data.optDouble("tx_nocross", 0.0);
            this.targetYDegreesNoCrosshair = data.optDouble("ty_nocross", 0.0);
            this.targetCorners = LLResultTypes.parsePoints(data.optJSONArray("pts"));
        }

        public int getFiducialId() {
            return this.fiducialId;
        }

        public String getFamily() {
            return this.family;
        }

        public List<List<Double>> getTargetCorners() {
            return this.targetCorners;
        }

        public double getSkew() {
            return this.skew;
        }

        public Pose3D getCameraPoseTargetSpace() {
            return this.cameraPoseTargetSpace;
        }

        public Pose3D getRobotPoseFieldSpace() {
            return this.robotPoseFieldSpace;
        }

        public Pose3D getRobotPoseTargetSpace() {
            return this.robotPoseTargetSpace;
        }

        public Pose3D getTargetPoseCameraSpace() {
            return this.targetPoseCameraSpace;
        }

        public Pose3D getTargetPoseRobotSpace() {
            return this.targetPoseRobotSpace;
        }

        public double getTargetArea() {
            return this.targetArea;
        }

        public double getTargetXPixels() {
            return this.targetXPixels;
        }

        public double getTargetYPixels() {
            return this.targetYPixels;
        }

        public double getTargetXDegrees() {
            return this.targetXDegrees;
        }

        public double getTargetYDegrees() {
            return this.targetYDegrees;
        }

        public double getTargetXDegreesNoCrosshair() {
            return this.targetXDegreesNoCrosshair;
        }

        public double getTargetYDegreesNoCrosshair() {
            return this.targetYDegreesNoCrosshair;
        }
    }

    public static class DetectorResult {
        private String className;
        private int classId;
        private double confidence;
        private double targetArea;
        private double targetXPixels;
        private double targetYPixels;
        private double targetXDegrees;
        private double targetYDegrees;
        private double targetXDegreesNoCrosshair;
        private double targetYDegreesNoCrosshair;
        private List<List<Double>> targetCorners;

        protected DetectorResult(JSONObject data) {
            this.className = data.optString("class", "");
            this.classId = data.optInt("classID", 0);
            this.confidence = data.optDouble("conf", 0.0);
            this.targetArea = data.optDouble("ta", 0.0);
            this.targetXPixels = data.optDouble("txp", 0.0);
            this.targetYPixels = data.optDouble("typ", 0.0);
            this.targetXDegrees = data.optDouble("tx", 0.0);
            this.targetYDegrees = data.optDouble("ty", 0.0);
            this.targetXDegreesNoCrosshair = data.optDouble("tx_nocross", 0.0);
            this.targetYDegreesNoCrosshair = data.optDouble("ty_nocross", 0.0);
            this.targetCorners = LLResultTypes.parsePoints(data.optJSONArray("pts"));
        }

        public String getClassName() {
            return this.className;
        }

        public int getClassId() {
            return this.classId;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public List<List<Double>> getTargetCorners() {
            return this.targetCorners;
        }

        public double getTargetArea() {
            return this.targetArea;
        }

        public double getTargetXPixels() {
            return this.targetXPixels;
        }

        public double getTargetYPixels() {
            return this.targetYPixels;
        }

        public double getTargetXDegrees() {
            return this.targetXDegrees;
        }

        public double getTargetYDegrees() {
            return this.targetYDegrees;
        }

        public double getTargetXDegreesNoCrosshair() {
            return this.targetXDegreesNoCrosshair;
        }

        public double getTargetYDegreesNoCrosshair() {
            return this.targetYDegreesNoCrosshair;
        }
    }

    public static class ClassifierResult {
        private String className;
        private int classId;
        private double confidence;

        protected ClassifierResult(JSONObject data) {
            this.className = data.optString("class", "");
            this.classId = data.optInt("classID", 0);
            this.confidence = data.optDouble("conf", 0.0);
        }

        public String getClassName() {
            return this.className;
        }

        public int getClassId() {
            return this.classId;
        }

        public double getConfidence() {
            return this.confidence;
        }
    }

    public static class BarcodeResult {
        private String family;
        private String data;
        private double targetXPixels;
        private double targetYPixels;
        private double targetXDegrees;
        private double targetYDegrees;
        private double targetXDegreesNoCrosshair;
        private double targetYDegreesNoCrosshair;
        private double targetArea;
        private List<List<Double>> targetCorners;

        protected BarcodeResult(JSONObject data) {
            this.family = data.optString("fam", "");
            this.data = data.optString("data", "");
            this.targetXPixels = data.optDouble("txp", 0.0);
            this.targetYPixels = data.optDouble("typ", 0.0);
            this.targetXDegrees = data.optDouble("tx", 0.0);
            this.targetYDegrees = data.optDouble("ty", 0.0);
            this.targetXDegreesNoCrosshair = data.optDouble("tx_nocross", 0.0);
            this.targetYDegreesNoCrosshair = data.optDouble("ty_nocross", 0.0);
            this.targetArea = data.optDouble("ta", 0.0);
            this.targetCorners = LLResultTypes.parsePoints(data.optJSONArray("pts"));
        }

        public String getFamily() {
            return this.family;
        }

        public String getData() {
            return this.data;
        }

        public double getTargetXPixels() {
            return this.targetXPixels;
        }

        public double getTargetYPixels() {
            return this.targetYPixels;
        }

        public double getTargetXDegrees() {
            return this.targetXDegrees;
        }

        public double getTargetYDegrees() {
            return this.targetYDegrees;
        }

        public double getTargetXDegreesNoCrosshair() {
            return this.targetXDegreesNoCrosshair;
        }

        public double getTargetYDegreesNoCrosshair() {
            return this.targetYDegreesNoCrosshair;
        }

        public double getTargetArea() {
            return this.targetArea;
        }

        public List<List<Double>> getTargetCorners() {
            return this.targetCorners;
        }
    }
}

