/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetADCResponse;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.AnalogInputController;
import com.qualcomm.robotcore.util.SerialNumber;

public class LynxAnalogInputController
extends LynxController
implements AnalogInputController {
    public static final String TAG = "LynxAnalogInputController";
    public static final int apiPortFirst = 0;
    public static final int apiPortLast = 3;

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxAnalogInputController(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        this.finishConstruction();
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxAnalogInputControllerDisplayName);
    }

    @Override
    public SerialNumber getSerialNumber() {
        return this.getModule().getSerialNumber();
    }

    public double getAnalogInputVoltage(int port) {
        LynxModule module;
        this.validatePort(port);
        LynxGetADCCommand command = new LynxGetADCCommand(this.getModule(), LynxGetADCCommand.Channel.user(port += 0), LynxGetADCCommand.Mode.ENGINEERING);
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command);
            return bulkData.getAnalogInputVoltage(port);
        }
        try {
            LynxGetADCResponse response = (LynxGetADCResponse)command.sendReceive();
            return (double)response.getValue() * 0.001;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(0.0);
        }
    }

    public double getMaxAnalogInputVoltage() {
        return 3.3;
    }

    private void validatePort(int port) {
        if (port < 0 || port > 3) {
            throw new IllegalArgumentException(String.format("port %d is invalid; valid ports are %d..%d", port, 0, 3));
        }
    }
}

