/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import androidx.annotation.NonNull;
import com.qualcomm.hardware.lynx.LynxCommExceptionHandler;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUnsupportedCommandException;
import com.qualcomm.hardware.lynx.Supplier;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.LynxInterface;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.Engagable;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealth;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealthImpl;
import com.qualcomm.robotcore.hardware.RobotCoreLynxController;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.WeakReferenceSet;
import java.util.concurrent.Callable;

public abstract class LynxController
extends LynxCommExceptionHandler
implements RobotCoreLynxController,
Engagable,
HardwareDeviceHealth,
RobotArmingStateNotifier.Callback,
RobotArmingStateNotifier {
    protected Context context;
    private LynxModule module;
    protected boolean isHardwareInitialized;
    protected boolean isEngaged;
    protected boolean isHooked;
    private LynxModuleIntf pretendModule;
    protected final WeakReferenceSet<RobotArmingStateNotifier.Callback> registeredCallbacks = new WeakReferenceSet();
    protected final HardwareDeviceHealthImpl hardwareDeviceHealth;

    @Override
    protected abstract String getTag();

    public LynxController(Context context, LynxModule module) {
        this.context = context;
        this.module = module;
        this.isEngaged = true;
        this.isHooked = false;
        this.isHardwareInitialized = false;
        this.pretendModule = new PretendLynxModule();
        this.hardwareDeviceHealth = new HardwareDeviceHealthImpl(this.getTag(), this.getHealthStatusOverride());
        this.module.noteController(this);
    }

    protected void finishConstruction() {
        this.moduleNowArmedOrPretending();
        this.module.registerCallback(this, false);
    }

    public synchronized void onModuleStateChange(RobotArmingStateNotifier module, RobotArmingStateNotifier.ARMINGSTATE state) {
        switch (state) {
            case ARMED: 
            case PRETENDING: {
                this.moduleNowArmedOrPretending();
                break;
            }
            case DISARMED: {
                this.moduleNowDisarmed();
            }
        }
        for (RobotArmingStateNotifier.Callback callback : this.registeredCallbacks) {
            callback.onModuleStateChange((RobotArmingStateNotifier)this, state);
        }
    }

    protected void moduleNowArmedOrPretending() {
        this.adjustHookingToMatchEngagement();
    }

    protected void moduleNowDisarmed() {
        if (this.isHooked) {
            this.unhook();
        }
    }

    public SerialNumber getSerialNumber() {
        return this.module.getSerialNumber();
    }

    public RobotArmingStateNotifier.ARMINGSTATE getArmingState() {
        return this.module.getArmingState();
    }

    public void registerCallback(RobotArmingStateNotifier.Callback callback, boolean doInitialCallback) {
        this.registeredCallbacks.add((Object)callback);
        if (doInitialCallback) {
            callback.onModuleStateChange((RobotArmingStateNotifier)this, this.getArmingState());
        }
    }

    public void unregisterCallback(RobotArmingStateNotifier.Callback callback) {
        this.registeredCallbacks.remove((Object)callback);
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public synchronized void close() {
        if (this.isEngaged()) {
            this.floatHardware();
            this.disengage();
        }
        this.setHealthStatus(HardwareDeviceHealth.HealthStatus.CLOSED);
    }

    public String getConnectionInfo() {
        return this.getModule().getConnectionInfo();
    }

    public int getVersion() {
        return 1;
    }

    public abstract String getDeviceName();

    public void resetDeviceConfigurationForOpMode() {
        try {
            this.initializeHardware();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RobotCoreException e) {
            RobotLog.vv((String)this.getTag(), (Throwable)e, (String)"exception initializing hardware; ignored");
        }
    }

    void initializeHardwareIfNecessary() throws RobotCoreException, InterruptedException {
        if (!this.isHardwareInitialized) {
            RobotLog.vv((String)this.getTag(), (String)"initializeHardware() mod#=%d", (Object[])new Object[]{this.getModule().getModuleAddress()});
            this.initializeHardware();
            this.isHardwareInitialized = this.isArmed();
        }
    }

    protected void initializeHardware() throws RobotCoreException, InterruptedException {
    }

    protected void floatHardware() {
    }

    public void forgetLastKnown() {
    }

    protected void setHealthyIfArmed() {
        if (this.isArmed()) {
            this.setHealthStatus(HardwareDeviceHealth.HealthStatus.HEALTHY);
        }
    }

    public void setHealthStatus(HardwareDeviceHealth.HealthStatus status) {
        this.hardwareDeviceHealth.setHealthStatus(status);
    }

    protected Callable<HardwareDeviceHealth.HealthStatus> getHealthStatusOverride() {
        return new Callable<HardwareDeviceHealth.HealthStatus>(){

            @Override
            public HardwareDeviceHealth.HealthStatus call() throws Exception {
                if (LynxController.this.module.getArmingState() == RobotArmingStateNotifier.ARMINGSTATE.PRETENDING) {
                    return HardwareDeviceHealth.HealthStatus.UNHEALTHY;
                }
                return HardwareDeviceHealth.HealthStatus.UNKNOWN;
            }
        };
    }

    public HardwareDeviceHealth.HealthStatus getHealthStatus() {
        return this.hardwareDeviceHealth.getHealthStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engage() {
        LynxController lynxController = this;
        synchronized (lynxController) {
            if (!this.isEngaged) {
                RobotLog.vv((String)this.getTag(), (String)"engaging mod#=%d", (Object[])new Object[]{this.getModule().getModuleAddress()});
                this.isEngaged = true;
                this.adjustHookingToMatchEngagement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disengage() {
        LynxController lynxController = this;
        synchronized (lynxController) {
            if (!this.isEngaged) {
                RobotLog.vv((String)this.getTag(), (String)"disengage mod#=%d", (Object[])new Object[]{this.getModule().getModuleAddress()});
                this.isEngaged = false;
                this.adjustHookingToMatchEngagement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEngaged() {
        LynxController lynxController = this;
        synchronized (lynxController) {
            return this.isEngaged;
        }
    }

    protected LynxModuleIntf getModule() {
        return this.isHooked ? this.module : this.pretendModule;
    }

    protected void adjustHookingToMatchEngagement() {
        if (!this.isHooked && this.isEngaged) {
            this.hook();
        } else if (this.isHooked && !this.isEngaged) {
            this.unhook();
        }
    }

    protected void hook() {
        this.doHook();
        this.isHooked = true;
        try {
            this.initializeHardwareIfNecessary();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (RobotCoreException e) {
            RobotLog.ee((String)this.getTag(), (Throwable)e, (String)"exception thrown in LynxController.hook()");
        }
    }

    protected void unhook() {
        this.doUnhook();
        this.isHooked = false;
    }

    protected void doHook() {
    }

    protected void doUnhook() {
    }

    protected boolean isArmed() {
        return this.module.getArmingState() == RobotArmingStateNotifier.ARMINGSTATE.ARMED;
    }

    public class PretendLynxModule
    implements LynxModuleIntf {
        boolean isEngaged = true;

        public HardwareDevice.Manufacturer getManufacturer() {
            return HardwareDevice.Manufacturer.Lynx;
        }

        public String getFirmwareVersionString() {
            return this.getDeviceName();
        }

        public String getNullableFirmwareVersionString() {
            return null;
        }

        public String getDeviceName() {
            return LynxController.this.module.getDeviceName() + " (pretend)";
        }

        public String getConnectionInfo() {
            return LynxController.this.module.getConnectionInfo();
        }

        public int getVersion() {
            return 1;
        }

        public void resetDeviceConfigurationForOpMode() {
        }

        public void close() {
        }

        public SerialNumber getSerialNumber() {
            return LynxController.this.module.getSerialNumber();
        }

        @Override
        public <T> T acquireI2cLockWhile(Supplier<T> supplier) throws InterruptedException, RobotCoreException, LynxNackException {
            return supplier.get();
        }

        @Override
        public void acquireNetworkTransmissionLock(LynxMessage message) throws InterruptedException {
        }

        @Override
        public void releaseNetworkTransmissionLock(LynxMessage message) throws InterruptedException {
        }

        @Override
        public void sendCommand(LynxMessage command) throws InterruptedException, LynxUnsupportedCommandException {
        }

        @Override
        public void retransmit(LynxMessage message) throws InterruptedException {
        }

        @Override
        public void finishedWithMessage(LynxMessage message) throws InterruptedException {
        }

        @Override
        public void resetPingTimer(@NonNull LynxMessage message) {
        }

        public int getModuleAddress() {
            return LynxController.this.module.getModuleAddress();
        }

        @Override
        public void setAttentionRequired(boolean attentionRequired) {
        }

        @Override
        public LynxInterface getInterface(String interfaceName) {
            return LynxController.this.module.getInterface(interfaceName);
        }

        public boolean isParent() {
            return true;
        }

        @Override
        public void validateCommand(LynxMessage lynxMessage) throws LynxUnsupportedCommandException {
        }

        @Override
        public boolean isCommandSupported(Class<? extends LynxCommand> command) {
            return false;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        public boolean isEngaged() {
            return this.isEngaged;
        }

        public void engage() {
            this.isEngaged = true;
        }

        public void disengage() {
            this.isEngaged = false;
        }

        @Override
        public void noteNotResponding() {
        }

        @Override
        public boolean isNotResponding() {
            return false;
        }

        public void attemptFailSafeAndIgnoreErrors() {
        }
    }
}

