/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.commands.core.LynxGetDIODirectionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetDIODirectionResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxGetSingleDIOInputCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxGetSingleDIOInputResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxSetDIODirectionCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxSetSingleDIOOutputCommand;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DigitalChannel;
import com.qualcomm.robotcore.hardware.DigitalChannelController;
import com.qualcomm.robotcore.util.LastKnown;
import com.qualcomm.robotcore.util.SerialNumber;

public class LynxDigitalChannelController
extends LynxController
implements DigitalChannelController {
    public static final String TAG = "LynxDigitalChannelController";
    public static final int apiPinFirst = 0;
    public static final int apiPinLast = 7;
    protected final PinProperties[] pins = new PinProperties[8];

    @Override
    protected String getTag() {
        return TAG;
    }

    public LynxDigitalChannelController(Context context, LynxModule module) throws RobotCoreException, InterruptedException {
        super(context, module);
        for (int pin = 0; pin <= 7; ++pin) {
            this.pins[pin - 0] = new PinProperties();
        }
        this.finishConstruction();
    }

    @Override
    public void initializeHardware() {
        this.forgetLastKnown();
        for (int pin = 0; pin <= 7; ++pin) {
            this.internalSetDigitalChannelMode(pin - 0, DigitalChannel.Mode.INPUT);
        }
    }

    @Override
    public void forgetLastKnown() {
        for (PinProperties pin : this.pins) {
            pin.lastKnownMode.invalidate();
            pin.lastKnownState.invalidate();
        }
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxDigitalChannelControllerDisplayName);
    }

    @Override
    public SerialNumber getSerialNumber() {
        return this.getModule().getSerialNumber();
    }

    public synchronized DigitalChannel.Mode getDigitalChannelMode(int pin) {
        this.validatePin(pin);
        DigitalChannel.Mode result = (DigitalChannel.Mode)this.pins[pin += 0].lastKnownMode.getValue();
        if (result != null) {
            return result;
        }
        LynxGetDIODirectionCommand command = new LynxGetDIODirectionCommand(this.getModule(), pin);
        try {
            LynxGetDIODirectionResponse response = (LynxGetDIODirectionResponse)command.sendReceive();
            result = response.getMode();
            this.pins[pin].lastKnownMode.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(DigitalChannel.Mode.INPUT);
        }
    }

    public synchronized void setDigitalChannelMode(int pin, DigitalChannel.Mode mode) {
        DigitalChannel.Mode existingMode = this.getDigitalChannelMode(pin);
        this.validatePin(pin);
        this.internalSetDigitalChannelMode(pin += 0, mode);
        if (existingMode == DigitalChannel.Mode.INPUT && mode == DigitalChannel.Mode.OUTPUT) {
            this.pins[pin].lastKnownState.setValue((Object)false);
        }
    }

    @Deprecated
    public void setDigitalChannelMode(int pin, DigitalChannelController.Mode mode) {
        this.setDigitalChannelMode(pin, mode.migrate());
    }

    void internalSetDigitalChannelMode(int pinZ, DigitalChannel.Mode mode) {
        LynxSetDIODirectionCommand command = new LynxSetDIODirectionCommand(this.getModule(), pinZ, mode);
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            this.pins[pinZ].lastKnownMode.invalidate();
            return;
        }
        this.pins[pinZ].lastKnownMode.setValue((Object)mode);
    }

    public synchronized boolean getDigitalChannelState(int pin) {
        LynxModule module;
        DigitalChannel.Mode mode = this.getDigitalChannelMode(pin);
        this.validatePin(pin);
        pin += 0;
        if (mode == DigitalChannel.Mode.OUTPUT) {
            return (Boolean)this.pins[pin].lastKnownState.getNonTimedValue();
        }
        LynxGetSingleDIOInputCommand command = new LynxGetSingleDIOInputCommand(this.getModule(), pin);
        if (this.getModule() instanceof LynxModule && (module = (LynxModule)this.getModule()).getBulkCachingMode() != LynxModule.BulkCachingMode.OFF) {
            LynxModule.BulkData bulkData = module.recordBulkCachingCommandIntent(command);
            return bulkData.getDigitalChannelState(pin);
        }
        try {
            LynxGetSingleDIOInputResponse response = (LynxGetSingleDIOInputResponse)command.sendReceive();
            boolean result = response.getValue();
            this.pins[pin].lastKnownState.setValue((Object)result);
            return result;
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
            return LynxUsbUtil.makePlaceholderValue(false);
        }
    }

    public synchronized void setDigitalChannelState(int pin, boolean state) {
        DigitalChannel.Mode mode = this.getDigitalChannelMode(pin);
        this.validatePin(pin);
        pin += 0;
        if (mode == DigitalChannel.Mode.OUTPUT) {
            LynxSetSingleDIOOutputCommand command = new LynxSetSingleDIOOutputCommand(this.getModule(), pin, state);
            try {
                command.send();
            }
            catch (LynxNackException | InterruptedException | RuntimeException e) {
                this.handleException(e);
                this.pins[pin].lastKnownState.invalidate();
                return;
            }
            this.pins[pin].lastKnownState.setValue((Object)state);
        }
    }

    private void validatePin(int pin) {
        if (pin < 0 || pin > 7) {
            throw new IllegalArgumentException(String.format("pin %d is invalid; valid pins are %d..%d", pin, 0, 7));
        }
    }

    protected class PinProperties {
        LastKnown<DigitalChannel.Mode> lastKnownMode = new LastKnown();
        LastKnown<Boolean> lastKnownState = new LastKnown();

        protected PinProperties() {
        }
    }
}

