/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.usb.ftdi.RobotUsbDeviceFtdi;
import com.qualcomm.robotcore.util.ReadWriteFile;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.concurrent.atomic.AtomicBoolean;
import org.firstinspires.ftc.robotcore.external.Consumer;
import org.firstinspires.ftc.robotcore.internal.hardware.android.AndroidBoard;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.stellaris.FlashLoaderManager;
import org.firstinspires.ftc.robotcore.internal.stellaris.FlashLoaderProtocolException;
import org.firstinspires.ftc.robotcore.internal.system.AppAliveNotifier;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;

class LynxFirmwareUpdater {
    private static final String TAG = "LynxFirmwareUpdater";
    private static final AtomicBoolean firmwareUpdateInProgress = new AtomicBoolean(false);
    private final LynxUsbDeviceImpl device;
    private final boolean isControlHub;

    public LynxFirmwareUpdater(LynxUsbDeviceImpl device) {
        this.device = device;
        this.isControlHub = device.getSerialNumber().isEmbedded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RobotCoreCommandList.LynxFirmwareUpdateResp updateFirmware(RobotCoreCommandList.FWImage image, String requestId, Consumer<ProgressParameters> progressConsumer) {
        byte[] firmwareImage;
        RobotCoreCommandList.LynxFirmwareUpdateResp result;
        block7: {
            result = new RobotCoreCommandList.LynxFirmwareUpdateResp();
            result.success = false;
            result.originatorId = requestId;
            RobotLog.vv((String)TAG, (String)"updateFirmware() serialNumber=%s, fwimage=%s", (Object[])new Object[]{this.device.getSerialNumber(), image.getName()});
            firmwareImage = ReadWriteFile.readBytes((RobotCoreCommandList.FWImage)image);
            if (firmwareImage.length <= 0) {
                result.errorMessage = AppUtil.getDefContext().getString(R.string.lynxFirmwareFileEmpty);
                RobotLog.vv((String)TAG, (String)"Firmware update file was empty");
                return result;
            }
            boolean firmwareUpdateAllowed = firmwareUpdateInProgress.compareAndSet(false, true);
            if (firmwareUpdateAllowed) break block7;
            result.errorMessage = AppUtil.getDefContext().getString(R.string.lynxFirmwareUpdateAlreadyInProgress);
            RobotLog.vv((String)TAG, (String)"Cannot update firmware: a firmware update is already in progress");
            RobotCoreCommandList.LynxFirmwareUpdateResp lynxFirmwareUpdateResp = result;
            RobotLog.vv((String)TAG, (String)"reengaging lynx usb device %s", (Object[])new Object[]{this.device.getSerialNumber()});
            this.device.engage();
            firmwareUpdateInProgress.set(false);
            return lynxFirmwareUpdateResp;
        }
        try {
            RobotLog.vv((String)TAG, (String)"disengaging lynx usb device %s", (Object[])new Object[]{this.device.getSerialNumber()});
            this.device.disengage();
            int cRetryFirmwareUpdate = 2;
            for (int i = 0; i < cRetryFirmwareUpdate; ++i) {
                RobotLog.vv((String)TAG, (String)"trying firmware update: count=%d", (Object[])new Object[]{i});
                AppAliveNotifier.getInstance().notifyAppAlive();
                if (!this.updateFirmwareOnce(firmwareImage, progressConsumer)) continue;
                result.success = true;
                break;
            }
        }
        catch (RuntimeException e) {
            try {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"RuntimeException in updateLynxFirmware()");
            }
            catch (Throwable throwable) {
                RobotLog.vv((String)TAG, (String)"reengaging lynx usb device %s", (Object[])new Object[]{this.device.getSerialNumber()});
                this.device.engage();
                firmwareUpdateInProgress.set(false);
                throw throwable;
            }
            RobotLog.vv((String)TAG, (String)"reengaging lynx usb device %s", (Object[])new Object[]{this.device.getSerialNumber()});
            this.device.engage();
            firmwareUpdateInProgress.set(false);
        }
        RobotLog.vv((String)TAG, (String)"reengaging lynx usb device %s", (Object[])new Object[]{this.device.getSerialNumber()});
        this.device.engage();
        firmwareUpdateInProgress.set(false);
        return result;
    }

    private boolean updateFirmwareOnce(byte[] firmwareImage, Consumer<ProgressParameters> progressConsumer) {
        boolean success = true;
        if (this.enterFirmwareUpdateMode()) {
            FlashLoaderManager manager = new FlashLoaderManager(this.device.getRobotUsbDevice(), firmwareImage);
            try {
                manager.updateFirmware(progressConsumer);
            }
            catch (InterruptedException e) {
                success = false;
                Thread.currentThread().interrupt();
                RobotLog.ee((String)TAG, (String)"interrupt while updating firmware: serial=%s", (Object[])new Object[]{this.device.getSerialNumber()});
            }
            catch (FlashLoaderProtocolException e) {
                success = false;
                RobotLog.ee((String)TAG, (Throwable)e, (String)"exception while updating firmware: serial=%s", (Object[])new Object[]{this.device.getSerialNumber()});
            }
        } else {
            RobotLog.ee((String)TAG, (String)"failed to enter firmware update mode");
            success = false;
        }
        return success;
    }

    private boolean enterFirmwareUpdateMode() {
        boolean result = false;
        if (this.isControlHub) {
            RobotLog.vv((String)TAG, (String)"putting embedded lynx into firmware update mode");
            result = this.enterFirmwareUpdateModeControlHub();
        } else {
            RobotLog.vv((String)TAG, (String)"putting lynx(serial=%s) into firmware update mode", (Object[])new Object[]{this.device.getSerialNumber()});
            result = this.enterFirmwareUpdateModeUSB();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private boolean enterFirmwareUpdateModeUSB() {
        RobotLog.vv((String)"LynxModule", (String)"enterFirmwareUpdateModeUSB() serial=%s", (Object[])new Object[]{this.device.getSerialNumber()});
        if (!LynxConstants.isEmbeddedSerialNumber((SerialNumber)this.device.getSerialNumber())) {
            RobotUsbDeviceFtdi deviceFtdi = LynxUsbDeviceImpl.accessCBus(this.device.getRobotUsbDevice());
            if (deviceFtdi != null) {
                try {
                    int msDelay = 75;
                    deviceFtdi.cbus_setup(3, 3);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(1);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(0);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(1);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(3);
                    Thread.sleep(200L);
                    return true;
                }
                catch (InterruptedException | RobotUsbException e) {
                    LynxUsbDeviceImpl.exceptionHandler.handleException((Exception)e);
                }
            } else {
                RobotLog.ee((String)TAG, (String)"enterFirmwareUpdateModeUSB() can't access FTDI device");
            }
        } else {
            RobotLog.ee((String)TAG, (String)"enterFirmwareUpdateModeUSB() issued on Control Hub's embedded Expansion Hub");
        }
        return false;
    }

    public boolean enterFirmwareUpdateModeControlHub() {
        RobotLog.vv((String)"LynxModule", (String)"enterFirmwareUpdateModeControlHub()");
        if (LynxConstants.isRevControlHub()) {
            try {
                int msDelay = 75;
                boolean prevState = AndroidBoard.getInstance().getAndroidBoardIsPresentPin().getState();
                RobotLog.vv((String)"LynxModule", (String)"fw update embedded usb device: isPresent: was=%s", (Object[])new Object[]{prevState});
                if (!prevState) {
                    AndroidBoard.getInstance().getAndroidBoardIsPresentPin().setState(true);
                    Thread.sleep(msDelay);
                }
                AndroidBoard.getInstance().getProgrammingPin().setState(true);
                Thread.sleep(msDelay);
                AndroidBoard.getInstance().getLynxModuleResetPin().setState(true);
                Thread.sleep(msDelay);
                AndroidBoard.getInstance().getLynxModuleResetPin().setState(false);
                Thread.sleep(msDelay);
                AndroidBoard.getInstance().getProgrammingPin().setState(false);
                Thread.sleep(msDelay);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            RobotLog.ee((String)TAG, (String)"enterFirmwareUpdateModeControlHub() issued on non-Control Hub");
        }
        return false;
    }
}

