/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import com.qualcomm.hardware.ams.AMSColorSensor;
import com.qualcomm.hardware.ams.AMSColorSensorImpl;
import com.qualcomm.robotcore.R;
import com.qualcomm.robotcore.hardware.ColorRangeSensor;
import com.qualcomm.robotcore.hardware.DistanceSensor;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.OpticalDistanceSensor;
import com.qualcomm.robotcore.util.Range;
import java.nio.ByteOrder;
import java.util.Locale;
import org.firstinspires.ftc.robotcore.external.navigation.DistanceUnit;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class LynxI2cColorRangeSensor
extends AMSColorSensorImpl
implements DistanceSensor,
OpticalDistanceSensor,
ColorRangeSensor {
    protected static final double apiLevelMin = 0.0;
    protected static final double apiLevelMax = 1.0;
    public double aParam = 186.347;
    public double bParam = 30403.5;
    public double cParam = 0.576649;

    public LynxI2cColorRangeSensor(I2cDeviceSynchSimple deviceClient, boolean deviceClientIsOwned) {
        super(AMSColorSensor.Parameters.createForTMD37821(), deviceClient, deviceClientIsOwned);
    }

    public double getDistance(DistanceUnit unit) {
        int rawOptical = this.rawOptical();
        double cmOptical = this.cmFromOptical(rawOptical);
        return unit.fromUnit(DistanceUnit.CM, cmOptical);
    }

    protected double cmFromOptical(int rawOptical) {
        return (-this.aParam * this.cParam + this.cParam * (double)rawOptical - Math.sqrt(-this.aParam * this.bParam + this.bParam * (double)rawOptical)) / (this.aParam - (double)rawOptical);
    }

    @Override
    public String getDeviceName() {
        return AppUtil.getDefContext().getString(R.string.configTypeLynxColorSensor);
    }

    @Override
    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public double getLightDetected() {
        return Range.clip((double)Range.scale((double)this.getRawLightDetected(), (double)0.0, (double)this.getRawLightDetectedMax(), (double)0.0, (double)1.0), (double)0.0, (double)1.0);
    }

    public double getRawLightDetected() {
        return this.rawOptical();
    }

    public double getRawLightDetectedMax() {
        return ((AMSColorSensor.Parameters)this.parameters).proximitySaturation;
    }

    public String status() {
        return String.format(Locale.getDefault(), "%s on %s", this.getDeviceName(), this.getConnectionInfo());
    }

    public int rawOptical() {
        return this.readUnsignedShort(AMSColorSensor.Register.PDATA, ByteOrder.LITTLE_ENDIAN);
    }
}

