/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxController;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.Supplier;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cConfigureChannelCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadMultipleBytesCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadSingleByteCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadStatusQueryCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadStatusQueryResponse;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteMultipleBytesCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteSingleByteCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteStatusQueryCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteStatusQueryResponse;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.HardwareDeviceHealth;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchReadHistory;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchReadHistoryImpl;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.hardware.TimestampedI2cData;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.Util;
import java.util.concurrent.BlockingQueue;

public abstract class LynxI2cDeviceSynch
extends LynxController
implements I2cDeviceSynchSimple,
I2cDeviceSynchReadHistory {
    public static final String TAG = "LynxI2cDeviceSynch";
    protected I2cAddr i2cAddr;
    protected int bus;
    private boolean loggingEnabled;
    private String loggingTag;
    private String name;
    private final I2cDeviceSynchReadHistoryImpl readHistory = new I2cDeviceSynchReadHistoryImpl();
    protected LynxUsbUtil.Placeholder<TimestampedData> readTimeStampedPlaceholder = new LynxUsbUtil.Placeholder("LynxI2cDeviceSynch", "readTimestamped", new Object[0]);
    private LynxUsbUtil.Placeholder<TimestampedData> readStatusQueryPlaceholder = new LynxUsbUtil.Placeholder("LynxI2cDeviceSynch", "readStatusQuery", new Object[0]);

    @Override
    protected String getTag() {
        return TAG;
    }

    protected LynxI2cDeviceSynch(Context context, LynxModule module, int bus) {
        super(context, module);
        this.bus = bus;
        this.i2cAddr = I2cAddr.zero();
        this.loggingEnabled = false;
        this.loggingTag = TAG;
        this.finishConstruction();
    }

    @Override
    public String getDeviceName() {
        return this.context.getString(R.string.lynxI2cDeviceSynchDisplayName);
    }

    @Override
    public String getConnectionInfo() {
        return String.format("%s; bus %d; addr7=0x%02x", this.getModule().getConnectionInfo(), this.bus, this.i2cAddr.get7Bit());
    }

    @Override
    public void resetDeviceConfigurationForOpMode() {
        super.resetDeviceConfigurationForOpMode();
        this.setBusSpeed(BusSpeed.STANDARD_100K);
        this.readTimeStampedPlaceholder.reset();
        this.readStatusQueryPlaceholder.reset();
    }

    @Override
    public void close() {
        this.setHealthStatus(HardwareDeviceHealth.HealthStatus.CLOSED);
        super.close();
    }

    @Override
    public boolean isArmed() {
        return super.isArmed();
    }

    public void setI2cAddress(I2cAddr i2cAddr) {
        this.i2cAddr = i2cAddr;
    }

    public void setI2cAddr(I2cAddr i2cAddr) {
        this.i2cAddr = i2cAddr;
    }

    public I2cAddr getI2cAddress() {
        return this.i2cAddr;
    }

    public I2cAddr getI2cAddr() {
        return this.i2cAddr;
    }

    public void setUserConfiguredName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public String getUserConfiguredName() {
        return this.name;
    }

    public void setLogging(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public boolean getLogging() {
        return this.loggingEnabled;
    }

    public void setLoggingTag(String loggingTag) {
        this.loggingTag = loggingTag;
    }

    public String getLoggingTag() {
        return this.loggingTag;
    }

    public void setHistoryQueueCapacity(int capacity) {
        this.readHistory.setHistoryQueueCapacity(capacity);
    }

    public int getHistoryQueueCapacity() {
        return this.readHistory.getHistoryQueueCapacity();
    }

    public BlockingQueue<TimestampedI2cData> getHistoryQueue() {
        return this.readHistory.getHistoryQueue();
    }

    public byte[] read(int ireg, int creg) {
        return this.readTimeStamped((int)ireg, (int)creg).data;
    }

    public synchronized byte read8(int ireg) {
        return this.read(ireg, 1)[0];
    }

    public abstract TimestampedData readTimeStamped(int var1, int var2);

    public byte[] read(int creg) {
        return this.readTimeStamped((int)creg).data;
    }

    public synchronized byte read8() {
        try {
            final Supplier<LynxI2cReadSingleByteCommand> readTxSupplier = new Supplier<LynxI2cReadSingleByteCommand>(){

                @Override
                public LynxI2cReadSingleByteCommand get() {
                    return new LynxI2cReadSingleByteCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr);
                }
            };
            return this.acquireI2cLockWhile(new Supplier<Byte>(){

                @Override
                public Byte get() throws InterruptedException, LynxNackException, RobotCoreException {
                    LynxI2cDeviceSynch.this.sendI2cTransaction(readTxSupplier);
                    return LynxI2cDeviceSynch.this.pollForReadResult((I2cAddr)LynxI2cDeviceSynch.this.i2cAddr, (int)0, (int)1).data[0];
                }
            });
        }
        catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
            return LynxUsbUtil.makePlaceholderValue((byte)0);
        }
    }

    public synchronized TimestampedData readTimeStamped(final int creg) {
        try {
            final Supplier readTxSupplier = new Supplier<LynxCommand<?>>(){

                @Override
                public LynxCommand<?> get() {
                    return creg == 1 ? new LynxI2cReadSingleByteCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr) : new LynxI2cReadMultipleBytesCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr, creg);
                }
            };
            return this.acquireI2cLockWhile(new Supplier<TimestampedData>(){

                @Override
                public TimestampedData get() throws InterruptedException, LynxNackException, RobotCoreException {
                    LynxI2cDeviceSynch.this.sendI2cTransaction(readTxSupplier);
                    LynxI2cDeviceSynch.this.readTimeStampedPlaceholder.reset();
                    return LynxI2cDeviceSynch.this.pollForReadResult(LynxI2cDeviceSynch.this.i2cAddr, 0, creg);
                }
            });
        }
        catch (RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        catch (LynxNackException e) {
            I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
            this.handleException(e);
        }
        return this.readTimeStampedPlaceholder.log((TimestampedData)TimestampedI2cData.makeFakeData((I2cAddr)this.getI2cAddress(), (int)0, (int)creg));
    }

    public void write(int ireg, byte[] data) {
        this.internalWrite(ireg, data, I2cWaitControl.ATOMIC);
    }

    public synchronized void write8(int ireg, int bVal) {
        this.internalWrite(ireg, new byte[]{(byte)bVal}, I2cWaitControl.ATOMIC);
    }

    public synchronized void write8(int ireg, int bVal, I2cWaitControl waitControl) {
        this.internalWrite(ireg, new byte[]{(byte)bVal}, waitControl);
    }

    public synchronized void write(int ireg, byte[] data, I2cWaitControl waitControl) {
        this.internalWrite(ireg, data, waitControl);
    }

    private void internalWrite(int ireg, byte[] data, final I2cWaitControl waitControl) {
        if (data.length > 0) {
            final byte[] payload = Util.concatenateByteArrays((byte[])new byte[]{(byte)ireg}, (byte[])data);
            final Supplier writeTxSupplier = new Supplier<LynxCommand<?>>(){

                @Override
                public LynxCommand<?> get() {
                    return payload.length == 1 ? new LynxI2cWriteSingleByteCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr, payload[0]) : new LynxI2cWriteMultipleBytesCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr, payload);
                }
            };
            try {
                this.acquireI2cLockWhile(new Supplier<Object>(){

                    @Override
                    public Object get() throws InterruptedException, RobotCoreException, LynxNackException {
                        LynxI2cDeviceSynch.this.sendI2cTransaction(writeTxSupplier);
                        LynxI2cDeviceSynch.this.internalWaitForWriteCompletions(waitControl);
                        return null;
                    }
                });
            }
            catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException e) {
                this.handleException((Exception)e);
            }
        }
    }

    public synchronized void write(byte[] data) {
        this.internalWrite(data, I2cWaitControl.ATOMIC);
    }

    public synchronized void write(byte[] data, I2cWaitControl waitControl) {
        this.internalWrite(data, waitControl);
    }

    public synchronized void write8(int bVal) {
        this.internalWrite(new byte[]{(byte)bVal}, I2cWaitControl.ATOMIC);
    }

    public synchronized void write8(int bVal, I2cWaitControl waitControl) {
        this.internalWrite(new byte[]{(byte)bVal}, waitControl);
    }

    private void internalWrite(final byte[] payload, final I2cWaitControl waitControl) {
        if (payload.length > 0) {
            final Supplier writeTxSupplier = new Supplier<LynxCommand<?>>(){

                @Override
                public LynxCommand<?> get() {
                    return payload.length == 1 ? new LynxI2cWriteSingleByteCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr, payload[0]) : new LynxI2cWriteMultipleBytesCommand(LynxI2cDeviceSynch.this.getModule(), LynxI2cDeviceSynch.this.bus, LynxI2cDeviceSynch.this.i2cAddr, payload);
                }
            };
            try {
                this.acquireI2cLockWhile(new Supplier<Object>(){

                    @Override
                    public Object get() throws InterruptedException, RobotCoreException, LynxNackException {
                        LynxI2cDeviceSynch.this.sendI2cTransaction(writeTxSupplier);
                        LynxI2cDeviceSynch.this.internalWaitForWriteCompletions(waitControl);
                        return null;
                    }
                });
            }
            catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException e) {
                this.handleException((Exception)e);
            }
        }
    }

    public synchronized void waitForWriteCompletions(final I2cWaitControl waitControl) {
        try {
            this.acquireI2cLockWhile(new Supplier<Object>(){

                @Override
                public Object get() {
                    LynxI2cDeviceSynch.this.internalWaitForWriteCompletions(waitControl);
                    return null;
                }
            });
        }
        catch (LynxNackException | RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
    }

    public void enableWriteCoalescing(boolean enable) {
    }

    public boolean isWriteCoalescingEnabled() {
        return false;
    }

    protected void sendI2cTransaction(Supplier<? extends LynxCommand<?>> transactionSupplier) throws LynxNackException, InterruptedException, RobotCoreException {
        block5: while (true) {
            try {
                transactionSupplier.get().send();
            }
            catch (LynxNackException e) {
                switch (e.getNack().getNackReasonCodeAsEnum()) {
                    case I2C_MASTER_BUSY: 
                    case I2C_OPERATION_IN_PROGRESS: {
                        continue block5;
                    }
                }
                throw e;
            }
            break;
        }
    }

    protected <T> T acquireI2cLockWhile(Supplier<T> supplier) throws InterruptedException, RobotCoreException, LynxNackException {
        return this.getModule().acquireI2cLockWhile(supplier);
    }

    protected void internalWaitForWriteCompletions(I2cWaitControl waitControl) {
        if (waitControl == I2cWaitControl.WRITTEN) {
            boolean keepTrying = true;
            block7: while (keepTrying) {
                LynxI2cWriteStatusQueryCommand writeStatus = new LynxI2cWriteStatusQueryCommand(this.getModule(), this.bus);
                try {
                    LynxI2cWriteStatusQueryResponse response = (LynxI2cWriteStatusQueryResponse)writeStatus.sendReceive();
                    if (response.isStatusOk()) {
                        I2cWarningManager.removeProblemI2cDevice((I2cDeviceSynchSimple)this);
                    } else {
                        I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
                    }
                    return;
                }
                catch (LynxNackException e) {
                    switch (e.getNack().getNackReasonCodeAsEnum()) {
                        case I2C_NO_RESULTS_PENDING: {
                            return;
                        }
                        case I2C_OPERATION_IN_PROGRESS: {
                            continue block7;
                        }
                    }
                    this.handleException(e);
                    keepTrying = false;
                }
                catch (InterruptedException | RuntimeException e) {
                    this.handleException(e);
                    keepTrying = false;
                }
            }
        }
    }

    protected TimestampedData pollForReadResult(I2cAddr i2cAddr, int ireg, int creg) {
        boolean keepTrying = true;
        block7: while (keepTrying) {
            LynxI2cReadStatusQueryCommand readStatus = new LynxI2cReadStatusQueryCommand(this.getModule(), this.bus, creg);
            try {
                LynxI2cReadStatusQueryResponse response = (LynxI2cReadStatusQueryResponse)readStatus.sendReceive();
                long now = System.nanoTime();
                response.logResponse();
                TimestampedI2cData result = new TimestampedI2cData();
                result.data = response.getBytes();
                result.nanoTime = response.getPayloadTimeWindow().isCleared() ? now : response.getPayloadTimeWindow().getNanosecondsLast();
                result.i2cAddr = i2cAddr;
                result.register = ireg;
                if (result.data.length == creg) {
                    this.readStatusQueryPlaceholder.reset();
                    this.readHistory.addToHistoryQueue(result);
                    I2cWarningManager.removeProblemI2cDevice((I2cDeviceSynchSimple)this);
                    return result;
                }
                RobotLog.ee((String)this.loggingTag, (String)"readStatusQuery: cbExpected=%d cbRead=%d", (Object[])new Object[]{creg, result.data.length});
                I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
                keepTrying = false;
            }
            catch (LynxNackException e) {
                switch (e.getNack().getNackReasonCodeAsEnum()) {
                    case I2C_MASTER_BUSY: 
                    case I2C_OPERATION_IN_PROGRESS: {
                        continue block7;
                    }
                    case I2C_NO_RESULTS_PENDING: {
                        this.handleException(e);
                        keepTrying = false;
                        I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
                        break;
                    }
                    default: {
                        this.handleException(e);
                        keepTrying = false;
                        I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
                        break;
                    }
                }
            }
            catch (InterruptedException | RuntimeException e) {
                this.handleException(e);
                keepTrying = false;
            }
        }
        return this.readStatusQueryPlaceholder.log((TimestampedData)TimestampedI2cData.makeFakeData((I2cAddr)i2cAddr, (int)ireg, (int)creg));
    }

    public void setBusSpeed(BusSpeed speed) {
        LynxI2cConfigureChannelCommand command = new LynxI2cConfigureChannelCommand(this.getModule(), this.bus, speed.toSpeedCode());
        try {
            command.send();
        }
        catch (LynxNackException | InterruptedException | RuntimeException e) {
            this.handleException(e);
        }
    }

    public static enum BusSpeed {
        STANDARD_100K{

            @Override
            protected LynxI2cConfigureChannelCommand.SpeedCode toSpeedCode() {
                return LynxI2cConfigureChannelCommand.SpeedCode.STANDARD_100K;
            }
        }
        ,
        FAST_400K{

            @Override
            protected LynxI2cConfigureChannelCommand.SpeedCode toSpeedCode() {
                return LynxI2cConfigureChannelCommand.SpeedCode.FAST_400K;
            }
        };


        protected LynxI2cConfigureChannelCommand.SpeedCode toSpeedCode() {
            throw new AbstractMethodError();
        }
    }
}

