/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.Supplier;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadMultipleBytesCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cReadSingleByteCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteSingleByteCommand;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWaitControl;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.hardware.TimestampedI2cData;

public class LynxI2cDeviceSynchV1
extends LynxI2cDeviceSynch {
    public LynxI2cDeviceSynchV1(Context context, LynxModule module, int bus) {
        super(context, module, bus);
    }

    @Override
    public synchronized TimestampedData readTimeStamped(final int ireg, final int creg) {
        try {
            final Supplier<LynxI2cWriteSingleByteCommand> writeTxSupplier = new Supplier<LynxI2cWriteSingleByteCommand>(){

                @Override
                public LynxI2cWriteSingleByteCommand get() {
                    return new LynxI2cWriteSingleByteCommand(LynxI2cDeviceSynchV1.this.getModule(), LynxI2cDeviceSynchV1.this.bus, LynxI2cDeviceSynchV1.this.i2cAddr, ireg);
                }
            };
            final Supplier readTxSupplier = new Supplier<LynxCommand<?>>(){

                @Override
                public LynxCommand<?> get() {
                    return creg == 1 ? new LynxI2cReadSingleByteCommand(LynxI2cDeviceSynchV1.this.getModule(), LynxI2cDeviceSynchV1.this.bus, LynxI2cDeviceSynchV1.this.i2cAddr) : new LynxI2cReadMultipleBytesCommand(LynxI2cDeviceSynchV1.this.getModule(), LynxI2cDeviceSynchV1.this.bus, LynxI2cDeviceSynchV1.this.i2cAddr, creg);
                }
            };
            return this.acquireI2cLockWhile(new Supplier<TimestampedData>(){

                @Override
                public TimestampedData get() throws InterruptedException, RobotCoreException, LynxNackException {
                    LynxI2cDeviceSynchV1.this.sendI2cTransaction(writeTxSupplier);
                    LynxI2cDeviceSynchV1.this.internalWaitForWriteCompletions(I2cWaitControl.ATOMIC);
                    LynxI2cDeviceSynchV1.this.sendI2cTransaction(readTxSupplier);
                    LynxI2cDeviceSynchV1.this.readTimeStampedPlaceholder.reset();
                    return LynxI2cDeviceSynchV1.this.pollForReadResult(LynxI2cDeviceSynchV1.this.i2cAddr, ireg, creg);
                }
            });
        }
        catch (RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        catch (LynxNackException e) {
            I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
            this.handleException(e);
        }
        return (TimestampedData)this.readTimeStampedPlaceholder.log(TimestampedI2cData.makeFakeData((I2cAddr)this.getI2cAddress(), (int)ireg, (int)creg));
    }
}

