/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import com.qualcomm.hardware.lynx.LynxI2cDeviceSynch;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.Supplier;
import com.qualcomm.hardware.lynx.commands.LynxCommand;
import com.qualcomm.hardware.lynx.commands.core.LynxI2cWriteReadMultipleBytesCommand;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.I2cAddr;
import com.qualcomm.robotcore.hardware.I2cDeviceSynchSimple;
import com.qualcomm.robotcore.hardware.I2cWarningManager;
import com.qualcomm.robotcore.hardware.TimestampedData;
import com.qualcomm.robotcore.hardware.TimestampedI2cData;

public class LynxI2cDeviceSynchV2
extends LynxI2cDeviceSynch {
    public LynxI2cDeviceSynchV2(Context context, LynxModule module, int bus) {
        super(context, module, bus);
    }

    @Override
    public synchronized TimestampedData readTimeStamped(final int ireg, final int creg) {
        try {
            final Supplier readWriteTxSupplier = new Supplier<LynxCommand<?>>(){

                @Override
                public LynxCommand<?> get() {
                    return new LynxI2cWriteReadMultipleBytesCommand(LynxI2cDeviceSynchV2.this.getModule(), LynxI2cDeviceSynchV2.this.bus, LynxI2cDeviceSynchV2.this.i2cAddr, ireg, creg);
                }
            };
            return this.acquireI2cLockWhile(new Supplier<TimestampedData>(){

                @Override
                public TimestampedData get() throws InterruptedException, RobotCoreException, LynxNackException {
                    LynxI2cDeviceSynchV2.this.sendI2cTransaction(readWriteTxSupplier);
                    LynxI2cDeviceSynchV2.this.readTimeStampedPlaceholder.reset();
                    return LynxI2cDeviceSynchV2.this.pollForReadResult(LynxI2cDeviceSynchV2.this.i2cAddr, ireg, creg);
                }
            });
        }
        catch (RobotCoreException | InterruptedException | RuntimeException e) {
            this.handleException((Exception)e);
        }
        catch (LynxNackException e) {
            I2cWarningManager.notifyProblemI2cDevice((I2cDeviceSynchSimple)this);
            this.handleException(e);
        }
        return (TimestampedData)this.readTimeStampedPlaceholder.log(TimestampedI2cData.makeFakeData((I2cAddr)this.getI2cAddress(), (int)ireg, (int)creg));
    }
}

