/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxModuleIntf;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerImpl;
import com.qualcomm.robotcore.eventloop.opmode.OpModeManagerNotifier;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareMap;
import com.qualcomm.robotcore.util.ElapsedTime;
import com.qualcomm.robotcore.util.GlobalWarningSource;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;

public class LynxModuleWarningManager {
    private static final LynxModuleWarningManager instance = new LynxModuleWarningManager();
    private static final String TAG = "LynxModuleWarningManager";
    private static final String MIN_FW_VERSION_HUMAN_STRING = "1.8.2";
    private static final int MIN_FW_VERSION_MAJOR = 1;
    private static final int MIN_FW_VERSION_MINOR = 8;
    private static final int MIN_FW_VERSION_ENG = 2;
    private static final int LOW_BATTERY_STATUS_TIMEOUT_SECONDS = 2;
    private static final int LOW_BATTERY_LOG_FREQUENCY_SECONDS = 2;
    private static final int UNRESPONSIVE_LOG_FREQUENCY_SECONDS = 2;
    private final OpModeManagerNotifier.Notifications opModeNotificationListener = new WarningManagerOpModeListener();
    private final SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)AppUtil.getDefContext());
    private final GlobalWarningSource warningSource = new LynxModuleWarningSource();
    private final Object warningMessageLock = new Object();
    private volatile boolean userOpModeRunning = false;
    private volatile HardwareMap hardwareMap = null;
    private final ConcurrentMap<Integer, UnresponsiveStatus> modulesReportedUnresponsive = new ConcurrentHashMap<Integer, UnresponsiveStatus>();
    private final ConcurrentMap<Integer, LowBatteryStatus> modulesReportedLowBattery = new ConcurrentHashMap<Integer, LowBatteryStatus>();
    private final Set<String> modulesReportedReset = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> outdatedModules = Collections.newSetFromMap(new ConcurrentHashMap());
    private String cachedWarningMessage = null;

    public static LynxModuleWarningManager getInstance() {
        return instance;
    }

    public void init(OpModeManagerImpl opModeManager, HardwareMap hardwareMap) {
        this.hardwareMap = hardwareMap;
        opModeManager.registerListener(this.opModeNotificationListener);
        this.warningSource.clearGlobalWarning();
        RobotLog.registerGlobalWarningSource((GlobalWarningSource)this.warningSource);
        if (this.sharedPrefs.getBoolean(AppUtil.getDefContext().getString(R.string.pref_warn_about_obsolete_software), true)) {
            this.lookForOutdatedModules();
        } else {
            this.outdatedModules.clear();
        }
    }

    public void reportModuleUnresponsive(LynxModule module) {
        if (!module.isUserModule() || !module.isOpen) {
            return;
        }
        int moduleNumber = module.getModuleAddress();
        UnresponsiveStatus unresponsiveStatus = (UnresponsiveStatus)this.modulesReportedUnresponsive.get(moduleNumber);
        if (unresponsiveStatus == null) {
            String moduleName = this.getModuleName(module);
            unresponsiveStatus = new UnresponsiveStatus((LynxModuleIntf)module, moduleName);
            this.modulesReportedUnresponsive.put(moduleNumber, unresponsiveStatus);
        }
        unresponsiveStatus.reportConditionAndLogWithThrottle(this.userOpModeRunning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportModuleReset(LynxModule module) {
        if (!module.isUserModule()) {
            return;
        }
        String moduleName = this.getModuleName(module);
        String logMessage = "%s regained power after a complete power loss.";
        if (this.userOpModeRunning) {
            logMessage = logMessage + " A user OpMode was running, so unexpected behavior may occur.";
            boolean newlyReported = this.modulesReportedReset.add(moduleName);
            if (newlyReported) {
                Object object = this.warningMessageLock;
                synchronized (object) {
                    this.cachedWarningMessage = null;
                }
            }
        } else {
            logMessage = logMessage + " No user OpMode was running.";
        }
        RobotLog.ww((String)"HubPowerCycle", (String)logMessage, (Object[])new Object[]{moduleName});
    }

    public void reportModuleLowBattery(LynxModule module) {
        if (!module.isUserModule()) {
            return;
        }
        int moduleNumber = module.getModuleAddress();
        LowBatteryStatus lowBatteryStatus = (LowBatteryStatus)this.modulesReportedLowBattery.get(moduleNumber);
        if (lowBatteryStatus == null) {
            String moduleName = this.getModuleName(module);
            lowBatteryStatus = new LowBatteryStatus(module, moduleName);
            this.modulesReportedLowBattery.put(moduleNumber, lowBatteryStatus);
        }
        lowBatteryStatus.reportConditionAndLogWithThrottle(this.userOpModeRunning);
    }

    private String getModuleName(LynxModule module) {
        String moduleName;
        try {
            moduleName = (String)this.hardwareMap.getNamesOf((HardwareDevice)module).iterator().next();
        }
        catch (RuntimeException e) {
            moduleName = "Expansion Hub " + module.getModuleAddress();
        }
        return moduleName;
    }

    private void lookForOutdatedModules() {
        this.outdatedModules.clear();
        List lynxModules = this.hardwareMap.getAll(LynxModule.class);
        for (LynxModule lynxModule : lynxModules) {
            try {
                boolean isExpansionHub;
                String fwVersion = lynxModule.getNullableFirmwareVersionString();
                if (fwVersion == null) continue;
                String[] versionNums = fwVersion.split("(, )?\\w*: ");
                versionNums = Arrays.copyOfRange(versionNums, 2, 5);
                int majorVersion = Integer.parseInt(versionNums[0]);
                int minorVersion = Integer.parseInt(versionNums[1]);
                int engVersion = Integer.parseInt(versionNums[2]);
                boolean bl = isExpansionHub = lynxModule.getRevProductNumber() == 3215698;
                if (!this.isFwVersionOutdated(majorVersion, minorVersion, engVersion) || !isExpansionHub) continue;
                this.outdatedModules.add(this.getModuleName(lynxModule));
            }
            catch (RuntimeException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Exception caught while checking if module is outdated");
            }
        }
    }

    private boolean isFwVersionOutdated(int majorVersion, int minorVersion, int engVersion) {
        if (majorVersion > 1) {
            return false;
        }
        if (majorVersion < 1) {
            return true;
        }
        if (minorVersion > 8) {
            return false;
        }
        if (minorVersion < 8) {
            return true;
        }
        return engVersion < 2;
    }

    private class WarningManagerOpModeListener
    implements OpModeManagerNotifier.Notifications {
        private WarningManagerOpModeListener() {
        }

        public void onOpModePreInit(OpMode opMode) {
            LynxModuleWarningManager.this.userOpModeRunning = !(opMode instanceof OpModeManagerImpl.DefaultOpMode);
        }

        public void onOpModePreStart(OpMode opMode) {
        }

        public void onOpModePostStop(OpMode opMode) {
            LynxModuleWarningManager.this.userOpModeRunning = false;
        }
    }

    private class LynxModuleWarningSource
    implements GlobalWarningSource {
        private int warningMessageSuppressionCount = 0;

        private LynxModuleWarningSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getGlobalWarning() {
            Object object = LynxModuleWarningManager.this.warningMessageLock;
            synchronized (object) {
                boolean cacheValid;
                if (this.warningMessageSuppressionCount > 0) {
                    return "";
                }
                boolean bl = cacheValid = LynxModuleWarningManager.this.cachedWarningMessage != null;
                if (cacheValid) {
                    for (ConditionStatus status : LynxModuleWarningManager.this.modulesReportedLowBattery.values()) {
                        if (!status.hasChangedSinceLastCheck()) continue;
                        cacheValid = false;
                        break;
                    }
                    for (ConditionStatus status : LynxModuleWarningManager.this.modulesReportedUnresponsive.values()) {
                        if (!status.hasChangedSinceLastCheck() && cacheValid) continue;
                        cacheValid = false;
                        break;
                    }
                }
                if (!cacheValid) {
                    LynxModuleWarningManager.this.cachedWarningMessage = this.composeWarning();
                }
                return LynxModuleWarningManager.this.cachedWarningMessage;
            }
        }

        public boolean shouldTriggerWarningSound() {
            return true;
        }

        private String composeWarning() {
            String currentlyUnresponsiveWarning = null;
            String previouslyUnresponsiveWarning = null;
            if (LynxModuleWarningManager.this.modulesReportedUnresponsive.size() > 0) {
                ArrayList<String> modulesCurrentlyUnresponsive = new ArrayList<String>();
                ArrayList<String> modulesUnresponsiveDuringOpMode = new ArrayList<String>();
                for (UnresponsiveStatus status : LynxModuleWarningManager.this.modulesReportedUnresponsive.values()) {
                    if (status.lynxModule.isNotResponding()) {
                        modulesCurrentlyUnresponsive.add(status.moduleName);
                        continue;
                    }
                    if (!status.conditionTrueDuringOpModeRun || LynxModuleWarningManager.this.modulesReportedReset.contains(status.moduleName)) continue;
                    modulesUnresponsiveDuringOpMode.add(status.moduleName);
                }
                currentlyUnresponsiveWarning = this.composeCurrentlyUnresponsiveWarning(modulesCurrentlyUnresponsive);
                previouslyUnresponsiveWarning = this.composePreviouslyNotRespondingWarning(modulesUnresponsiveDuringOpMode);
            }
            String powerIssuesWarning = this.composePowerIssuesWarning();
            String outdatedHubsWarning = this.composeOutdatedHubsWarning();
            return RobotLog.combineGlobalWarnings(Arrays.asList(currentlyUnresponsiveWarning, previouslyUnresponsiveWarning, powerIssuesWarning, outdatedHubsWarning));
        }

        @Nullable
        private String composeCurrentlyUnresponsiveWarning(List<String> modulesCurrentlyUnresponsive) {
            if (modulesCurrentlyUnresponsive.size() > 0) {
                StringBuilder builder = new StringBuilder();
                this.composeModuleList(modulesCurrentlyUnresponsive, builder);
                builder.append(AppUtil.getDefContext().getString(R.string.lynxModuleCurrentlyNotResponding));
                return builder.toString();
            }
            return null;
        }

        @Nullable
        private String composePreviouslyNotRespondingWarning(List<String> modulesUnresponsiveDuringOpMode) {
            if (modulesUnresponsiveDuringOpMode.size() > 0) {
                StringBuilder builder = new StringBuilder();
                this.composeModuleList(modulesUnresponsiveDuringOpMode, builder);
                builder.append(AppUtil.getDefContext().getString(R.string.lynxModulePreviouslyNotResponding));
                return builder.toString();
            }
            return null;
        }

        @Nullable
        private String composePowerIssuesWarning() {
            boolean batteryLowWarningAdded;
            if (LynxModuleWarningManager.this.modulesReportedReset.size() < 1 && LynxModuleWarningManager.this.modulesReportedLowBattery.size() < 1) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            boolean powerLossWarningAdded = this.composePowerLossWarning(builder);
            if (powerLossWarningAdded) {
                builder.append(" ");
            }
            if (batteryLowWarningAdded = this.composeBatteryLowWarning(builder)) {
                builder.append(" ");
            }
            if (powerLossWarningAdded || batteryLowWarningAdded) {
                this.composePowerIssueTip(LynxModuleWarningManager.this.userOpModeRunning, builder);
                return builder.toString();
            }
            return null;
        }

        @Nullable
        private String composeOutdatedHubsWarning() {
            if (LynxModuleWarningManager.this.outdatedModules.size() < 1) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            this.composeModuleList(LynxModuleWarningManager.this.outdatedModules, builder);
            builder.append(AppUtil.getDefContext().getString(R.string.lynxModuleFirmwareOutdated, new Object[]{LynxModuleWarningManager.MIN_FW_VERSION_HUMAN_STRING}));
            return builder.toString();
        }

        private boolean composePowerLossWarning(StringBuilder builder) {
            if (LynxModuleWarningManager.this.modulesReportedReset.size() < 1) {
                return false;
            }
            this.composeModuleList(LynxModuleWarningManager.this.modulesReportedReset, builder);
            builder.append(AppUtil.getDefContext().getString(R.string.lynxModulePowerLost));
            return true;
        }

        private boolean composeBatteryLowWarning(StringBuilder builder) {
            if (LynxModuleWarningManager.this.modulesReportedLowBattery.size() < 1) {
                return false;
            }
            boolean warningAdded = false;
            ArrayList<String> modulesCurrentlyReporting = new ArrayList<String>();
            ArrayList<String> modulesReportedDuringOpMode = new ArrayList<String>();
            for (LowBatteryStatus status : LynxModuleWarningManager.this.modulesReportedLowBattery.values()) {
                if (status.conditionCurrentlyTrue()) {
                    modulesCurrentlyReporting.add(status.moduleName);
                    continue;
                }
                if (!status.conditionTrueDuringOpModeRun) continue;
                modulesReportedDuringOpMode.add(status.moduleName);
            }
            if (modulesCurrentlyReporting.size() > 0) {
                this.composeModuleList(modulesCurrentlyReporting, builder);
                builder.append(AppUtil.getDefContext().getString(R.string.lynxModuleBatteryIsCurrentlyLow));
                warningAdded = true;
            }
            if (modulesReportedDuringOpMode.size() > 0) {
                if (warningAdded) {
                    builder.append(" ");
                }
                this.composeModuleList(modulesReportedDuringOpMode, builder);
                builder.append(AppUtil.getDefContext().getString(R.string.lynxModuleBatteryWasLow));
                warningAdded = true;
            }
            return warningAdded;
        }

        private void composePowerIssueTip(boolean runningUserOpMode, StringBuilder builder) {
            if (runningUserOpMode) {
                builder.append(AppUtil.getDefContext().getString(R.string.powerIssueTip));
            } else {
                builder.append(AppUtil.getDefContext().getString(R.string.robotOffTip));
            }
        }

        void composeModuleList(Collection<String> moduleNames, StringBuilder builder) {
            Iterator<String> iterator = moduleNames.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(" ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suppressGlobalWarning(boolean suppress) {
            Object object = LynxModuleWarningManager.this.warningMessageLock;
            synchronized (object) {
                this.warningMessageSuppressionCount = suppress ? ++this.warningMessageSuppressionCount : --this.warningMessageSuppressionCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearGlobalWarning() {
            Object object = LynxModuleWarningManager.this.warningMessageLock;
            synchronized (object) {
                LynxModuleWarningManager.this.cachedWarningMessage = null;
                LynxModuleWarningManager.this.modulesReportedUnresponsive.clear();
                LynxModuleWarningManager.this.modulesReportedReset.clear();
                LynxModuleWarningManager.this.modulesReportedLowBattery.clear();
                LynxModuleWarningManager.this.outdatedModules.clear();
                this.warningMessageSuppressionCount = 0;
            }
        }

        public void setGlobalWarning(String warning) {
        }
    }

    private static class LowBatteryStatus
    extends ConditionStatus {
        private LowBatteryStatus(LynxModule lynxModule, String moduleName) {
            super(lynxModule, moduleName, 2);
        }

        @Override
        boolean conditionCurrentlyTrue() {
            return this.timeSinceConditionLastReported.seconds() < 2.0;
        }

        @Override
        void logCondition() {
            RobotLog.w((String)"%s currently has a battery too low to run motors and servos.", (Object[])new Object[]{this.moduleName});
        }
    }

    private static class UnresponsiveStatus
    extends ConditionStatus {
        private UnresponsiveStatus(LynxModuleIntf lynxModule, String moduleName) {
            super(lynxModule, moduleName, 2);
        }

        @Override
        boolean conditionCurrentlyTrue() {
            return this.lynxModule.isNotResponding();
        }

        @Override
        void logCondition() {
            RobotLog.w((String)"%s is currently unresponsive.", (Object[])new Object[]{this.moduleName});
        }
    }

    private static abstract class ConditionStatus {
        final ElapsedTime timeSinceConditionLastReported = new ElapsedTime();
        final ElapsedTime timeSinceConditionLogged = new ElapsedTime(0L);
        final LynxModuleIntf lynxModule;
        final String moduleName;
        final int logFrequencySeconds;
        boolean conditionPreviouslyTrue = false;
        boolean conditionTrueDuringOpModeRun = false;

        ConditionStatus(LynxModuleIntf lynxModule, String moduleName, int logFrequencySeconds) {
            this.lynxModule = lynxModule;
            this.logFrequencySeconds = logFrequencySeconds;
            this.moduleName = moduleName;
        }

        abstract boolean conditionCurrentlyTrue();

        abstract void logCondition();

        void reportConditionAndLogWithThrottle(boolean userOpModeRunning) {
            if (userOpModeRunning) {
                this.conditionTrueDuringOpModeRun = true;
            }
            this.timeSinceConditionLastReported.reset();
            if (this.timeSinceConditionLogged.seconds() > (double)this.logFrequencySeconds) {
                this.logCondition();
                this.timeSinceConditionLogged.reset();
            }
        }

        final boolean hasChangedSinceLastCheck() {
            boolean conditionCurrentlyTrue = this.conditionCurrentlyTrue();
            boolean changedSinceLastCheck = conditionCurrentlyTrue != this.conditionPreviouslyTrue;
            this.conditionPreviouslyTrue = conditionCurrentlyTrue;
            return changedSinceLastCheck;
        }
    }
}

