/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.Engagable;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.LynxModuleDescription;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.RobotCoreLynxUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.util.GlobalWarningSource;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.firstinspires.ftc.robotcore.external.Consumer;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;

public interface LynxUsbDevice
extends RobotUsbModule,
GlobalWarningSource,
RobotCoreLynxUsbDevice,
HardwareDevice,
SyncdDevice,
Engagable {
    public RobotUsbDevice getRobotUsbDevice();

    public boolean isSystemSynthetic();

    public void setSystemSynthetic(boolean var1);

    public void failSafe();

    public void changeModuleAddress(LynxModule var1, int var2, Runnable var3);

    public LynxModule getOrAddModule(LynxModuleDescription var1) throws RobotCoreException, InterruptedException;

    public void removeConfiguredModule(LynxModule var1);

    public void noteMissingModule(int var1, String var2);

    public void performSystemOperationOnParentModule(int var1, @Nullable Consumer<LynxModule> var2, int var3, TimeUnit var4) throws RobotCoreException, InterruptedException, TimeoutException;

    public void performSystemOperationOnConnectedModule(int var1, int var2, @Nullable Consumer<LynxModule> var3, int var4, TimeUnit var5) throws RobotCoreException, InterruptedException, TimeoutException;

    public SystemOperationHandle keepConnectedModuleAliveForSystemOperations(int var1, int var2) throws RobotCoreException, InterruptedException;

    public LynxModuleMetaList discoverModules(boolean var1) throws RobotCoreException, InterruptedException;

    public void acquireNetworkTransmissionLock(@NonNull LynxMessage var1) throws InterruptedException;

    public void releaseNetworkTransmissionLock(@NonNull LynxMessage var1) throws InterruptedException;

    public void transmit(LynxMessage var1) throws InterruptedException;

    public boolean setupControlHubEmbeddedModule() throws InterruptedException, RobotCoreException;

    public LynxUsbDeviceImpl getDelegationTarget();

    public RobotCoreCommandList.LynxFirmwareUpdateResp updateFirmware(RobotCoreCommandList.FWImage var1, String var2, Consumer<ProgressParameters> var3);

    public static class SystemOperationHandle {
        protected final LynxUsbDeviceImpl lynxUsb;
        protected final LynxModule module;
        protected final LynxModule parentModule;
        protected volatile boolean closed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SystemOperationHandle(LynxUsbDeviceImpl lynxUsb, LynxModule module, LynxModule parentModule) {
            this.lynxUsb = lynxUsb;
            this.module = module;
            this.parentModule = parentModule;
            Object object = lynxUsb.sysOpStartStopLock;
            synchronized (object) {
                ++parentModule.systemOperationCounter;
                ++module.systemOperationCounter;
            }
        }

        public void performSystemOperation(@Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
            if (this.closed) {
                throw new RuntimeException("Attempted to perform system operation on closed handle");
            }
            this.lynxUsb.internalPerformSysOp(this.module, this.parentModule, operation, timeout, timeoutUnit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.closed = true;
            Object object = this.lynxUsb.sysOpStartStopLock;
            synchronized (object) {
                --this.parentModule.systemOperationCounter;
                this.lynxUsb.internalCloseLynxModuleIfUnused(this.parentModule);
                --this.module.systemOperationCounter;
                this.lynxUsb.internalCloseLynxModuleIfUnused(this.module);
            }
        }

        public SerialNumber getLynxModuleSerialNumber() {
            return this.module.getModuleSerialNumber();
        }

        public boolean wrapsModule(LynxModule module) {
            return module == this.module;
        }

        public boolean wrapsSameModule(SystemOperationHandle otherHandle) {
            return otherHandle.module == this.module;
        }
    }
}

