/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.LynxUsbDeviceImpl;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.HardwareDeviceCloseOnTearDown;
import com.qualcomm.robotcore.hardware.LynxModuleDescription;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.firstinspires.ftc.robotcore.external.Consumer;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;

public class LynxUsbDeviceDelegate
implements LynxUsbDevice,
HardwareDeviceCloseOnTearDown {
    public static String TAG = "LynxUsb";
    protected LynxUsbDeviceImpl delegate;
    protected boolean releaseOnClose;
    protected boolean isOpen;

    public LynxUsbDeviceDelegate(LynxUsbDeviceImpl lynxUsbDevice) {
        this.delegate = lynxUsbDevice;
        this.releaseOnClose = true;
        this.isOpen = true;
        RobotLog.vv((String)TAG, (String)"0x%08x on 0x%08x: new delegate to [%s]", (Object[])new Object[]{this.hashCode(), this.delegate.hashCode(), this.delegate.getSerialNumber()});
    }

    @Override
    public LynxUsbDeviceImpl getDelegationTarget() {
        return this.delegate;
    }

    public synchronized void close() {
        if (this.releaseOnClose) {
            RobotLog.vv((String)TAG, (String)"0x%08x on 0x%08x: releasing delegate to [%s]", (Object[])new Object[]{this.hashCode(), this.delegate.hashCode(), this.delegate.getSerialNumber()});
            this.releaseOnClose = false;
            this.delegate.releaseRef();
            this.isOpen = false;
        } else {
            RobotLog.ee((String)TAG, (String)"0x%08x on 0x%08x: closing closed[%s]; ignored", (Object[])new Object[]{this.hashCode(), this.delegate.hashCode(), this.delegate.getSerialNumber()});
        }
    }

    protected void assertOpen() {
        if (!this.isOpen) {
            Assert.assertTrue((boolean)false, (String)"0x%08x on 0x%08x: closed", (Object[])new Object[]{this.hashCode(), this.delegate.hashCode()});
        }
    }

    public void disengage() {
        this.assertOpen();
        this.delegate.disengage();
    }

    public void engage() {
        this.assertOpen();
        this.delegate.engage();
    }

    public boolean isEngaged() {
        this.assertOpen();
        return this.delegate.isEngaged();
    }

    @Override
    public RobotUsbDevice getRobotUsbDevice() {
        this.assertOpen();
        return this.delegate.getRobotUsbDevice();
    }

    @Override
    public boolean isSystemSynthetic() {
        this.assertOpen();
        return this.delegate.isSystemSynthetic();
    }

    @Override
    public void setSystemSynthetic(boolean systemSynthetic) {
        this.assertOpen();
        this.delegate.setSystemSynthetic(systemSynthetic);
    }

    @Override
    public void failSafe() {
        this.assertOpen();
        this.delegate.failSafe();
    }

    public void lockNetworkLockAcquisitions() {
        this.delegate.lockNetworkLockAcquisitions();
    }

    public void setThrowOnNetworkLockAcquisition(boolean shouldThrow) {
        this.delegate.setThrowOnNetworkLockAcquisition(shouldThrow);
    }

    @Override
    public void changeModuleAddress(LynxModule module, int newAddress, Runnable runnable) {
        this.assertOpen();
        this.delegate.changeModuleAddress(module, newAddress, runnable);
    }

    @Override
    public void noteMissingModule(int moduleAddress, String moduleName) {
        this.assertOpen();
        this.delegate.noteMissingModule(moduleAddress, moduleName);
    }

    @Override
    public void performSystemOperationOnParentModule(int parentAddress, @Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
        this.assertOpen();
        this.delegate.performSystemOperationOnParentModule(parentAddress, operation, timeout, timeoutUnit);
    }

    @Override
    public void performSystemOperationOnConnectedModule(int moduleAddress, int parentAddress, @Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
        this.assertOpen();
        this.delegate.performSystemOperationOnConnectedModule(moduleAddress, parentAddress, operation, timeout, timeoutUnit);
    }

    @Override
    public LynxUsbDevice.SystemOperationHandle keepConnectedModuleAliveForSystemOperations(int moduleAddress, int parentAddress) throws RobotCoreException, InterruptedException {
        this.assertOpen();
        return this.delegate.keepConnectedModuleAliveForSystemOperations(moduleAddress, parentAddress);
    }

    @Override
    public LynxModule getOrAddModule(LynxModuleDescription moduleDescription) throws RobotCoreException, InterruptedException {
        this.assertOpen();
        return this.delegate.getOrAddModule(moduleDescription);
    }

    @Override
    public void removeConfiguredModule(LynxModule module) {
        this.assertOpen();
        this.delegate.removeConfiguredModule(module);
    }

    @Override
    public LynxModuleMetaList discoverModules(boolean checkForImus) throws RobotCoreException, InterruptedException {
        this.assertOpen();
        return this.delegate.discoverModules(checkForImus);
    }

    @Override
    public void acquireNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.assertOpen();
        this.delegate.acquireNetworkTransmissionLock(message);
    }

    @Override
    public void releaseNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.assertOpen();
        this.delegate.releaseNetworkTransmissionLock(message);
    }

    @Override
    public void transmit(LynxMessage message) throws InterruptedException {
        this.assertOpen();
        this.delegate.transmit(message);
    }

    @Override
    public boolean setupControlHubEmbeddedModule() throws RobotCoreException, InterruptedException {
        this.assertOpen();
        return this.delegate.setupControlHubEmbeddedModule();
    }

    @Override
    public RobotCoreCommandList.LynxFirmwareUpdateResp updateFirmware(RobotCoreCommandList.FWImage image, String requestId, Consumer<ProgressParameters> progressConsumer) {
        return this.delegate.updateFirmware(image, requestId, progressConsumer);
    }

    public String getDeviceName() {
        this.assertOpen();
        return this.delegate.getDeviceName();
    }

    public String getConnectionInfo() {
        this.assertOpen();
        return this.delegate.getConnectionInfo();
    }

    public int getVersion() {
        this.assertOpen();
        return this.delegate.getVersion();
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        this.assertOpen();
        return this.delegate.getManufacturer();
    }

    public void resetDeviceConfigurationForOpMode() {
        this.assertOpen();
        this.delegate.resetDeviceConfigurationForOpMode();
    }

    public SyncdDevice.ShutdownReason getShutdownReason() {
        this.assertOpen();
        return this.delegate.getShutdownReason();
    }

    public void setOwner(RobotUsbModule owner) {
        this.assertOpen();
        this.delegate.setOwner(owner);
    }

    public RobotUsbModule getOwner() {
        this.assertOpen();
        return this.delegate.getOwner();
    }

    public SerialNumber getSerialNumber() {
        this.assertOpen();
        return this.delegate.getSerialNumber();
    }

    public RobotArmingStateNotifier.ARMINGSTATE getArmingState() {
        this.assertOpen();
        return this.delegate.getArmingState();
    }

    public void registerCallback(RobotArmingStateNotifier.Callback callback, boolean doInitialCallback) {
        this.assertOpen();
        this.delegate.registerCallback(callback, doInitialCallback);
    }

    public void unregisterCallback(RobotArmingStateNotifier.Callback callback) {
        this.assertOpen();
        this.delegate.unregisterCallback(callback);
    }

    public void arm() throws RobotCoreException, InterruptedException {
        this.assertOpen();
        this.delegate.arm();
    }

    public void pretend() throws RobotCoreException, InterruptedException {
        this.assertOpen();
        this.delegate.pretend();
    }

    public void armOrPretend() throws RobotCoreException, InterruptedException {
        this.assertOpen();
        this.delegate.armOrPretend();
    }

    public void disarm() throws RobotCoreException, InterruptedException {
        this.assertOpen();
        this.delegate.disarm();
    }

    public String getGlobalWarning() {
        this.assertOpen();
        return this.delegate.getGlobalWarning();
    }

    public boolean shouldTriggerWarningSound() {
        return this.delegate.shouldTriggerWarningSound();
    }

    public void suppressGlobalWarning(boolean suppress) {
        this.assertOpen();
        this.delegate.suppressGlobalWarning(suppress);
    }

    public void setGlobalWarning(String warning) {
        this.assertOpen();
        this.delegate.setGlobalWarning(warning);
    }

    public void clearGlobalWarning() {
        this.assertOpen();
        this.delegate.clearGlobalWarning();
    }
}

