/*
 * Decompiled with CFR 0.152.
 */
package com.qualcomm.hardware.lynx;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qualcomm.hardware.HardwareFactory;
import com.qualcomm.hardware.R;
import com.qualcomm.hardware.lynx.LynxCommExceptionHandler;
import com.qualcomm.hardware.lynx.LynxFirmwareUpdater;
import com.qualcomm.hardware.lynx.LynxModule;
import com.qualcomm.hardware.lynx.LynxNackException;
import com.qualcomm.hardware.lynx.LynxUsbDevice;
import com.qualcomm.hardware.lynx.LynxUsbDeviceDelegate;
import com.qualcomm.hardware.lynx.LynxUsbUtil;
import com.qualcomm.hardware.lynx.MessageKeyedLock;
import com.qualcomm.hardware.lynx.commands.LynxDatagram;
import com.qualcomm.hardware.lynx.commands.LynxMessage;
import com.qualcomm.hardware.lynx.commands.standard.LynxDiscoveryCommand;
import com.qualcomm.hardware.lynx.commands.standard.LynxDiscoveryResponse;
import com.qualcomm.robotcore.eventloop.SyncdDevice;
import com.qualcomm.robotcore.exception.RobotCoreException;
import com.qualcomm.robotcore.hardware.DeviceManager;
import com.qualcomm.robotcore.hardware.HardwareDevice;
import com.qualcomm.robotcore.hardware.LynxModuleDescription;
import com.qualcomm.robotcore.hardware.LynxModuleImuType;
import com.qualcomm.robotcore.hardware.LynxModuleMeta;
import com.qualcomm.robotcore.hardware.LynxModuleMetaList;
import com.qualcomm.robotcore.hardware.configuration.LynxConstants;
import com.qualcomm.robotcore.hardware.usb.RobotArmingStateNotifier;
import com.qualcomm.robotcore.hardware.usb.RobotUsbDevice;
import com.qualcomm.robotcore.hardware.usb.RobotUsbManager;
import com.qualcomm.robotcore.hardware.usb.RobotUsbModule;
import com.qualcomm.robotcore.hardware.usb.ftdi.RobotUsbDeviceFtdi;
import com.qualcomm.robotcore.util.IncludedFirmwareFileInfo;
import com.qualcomm.robotcore.util.RobotLog;
import com.qualcomm.robotcore.util.SerialNumber;
import com.qualcomm.robotcore.util.ThreadPool;
import com.qualcomm.robotcore.util.TypeConversion;
import com.qualcomm.robotcore.util.Util;
import com.qualcomm.robotcore.util.WeakReferenceSet;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.firstinspires.ftc.robotcore.external.Consumer;
import org.firstinspires.ftc.robotcore.internal.hardware.TimeWindow;
import org.firstinspires.ftc.robotcore.internal.hardware.android.AndroidBoard;
import org.firstinspires.ftc.robotcore.internal.hardware.usb.ArmableUsbDevice;
import org.firstinspires.ftc.robotcore.internal.network.RobotCoreCommandList;
import org.firstinspires.ftc.robotcore.internal.system.AppAliveNotifier;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.firstinspires.ftc.robotcore.internal.system.Assert;
import org.firstinspires.ftc.robotcore.internal.ui.ProgressParameters;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbDeviceClosedException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbFTDIException;
import org.firstinspires.ftc.robotcore.internal.usb.exception.RobotUsbUnspecifiedException;

public class LynxUsbDeviceImpl
extends ArmableUsbDevice
implements LynxUsbDevice {
    public static final String TAG = "LynxUsb";
    public static boolean DEBUG_LOG_MESSAGES = false;
    public static boolean DEBUG_LOG_DATAGRAMS = false;
    public static boolean DEBUG_LOG_DATAGRAMS_FINISH = false;
    public static boolean DEBUG_LOG_DATAGRAMS_LOCK = false;
    protected static final WeakReferenceSet<LynxUsbDeviceImpl> extantDevices = new WeakReferenceSet();
    protected static final LynxCommExceptionHandler exceptionHandler = new LynxCommExceptionHandler("LynxUsb");
    protected final ConcurrentHashMap<Integer, LynxModule> knownModules;
    protected final ConcurrentHashMap<Integer, LynxModule> knownModulesChanging;
    protected final ConcurrentHashMap<Integer, LynxModuleMeta> discoveredModules;
    protected final ConcurrentHashMap<Integer, String> missingModules;
    protected final MessageKeyedLock networkTransmissionLock;
    protected ExecutorService incomingDatagramPoller = null;
    protected boolean resetAttempted = false;
    protected boolean hasShutdownAbnormally = false;
    protected boolean isSystemSynthetic = false;
    protected boolean isEngaged = true;
    protected boolean wasPollingWhenEngaged = true;
    protected final Object engageLock = new Object();
    protected final Object sysOpStartStopLock = new Object();
    protected final Set<Object> runningSysOpTrackers = new HashSet<Object>();
    protected final LynxFirmwareUpdater lynxFirmwareUpdater = new LynxFirmwareUpdater(this);
    protected static final int cbusNReset = 1;
    protected static final int cbusNProg = 2;
    protected static final int cbusMask = 3;
    protected static final int cbusNeitherAsserted = 3;
    protected static final int cbusBothAsserted = 0;
    protected static final int cbusProgAsserted = 1;
    protected static final int cbusResetAsserted = 2;
    protected static final int msNetworkTransmissionLockAcquisitionTimeMax = 500;
    protected static final int msCbusWiggle = 75;
    protected static final int msResetRecovery = 200;
    protected static final String SEPARATOR = " / ";

    protected String getTag() {
        return TAG;
    }

    public static ArmableUsbDevice.OpenRobotUsbDevice createUsbOpener(RobotUsbManager usbManager, SerialNumber serialNumber) {
        return () -> {
            RobotUsbDevice dev = null;
            try {
                dev = LynxUsbUtil.openUsbDevice(true, usbManager, serialNumber);
                if (!dev.getUsbIdentifiers().isLynxDevice()) {
                    dev.close();
                    String msg = String.format(Locale.US, "Supposed Lynx USB device (serial number %s) does not have expected IDs", serialNumber);
                    RobotLog.ee((String)TAG, (String)msg);
                    throw new RobotCoreException(msg);
                }
                dev.setDeviceType(DeviceManager.UsbDeviceType.LYNX_USB_DEVICE);
            }
            catch (RobotCoreException | RuntimeException e) {
                if (dev != null) {
                    dev.close();
                }
                throw e;
            }
            return dev;
        };
    }

    protected LynxUsbDeviceImpl(Context context, SerialNumber serialNumber, @Nullable SyncdDevice.Manager manager, RobotUsbManager usbManager) {
        super(context, serialNumber, manager, LynxUsbDeviceImpl.createUsbOpener(usbManager, serialNumber));
        this.knownModules = new ConcurrentHashMap();
        this.knownModulesChanging = new ConcurrentHashMap();
        this.discoveredModules = new ConcurrentHashMap();
        this.missingModules = new ConcurrentHashMap();
        this.networkTransmissionLock = new MessageKeyedLock("lynx xmit lock", 500);
        extantDevices.add((Object)this);
        this.finishConstruction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LynxUsbDevice findOrCreateAndArm(Context context, SerialNumber serialNumber, @Nullable SyncdDevice.Manager manager, RobotUsbManager robotUsbManager) throws RobotCoreException, InterruptedException {
        WeakReferenceSet<LynxUsbDeviceImpl> weakReferenceSet = extantDevices;
        synchronized (weakReferenceSet) {
            for (LynxUsbDeviceImpl device : extantDevices) {
                if (!device.getSerialNumber().equals((Object)serialNumber) || device.getArmingState() == RobotArmingStateNotifier.ARMINGSTATE.CLOSED) continue;
                device.addRef();
                RobotLog.vv((String)TAG, (String)"using existing [%s]: 0x%08x", (Object[])new Object[]{serialNumber, device.hashCode()});
                return new LynxUsbDeviceDelegate(device);
            }
            LynxUsbDeviceImpl newDevice = new LynxUsbDeviceImpl(context, serialNumber, manager, robotUsbManager);
            RobotLog.vv((String)TAG, (String)"creating new [%s]: 0x%08x", (Object[])new Object[]{serialNumber, newDevice.hashCode()});
            newDevice.armOrPretend();
            return new LynxUsbDeviceDelegate(newDevice);
        }
    }

    @Override
    public LynxUsbDeviceImpl getDelegationTarget() {
        return this;
    }

    @Override
    public boolean isSystemSynthetic() {
        return this.isSystemSynthetic;
    }

    @Override
    public void setSystemSynthetic(boolean systemSynthetic) {
        this.isSystemSynthetic = systemSynthetic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        WeakReferenceSet<LynxUsbDeviceImpl> weakReferenceSet = extantDevices;
        synchronized (weakReferenceSet) {
            super.doClose();
            extantDevices.remove((Object)this);
        }
    }

    public HardwareDevice.Manufacturer getManufacturer() {
        return HardwareDevice.Manufacturer.Lynx;
    }

    public String getDeviceName() {
        return this.context.getString(R.string.moduleDisplayNameLynxUsbDevice);
    }

    public String getConnectionInfo() {
        return "USB " + this.getSerialNumber();
    }

    public void resetDeviceConfigurationForOpMode() {
    }

    public int getVersion() {
        return 1;
    }

    public SyncdDevice.ShutdownReason getShutdownReason() {
        RobotUsbDevice robotUsbDevice = this.robotUsbDevice;
        return this.hasShutdownAbnormally || robotUsbDevice == null || !robotUsbDevice.isOpen() ? SyncdDevice.ShutdownReason.ABNORMAL : SyncdDevice.ShutdownReason.NORMAL;
    }

    protected boolean hasShutdownAbnormally() {
        return this.getShutdownReason() != SyncdDevice.ShutdownReason.NORMAL;
    }

    public void setOwner(RobotUsbModule owner) {
    }

    public RobotUsbModule getOwner() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void engage() {
        Object object = this.engageLock;
        synchronized (object) {
            if (!this.isEngaged) {
                if (this.wasPollingWhenEngaged && this.isArmed()) {
                    this.startPollingForIncomingDatagrams();
                }
                for (LynxModule module : this.getKnownModules()) {
                    module.engage();
                }
                this.isEngaged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disengage() {
        Object object = this.engageLock;
        synchronized (object) {
            if (this.isEngaged) {
                this.isEngaged = false;
                for (LynxModule module : this.getKnownModules()) {
                    module.disengage();
                }
                this.wasPollingWhenEngaged = this.stopPollingForIncomingDatagrams();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isEngaged() {
        Object object = this.engageLock;
        synchronized (object) {
            return this.isEngaged;
        }
    }

    protected void doPretend() {
        RobotLog.vv((String)TAG, (String)"doPretend() serial=%s", (Object[])new Object[]{this.serialNumber});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void armDevice(RobotUsbDevice device) throws RobotCoreException, InterruptedException {
        Object object = this.armingLock;
        synchronized (object) {
            RobotLog.vv((String)TAG, (String)"armDevice() serial=%s...", (Object[])new Object[]{this.serialNumber});
            Assert.assertTrue((device != null ? 1 : 0) != 0);
            this.robotUsbDevice = device;
            if (!this.resetAttempted) {
                this.resetAttempted = true;
                LynxUsbDeviceImpl.resetDevice(this.robotUsbDevice);
            }
            this.hasShutdownAbnormally = false;
            if (this.syncdDeviceManager != null) {
                this.syncdDeviceManager.registerSyncdDevice((SyncdDevice)this);
            }
            this.resetNetworkTransmissionLock();
            this.startPollingForIncomingDatagrams();
            this.pingAndQueryKnownInterfaces();
            this.startRegularPinging();
            RobotLog.vv((String)TAG, (String)"...done armDevice()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disarmDevice() throws InterruptedException {
        Object object = this.armingLock;
        synchronized (object) {
            RobotLog.vv((String)TAG, (String)"disarmDevice() serial=%s...", (Object[])new Object[]{this.serialNumber});
            Assert.assertFalse((boolean)this.isArmedOrArming());
            this.pretendFinishExtantCommands();
            this.abandonUnfinishedCommands();
            this.stopRegularPinging();
            this.stopPollingForIncomingDatagrams();
            if (this.robotUsbDevice != null) {
                this.robotUsbDevice.close();
                this.robotUsbDevice = null;
            }
            this.resetNetworkTransmissionLock();
            if (this.syncdDeviceManager != null) {
                this.syncdDeviceManager.unregisterSyncdDevice((SyncdDevice)this);
            }
            RobotLog.vv((String)TAG, (String)"...done disarmDevice()");
        }
    }

    protected void doCloseFromArmed() throws RobotCoreException, InterruptedException {
        this.failSafe();
        this.closeModules();
        super.doCloseFromArmed();
    }

    protected void doCloseFromOther() throws RobotCoreException, InterruptedException {
        this.closeModules();
        super.doCloseFromOther();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeModules() {
        for (LynxModule lynxModule : this.getKnownModules()) {
            try {
                lynxModule.failSafe();
            }
            catch (LynxNackException | RobotCoreException e) {
                RobotLog.ee((String)TAG, (Throwable)e, (String)"Failed to put module into failsafe mode before closing");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Object object = this.sysOpStartStopLock;
        synchronized (object) {
            try {
                while (this.runningSysOpTrackers.size() > 0) {
                    this.sysOpStartStopLock.wait();
                }
                for (LynxModule module : this.getKnownModules()) {
                    module.close();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void failSafe() {
        for (LynxModule module : this.getKnownModules()) {
            try {
                if (!module.isUserModule()) continue;
                module.failSafe();
            }
            catch (LynxNackException | RobotCoreException | InterruptedException e) {
                exceptionHandler.handleException((Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<LynxModule> getKnownModules() {
        ConcurrentHashMap<Integer, LynxModule> concurrentHashMap = this.knownModules;
        synchronized (concurrentHashMap) {
            return this.knownModules.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LynxModule findKnownModule(int moduleAddress) {
        ConcurrentHashMap<Integer, LynxModule> concurrentHashMap = this.knownModules;
        synchronized (concurrentHashMap) {
            LynxModule result = this.knownModules.get(moduleAddress);
            if (result == null) {
                result = this.knownModulesChanging.get(moduleAddress);
            }
            return result;
        }
    }

    public List<String> getAllModuleFirmwareVersions() {
        ArrayList<String> versions = new ArrayList<String>();
        for (LynxModule module : this.getKnownModules()) {
            module.getFirmwareVersionString();
            versions.add(module.getModuleAddress() + SEPARATOR + module.getFirmwareVersionString());
        }
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeModuleAddress(LynxModule module, int newAddress, Runnable runnable) {
        int oldAddress = module.getModuleAddress();
        if (newAddress != oldAddress) {
            ConcurrentHashMap<Integer, LynxModule> concurrentHashMap = this.knownModules;
            synchronized (concurrentHashMap) {
                this.knownModulesChanging.put(newAddress, module);
            }
            runnable.run();
            concurrentHashMap = this.knownModules;
            synchronized (concurrentHashMap) {
                this.knownModules.put(newAddress, module);
                this.knownModules.remove(oldAddress);
                this.knownModulesChanging.remove(newAddress);
            }
        }
    }

    @Override
    public void noteMissingModule(int moduleAddress, String moduleName) {
        this.missingModules.put(moduleAddress, moduleName);
        RobotLog.ee((String)TAG, (String)"module #%d did not connect at startup: skip adding its hardware items to the hardwareMap", (Object[])new Object[]{moduleAddress});
    }

    protected String composeGlobalWarning() {
        ArrayList<String> warnings = new ArrayList<String>();
        String armingWarning = super.composeGlobalWarning();
        warnings.add(armingWarning);
        if (armingWarning.isEmpty()) {
            for (String moduleName : this.missingModules.values()) {
                warnings.add(AppUtil.getDefContext().getString(R.string.errorExpansionHubIsMissing, new Object[]{moduleName}));
            }
            for (LynxModule module : this.getKnownModules()) {
                List<String> moduleWarnings = module.getGlobalWarnings();
                warnings.addAll(moduleWarnings);
            }
        }
        return RobotLog.combineGlobalWarnings(warnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LynxModule getOrAddModule(LynxModuleDescription moduleDescription) throws InterruptedException, RobotCoreException {
        Object object = this.sysOpStartStopLock;
        synchronized (object) {
            LynxModule module;
            int moduleAddress = moduleDescription.address;
            RobotLog.vv((String)TAG, (String)"addConfiguredModule() module#=%d", (Object[])new Object[]{moduleAddress});
            boolean added = false;
            ConcurrentHashMap<Integer, LynxModule> concurrentHashMap = this.knownModules;
            synchronized (concurrentHashMap) {
                if (!this.knownModules.containsKey(moduleAddress)) {
                    module = new LynxModule(this, moduleAddress, moduleDescription.isParent, moduleDescription.isUserModule);
                    if (moduleDescription.isSystemSynthetic) {
                        module.setSystemSynthetic(true);
                    }
                    this.knownModules.put(moduleAddress, module);
                    added = true;
                } else {
                    module = this.knownModules.get(moduleAddress);
                    RobotLog.vv((String)TAG, (String)"addConfiguredModule() module#=%d: already exists", (Object[])new Object[]{moduleAddress});
                    if (moduleDescription.isUserModule && !module.isUserModule()) {
                        RobotLog.vv((String)TAG, (String)"Converting module #%d to a user module", (Object[])new Object[]{module.getModuleAddress()});
                        module.setUserModule(true);
                    }
                    if (moduleDescription.isUserModule && moduleDescription.isSystemSynthetic && !module.isSystemSynthetic()) {
                        module.setSystemSynthetic(true);
                    }
                    if (moduleDescription.isParent != module.isParent()) {
                        RobotLog.ww((String)TAG, (String)"addConfiguredModule(): The active configuration file may be incorrect about whether Expansion Hub %d is the parent", (Object[])new Object[]{module.getModuleAddress()});
                    }
                }
            }
            if (added) {
                try {
                    module.pingAndQueryKnownInterfacesAndEtc();
                }
                catch (RobotCoreException | InterruptedException | RuntimeException e) {
                    RobotLog.logExceptionHeader((String)TAG, (Exception)e, (String)"addConfiguredModule() module#=%d", (Object[])new Object[]{module.getModuleAddress()});
                    RobotLog.ee((String)TAG, (String)"Unable to communicate with REV Hub #%d at robot startup. A Robot Restart will be required to use this hub.", (Object[])new Object[]{module.getModuleAddress()});
                    module.close();
                    ConcurrentHashMap<Integer, LynxModule> concurrentHashMap2 = this.knownModules;
                    synchronized (concurrentHashMap2) {
                        this.knownModules.remove(module.getModuleAddress());
                    }
                    throw e;
                }
            }
            return module;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfiguredModule(LynxModule module) {
        ConcurrentHashMap<Integer, LynxModule> concurrentHashMap = this.knownModules;
        synchronized (concurrentHashMap) {
            if (module.getModuleAddress() != 0 && this.knownModules.remove(module.getModuleAddress()) == null) {
                RobotLog.ee((String)TAG, (String)"removeConfiguredModule(): mod#=%d wasn't there", (Object[])new Object[]{module.getModuleAddress()});
            }
        }
    }

    @Override
    public void performSystemOperationOnParentModule(int parentAddress, @Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
        this.performSystemOperationOnConnectedModule(parentAddress, parentAddress, operation, timeout, timeoutUnit);
    }

    @Override
    public void performSystemOperationOnConnectedModule(int moduleAddress, int parentAddress, @Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
        LynxModuleDescription parentModuleDescription = new LynxModuleDescription.Builder(parentAddress, true).build();
        LynxModuleDescription moduleDescription = new LynxModuleDescription.Builder(moduleAddress, false).build();
        LynxModule parentModule = this.getOrAddModule(parentModuleDescription);
        LynxModule module = moduleAddress == parentAddress ? parentModule : this.getOrAddModule(moduleDescription);
        this.internalPerformSysOp(module, parentModule, operation, timeout, timeoutUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalPerformSysOp(LynxModule module, LynxModule parentModule, @Nullable Consumer<LynxModule> operation, int timeout, TimeUnit timeoutUnit) throws RobotCoreException, InterruptedException, TimeoutException {
        Object sysOpTracker = new Object();
        Object object = this.sysOpStartStopLock;
        synchronized (object) {
            try {
                module.ping(false);
            }
            catch (LynxNackException e) {
                throw new RobotCoreException("Received NACK when pinging LynxModule: " + e.getNack());
            }
            ++parentModule.systemOperationCounter;
            ++module.systemOperationCounter;
            this.runningSysOpTrackers.add(sysOpTracker);
        }
        Future<?> operationFuture = null;
        try {
            if (operation != null) {
                LynxModule finalModule = module;
                operationFuture = ThreadPool.getDefault().submit(() -> operation.accept((Object)finalModule));
                operationFuture.get(timeout, timeoutUnit);
            }
        }
        catch (TimeoutException e) {
            operationFuture.cancel(true);
            throw e;
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            if (cause instanceof InterruptedException) {
                throw new RobotCoreException("Background thread was interrupted while performing system operation", cause);
            }
            if (cause instanceof RobotCoreException) {
                throw (RobotCoreException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof TimeoutException) {
                throw (TimeoutException)cause;
            }
        }
        finally {
            Object object2 = this.sysOpStartStopLock;
            synchronized (object2) {
                this.runningSysOpTrackers.remove(sysOpTracker);
                this.sysOpStartStopLock.notifyAll();
                --parentModule.systemOperationCounter;
                this.internalCloseLynxModuleIfUnused(parentModule);
                --module.systemOperationCounter;
                this.internalCloseLynxModuleIfUnused(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCloseLynxModuleIfUnused(LynxModule lynxModule) {
        Object object = this.sysOpStartStopLock;
        synchronized (object) {
            if (this.findKnownModule(lynxModule.getModuleAddress()) != lynxModule) {
                throw new RuntimeException("An unaffiliated module was passed in to internalCloseLynxModuleIfAppropriate()");
            }
            if (lynxModule.systemOperationCounter < 0) {
                RobotLog.ee((String)TAG, (String)"systemOperationCounter for module %d was below 0", (Object[])new Object[]{lynxModule.getModuleAddress()});
            }
            if (!lynxModule.isUserModule && lynxModule.systemOperationCounter <= 0) {
                lynxModule.close();
            }
        }
    }

    @Override
    public LynxUsbDevice.SystemOperationHandle keepConnectedModuleAliveForSystemOperations(int moduleAddress, int parentAddress) throws RobotCoreException, InterruptedException {
        LynxModuleDescription parentModuleDescription = new LynxModuleDescription.Builder(parentAddress, true).build();
        LynxModuleDescription moduleDescription = new LynxModuleDescription.Builder(moduleAddress, false).build();
        LynxModule parentModule = this.getOrAddModule(parentModuleDescription);
        LynxModule module = moduleAddress == parentAddress ? parentModule : this.getOrAddModule(moduleDescription);
        return new LynxUsbDevice.SystemOperationHandle(this, module, parentModule);
    }

    @Override
    public LynxModuleMetaList discoverModules(boolean checkForImus) throws RobotCoreException, InterruptedException {
        RobotLog.vv((String)TAG, (String)("lynx discovery beginning for device " + this.serialNumber));
        this.discoveredModules.clear();
        try (LynxModule fakeModule = new LynxModule(this, 0, false, false);){
            LynxDiscoveryCommand discoveryCommand = new LynxDiscoveryCommand(fakeModule);
            discoveryCommand.send();
            long nsPerModuleInterval = 3000000L;
            int maxNumberOfModules = 254;
            long nsPacketTimeMax = 50000000L;
            long nsSlop = 200000000L;
            long nsWait = nsPerModuleInterval * (long)maxNumberOfModules + nsPacketTimeMax + nsSlop;
            long msWait = nsWait / 1000000L;
            RobotLog.vv((String)TAG, (String)"discovery waiting %dms and %dns", (Object[])new Object[]{msWait, nsWait -= msWait * 1000000L});
            Thread.sleep(msWait, (int)nsWait);
            RobotLog.vv((String)TAG, (String)"discovery waiting complete: #modules=%d", (Object[])new Object[]{this.discoveredModules.size()});
            RobotLog.vv((String)TAG, (String)"Checking type of discovered modules");
            LynxModuleMeta[] parents = (LynxModuleMeta[])this.discoveredModules.values().stream().filter(LynxModuleMeta::isParent).toArray(LynxModuleMeta[]::new);
            if (parents.length > 0) {
                LynxModuleMeta parentInfo = parents[0];
                for (LynxModuleMeta moduleMeta : this.discoveredModules.values()) {
                    try {
                        this.performSystemOperationOnConnectedModule(moduleMeta.getModuleAddress(), parentInfo.getModuleAddress(), (Consumer<LynxModule>)((Consumer)module -> {
                            int revProductNumber = module.getRevProductNumber();
                            moduleMeta.setRevProductNumber(revProductNumber);
                            if (checkForImus) {
                                moduleMeta.setImuType(module.getImuType());
                            } else {
                                moduleMeta.setImuType(LynxModuleImuType.UNKNOWN);
                            }
                        }), 250, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        RobotLog.ee((String)TAG, (Throwable)e, (String)"Timeout expired while getting IMU type");
                    }
                }
            } else {
                RobotLog.ee((String)TAG, (String)"Unable to check for onboard IMUs as the parent module was not found");
            }
        }
        LynxModuleMetaList result = new LynxModuleMetaList(this.serialNumber, this.discoveredModules.values());
        RobotLog.vv((String)TAG, (String)"...lynx discovery completed");
        return result;
    }

    @Override
    public boolean setupControlHubEmbeddedModule() throws InterruptedException, RobotCoreException {
        if (!this.getSerialNumber().isEmbedded()) {
            RobotLog.ww((String)TAG, (String)"setupControlHubEmbeddedModule() called on non-embedded USB device");
            return false;
        }
        try {
            this.performSystemOperationOnParentModule(173, null, 250, TimeUnit.MILLISECONDS);
            RobotLog.vv((String)TAG, (String)"Verified that the embedded Control Hub module has the correct address");
            return false;
        }
        catch (RobotCoreException | TimeoutException e) {
            return this.handleEmbeddedModuleNotFoundAtExpectedAddress();
        }
    }

    private boolean handleEmbeddedModuleNotFoundAtExpectedAddress() throws RobotCoreException, InterruptedException {
        RobotLog.ww((String)TAG, (String)"Unable to find embedded Control Hub module at address %d. Attempting to resolve automatically.", (Object[])new Object[]{173});
        LynxModuleMeta discoveredParentModule = this.discoverModules(false).getParent();
        if (discoveredParentModule == null) {
            RobotLog.ee((String)TAG, (String)"Unable to communicate with internal Expansion Hub. Attempting to re-flash firmware.");
            this.autoReflashControlHubFirmware();
            discoveredParentModule = this.discoverModules(false).getParent();
            if (discoveredParentModule == null) {
                RobotLog.setGlobalErrorMsg((String)AppUtil.getDefContext().getString(R.string.controlHubNotAbleToCommunicateWithInternalHub));
                return false;
            }
            RobotLog.ii((String)TAG, (String)"Successfully un-bricked the Control Hub's embedded module");
            if (discoveredParentModule.getModuleAddress() == 173) {
                RobotLog.ii((String)TAG, (String)"The embedded module already has the correct address");
                return false;
            }
        }
        try {
            this.setControlHubModuleAddress(discoveredParentModule);
            return true;
        }
        catch (TimeoutException e) {
            RobotLog.ee((String)TAG, (Throwable)e, (String)"Timeout expired while setting Control Hub module address");
            return false;
        }
    }

    private void autoReflashControlHubFirmware() {
        this.updateFirmware(IncludedFirmwareFileInfo.FW_IMAGE, "autoFirmwareUpdate", new Consumer<ProgressParameters>(){

            public void accept(ProgressParameters value) {
                AppAliveNotifier.getInstance().notifyAppAlive();
            }
        });
        LynxUsbDeviceImpl.resetDevice(this.robotUsbDevice);
    }

    private void setControlHubModuleAddress(LynxModuleMeta discoveredParentModule) throws InterruptedException, RobotCoreException, TimeoutException {
        int oldParentModuleAddress = discoveredParentModule.getModuleAddress();
        RobotLog.vv((String)TAG, (String)"Found embedded module at address %d", (Object[])new Object[]{oldParentModuleAddress});
        this.performSystemOperationOnParentModule(oldParentModuleAddress, (Consumer<LynxModule>)((Consumer)parentModule -> {
            RobotLog.vv((String)TAG, (String)"Setting embedded module address to %d", (Object[])new Object[]{173});
            parentModule.setNewModuleAddress(173);
        }), 250, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLynxDiscoveryResponseReceived(LynxDatagram datagram) {
        LynxDiscoveryResponse incomingResponse = new LynxDiscoveryResponse();
        incomingResponse.setSerialization(datagram);
        incomingResponse.loadFromSerialization();
        RobotLog.vv((String)TAG, (String)"onLynxDiscoveryResponseReceived()... module#=%d isParent=%s", (Object[])new Object[]{incomingResponse.getDiscoveredModuleAddress(), Boolean.toString(incomingResponse.isParent())});
        try {
            ConcurrentHashMap<Integer, LynxModuleMeta> concurrentHashMap = this.discoveredModules;
            synchronized (concurrentHashMap) {
                if (!this.discoveredModules.containsKey(datagram.getSourceModuleAddress())) {
                    RobotLog.vv((String)TAG, (String)"discovered lynx module#=%d isParent=%s", (Object[])new Object[]{incomingResponse.getDiscoveredModuleAddress(), Boolean.toString(incomingResponse.isParent())});
                    LynxModuleMeta meta = new LynxModuleMeta(incomingResponse.getDiscoveredModuleAddress(), incomingResponse.isParent());
                    this.discoveredModules.put(meta.getModuleAddress(), meta);
                }
            }
        }
        finally {
            RobotLog.vv((String)TAG, (String)"...onLynxDiscoveryResponseReceived()");
        }
    }

    protected void pingAndQueryKnownInterfaces() throws RobotCoreException, InterruptedException {
        for (LynxModule module : this.getKnownModules()) {
            if (!module.isParent()) continue;
            module.pingAndQueryKnownInterfacesAndEtc();
        }
        for (LynxModule module : this.getKnownModules()) {
            if (module.isParent()) continue;
            module.pingAndQueryKnownInterfacesAndEtc();
        }
    }

    public void lockNetworkLockAcquisitions() {
        this.networkTransmissionLock.lockAcquisitions();
    }

    public void setThrowOnNetworkLockAcquisition(boolean shouldThrow) {
        this.networkTransmissionLock.throwOnLockAcquisitions(shouldThrow);
    }

    protected void resetNetworkTransmissionLock() throws InterruptedException {
        this.networkTransmissionLock.reset();
    }

    @Override
    public void acquireNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.networkTransmissionLock.acquire(message);
    }

    @Override
    public void releaseNetworkTransmissionLock(@NonNull LynxMessage message) throws InterruptedException {
        this.networkTransmissionLock.release(message);
    }

    protected void startPollingForIncomingDatagrams() {
        if (this.incomingDatagramPoller == null) {
            this.incomingDatagramPoller = ThreadPool.newSingleThreadExecutor((String)"lynx dg poller");
            this.incomingDatagramPoller.execute(new IncomingDatagramPoller());
        }
    }

    protected boolean stopPollingForIncomingDatagrams() {
        boolean wasEngaged = this.incomingDatagramPoller != null;
        RobotUsbDevice robotUsbDevice = this.robotUsbDevice;
        if (robotUsbDevice != null) {
            robotUsbDevice.requestReadInterrupt(true);
        }
        if (this.incomingDatagramPoller != null) {
            RobotLog.vv((String)TAG, (String)"shutting down incoming datagrams");
            this.incomingDatagramPoller.shutdownNow();
            ThreadPool.awaitTerminationOrExitApplication((ExecutorService)this.incomingDatagramPoller, (long)5L, (TimeUnit)TimeUnit.SECONDS, (String)"Lynx incoming datagram poller", (String)"internal error");
            this.incomingDatagramPoller = null;
        }
        if (robotUsbDevice != null) {
            robotUsbDevice.requestReadInterrupt(false);
        }
        return wasEngaged;
    }

    protected void startRegularPinging() {
        for (LynxModule module : this.getKnownModules()) {
            module.startPingTimer();
        }
    }

    void stopRegularPinging() {
        for (LynxModule module : this.getKnownModules()) {
            module.stopPingTimer(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmit(LynxMessage message) throws InterruptedException {
        Object object = this.engageLock;
        synchronized (object) {
            if (this.isArmedOrArming() && !this.hasShutdownAbnormally() && this.isEngaged) {
                LynxDatagram datagram = message.getSerialization();
                if (datagram != null) {
                    if (DEBUG_LOG_DATAGRAMS || DEBUG_LOG_MESSAGES) {
                        RobotLog.vv((String)TAG, (String)"xmit'ing: mod=%d cmd=0x%02x(%s) msg#=%d ref#=%d ", (Object[])new Object[]{message.getModuleAddress(), message.getCommandNumber(), message.getClass().getSimpleName(), message.getMessageNumber(), message.getReferenceNumber()});
                    }
                    byte[] bytes = datagram.toByteArray();
                    try {
                        this.robotUsbDevice.write(bytes);
                    }
                    catch (RuntimeException | RobotUsbException e) {
                        this.shutdownAbnormally();
                        RobotLog.ee((String)TAG, (Throwable)e, (String)"exception thrown in LynxUsbDevice.transmit");
                        return;
                    }
                    long now = System.nanoTime();
                    message.setNanotimeLastTransmit(now);
                    message.resetModulePingTimer();
                } else {
                    message.onPretendTransmit();
                }
            } else {
                message.onPretendTransmit();
            }
        }
        message.noteHasBeenTransmitted();
    }

    protected void shutdownAbnormally() {
        this.hasShutdownAbnormally = true;
        RobotUsbDevice robotUsbDevice = this.robotUsbDevice;
        boolean attached = robotUsbDevice != null && robotUsbDevice.isAttached();
        String format = this.context.getString(attached ? R.string.warningProblemCommunicatingWithUSBDevice : R.string.warningUSBDeviceDetached);
        this.setGlobalWarning(String.format(format, HardwareFactory.getDeviceDisplayName(this.context, this.serialNumber)));
    }

    protected void pretendFinishExtantCommands() throws InterruptedException {
        for (LynxModule module : this.getKnownModules()) {
            module.pretendFinishExtantCommands();
        }
    }

    protected void abandonUnfinishedCommands() {
        for (LynxModule module : this.getKnownModules()) {
            module.abandonUnfinishedCommands();
        }
    }

    protected static RobotUsbDeviceFtdi accessCBus(RobotUsbDevice robotUsbDevice) {
        RobotUsbDeviceFtdi deviceFtdi;
        if (robotUsbDevice instanceof RobotUsbDeviceFtdi && (deviceFtdi = (RobotUsbDeviceFtdi)robotUsbDevice).supportsCbusBitbang()) {
            return deviceFtdi;
        }
        RobotLog.ee((String)TAG, (String)"accessCBus() unexpectedly failed; ignoring");
        return null;
    }

    public static void resetDevice(@Nullable RobotUsbDevice robotUsbDevice) {
        if (robotUsbDevice == null) {
            RobotLog.ww((String)TAG, (String)"resetDevice() called with null robotUsbDevice");
            return;
        }
        RobotLog.vv((String)TAG, (String)"resetDevice() serial=%s", (Object[])new Object[]{robotUsbDevice.getSerialNumber()});
        int msDelay = 75;
        try {
            if (LynxConstants.isEmbeddedSerialNumber((SerialNumber)robotUsbDevice.getSerialNumber())) {
                boolean prevState = AndroidBoard.getInstance().getAndroidBoardIsPresentPin().getState();
                RobotLog.vv((String)"LynxModule", (String)"resetting embedded usb device: isPresent: was=%s", (Object[])new Object[]{prevState});
                if (!prevState) {
                    AndroidBoard.getInstance().getAndroidBoardIsPresentPin().setState(true);
                    Thread.sleep(msDelay);
                }
                AndroidBoard.getInstance().getLynxModuleResetPin().setState(true);
                Thread.sleep(msDelay);
                AndroidBoard.getInstance().getLynxModuleResetPin().setState(false);
                Thread.sleep(msDelay);
            } else {
                RobotUsbDeviceFtdi deviceFtdi = LynxUsbDeviceImpl.accessCBus(robotUsbDevice);
                if (deviceFtdi != null) {
                    deviceFtdi.cbus_setup(3, 3);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(2);
                    Thread.sleep(msDelay);
                    deviceFtdi.cbus_write(3);
                }
            }
            Thread.sleep(200L);
        }
        catch (InterruptedException | RobotUsbException e) {
            exceptionHandler.handleException((Exception)e);
        }
    }

    @Override
    public RobotCoreCommandList.LynxFirmwareUpdateResp updateFirmware(RobotCoreCommandList.FWImage image, String requestId, Consumer<ProgressParameters> progressConsumer) {
        return this.lynxFirmwareUpdater.updateFirmware(image, requestId, progressConsumer);
    }

    class IncomingDatagramPoller
    implements Runnable {
        boolean stopRequested = false;
        byte[] scratch = new byte[2];
        byte[] prefix = new byte[4];
        boolean isSynchronized = false;

        IncomingDatagramPoller() {
        }

        @Override
        public void run() {
            ThreadPool.logThreadLifeCycle((String)"lynx incoming datagrams", (Runnable)new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(6);
                    while (!(IncomingDatagramPoller.this.stopRequested || Thread.currentThread().isInterrupted() || LynxUsbDeviceImpl.this.hasShutdownAbnormally())) {
                        LynxDatagram datagram = IncomingDatagramPoller.this.pollForIncomingDatagram();
                        if (datagram == null) continue;
                        if (datagram.getPacketId() == LynxDiscoveryResponse.getStandardCommandNumber()) {
                            LynxUsbDeviceImpl.this.onLynxDiscoveryResponseReceived(datagram);
                            continue;
                        }
                        LynxModule module = LynxUsbDeviceImpl.this.findKnownModule(datagram.getSourceModuleAddress());
                        if (module == null) continue;
                        module.onIncomingDatagramReceived(datagram);
                    }
                }
            });
        }

        void readIncomingBytes(byte[] buffer, int cbToRead, @Nullable TimeWindow timeWindow) throws InterruptedException, RobotUsbException {
            long msReadTimeout = Integer.MAX_VALUE;
            RobotUsbDevice robotUsbDevice = LynxUsbDeviceImpl.this.robotUsbDevice;
            if (robotUsbDevice == null) {
                RobotLog.ee((String)LynxUsbDeviceImpl.TAG, (String)"readIncomingBytes() robotUsbDevice was null");
                throw new RobotUsbUnspecifiedException("readIncomingBytes() robotUsbDevice was null");
            }
            int cbRead = robotUsbDevice.read(buffer, 0, cbToRead, msReadTimeout, timeWindow);
            if (cbRead != cbToRead) {
                if (cbRead == 0) {
                    RobotLog.ee((String)LynxUsbDeviceImpl.TAG, (String)"readIncomingBytes() cbToRead=%d cbRead=%d: throwing InterruptedException", (Object[])new Object[]{cbToRead, cbRead});
                    throw new InterruptedException("interrupt during robotUsbDevice.read()");
                }
                RobotLog.ee((String)LynxUsbDeviceImpl.TAG, (String)"readIncomingBytes() cbToRead=%d cbRead=%d: throwing RobotCoreException", (Object[])new Object[]{cbToRead, cbRead});
                throw new RobotUsbUnspecifiedException("readIncomingBytes() cbToRead=%d cbRead=%d", new Object[]{cbToRead, cbRead});
            }
        }

        byte readSingleByte(byte[] buffer) throws InterruptedException, RobotUsbException {
            this.readIncomingBytes(buffer, 1, null);
            return buffer[0];
        }

        LynxDatagram pollForIncomingDatagram() {
            while (!(this.stopRequested || Thread.currentThread().isInterrupted() || LynxUsbDeviceImpl.this.hasShutdownAbnormally())) {
                try {
                    if (!this.isSynchronized) {
                        if (this.readSingleByte(this.scratch) != LynxDatagram.frameBytes[0] || this.readSingleByte(this.scratch) != LynxDatagram.frameBytes[1]) continue;
                        this.readIncomingBytes(this.scratch, 2, null);
                        System.arraycopy(LynxDatagram.frameBytes, 0, this.prefix, 0, 2);
                        System.arraycopy(this.scratch, 0, this.prefix, 2, 2);
                        RobotLog.vv((String)LynxUsbDeviceImpl.TAG, (String)"synchronization gained: serial=%s", (Object[])new Object[]{LynxUsbDeviceImpl.this.serialNumber});
                        this.isSynchronized = true;
                    } else {
                        this.readIncomingBytes(this.prefix, 4, null);
                        if (!LynxDatagram.beginsWithFraming(this.prefix)) {
                            RobotLog.vv((String)LynxUsbDeviceImpl.TAG, (String)"synchronization lost: serial=%s", (Object[])new Object[]{LynxUsbDeviceImpl.this.serialNumber});
                            this.isSynchronized = false;
                            continue;
                        }
                    }
                    int cbPacketLength = TypeConversion.unsignedShortToInt((short)TypeConversion.byteArrayToShort((byte[])this.prefix, (int)2, (ByteOrder)LynxDatagram.LYNX_ENDIAN));
                    int cbSuffix = cbPacketLength - 4;
                    byte[] suffix = new byte[cbSuffix];
                    TimeWindow payloadTimeWindow = new TimeWindow();
                    this.readIncomingBytes(suffix, cbSuffix, payloadTimeWindow);
                    byte[] completePacket = Util.concatenateByteArrays((byte[])this.prefix, (byte[])suffix);
                    LynxDatagram datagram = new LynxDatagram();
                    datagram.setPayloadTimeWindow(payloadTimeWindow);
                    datagram.fromByteArray(completePacket);
                    if (datagram.isChecksumValid()) {
                        if (DEBUG_LOG_DATAGRAMS) {
                            RobotLog.vv((String)LynxUsbDeviceImpl.TAG, (String)"rec'd: mod=%d cmd=0x%02x msg#=%d ref#=%d ", (Object[])new Object[]{datagram.getSourceModuleAddress(), datagram.getPacketId(), datagram.getMessageNumber(), datagram.getReferenceNumber()});
                        }
                        return datagram;
                    }
                    RobotLog.ee((String)LynxUsbDeviceImpl.TAG, (String)"invalid checksum received; message ignored");
                }
                catch (RuntimeException | RobotUsbDeviceClosedException | RobotUsbFTDIException e) {
                    RobotLog.vv((String)LynxUsbDeviceImpl.TAG, (String)"device closed in incoming datagram loop");
                    LynxUsbDeviceImpl.this.shutdownAbnormally();
                    RobotUsbDevice robotUsbDevice = LynxUsbDeviceImpl.this.robotUsbDevice;
                    if (robotUsbDevice != null) {
                        robotUsbDevice.close();
                    }
                    try {
                        LynxUsbDeviceImpl.this.pretendFinishExtantCommands();
                    }
                    catch (InterruptedException ignored) {
                        this.stopRequested = true;
                    }
                }
                catch (RobotCoreException | RobotUsbException e) {
                    RobotLog.vv((String)LynxUsbDeviceImpl.TAG, (Throwable)e, (String)"exception thrown in incoming datagram loop; ignored");
                }
                catch (InterruptedException e) {
                    this.stopRequested = true;
                }
            }
            return null;
        }
    }
}

